/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file defines the MIB tree for RFC1285-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBPRSE.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         


 *      $Log:   /b/gregs/bridge/snmp/tree/rfc1285tree.c_v  $
 * 
 *    Rev 1.1   17 Aug 1993 17:36:48   vinay
 * changed the access of some objects from RW to RO.
 * 
 *    Rev 1.0   30 Jul 1993 13:12:02   franks
 * Initial revision.
 * 
 *    Rev 1.1   19 May 1993 11:08:50   shekhar
 * The Access Mode for object PORTPcType is now made changed to RW.
 * 
 *    Rev 1.0   15 Dec 1992 15:53:26   shekhar
 * Initial revision.
 
 *************************************************************************/


#include <types.h>
#include <target.h>
#include <asn1.h>
#include <snmp.h>
#include <mib.h>
#include <syteksnm.h>
#include <rfc1285.h>

#ifdef __FDDI_ETH_BRG
MIBLEAF_T snmpFddiSMTNumber_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTNumber );

MIBLEAF_T snmpFddiSMTIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTIndex );

MIBLEAF_T snmpFddiSMTStationId_leaf = LEAF( VT_STRING,RO,49,svc_snmpFddiSMTStationId );

MIBLEAF_T snmpFddiSMTOpVersionId_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiSMTOpVersionId );

MIBLEAF_T snmpFddiSMTHiVersionId_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTHiVersionId );

MIBLEAF_T snmpFddiSMTLoVersionId_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTLoVersionId );

MIBLEAF_T snmpFddiSMTMACCt_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTMACCt );

MIBLEAF_T snmpFddiSMTNonMasterCt_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTNonMasterCt );

MIBLEAF_T snmpFddiSMTMasterCt_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTMasterCt );

MIBLEAF_T snmpFddiSMTPathsAvailable_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTPathsAvailable );

MIBLEAF_T snmpFddiSMTConfigCapabilities_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTConfigCapabilities );

MIBLEAF_T snmpFddiSMTConfigPolicy_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiSMTConfigPolicy );

MIBLEAF_T snmpFddiSMTConnectionPolicy_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiSMTConnectionPolicy );

MIBLEAF_T snmpFddiSMTTNotify_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiSMTTNotify );

MIBLEAF_T snmpFddiSMTStatusReporting_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTStatusReporting );

MIBLEAF_T snmpFddiSMTECMState_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTECMState );

MIBLEAF_T snmpFddiSMTCFState_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTCFState );

MIBLEAF_T snmpFddiSMTHoldState_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTHoldState );

MIBLEAF_T snmpFddiSMTRemoteDisconnectFlag_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiSMTRemoteDisconnectFlag );

MIBLEAF_T snmpFddiSMTStationAction_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiSMTStationAction );

static MIBARC_T snmpFddiSMTEntry_arcs[] = { 
				ARC(1,snmpFddiSMTIndex_leaf),
				ARC(2,snmpFddiSMTStationId_leaf),
				ARC(3,snmpFddiSMTOpVersionId_leaf),
				ARC(4,snmpFddiSMTHiVersionId_leaf),
				ARC(5,snmpFddiSMTLoVersionId_leaf),
				ARC(6,snmpFddiSMTMACCt_leaf),
				ARC(7,snmpFddiSMTNonMasterCt_leaf),
				ARC(8,snmpFddiSMTMasterCt_leaf),
				ARC(9,snmpFddiSMTPathsAvailable_leaf),
				ARC(10,snmpFddiSMTConfigCapabilities_leaf),
				ARC(11,snmpFddiSMTConfigPolicy_leaf),
				ARC(12,snmpFddiSMTConnectionPolicy_leaf),
				ARC(13,snmpFddiSMTTNotify_leaf),
				ARC(14,snmpFddiSMTStatusReporting_leaf),
				ARC(15,snmpFddiSMTECMState_leaf),
				ARC(16,snmpFddiSMTCFState_leaf),
				ARC(17,snmpFddiSMTHoldState_leaf),
				ARC(18,snmpFddiSMTRemoteDisconnectFlag_leaf),
				ARC(19,snmpFddiSMTStationAction_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T snmpFddiSMTEntry_node = NODE (snmpFddiSMTEntry_arcs);

static MIBARC_T snmpFddiSMTTable_arcs[] = { 
				ARC(1,snmpFddiSMTEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T snmpFddiSMTTable_node = NODE (snmpFddiSMTTable_arcs);

MIBLEAF_T snmpFddiMACNumber_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACNumber );

MIBLEAF_T snmpFddiMACSMTIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACSMTIndex );

MIBLEAF_T snmpFddiMACIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACIndex );

MIBLEAF_T snmpFddiMACFrameStatusCapabilities_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACFrameStatusCapabilities );

MIBLEAF_T snmpFddiMACTMaxGreatestLowerBound_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACTMaxGreatestLowerBound );

MIBLEAF_T snmpFddiMACTVXGreatestLowerBound_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACTVXGreatestLowerBound );

MIBLEAF_T snmpFddiMACPathsAvailable_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACPathsAvailable );

MIBLEAF_T snmpFddiMACCurrentPath_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACCurrentPath );

MIBLEAF_T snmpFddiMACUpstreamNbr_leaf = LEAF( VT_STRING,RO,49,svc_snmpFddiMACUpstreamNbr );

MIBLEAF_T snmpFddiMACOldUpstreamNbr_leaf = LEAF( VT_STRING,RO,49,svc_snmpFddiMACOldUpstreamNbr );

MIBLEAF_T snmpFddiMACDupAddrTest_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACDupAddrTest );

MIBLEAF_T snmpFddiMACPathsRequested_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACPathsRequested );

MIBLEAF_T snmpFddiMACDownstreamPORTType_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACDownstreamPORTType );

MIBLEAF_T snmpFddiMACSMTAddress_leaf = LEAF( VT_STRING,RO,49,svc_snmpFddiMACSMTAddress );

MIBLEAF_T snmpFddiMACTReq_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiMACTReq );

MIBLEAF_T snmpFddiMACTNeg_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACTNeg );

MIBLEAF_T snmpFddiMACTMax_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACTMax );

MIBLEAF_T snmpFddiMACTvxValue_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACTvxValue );

MIBLEAF_T snmpFddiMACTMin_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACTMin );

MIBLEAF_T snmpFddiMACCurrentFrameStatus_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACCurrentFrameStatus );

MIBLEAF_T snmpFddiMACFrameCts_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpFddiMACFrameCts );

MIBLEAF_T snmpFddiMACErrorCts_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpFddiMACErrorCts );

MIBLEAF_T snmpFddiMACLostCts_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpFddiMACLostCts );

MIBLEAF_T snmpFddiMACFrameErrorThreshold_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACFrameErrorThreshold );

MIBLEAF_T snmpFddiMACFrameErrorRatio_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACFrameErrorRatio );

MIBLEAF_T snmpFddiMACRMTState_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACRMTState );

MIBLEAF_T snmpFddiMACDaFlag_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACDaFlag );

MIBLEAF_T snmpFddiMACUnaDaFlag_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACUnaDaFlag );

MIBLEAF_T snmpFddiMACFrameCondition_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACFrameCondition );

MIBLEAF_T snmpFddiMACChipSet_leaf = LEAF( VT_OBJECT,RO,49,svc_snmpFddiMACChipSet );

MIBLEAF_T snmpFddiMACAction_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiMACAction );

static MIBARC_T snmpFddiMACEntry_arcs[] = { 
				ARC(1,snmpFddiMACSMTIndex_leaf),
				ARC(2,snmpFddiMACIndex_leaf),
				ARC(3,snmpFddiMACFrameStatusCapabilities_leaf),
				ARC(4,snmpFddiMACTMaxGreatestLowerBound_leaf),
				ARC(5,snmpFddiMACTVXGreatestLowerBound_leaf),
				ARC(6,snmpFddiMACPathsAvailable_leaf),
				ARC(7,snmpFddiMACCurrentPath_leaf),
				ARC(8,snmpFddiMACUpstreamNbr_leaf),
				ARC(9,snmpFddiMACOldUpstreamNbr_leaf),
				ARC(10,snmpFddiMACDupAddrTest_leaf),
				ARC(11,snmpFddiMACPathsRequested_leaf),
				ARC(12,snmpFddiMACDownstreamPORTType_leaf),
				ARC(13,snmpFddiMACSMTAddress_leaf),
				ARC(14,snmpFddiMACTReq_leaf),
				ARC(15,snmpFddiMACTNeg_leaf),
				ARC(16,snmpFddiMACTMax_leaf),
				ARC(17,snmpFddiMACTvxValue_leaf),
				ARC(18,snmpFddiMACTMin_leaf),
				ARC(19,snmpFddiMACCurrentFrameStatus_leaf),
				ARC(20,snmpFddiMACFrameCts_leaf),
				ARC(21,snmpFddiMACErrorCts_leaf),
				ARC(22,snmpFddiMACLostCts_leaf),
				ARC(23,snmpFddiMACFrameErrorThreshold_leaf),
				ARC(24,snmpFddiMACFrameErrorRatio_leaf),
				ARC(25,snmpFddiMACRMTState_leaf),
				ARC(26,snmpFddiMACDaFlag_leaf),
				ARC(27,snmpFddiMACUnaDaFlag_leaf),
				ARC(28,snmpFddiMACFrameCondition_leaf),
				ARC(29,snmpFddiMACChipSet_leaf),
				ARC(30,snmpFddiMACAction_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T snmpFddiMACEntry_node = NODE (snmpFddiMACEntry_arcs);

static MIBARC_T snmpFddiMACTable_arcs[] = { 
				ARC(1,snmpFddiMACEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T snmpFddiMACTable_node = NODE (snmpFddiMACTable_arcs);

MIBLEAF_T snmpFddiPORTNumber_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTNumber );

MIBLEAF_T snmpFddiPORTSMTIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTSMTIndex );

MIBLEAF_T snmpFddiPORTIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTIndex );

MIBLEAF_T snmpFddiPORTPCType_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTPCType );

MIBLEAF_T snmpFddiPORTPCNeighbor_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTPCNeighbor );

MIBLEAF_T snmpFddiPORTConnectionPolicies_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiPORTConnectionPolicies );

MIBLEAF_T snmpFddiPORTRemoteMACIndicated_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTRemoteMACIndicated );

MIBLEAF_T snmpFddiPORTCEState_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTCEState );

MIBLEAF_T snmpFddiPORTPathsRequested_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTPathsRequested );

MIBLEAF_T snmpFddiPORTMACPlacement_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTMACPlacement );

MIBLEAF_T snmpFddiPORTAvailablePaths_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTAvailablePaths );

MIBLEAF_T snmpFddiPORTMACLoopTime_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiPORTMACLoopTime );

MIBLEAF_T snmpFddiPORTTBMax_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiPORTTBMax );

MIBLEAF_T snmpFddiPORTBSFlag_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTBSFlag );

MIBLEAF_T snmpFddiPORTLCTFailCts_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpFddiPORTLCTFailCts );

MIBLEAF_T snmpFddiPORTLerEstimate_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTLerEstimate );

MIBLEAF_T snmpFddiPORTLemRejectCts_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpFddiPORTLemRejectCts );

MIBLEAF_T snmpFddiPORTLemCts_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpFddiPORTLemCts );

MIBLEAF_T snmpFddiPORTLerCutoff_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiPORTLerCutoff );

MIBLEAF_T snmpFddiPORTLerAlarm_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiPORTLerAlarm );

MIBLEAF_T snmpFddiPORTConnectState_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTConnectState );

MIBLEAF_T snmpFddiPORTPCMState_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTPCMState );

MIBLEAF_T snmpFddiPORTPCWithhold_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTPCWithhold );

MIBLEAF_T snmpFddiPORTLerCondition_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiPORTLerCondition );

MIBLEAF_T snmpFddiPORTChipSet_leaf = LEAF( VT_OBJECT,RO,49,svc_snmpFddiPORTChipSet );

MIBLEAF_T snmpFddiPORTAction_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiPORTAction );

static MIBARC_T snmpFddiPORTEntry_arcs[] = { 
				ARC(1,snmpFddiPORTSMTIndex_leaf),
				ARC(2,snmpFddiPORTIndex_leaf),
				ARC(3,snmpFddiPORTPCType_leaf),
				ARC(4,snmpFddiPORTPCNeighbor_leaf),
				ARC(5,snmpFddiPORTConnectionPolicies_leaf),
				ARC(6,snmpFddiPORTRemoteMACIndicated_leaf),
				ARC(7,snmpFddiPORTCEState_leaf),
				ARC(8,snmpFddiPORTPathsRequested_leaf),
				ARC(9,snmpFddiPORTMACPlacement_leaf),
				ARC(10,snmpFddiPORTAvailablePaths_leaf),
				ARC(11,snmpFddiPORTMACLoopTime_leaf),
				ARC(12,snmpFddiPORTTBMax_leaf),
				ARC(13,snmpFddiPORTBSFlag_leaf),
				ARC(14,snmpFddiPORTLCTFailCts_leaf),
				ARC(15,snmpFddiPORTLerEstimate_leaf),
				ARC(16,snmpFddiPORTLemRejectCts_leaf),
				ARC(17,snmpFddiPORTLemCts_leaf),
				ARC(18,snmpFddiPORTLerCutoff_leaf),
				ARC(19,snmpFddiPORTLerAlarm_leaf),
				ARC(20,snmpFddiPORTConnectState_leaf),
				ARC(21,snmpFddiPORTPCMState_leaf),
				ARC(22,snmpFddiPORTPCWithhold_leaf),
				ARC(23,snmpFddiPORTLerCondition_leaf),
				ARC(24,snmpFddiPORTChipSet_leaf),
				ARC(25,snmpFddiPORTAction_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T snmpFddiPORTEntry_node = NODE (snmpFddiPORTEntry_arcs);

static MIBARC_T snmpFddiPORTTable_arcs[] = { 
				ARC(1,snmpFddiPORTEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T snmpFddiPORTTable_node = NODE (snmpFddiPORTTable_arcs);

MIBLEAF_T snmpFddiATTACHMENTNumber_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiATTACHMENTNumber );

MIBLEAF_T snmpFddiATTACHMENTSMTIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiATTACHMENTSMTIndex );

MIBLEAF_T snmpFddiATTACHMENTIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiATTACHMENTIndex );

MIBLEAF_T snmpFddiATTACHMENTClass_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiATTACHMENTClass );

MIBLEAF_T snmpFddiATTACHMENTOpticalBypassPresent_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiATTACHMENTOpticalBypassPresent );

MIBLEAF_T snmpFddiATTACHMENTIMaxExpiration_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiATTACHMENTIMaxExpiration );

MIBLEAF_T snmpFddiATTACHMENTInsertedStatus_leaf = LEAF( VT_NUMBER,RO,49,svc_snmpFddiATTACHMENTInsertedStatus );

MIBLEAF_T snmpFddiATTACHMENTInsertPolicy_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpFddiATTACHMENTInsertPolicy );

static MIBARC_T snmpFddiATTACHMENTEntry_arcs[] = { 
				ARC(1,snmpFddiATTACHMENTSMTIndex_leaf),
				ARC(2,snmpFddiATTACHMENTIndex_leaf),
				ARC(3,snmpFddiATTACHMENTClass_leaf),
				ARC(4,snmpFddiATTACHMENTOpticalBypassPresent_leaf),
				ARC(5,snmpFddiATTACHMENTIMaxExpiration_leaf),
				ARC(6,snmpFddiATTACHMENTInsertedStatus_leaf),
				ARC(7,snmpFddiATTACHMENTInsertPolicy_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T snmpFddiATTACHMENTEntry_node = NODE (snmpFddiATTACHMENTEntry_arcs);

static MIBARC_T snmpFddiATTACHMENTTable_arcs[] = { 
				ARC(1,snmpFddiATTACHMENTEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T snmpFddiATTACHMENTTable_node = NODE (snmpFddiATTACHMENTTable_arcs);

/* not defined at present */
/*
static MIBNODE_T snmpFddiChipSets_node = NODE (snmpFddiChipSets_arcs);
*/

static MIBARC_T snmpFddiATTACHMENT_arcs[] = { 
				ARC(1,snmpFddiATTACHMENTNumber_leaf),
				ARC(2,snmpFddiATTACHMENTTable_node),
			END_OF_ARC_LIST};

static MIBNODE_T snmpFddiATTACHMENT_node = NODE (snmpFddiATTACHMENT_arcs);

static MIBARC_T snmpFddiPORT_arcs[] = { 
				ARC(1,snmpFddiPORTNumber_leaf),
				ARC(2,snmpFddiPORTTable_node),
			END_OF_ARC_LIST};

static MIBNODE_T snmpFddiPORT_node = NODE (snmpFddiPORT_arcs);

/* Path group is empty foe now */
/*
static MIBNODE_T snmpFddiPATH_node = NODE (snmpFddiPATH_arcs);
*/

static MIBARC_T snmpFddiMAC_arcs[] = { 
				ARC(1,snmpFddiMACNumber_leaf),
				ARC(2,snmpFddiMACTable_node),
			END_OF_ARC_LIST};

static MIBNODE_T snmpFddiMAC_node = NODE (snmpFddiMAC_arcs);

static MIBARC_T snmpFddiSMT_arcs[] = { 
				ARC(1,snmpFddiSMTNumber_leaf),
				ARC(2,snmpFddiSMTTable_node),
			END_OF_ARC_LIST};

static MIBNODE_T snmpFddiSMT_node = NODE (snmpFddiSMT_arcs);

static MIBARC_T fddi_arcs[] = { 
				ARC(1,snmpFddiSMT_node),
				ARC(2,snmpFddiMAC_node),
/*				ARC(3,snmpFddiPATH_node),	*/
				ARC(4,snmpFddiPORT_node),
				ARC(5,snmpFddiATTACHMENT_node),
/*				ARC(6,snmpFddiChipSets_node),	*/
			END_OF_ARC_LIST};

/*export */ MIBNODE_T fddi_node = NODE (fddi_arcs);
#endif
