/***************************************************************************
*	Program Name:	nim960 bridge
*
*	Filename:	sncbuff.c
*
*       $Log:   /b/gregs/bridge/sonic/sncbuff.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:04:54   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 08:48:02   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 08:43:06   gregs
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:07:44   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 09:45:18   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:04:50   franks
 * Initial revision.
 * 
 *    Rev 1.1   06 Jul 1993 14:17:02   sammyc
 * 
 *    Rev 1.0   05 Apr 1993 17:13:00   ramki
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:39:54   pvcs
 * Initial revision.
*
*	Comments:	Port to i960 platform.
*
*       This section contains some utilties
*
*       Functions are: 
*       get a free DBD
*       put a free DBD
*       put a free snc frame
*
*	Copyright (c) 1991 by Hughes LAN Systems
 ******************************************************************/

#include "krnl.h"
#include "target.h"
#include "sncvar.h"

/* sammy change here:
   snc_put_frame is called by the up service call which
   will free the receive packet back to the receiver

   the transmitted frame back to the free list is done by
   the polling procedure
*/
/*
 * Put a transmitted frame back onto the free list
 *    this can be called with an RDA as well
 */
snc_put_frame(sncr,port)
SNCR *sncr;	/* TDA descriptor pointer */
word port;
	{
	register SDV *sdvp = &sv_sdvs[port];
	register ind  = sdvp->sv_freeind;
	register sncr_seq = sncr->sncr_seq;

#ifdef sammy	 /* sncr will be freed at polling procedure */
	/* free sncr */
	sncr->sncr_nus = 1;
	sncr->sncr_sta = 0;
	sncr->sncr_nxt |= SNCT_NXT_EOL;
	sdvp->sv_rcvtl->sncr_nxt = (shrt)sncr;
	sdvp->sv_rcvtl = sncr;
#endif

	/* free sncr buffer to buffer pool */
        sdvp->sv_rxqlen--;             /* decrement the qlen counter */
	sdvp->sv_plnus[(sncr_seq >> 8) & 0x7]--;
	while((sdvp->sv_plind != ind) &&
	      !(sdvp->sv_plnus[ind]) )
	  {
	    snc_put_pool(sdvp->sv_var_loc);
	    ind = (++ind) & RDA_POOL_MASK;
	    sdvp->sv_freeind=ind;
	  }
      }

/*
 * Put a transmitted frame back onto the free list
 *    this can be called with an RDA as well
 */
snc_put_pkt(driverinfo)
word driverinfo;	/* packet descriptor pointer */
	{
	  register port = driverinfo >> 11;
	  register SDV *sdvp = &sv_sdvs[port];
	  register ind = sdvp->sv_freeind;
	  
	  sdvp->sv_rxqlen--;           /* decrement the qlen counter */
	  sdvp->sv_plnus[(driverinfo >> 8) & 0x07]--;
	  while((sdvp->sv_plind != ind) && !(sdvp->sv_plnus[ind]) )
	  {
	    snc_put_pool(sdvp->sv_var_loc);
	    ind = (++ind) & RDA_POOL_MASK;
	    sdvp->sv_freeind=ind;
	  }
      }

/* routine to put a used and freed pool back to work */
snc_put_pool(svp)
SV *svp;
	{
	register SNCP *plp = svp->sv_plnxt;
	register SNC *snc = svp->sv_snc;

	/* give resource pool to receiver  */
	if (plp == svp->sv_plend)		/* if at end of pool queue */
		plp = svp->sv_sncp;		/* then wrap to front  */
	svp->sv_plnxt = ++plp;			/* store the change */
	snc->snc_rwp = (shrt)((word)plp);	        /* tell sonic of the change  */
	/* putchar('p'); */
	/* clear the RBE bit in ISR if eny */
	if(snc->snc_isr & SNC_ISR_RBE)
	  {
	    snc->snc_isr = (SNC_ISR_RBE);  
	  } 
	}

snc_put_snct(snct,portbit)
SNCT *snct;
word portbit;
{
PKT *pkt, *pktnext;
extern byte *snctrda;


  /* check if broute frame
     if yes free the packet header & packet buffer 
     if no free snct header & snct buffer */
  
  if(pkt = snct->snct_pkt)
    {
      pkt->pktXmtPort &= ~portbit;
      if(!pkt->pktXmtPort)
	{
	  for( pktnext = pkt->pktBufLink; pkt ; pktnext = pktnext->pktBufLink)
	    {
	      pkt->pktUseCount &= ~PKTINXMT;
	      pkt->pktFree(pkt);
	      pkt = pktnext;
	    }
	}
    }
  else
    {
      if(!(--snctrda[snct->snct_hom]))
	{
	  snc_put_pkt(snct->snct_hom);
	}
    }
}







