/***************************************************************************
*	Program Name:	nim960 bridge
*
*	Filename:	sncgen.c
*
*       $Log:   /b/gregs/bridge/sonic/sncgen.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:04:58   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 08:48:06   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:07:48   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 09:45:30   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:04:52   franks
 * Initial revision.
 * 
 *    Rev 1.1   06 Jul 1993 14:17:24   sammyc
 * 
 *    Rev 1.0   05 Apr 1993 17:13:04   ramki
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:39:56   pvcs
 * Initial revision.
*
*	Comments:	Port to i960 platform.
*       This file contain traffic generator routines
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
***************************************************************************/


#include <krnl.h>
#include <target.h>
#include <sncvar.h>
#include <led.h>
#include <sys.h>

#define  SNCT_XMIT_ERROR_MASK (SNC_TCR_BMC|SNC_TCR_FU|SNC_TCR_EXD|SNC_TCR_EXC)
#define  SNCT_XMIT_DETECT (SNCT_XMIT_ERROR_MASK | SNC_TCR_PTX)

extern word *flick_tx;
extern word *flick_rx;

snc_gen_account(port)
word port;
	{
	register SDV *sdvp =&sv_sdvs[port];
	register SV *svp;
	register SNCT *snct;
	register SNCT *snctnxt;

	for(snct=sdvp->sv_xmthd;snct->snct_sta & SNCT_XMIT_DETECT;snct=snctnxt)
	  {

	  sdvp->sv_xmthd=snctnxt=(SNCT *)( (*(word *)&(snct->snct_nxt)) & 0xfffffffe); 
	    if(snct->snct_sta & SNC_TCR_PTX)
	      {
		--sdvp->sv_txqlen;
		sdvp->sv_txcnt++; /* increment # of unicast packet out */
		/* set up the tx led flicker */
		flk_led(LED_MONO,flick_tx[port]); 
	      }
	    else
	      {
		--sdvp->sv_txqlen;
		sdvp->sv_snc->snc_cr = SNC_CR_RST; 
		free_gen_snct(port);
		sdvp->sv_snc->snc_ctda=(shrt)((word)sdvp->sv_xmthd); 
		if(sdvp->sv_txqlen) /* check if any packet in the queue */
		  sdvp->sv_snc->snc_cr = SNC_CR_TXP;  /* start transmit cmnd */
	      }
	    snct->snct_sta=0;
	  }

      }

PKT *gen_pkt_ptr;
word snc_gen_debug=0;

snc_gen_transmit(pkt,portlst)
PKT *pkt;
word portlst;
{
        
	register SDV *sdvp;
	register prt;
	register portnum;
	register number_of_port = NumberOfSonicPort;
	register retval;
	
	/* generate the packet */
	retval = snc_transmit_pkt_test(pkt,pkt->pktTotalSize,portlst);
	/*free the xmit buffer if possible */
	for(prt=1,portnum=0; portnum < number_of_port; prt <<=1,portnum++)
	  {
	    if(prt & portlst)
	      {
		snc_gen_account(portnum);
	      }
	  }
	if(retval)
	  {
	    snc_gen_debug++;
	    if(snc_gen_debug > 0x10000)
	      {
		snc_gen_debug=0;
		/* check if transmiter is choke */
		for(prt=1,portnum=0;portnum < number_of_port; prt<<=1,portnum++)
		  {
		    if(prt & portlst)
		      {
			sdvp=&sv_sdvs[portnum];
			if(sdvp->sv_snc->snc_cr & SNC_CR_TXP)
			  {
			    sdvp->sv_snc->snc_cr = SNC_CR_RST;
			    cam_wt();
			    cam_wt();
			    cam_wt();
			    sdvp->sv_snc->snc_cr = SNC_CR_TXP;
			    cam_wt();
			    cam_wt();
			    cam_wt();
			    cam_wt();
			    sdvp->sv_snc->snc_cr = SNC_CR_TXP;
			  }
			if(sdvp->sv_snc->snc_cr & SNC_CR_RST)
			  {
			    if(sdvp->sv_txqlen)
			      {
				cam_wt();
				sdvp->sv_snc->snc_cr=SNC_CR_TXP;
				cam_wt();
				cam_wt();
				sdvp->sv_snc->snc_cr=SNC_CR_TXP;
			      }
			    else
			      sdvp->sv_snc->snc_cr = 0;
			  }
		      }
		  }
	      }
	  }
	else
	  snc_gen_debug=0;
	return(retval);
      }
	

snc_gen_init()
{
        register SDV *sdvp;
	register i;
	register port;
	register prt;
	extern SV *sv_vars;
	extern void snc_null();
	extern word snc_init;
	extern PKT *GetPkt();

	snc_init=0;
	for(port=0,prt=1;port < NumberOfSonicPort; port++,prt<<=1)
	  {
	    if( (gen_pkt_ptr = GetPkt()) == NULL)
	      {
		printf("can't get pkt buffer\n");
		return(NULL);
	      }
	    else
	      {
		break;
	      }
	  }
      }


char *snc_gen_bufinit(dest,src,dataptr,len,portlst)
NID *dest;
NID *src;
byte *dataptr;
word len;
word portlst;
{
  word prt;
  word port;
  PKT *pkt = gen_pkt_ptr;
  byte *pktbuf_ptr;
  byte *ptr;
  word count;

  len-=4; /* deduct the CRC field */
  /* create the self test frame */
  pkt->pktTotalSize = len;
  pkt->pktXmtPort = portlst;

  /* copy data to pkt->pktDataPtr */
  pktbuf_ptr = (byte *)pkt->pktDataPtr;
  ptr= dataptr;
  ncopy(pktbuf_ptr,dest);
  pktbuf_ptr += 6;
  ncopy(pktbuf_ptr,src);
  pktbuf_ptr += 6;

  /* user buffer is 52 bytes so copy them */
  for(count=0; count <52 ;count++)
    *pktbuf_ptr++=*ptr++;
  ptr--; /* go backwards */
  
  if(len > 64 )
    for(count =0 ; count < (len -64) ; count ++)
      *pktbuf_ptr++=*ptr; /* repeat the last byte */
  return( (char *)pkt);
}


free_gen_snct(port)
word port;
{
  register SDV *sdvp;
  register SNCT *snct;
  register SNCT *snctnxt;
  
  sdvp = &sv_sdvs[port];
  for(;sdvp->sv_txqlen > 0;sdvp->sv_txqlen--)
    {
      snct = (SNCT *)(sdvp->sv_xmthd);
      sdvp->sv_xmthd=snctnxt=(SNCT *)( (*(word *)&(snct->snct_nxt)) & 0xfffffffe); 
      /* clear the status field */
      snct->snct_sta=0;
    }
}








