/***************************************************************************
*	Program Name:	nim960 bridge
*
*	Filename:	sncinit.c
*
*       $Log:   /b/gregs/bridge/sonic/sncinit.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:05:00   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 08:48:08   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:07:48   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 09:45:32   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:04:54   franks
 * Initial revision.
 * 
 *    Rev 1.2   06 Jul 1993 14:17:28   sammyc
 * 
 *    Rev 1.1   07 Apr 1993 19:04:58   sammyc
 * remove initshmalloc() routine. Move to /u/brouter/main.c
 * 
 *    Rev 1.0   05 Apr 1993 17:13:06   ramki
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:39:58   pvcs
 * Initial revision.
*
*	Comments:	Port to i960 platform.
*       SONIC FAST POLLED DRIVER
*       This file contains the sonic driver functions.
*       It operates in conjunction with the fast polled channel driver.  
*       It supports 4 channels simultaneously, parameterized by a pointer
*       to the control structure.
*        This section contains the initialization routines
*
*	Copyright (c) 1991 by Hughes LAN Systems
******************************************************************/

#include "krnl.h"
#include <target.h>
#include "memory.h"
#include "sncvar.h"

#define EMU_RDA_SIZE  768
#define DOWN 2
#define UP 1

/* sonic driver data structures */
extern SV *sv_vars;
extern SO *sv_so;
extern SDV *sv_sdvs;


/*extern variable */
extern word snc_init;
extern byte *snctrda;
extern word *flick_tx;
extern word *flick_rx;
extern word *port_num2lst;
extern word *port_lst2num;

PortNum2List(int number)

	{
	return port_num2lst[number];
	}
PortList2Num(int list)
	{
	return port_lst2num[list];
	}

/* snc_config()*************************************************************
*  description :
*  snc_config will :
   1. setup initial parameter(receive mode )
   2. setup initial starting address(SNCP,SNCAM,SNCT,SNCR)
   3. call snc_mem_init() to set up the descripter
***************************************************************************/
snc_config(portnum,rcvrmode,start_addr,io_addr)
word portnum;
word rcvrmode;
word start_addr;
word io_addr;
{
	register SV *svp ;
	register base;
	register port;
	register indx;
	extern char *malloc_shrambufstart_addr;

	if(snc_init) /* if driver already start then reset it */
	  {
	    snc_init=0;
	    for(indx=0,port=1;indx < NumberOfSonicPort;indx++,port <<=1)
	      {
		/* if(sv_so->so_prt_ena & port) */
		  {
		    svp=&sv_vars[indx];
		    svp->sv_snc->snc_cr=SNC_CR_RXDIS;/* disable the receiver */
		    cam_wt();
		    svp->sv_snc->snc_cr=SNC_CR_RST;   /* reset the SONIC */
		    cam_wt();
		  }
		  if(!(svp->sv_snc->snc_cr & SNC_CR_RST))
		    printf("port %d can't do sotfware reset\n",port);
	      }
	  }
	
	if(snc_malloc(NumberOfSonicPort))
	  {
	    printf("MALLOC FAILURE : SONIC DRIVER \n");
	    InitAbort();
	  }
	/* clear the sonic data structures first */
	memset(&(sv_sdvs[portnum]),0,sizeof(SDV));
	memset(&(sv_vars[portnum]),0,sizeof(SV));
	/* set up head of SNCP,SNCC,SNCR,SNCT */
	svp = &sv_vars[portnum];
	sv_so->so_var_loc[portnum] = svp;
	sv_sdvs[portnum].sv_var_loc = svp;
	svp->sv_snc = (SNC *)io_addr;
	sv_sdvs[portnum].sv_snc = svp->sv_snc;
	svp->sv_sncb = (byte *)(start_addr+SV_TOTL_OVERHEAD);
	base=start_addr;
	svp->sv_sncp = (SNCP *)base; 	/* receive buffer space */
	base += SV_TOTL_SNCP;
	svp->sv_sncc = (SNCC *)base; 	/* cam descriptor area */
	base += SV_TOTL_SNCC;
	svp->sv_sncr = (SNCR *)base; 	/* receive descriptor area */
	base += sizeof(SNCR) * SV_NMBR_PFRM;
	/* snct set up */
	sv_so->so_lcl_snct[portnum] = (SNCT *)(start_addr + SV_TOTL_PCTL);
        sv_so->so_lcl_buff[portnum] = (byte *)(start_addr + SV_TOTL_PCTL +
					       SV_TOTL_LCTL);
	
	/* Configuration options are set to default */
	/*svp->sv_rcvwdt = 1; */	/* rcv lock-up deadman timer value */
	svp->sv_xmtwdt = 1; 	/* xmt lock-up deadman timer value */
	svp->sv_rcvmd  = rcvrmode;	/* receiver mode */
	svp->sv_xmtmd  = 0;		/* normal transmit mode */
	svp->sv_maxsiz = SV_SIZE_PBUF;	/* extended mode size */
	/* set SNMP DOT3 default */
	svp->sv_multi = 1;
        svp->sv_init  = SNC_UNINIT;
	svp->sv_admin_status = svp->sv_oper_status = DOWN;
	svp->sv_last_change = (word)RealTimeTicks();
	svp->sv_txen  = 1;
	svp->sv_rxen  = 1;

#ifdef sammy	
	/* clear the malloc & shmalloc buffer */
	memset(malloc_shrambufstart_addr,0,SV_TOTL_LBUF);
	initshmalloc(malloc_shrambufstart_addr,SV_TOTL_LBUF);
#endif
	/* initialize the SNCP & RRA & SNCT & SNCR */
	snc_mem_init(portnum,start_addr);
	return(0);
	/*snc_mem_init();*/		   /* init the sonic data structures */
}
/***************************************************************************
* snc_mem_init():
*            1. pkt area
*	     2. each port will init
*	        a. SNCP
*		b. RRA
*		c. SNCT
*		d. SNCR
***************************************************************************/


snc_mem_init(portnum,start_addr)
word start_addr;
word portnum;
{
  register SV *svp;
  register SNCR *sncr;
  register SNCT *snct;
  byte *buff;
  word i;


  sv_so->so_prt_ena = 0;                  /* no port is enable now */
  buff = sv_so->so_lcl_buff[portnum];	/* the buffers */
  sv_so->so_lcl_hd[portnum] = 0;   /* head of free list */
  sv_so->so_lcl_tl[portnum] = 0;   /* tail of free list */
  sv_so->so_lcl_mx = SV_NMBR_LFRM; /* number allocated buffers */
  sv_so->so_lcl_cr[portnum] = SV_NMBR_LFRM;/* number currently avail buffers */

  svp=sv_so->so_var_loc[portnum];
  sncr=svp->sv_sncr;                      /* RDA array */
  snct=sv_so->so_lcl_snct[portnum];       /* TDA array */
  
  /**********************************/
  /* init SNCP, the RRA buffer area */
  /**********************************/
  for (i = 0; i < SV_NMBR_POOL; i++)
    {
      memset(&(svp->sv_sncp[i]), 0, sizeof(SNCP));  
      svp->sv_sncp[i].sncp_blo = 
	LO(svp->sv_sncb + i * SV_TOTL_POOL);
      svp->sv_sncp[i].sncp_bhi = 
	HI(svp->sv_sncb + i * SV_TOTL_POOL);
      svp->sv_sncp[i].sncp_llo = SV_TOTL_POOL >> 1; /* word count(not byte) */
      svp->sv_sncp[i].sncp_lhi = 0;
    }
  svp->sv_plind = 0;	   /* filling the 0th pool */
  sv_sdvs[portnum].sv_plind=0;
  svp->sv_plcur = &svp->sv_sncp[0];
  svp->sv_plnxt = &svp->sv_sncp[0];
  svp->sv_plend = &svp->sv_sncp[SV_NMBR_POOL];
  
  /******************************************/
  /* init the TDAs sammy change here 5/6/91 */
  /******************************************/
  /* transmit head = NULL */
  /* transmit tail = next free snct */
  svp->sv_xmthd = (SNCT *)SNCT_NXT_EOL;
  sv_sdvs[portnum].sv_xmthd=(SNCT *)SNCT_NXT_EOL;
  for(i=0; i<SV_NMBR_SNCT; i++,snct++)
    {
      /* init & chain the tdas together */
      memset(snct,0,sizeof(SNCT));
      snct->snct_hom= portnum;	/* they live on special port 1 */
      snct->snct_frg =1;

      
      if(i == SV_NMBR_SNCT-1)
	{
	  svp->sv_xmttl = snct;
	  sv_sdvs[portnum].sv_xmttl = snct;
	  /*point to begining */
	  *(word *)&snct->snct_nxt=(word)sv_so->so_lcl_snct[portnum]; 
	}
      else
	*(word *)&snct->snct_nxt=(word)(snct+1);   /* point to next */
      
      snct->snct_nxt |= SNCT_NXT_EOL;  /* mark as end of list */
    }
  
  /*****************/
  /* init the RDAs */
  /****************/
  svp->sv_rcvhd = (SNCR *)SNCR_NXT_EOL;
  sv_sdvs[portnum].sv_rcvhd = (SNCR *)SNCR_NXT_EOL;
  for (i = 0; i < SV_NMBR_PFRM; i++, sncr++)
    {
      /* init & chain the rdas together */
      memset(sncr,0,sizeof(SNCR));
      sncr->sncr_hom = portnum;	/* record the home port num */
      sncr->sncr_nus = 1;	/* rda is avail to the driver */
      sncr->sncr_cnt = 0;   /* clear the counter */
      sncr->sncr_nxt = SNCR_NXT_EOL;       /* mark as end of lst */
      if (sv_sdvs[portnum].sv_rcvhd == (SNCR *)SNCR_NXT_EOL) 
	sv_sdvs[portnum].sv_rcvhd = sncr;
      else
	{
	  sv_sdvs[portnum].sv_rcvtl->sncr_nxt = (shrt)( (word)sncr);
	  sv_sdvs[portnum].sv_rcvtl->sncr5 = start_addr >>16;
	}
      sv_sdvs[portnum].sv_rcvtl = sncr;
    }
  sv_sdvs[portnum].sv_rcvtl->sncr_nxt = (shrt)((word) (sv_sdvs[portnum].sv_rcvhd));
  sv_sdvs[portnum].sv_rcvtl->sncr5 = start_addr >>16;
  (sv_sdvs[portnum].sv_rcvtl->sncr_nxt) |= SNCR_NXT_EOL; 

}

int snc_null(){;}

snc_set_upcall(srvc)
int (*srvc) ();
{
  /*printf("srvc = %x\n", srvc); */
  sv_so->so_rcv_upc=srvc ? srvc : snc_null;
  return(0);
}
     
/*
 * Start the driver.  
 */
snc_start(portnum)
word portnum;
{
  register retval;
  register port;
  register port_num;

  if( !(retval=snc_reset(portnum)) )
    {
      sv_so->so_prt_ena |= (1 << portnum);
      snc_clear_cnt(portnum);
    }
  else      /* failed */
    {
      printf("SNC RESET FAIL code = %x", retval);
      return(retval);
    }
  return(0);
}

/*
 * Stop the driver.  
 */
snc_stop(portnum)
word portnum;
{
  register index;
  register SV *svp;
  register port = 1 << portnum;
  
  if(sv_so->so_prt_ena & port)
    {
      /*SNC_DSA(portnum); */     /* disable this port */
      snc_flush_xmt(portnum);    /* flush the receives */
      snc_flush_cnt(portnum);    /* suck out the counters */
      snc_flush_rcv(portnum);
    }
  sv_so->so_rcv_upc = snc_null;  /* store upcall routine */  
  if(snc_init) /* if driver already start then reset it */
    {
      if(sv_so->so_prt_ena & port) 
      {
	sv_so->so_prt_ena &= ~port;
	svp=&sv_vars[portnum];
	svp->sv_snc->snc_cr=SNC_CR_RXDIS;/* disable the receiver */
	cam_wt();
	svp->sv_snc->snc_cr=SNC_CR_RST;   /* reset the SONIC */
	cam_wt();
      }
      if(!(svp->sv_snc->snc_cr & SNC_CR_RST))
	printf("port %d can't do software reset\n",portnum);
    }
  if(! sv_so->so_prt_ena)
    snc_init=0;
}


/*
 * reset one port of the driver.  
 */
snc_reset(portnum)
word portnum;
{
  register SDV *sdvp = &sv_sdvs[portnum];
  register SV *svp = sdvp->sv_var_loc;
  register SNC *sp = sdvp->sv_snc;
  register word base = (word)(svp->sv_sncp); /* starting address */
  register i;

  svp->sv_init=SNC_UNINIT;
  svp->sv_admin_status = svp->sv_oper_status = DOWN;
  svp->sv_last_change = (word)RealTimeTicks();
  svp->sv_txen=SNC_XMIT_DISENA;
  svp->sv_rxen=SNC_RECV_DISENA;

  /* reset chip, suck out all completed packets & counters, enable chip */
  SNC_DSA(( ((word)sp) >> 7)&0x03);	/* disable this port */
  cam_wt();
  /* snc_flush_cnt(portnum); */ 	/* suck out the timers */
  SNC_ENA(( ((word)sp) >> 7)&0x03); 	/* enable this port */
  
  /* verify that the sonic has working registers */
  sp->snc_urra = 0x3003;		/* just a value */
  cam_wt();
  sp->snc_utda = 0x0000;		/* change capacitance */
  for(i=0;i<1000;i++)
    ;
  if (sp->snc_urra != 0x3003)
    return SV_TEST_FAIL_NOSNC;	/* no chip present */

  /* reset the chip registers */
  cam_wt();
  sp->snc_cr   = SNC_CR_RXDIS;          /* disable receiver */
  cam_wt();
  sp->snc_cr   = SNC_CR_RST;		/* put into software reset */
  cam_wt();
#ifndef FDDI
  sp->snc_dcr  = SNC_DCR_STERM|SNC_DCR_DW|SNC_DCR_BMS|4|1;/* syncronous termination */
#else
  sp->snc_dcr  = SNC_DCR_STERM|SNC_DCR_DW|SNC_DCR_BMS|4;/* syncronous termination */
#endif
  if(svp->sv_rcvmd & SNC_RCR_PRO)
    {
      sp->snc_rcr =0 | SNC_RCR_RNT;
      cam_wt();
#ifndef FDDI
      sp->snc_dcr2 = 0x1;
#else
      sp->snc_dcr2 = 0x11;
#endif
    }
  else
    {
      sp->snc_rcr = svp->sv_rcvmd | SNC_RCR_RNT;
      cam_wt();
#ifdef FDDI
      sp->snc_dcr2 = 0x10;
#endif
    }
  cam_wt();

  sp->snc_cr   = 0; 			/* get out of software reset */
  cam_wt();
  sp->snc_isr  = SNC_ISR_TXDN;		/* pretend TX & CAM are cmplt */
  cam_wt();
  sp->snc_imr  = 0;			/* disable all interrupts  */
  cam_wt();
  base >>=16;                            /* get the hi word */
  cam_wt();
  sp->snc_utda = base;	                /* upper xmt descriptor addr */
  cam_wt();
  sp->snc_urda = base;	                /* upper rcv descriptor addr */
  cam_wt();
  sp->snc_urra = base;                   /* upper rcv resource addr */
  cam_wt();
  sp->snc_eobc = (svp->sv_maxsiz+1) >> 1; /* end of buffer counter reg  */
  cam_wt();
  sp->snc_rsa  = (shrt)((word)svp->sv_sncp);	/* rcv resource start addr */
  cam_wt();
  sp->snc_rea  = (shrt)((word)svp->sv_plend);	/* rcv resource end addr */
  cam_wt();
  sp->snc_rrp  = (shrt)((word)svp->sv_sncp);	/* rcv resource read pointer */
  cam_wt();
  sp->snc_rwp  = (shrt)((word)svp->sv_plend);   /* rcv resrc wrt pntr */
  cam_wt();
  sp->snc_crct = 0xffff;                /* clear talley counter */
  cam_wt();
  sp->snc_faet = 0xffff;
  cam_wt();
  sp->snc_mpt  = 0xffff;
  cam_wt();
  sp->snc_ce   = 0;			/* disable all CAM entries */
  cam_wt();
  sp->snc_cr   = SNC_CR_RRRA;		/* ld currnt pool cmd */
  cam_wt();
  i=0;
  while((sp->snc_cr & SNC_CR_RRRA) && i++ <100)
    ;
  if(i>=100)
    {
      printf("portnum=%x,sdvp=%x,sp=%x,&(sp->snc_cr)=%x\n",portnum,sdvp,svp,&sp->snc_cr);
      printf("sp->snc_cr = %x\n",sp->snc_cr);
      printf("SONIC load pool cmd FAILED on port %d \n",portnum);
    }

  /* load RDAs if any available */
  sp->snc_crda = (shrt)( (word)sdvp->sv_rcvhd);	/* load head of rda  */
  cam_wt();
  sp->snc_cr   = SNC_CR_RXEN;		/* enable receiver */
  cam_wt();
  i=0;
  while((sp->snc_cr & SNC_CR_RXDIS) && i++ <10000)
    ;
  if(i>=10000)
      /*printf("SONIC Rx enable failed on port %d\n",portnum) */;
  else
    svp->sv_rxen=SNC_RECV_ENA;
 
  /* load TDAs (load lo word of begin TDA addr) */
  cam_wt();
  sp->snc_ctda  = (shrt)( (word)sv_so->so_lcl_snct[portnum]);
  sdvp->sv_xmthd =sv_so->so_lcl_snct[portnum];

  /* this port is now active */
  /* snc_reset_sdt(port); */
  svp->sv_txen  =SNC_XMIT_ENA;
  svp->sv_init  =SNC_INIT;
  svp->sv_admin_status = svp->sv_oper_status = UP;
  svp->sv_last_change = (word)RealTimeTicks();

  return 0;	/* no problems */
}


snc_suspend(portnum)
word portnum;
{
  register index;
  register port = 1 << portnum;
  
  if(sv_so->so_prt_ena & port)
    {
      /*SNC_DSA(portnum); */     /* disable this port */
      snc_flush_xmt(portnum);    /* flush the receives */
      snc_flush_cnt(portnum);    /* suck out the counters */
      snc_flush_rcv(portnum);
    }
  sv_so->so_prt_ena &= ~port;
}  

snc_resume(portnum)
word portnum;
{
  register port=1 << portnum;
  sv_so->so_prt_ena |= port;
}


















