/***************************************************************************
*	Program Name:	nim960 bridge
*
*	Filename:	sncitf.c
*
*       $Log:   /b/gregs/bridge/sonic/sncitf.c_v  $
 * 
 *    Rev 1.6   12 Oct 1993 09:05:04   franks
 * No change.
 * 
 *    Rev 1.5   01 Oct 1993 13:57:44   gregs
 * Added 'test_mode' argument to chnl_test() so we can control whether loopback is 'internal', 'external', or both.
 * 
 *    Rev 1.4   29 Sep 1993 08:48:14   franks
 * No change.
 * 
 *    Rev 1.3   28 Sep 1993 10:30:58   gregs
 * 
 *    Rev 1.2   10 Sep 1993 15:07:54   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 09:45:38   franks
 * First SIT release
 * 
 *    Rev 1.0   30 Jul 1993 13:04:56   franks
 * Initial revision.
 * 
 *    Rev 1.0   05 Apr 1993 17:13:08   ramki
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:40:00   pvcs
 * Initial revision.
*
*	Comments:	Port to i960 platform.
*       This file contains the interface routine to the application layer
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
***************************************************************************/

#include "krnl.h"
#include <target.h>
#include "sonic.h"
#include "sncvar.h"

chnl_config(word portnum,word rcvmode,word start_addr,word io_addr)
{
  word receive_mode;
  /* setup the receive mode */
  switch(rcvmode)
    {
    case 0: /* normal mode */
      receive_mode = 0;
      break;
    case 1: /* promiscue mode */
      receive_mode = SNC_RCR_PRO;
      break;
    case 2: /* internal loopback */
      receive_mode = SNC_RCR_LB_MAC;
      break;
    case 3: /* external loopback */
      receive_mode = SNC_RCR_LB_XCVR;
      break;
    defalut:
      printf(" receive mode (%d) error, range 0 - 4 \n",rcvmode);
      return(0);
      break;
    }

  return(snc_config(portnum,receive_mode,start_addr,io_addr));
}

chnl_set_upcall(upcall)
int (*upcall) ();
{
  return( snc_set_upcall(upcall) );
}


chnl_test(portnum, test_mode)
word portnum;
word test_mode;
{
  register xmts = 1;
  register result = 0;
  register start_addr;
  register io_addr;
  extern Nop();

  switch(portnum)
    {
    case 0:
      start_addr = 0x50000000;
      io_addr    = 0x70000080;
      break;
    case 1:
      start_addr = 0x50010000;
      io_addr    = 0x70000100;
      break;
    case 2:
      start_addr = 0x50020000;
      io_addr    = 0x70000180;
      break;
#if FSFIX
    case 3:
      start_addr = 0x50030000;
      io_addr    = 0x70000000;
      break;
#endif
    default:
      printf("No such port number in chnl_test(port_num)\n");
    }
  switch(test_mode)
    {
    case 1: /*internal loopback */
      Di();
      snc_config(portnum,SNC_RCR_LB_MAC,start_addr,io_addr);
      if( snc_start(portnum))
	{
	  printf(" snc can't start\n");
	  Ei();
	  return(SV_TEST_FAIL_BADSNC);
	}
      result=snc_test(1<<portnum,SNC_RCR_LB_MAC,xmts,Nop);
      Ei();
      break;

    case 2: /* external loopback */
      Di();
      snc_config(portnum,SNC_RCR_LB_XCVR,start_addr,io_addr);
      if( snc_start(portnum))
	{
	  printf(" snc can't start\n");
	  return(SV_TEST_FAIL_BADSNC);
	}
      result=snc_test(1<<portnum,SNC_RCR_LB_MAC,xmts,Nop);
      Ei();
      break;
    case 3: /* internal & external loopback */
      Di();
      /* internal loopback */
      snc_config(portnum,SNC_RCR_LB_MAC,start_addr,io_addr);
      if( snc_start(portnum))
	{
	  printf(" snc can't start\n");
	  return(SV_TEST_FAIL_BADSNC);
	}
      result = snc_test(1<<portnum,SNC_RCR_LB_MAC,xmts,Nop);

      /* external loopback */
      snc_config(portnum,SNC_RCR_LB_XCVR,start_addr,io_addr);
      if( snc_start(portnum))
	{
	  printf(" snc can't start\n");
	  return(SV_TEST_FAIL_BADSNC);
	}
      result &= snc_test(1<<portnum,SNC_RCR_LB_XCVR,xmts,Nop);
      Ei();
      break;
    default:
      printf(" error test mode (%d) range 0-2 \n",test_mode);
      break;
    }
return(result);
}
chnl_self_test(portnum,test_mode,xmts,test_upcall,start_addr,io_addr)
word portnum;
word test_mode;
word xmts;
int (*test_upcall)();
word start_addr;
word io_addr;
{
  word result=0;

  switch(test_mode)
    {
    case 1: /*internal loopback */
      Di();
      snc_config(portnum,SNC_RCR_LB_MAC,start_addr,io_addr);
      if( snc_start(portnum))
	{
	  printf(" snc can't start\n");
	  Ei();
	  return(SV_TEST_FAIL_BADSNC);
	}
      result=snc_test(1<<portnum,SNC_RCR_LB_MAC,xmts,test_upcall);
      Ei();
      break;

    case 2: /* external loopback */
      Di();
      snc_config(portnum,SNC_RCR_LB_XCVR,start_addr,io_addr);
      if( snc_start(portnum))
	{
	  printf(" snc can't start\n");
	  return(SV_TEST_FAIL_BADSNC);
	}
      result=snc_test(1<<portnum,SNC_RCR_LB_MAC,xmts,test_upcall);
      Ei();
      break;
    case 0: /* internal & external loopback */
      Di();
      /* internal loopback */
      snc_config(portnum,SNC_RCR_LB_MAC,start_addr,io_addr);
      if( snc_start(portnum))
	{
	  printf(" snc can't start\n");
	  return(SV_TEST_FAIL_BADSNC);
	}
      result = snc_test(1<<portnum,SNC_RCR_LB_MAC,xmts,test_upcall);

      /* external loopback */
      snc_config(portnum,SNC_RCR_LB_XCVR,start_addr,io_addr);
      if( snc_start(portnum))
	{
	  printf(" snc can't start\n");
	  return(SV_TEST_FAIL_BADSNC);
	}
      result &= snc_test(1<<portnum,SNC_RCR_LB_XCVR,xmts,test_upcall);
      Ei();
      break;
    default:
      printf(" error test mode (%d) range 0-2 \n",test_mode);
      break;
    }
return(result);
}

chnl_transmit(pkt,freeit)
PKT *pkt;
word freeit;
{
  return(snc_transmit_pkt(pkt));

}

char *chnl_receive_sam(portnum)
word portnum;
{
  register SDV *sdvp;
  register SNCR *sncr;
  register portbit = 1 << portnum;
  register PKT *pkt;
  register char *pktbuf;
  extern MBOX ReceiveMbox;
  extern PKT *GetPkt();
  extern char *GetDramBuf();
  extern int FreeDramBuf();
  extern PKT *snc_receive();

  sdvp = &sv_sdvs[portnum];
  sncr = (SNCR *)(sdvp->sv_rcvhd);
  while(!sncr->sncr_nus)
    {
      if(pkt = snc_receive(sdvp,portnum,portbit,0))
	{
	      if( (pktbuf = GetDramBuf(sncr->sncr_len)) == NULL)
		{
		  /* no dram buffer available */
		  /*pkt->pktDriverFree(pkt->pktDriverInfo); */
		  pkt->pktFree(pkt);
		  return(NULL);
		}
	      memcpy(pktbuf,pkt->pktBufPtr,pkt->pktBufLen);
	      /* free the old buffer back to pool use new buffer */
	      pkt->pktDriverFree(pkt->pktDriverInfo);
	      pkt->pktDriverFree = (void *)FreeDramBuf;
	      pkt->pktDriverInfo = (unsigned)pktbuf;
	      SendMessage((MSGHDR *)pkt, (MBOX *)&ReceiveMbox);	      
	    }
    }
}



chnl_start(portnum)
word portnum;
{
  return( snc_start(portnum) );
}

chnl_stop(portnum)
word portnum;
{
  return( snc_stop(portnum) );
}

chnl_suspend(portnum)
word portnum;
{
  return( snc_suspend(portnum) );
}

chnl_resume(portnum)
word portnum;
{
  return( snc_resume(portnum) );
}

chnl_reset(portnum)
word portnum;
{
	register SDV *sdvp=&sv_sdvs[portnum];
	register SV *svp = sdvp->sv_var_loc;
	register mode;
	register start_addr;
	register io_addr;
	extern word snc_init;

	mode = (word)svp->sv_rcvmd;
	start_addr = (word)svp->sv_sncp;
	io_addr = (word)svp->sv_snc;

	sdvp->sv_snc->snc_cr = SNC_CR_RST; /*software reset the sonic */
	snc_flush_rcv(portnum);
	snc_flush_xmt(portnum);
	/* start program sonic */
	snc_config(portnum,mode,start_addr,io_addr);
	snc_start(portnum);
	snc_init=1;
}

chnl_cam_add(portnum,address)
word portnum;
NID *address;
{
  return( snc_cam_add(portnum,address) );
}

chnl_cam_delete(portnum,address)
word portnum;
NID *address;
{
  return( snc_cam_sub(portnum,address) );
}

chnl_tune(portnum)
word portnum;
{
}


chnl_get_counters(portnum,counters)
word portnum;
CHNLCNT *counters;
{
	register SDV *sdvp=&sv_sdvs[portnum];
	register SV *svp = sdvp->sv_var_loc;

	counters->chnl_outb = svp->sv_outb;
	counters->chnl_inb = svp->sv_inb;
	counters->chnl_outu = svp->sv_outu;
	counters->chnl_inu = svp->sv_inu;
	counters->chnl_outm = svp->sv_outm;
	counters->chnl_inm = svp->sv_inm;
	counters->chnl_txfail = svp->sv_txfail;
	counters->chnl_tx_clsn = svp->sv_clsn;
	counters->chnl_tx_exc = svp->sv_tx_exc;
	counters->chnl_tx_exd = svp->sv_tx_exd;
	counters->chnl_tx_fu = svp->sv_tx_fu;
	counters->chnl_tx_bcm = svp->sv_tx_bcm;
	counters->chnl_tx_def = svp->sv_tx_def;
	counters->chnl_tx_owc = svp->sv_tx_owc;
	counters->chnl_tx_crs = svp->sv_tx_crs;
	counters->chnl_rx_crc = svp->sv_crc;
	counters->chnl_rx_aln = svp->sv_aln;
	counters->chnl_rx_lst = svp->sv_lst;
      }
  
chnl_clear_counters(portnum,counters)
word portnum;
CHNLCNT *counters;
{
	register SDV *sdvp=&sv_sdvs[portnum];
	register SV *svp = sdvp->sv_var_loc;

	counters->chnl_outb = svp->sv_outb = 0;
	counters->chnl_inb = svp->sv_inb = 0;
	counters->chnl_outu = svp->sv_outu = 0;
	counters->chnl_inu = svp->sv_inu = 0;
	counters->chnl_outm = svp->sv_outm = 0;
	counters->chnl_inm = svp->sv_inm = 0;
	counters->chnl_tx_clsn = svp->sv_clsn = 0;
	counters->chnl_txfail = svp->sv_txfail = 0;
	counters->chnl_tx_exc = svp->sv_tx_exc = 0;
	counters->chnl_tx_exd = svp->sv_tx_exd = 0;
	counters->chnl_tx_fu = svp->sv_tx_fu = 0;
	counters->chnl_tx_bcm = svp->sv_tx_bcm = 0;
	counters->chnl_tx_def = svp->sv_tx_def = 0;
	counters->chnl_tx_owc = svp->sv_tx_owc = 0;
	counters->chnl_tx_crs = svp->sv_tx_crs = 0;
	counters->chnl_rx_crc = svp->sv_crc = 0;
	counters->chnl_rx_aln = svp->sv_aln = 0;
	counters->chnl_rx_lst = svp->sv_lst = 0;
      }

/* clear the chnl driver internal data structure */
chnl_clear()
{
  return( snc_clear() );
}
chnl_malloc()
{
  return(snc_malloc(3));
}


char *chnl_receive(portnum)
word portnum;
{
  register SDV *sdvp;
  register SNCR *sncr;
  register portbit = 1 << portnum;
  register PKT *pkt;
  register char *pktbuf;
  extern MBOX ReceiveMbox;
  extern PKT *GetPkt();
  extern char *GetDramBuf();
  extern int FreeDramBuf();
  extern PKT *snc_receive();

  sdvp = &sv_sdvs[portnum];
  sncr = (SNCR *)(sdvp->sv_rcvhd);
  while(!sncr->sncr_nus)
  {
      if(pkt = snc_receive(sdvp,portnum,portbit,0))
	{
	      if( (pktbuf = GetDramBuf(sncr->sncr_len)) == NULL)
		{
		  /* no dram buffer available */
		  /*pkt->pktDriverFree(pkt->pktDriverInfo); */
		  pkt->pktFree(pkt);
		  return(NULL);
		}
	      memcpy(pktbuf,pkt->pktBufPtr,pkt->pktBufLen);
	      /* free the old buffer back to pool use new buffer */
	      pkt->pktDriverFree(pkt->pktDriverInfo);
	      pkt->pktDriverFree = (void *)FreeDramBuf;
	      pkt->pktDriverInfo = (unsigned)pktbuf;
	      SendMessage((MSGHDR *)pkt, (MBOX *)&ReceiveMbox);	      
	}
	else
	{
	  	return(NULL);
	}
      sncr = (SNCR *)(sdvp->sv_rcvhd);
  }
}






