/***************************************************************************
*	Program Name:	nim960 bridge
*
*	Filename:	snccam.c
*
*       $Log:   /b/gregs/bridge/sonic/snccam.c_v  $
 * 
 *    Rev 1.5   02 Nov 1993 08:41:44   gregs
 * No change.
 * 
 *    Rev 1.4   12 Oct 1993 09:04:56   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 08:48:04   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:07:46   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 09:45:20   franks
 * First SIT release
 * 
 *    Rev 1.0   30 Jul 1993 13:04:52   franks
 * Initial revision.
 * 
 *    Rev 1.1   06 Jul 1993 14:17:12   sammyc
 * 
 *    Rev 1.0   05 Apr 1993 17:13:02   ramki
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:39:56   pvcs
 * Initial revision.
*
*	Comments:	Port to i960 platform.
*
*       This module contains the CAM management routines
*
*       Functions are: 
*       add cam entry - add an entry (if not already there)
*       rmv cam entry - remove an entry
*       rotate cam entry - rotate in another entry (duplicates are ok)
*
*       All calls are by port, numbered 1 thru 1<<N. 
*
*	Copyright (c) 1991 by Hughes LAN Systems
******************************************************************/

#include "krnl.h"
#include <target.h>
#include "sncvar.h"


/*
 * Have the sonic reload its CAM memory
 * 
 *  there are two basic CAM methods: exact list and shotgun.
 *  The exact list method uses a list whose size varies as entries
 *  are added, removed, and altered.  The list starts empty and
 *  becomes one bigger with each add, one smaller with each remove.
 *
 *  The shotgun approach uses all 16 entries.  Each new entry
 *  overwrites a previous entry.  The overwrites are sequential
 *  and circular.  Duplicates entries may exist.  The list starts
 *  empty, but with the first rotation in becomes fully enabled.
 *
 *  All calls make their request immediately.  The actual change
 *  occurrs sometime later.  If another change request is made
 *  before the previous one completes, then the driver will wait
 *  until the previous one completes.
 */


NID nid_zero = {0,0,0};		/* A nid with all 48 bits clear */

/* add an entry to the cam */
snc_cam_add(port,nid)
word port;
NID *nid;
	{
	register SV *svp = &sv_vars[port];
	register SNCC *scp = svp->sv_sncc;
	register SNC *snc = svp->sv_snc;
	word ind,bit;
	word i;

	/* check to see if nid is 0 */
	if(ncompare(nid, &nid_zero))
	  printf("!! warning adding cam address which is 0 ");
	/* scan list for entry already being present & find vacant location */
	for (ind = 0, bit = 1; bit != 0; ind++, bit <<= 1)
	  {
	    if (svp->sv_camena & bit)
	      {
		if (ncompare(&svp->sv_camlst[ind], nid))
		  {
		    printf("cam address duplicate\n");
		    return SV_ERR_NVLD;	/* a duplicate */
		  }
	      }
	    else
	      break;                    /* find an vacant entry */
	  }
	if (bit == 0)
	  return SV_ERR_NVLD;	/* no room */
	
	/* build add command */
	svp->sv_camena |= bit;
	scp->sncc_pntr =  ind;
	scp->sncc_adr0 = *((shrt *)nid);
	scp->sncc_adr1 = *((shrt *)nid + 1);
	scp->sncc_adr2 = *((shrt *)nid + 2);
	scp->sncc_enabl= svp->sv_camena;	/* load the cam enable list  */
	
	/* issue cam request */
	snc->snc_cdc = 1;			/* 1 more cam */
	snc->snc_cdp = (shrt)( (word)svp->sv_sncc);	/* cam loc */
	snc->snc_isr &= ~SNC_ISR_LCD;	/* not yet done */
	snc->snc_cr = SNC_CR_LCAM;	/* start the CAM load */
	i=0;
	while( !(snc->snc_isr & SNC_ISR_LCD) )
	  {
	    cam_wt();
	    if(i++ >= 5000)
	      {
		printf("Load Cam Fail \n");
		break;
	      }
	  }
	/* put information into local storage */
	svp->sv_camcnt++;
	ncopy(&svp->sv_camlst[ind], nid);
	return SV_OK;
      }

/* remove an entry from the cam */
snc_cam_sub(port, nid)
word port;
NID *nid;
	{
	register SV *svp = sv_so->so_var_loc[port];
	word ind, bit;
	word vacnt_ind;
	word vacnt_bit = 0;

	/* scan list for entry */
	for (ind = 0, bit = 1; bit != 0; ind++, bit <<= 1)
		if (svp->sv_camena & bit)
			if (ncompare(&svp->sv_camlst[ind], nid))
				{
				/* disable this entry */
				svp->sv_camena &= ~bit;
				svp->sv_snc->snc_ce = svp->sv_camena;
				svp->sv_camcnt--;
				return SV_OK;
				}
	return SV_ERR_NVLD;
	}


/* swap in this node ID */
snc_cam_rot(port, nid)
word port;
NID *nid;
	{
	register SV *svp = sv_so->so_var_loc[port];
	register SNCC *scp = svp->sv_sncc;
	register SNC *snc = svp->sv_snc;
	word bit = 1 << svp->sv_camnxt;
	word i;

	/* if the next spot is disabled, then flag it as enabled */
	if (!(svp->sv_camena & bit))
		{
		svp->sv_camena |= bit;
		svp->sv_camcnt++;
		}

	/* load the cam */
	if (snc_cam_wait(svp))
		return SV_ERR_BAD;
	/* put information into local storage */
	ncopy(&svp->sv_camlst[svp->sv_camnxt], nid);

	/* build add command */
	svp->sv_camena |= bit;
	scp->sncc_pntr =  svp->sv_camnxt;
	scp->sncc_adr0 = *((shrt *)nid);
	scp->sncc_adr1 = *((shrt *)nid + 1);
	scp->sncc_adr2 = *((shrt *)nid + 2);
	scp->sncc_enabl= svp->sv_camena;	/* load the cam enable list  */
	
	/* issue cam request */
	snc->snc_cdc = 1;			/* 1 more cam */
	snc->snc_cdp = (shrt)( (word)svp->sv_sncc);	/* cam loc */
	snc->snc_isr &= ~SNC_ISR_LCD;	/* not yet done */
	snc->snc_cr = SNC_CR_LCAM;	/* start the CAM load */
	do
	  cam_wt();
	while (!(snc->snc_isr & SNC_ISR_LCD) && i++ <50) ;
	if(i >= 50 )
	  printf(" Load Cam Fail \n");
	
	/* rotate the overwrite pointer */
	svp->sv_camnxt = (svp->sv_camnxt + 1) & (SNC_MAX_CAM-1);
	return SV_OK;
	}

/* re-install all cam entries */
/* We use SNCC_FIRST here because SNCC only for the last one has 
   sncc_enable field , all the other does not */

snc_cam_rst(port)
word port;
	{
	register SV *svp = sv_so->so_var_loc[port];
	register SNCC_FIRST *scp = (SNCC_FIRST *)(svp->sv_sncc);
	register SNC *snc = svp->sv_snc;
	register ind;
	register bit;
	word valid_entry_num=0;
	word i;

	if (snc_cam_wait(svp))
		return SV_ERR_BAD;
	for (ind = 0,bit=1; ind != SNC_MAX_CAM; ind++,bit <<=1)
		{
		if(svp->sv_camena & bit)
		  {
		    scp->sncc_pntr = valid_entry_num;  /* cam entry number */
		    scp->sncc_adr0 = *((shrt *)&svp->sv_camlst[ind] + 0);
		    scp->sncc_adr1 = *((shrt *)&svp->sv_camlst[ind] + 1);
		    scp->sncc_adr2 = *((shrt *)&svp->sv_camlst[ind] + 2);
		    scp++;
		    valid_entry_num++;
		  }
		}
	scp--;                                  /* back to the last one */
	((SNCC *)scp)->sncc_enabl=svp->sv_camena;/*load the cam enable list  */
	
	/* issue cam request */
	snc->snc_cdc = valid_entry_num;		/* total 16 */
	snc->snc_cdp = (shrt)( (word)svp->sv_sncc);	/* cam loc */
	snc->snc_isr &= ~SNC_ISR_LCD;	/* not yet done */
	snc->snc_cr = SNC_CR_LCAM;	/* start the CAM load */
	do
	  cam_wt();
	while (!(snc->snc_isr & SNC_ISR_LCD) && i++ <50) ;
	if(i >= 50 )
	  printf(" Load Cam Fail \n");
	
	/* rotate the overwrite pointer */

	return SV_OK;
	}

cam_wt()
	{
	word i,j;

	for (i = 0; i < 20000; i++)
		j = i;
	}


snc_cam_wait(svp)
register SV *svp;
	{
	word i=0;

	while (svp->sv_status & SV_STATUS_CAMREQ) 
		if (i++ == 0xfffff) 
			return 1;
	return 0;
	}








