/***************************************************************************
*	Program Name:	nim960 bridge
*
*	Filename:	in_alloc.c
*
*       $Log:   /b/gregs/bridge/sonic/sncpoll.c_v  $
 * 
 *    Rev 1.9   05 Nov 1993 13:57:42   franks
 * Check in free_fail_snct if sv_txqlen is zero prior to freeing any pkts.
 * 
 *    Rev 1.8   02 Nov 1993 08:41:56   gregs
 * Fixed transmit lock bug
 * 
 *    Rev 1.7   26 Oct 1993 15:43:22   sammyc
 * Fixed the transmit abort problem(size mismatched)
 * 
 *    Rev 1.6   20 Oct 1993 08:45:54   franks
 * Sammy fixed a bug which caused the bridge to loose pkt headers whenever the
 * sonic aborted transmission due to a mismatch in total frame size and the 
 * aggregate fragment sizes. 
 * 
 *    Rev 1.5   12 Oct 1993 09:05:08   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 08:48:16   franks
 * No change.
 * 
 *    Rev 1.3   28 Sep 1993 10:50:34   gregs
 * 
 *    Rev 1.2   10 Sep 1993 15:07:56   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 09:45:40   franks
 * First SIT release
 * 
 *    Rev 1.0   30 Jul 1993 13:04:56   franks
 * Initial revision.
 * 
 *    Rev 1.1   06 Jul 1993 14:17:34   sammyc
 * 
 *    Rev 1.0   05 Apr 1993 17:20:40   ramki
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:40:02   pvcs
 * Initial revision.
*
*	Comments:	Port to i960 platform.
*
*       This section contains the fast polled routines
*
*       Functions are: 
*       reception - into the received list
*       transmission - from the three prioritized transmit lists
*       timer - counters, deadman, etc.
*
*	Copyright (c) 1991 by Hughes LAN Systems
 ******************************************************************/

#include "krnl.h"
#include <target.h>
#include <sncvar.h>
#include <frame.h>
#include <uart.h>
#include <led.h>
#define ARP 0x0608
#define  SNCT_XMIT_ERROR_MASK (SNC_TCR_BMC|SNC_TCR_FU|SNC_TCR_EXD|SNC_TCR_EXC)
#define  SNCT_XMIT_DETECT (SNCT_XMIT_ERROR_MASK | SNC_TCR_PTX)

/* 
 * THIS IS THE FAST POLLED DRIVER SECTION
 *    ALL CODE HERE MUST BE EXPEDITIOUS AND NON_BLOCKING
 */

extern MBOX ReceiveMbox;
extern word *port_num2lst;
extern word *flick_tx;
extern word *flick_rx;
extern shrt chnl_flk_tx_led;

shrt bcast[3] = {0xffff, 0xffff, 0xffff};
shrt me[3] = {0x4444,0x4444,0x4444};	/* ### replace with real thing */
extern word snc_init;
extern byte *snctrda;

word debug_pkt;
snc_fpd_pkt()
{
  register PKT *pkt;
  register PKT *pktnext;
  register SV *svp;
  register SDV *sdvp;
  register SNCR *sncr;
  register SNCT *snct;
  register SNCT *snctnxt;
  register snct_sta;
  register port;
  register portbit;

  if(!snc_init)
    return(0);

/* process all the xmit & rcv  frame */
  for(port =0,portbit=1; port < NumberOfSonicPort; port++,portbit<<=1)
    {
      sdvp = &sv_sdvs[port];

      /* free the receiving buffer */
      while ((sncr = (SNCR *)((*(word *)&sdvp->sv_rcvtl->sncr_nxt) & 0xfffffffe)) != sdvp->sv_rcvhd)
	{
	  sncr->sncr_nus = 1;
	  sncr->sncr_sta = 0;
	  sncr->sncr_nxt |= SNCT_NXT_EOL;
	  sdvp->sv_rcvtl->sncr_nxt = (shrt)( (word)sncr);
	  sdvp->sv_rcvtl = sncr;
	}

      /* free the xmit buffer */
      for (snct = (SNCT *)(sdvp->sv_xmthd);
	   ((sdvp->sv_txqlen)&&(snct->snct_sta & SNCT_XMIT_DETECT));
	   snct = snctnxt)
	{
	  sdvp->sv_var_loc->sv_outb += snct->snct_len;	/* num bytes sent out */
	  snct_sta=snct->snct_sta;
	  /* process the counters */
	  if (snct_sta & SNCT_STA_PTX)
	    {
	      if(snct_sta & 0xfffe)
		{
		  svp = sdvp->sv_var_loc;
		  if(snct_sta >> SNCT_STA_NCX_SHFT)
		    svp->sv_clsn += (snct_sta >> SNCT_STA_NCX_SHFT);
		  if(snct_sta & SNC_TCR_DEF)
		    svp->sv_tx_def++;
		  if(snct_sta & SNC_TCR_OWC)
		    svp->sv_tx_owc++;
		  if(snct_sta &(SNC_TCR_NCRS | SNC_TCR_CRSL))
		    svp->sv_tx_crs++;
		}
	      sdvp->sv_txcnt++;              /* increment counter*/
	      (chnl_flk_tx_led) |= portbit;  /* set up flicker */
	      --sdvp->sv_txqlen;	/* decrement queue length */
	      sdvp->sv_xmthd=snctnxt=
              (SNCT *)(*(word *)&snct->snct_nxt&0xfffffffe); /* detach queue */
	      snct->snct_sta=0;              /* clear status */
	    }
	  else      /* transmit failure */
	    {
	      if(snct_sta & SNC_TCR_BMC)
		{
		sdvp->sv_snc->snc_cr = SNC_CR_TXP;
		return(0);
		}
	      else
		{
		  /* 1. do statistic 2. free the bufer */ 
		  sdvp->sv_var_loc->sv_txfail++;
		  snc_tx_fail_cnt(snct_sta,port,snct);
		  free_fail_snct(port);
		  /*(transmit stop) so move the xmit pointer to next one */
		  sdvp->sv_snc->snc_ctda=(shrt)((word)sdvp->sv_xmthd);
		  return(0);
		}
	    }
	  
	  /* check if broute frame
	     if yes free the packet header & packet buffer 
	     if no free snct header & snct buffer */

	  if(pkt = snct->snct_pkt)
	    {
	      pkt->pktXmtPort &= ~portbit;
	      if(!pkt->pktXmtPort)
		{
		  for( pktnext = pkt->pktBufLink; pkt ; pktnext = pktnext->pktBufLink)
		    {
		      pkt->pktUseCount &= ~PKTINXMT;
		      pkt->pktFree(pkt);
		      pkt = pktnext;
		    }
		}
	    }
	  else
	    {
	      if(!(--snctrda[snct->snct_hom]))
		{
		  snc_put_pkt(snct->snct_hom);
		}
	    }
	}
    }
    FlkPortLeds();
}

/*
 * This routine is invoked every 10 milliseconds
 * Then, every  100 milliseconds
 *    It does: transmitter deadman timers
 * Then, every 500 milliseconds
 *    It does: receiver deadman timers, sonic counter fetching
 */             
static int half_sec;
snc_fpd_tmr()
{
  /* suck out the counters */
  register SDV *sdvp;
  register SV *svp;
  register port;
  extern word exc_col_flag;
  extern int snc_disable();
  extern int snc_reena();


  if(!snc_init || (half_sec++ < 50))
    return(0);
  for(port=0;port < NumberOfSonicPort;port++)
    {
      sdvp=&sv_sdvs[port];
      svp=sdvp->sv_var_loc;
      svp->sv_crc += svp->sv_snc->snc_crct;	/* read crc err cntr */
      svp->sv_snc->snc_crct = 0xffff;	/* clear crc err cntr */
      svp->sv_aln += svp->sv_snc->snc_faet;	/* read alignment err cntr */
      svp->sv_snc->snc_faet = 0xffff;	/* clear alignment err cntr */
      svp->sv_lst += svp->sv_snc->snc_mpt;	/* read lost packets cntr */
      svp->sv_snc->snc_mpt = 0xffff;	/* clear lost packets cntr */
      /* check if xmit is dead */
      if((sdvp->sv_snc->snc_cr & SNC_CR_TXP) || (sdvp->sv_txqlen && 
	   (sdvp->sv_snc->snc_tcr & SNCT_XMIT_ERROR_MASK)) )
	{
	  if(sdvp->sv_xmthd == svp->sv_txlockhd) /* got it */
	    {
	      sdvp->sv_snc->snc_cr=SNC_CR_RXDIS; /* disable receiver */
	      cam_wt();
	      sdvp->sv_snc->snc_cr=SNC_CR_RST; /*reset sonic */
	      cam_wt();
	      free_fail_snct(port);
	      /*(transmit stop) so move the xmit pointer to next one */
	      sdvp->sv_snc->snc_ctda=(shrt)((word)sdvp->sv_xmthd);
	      cam_wt();/* wait between sonic cmd */
	      sdvp->sv_snc->snc_cr = 0; /* go out reset mode */
	      cam_wt();
	      sdvp->sv_snc->snc_cr=SNC_CR_RXEN;/* enable receiver  */
	      cam_wt();
	    }
	  else 
	    svp->sv_txlockhd = sdvp->sv_xmthd;
	}
	if(sdvp->sv_snc->snc_tcr & SNCT_XMIT_ERROR_MASK)
		sdvp->sv_snc->snc_cr = SNC_CR_TXP;
      /* check receiver lockup due to no resource error */
      if( (svp->sv_rxlockhd == sdvp->sv_rcvhd) /* && svp->sv_rcvwdt  */)
	{
	  if(svp->sv_rxlocknorsrc != svp->sv_lst)
	    {
	      svp->sv_rxlocknorsrc = svp->sv_lst;
	      svp->sv_rxlockcnt++;
	    }
	  if(svp->sv_rxlockcnt == 5)
	    {
	      snc_disable();
	      snc_reena(1);
	      /*printf("need to reset receiver on port%d\n",port); */
	      svp->sv_rcvwdt =1; /* enable the receive WDT timer */
	      svp->sv_rxlockcnt=0;
	      svp->sv_rcvlk++;
	    }
	}
      else
	{
	  svp->sv_rxlockhd = sdvp->sv_rcvhd;
	  svp->sv_rxlockcnt=0;
	}
    }
  half_sec=0;
}

proc_rcv(sncr)
register SNCR *sncr;
	{
	register FRMHDR *fp;
	register PKT *pkt;
	extern PKT *GetPkt();

	/* decide if frame is to ME */
	fp = (FRMHDR *) *(word *)&sncr->sncr_blo;
	if (!ncompare(fp, me)		/* is not to me */
	&& (!ncompare(fp, bcast) 	/* and is not bcast */
	|| (fp->ln != ARP && fp->_p != ARP)))	/* or not arp */
		return;

	if (sncr->sncr_len > SV_SIZE_LFRM
	||  (pkt = GetPkt()) == NULL)
		return;

	/* copy descriptor and contents */
	pkt->pktTotalSize = pkt->pktDataSize = sncr->sncr_len;
	/******??????? ********/
	pkt->pktDriverInfo = sncr->sncr_seq;
	pkt->pktRcvPort = sncr->sncr_seq >> 11;
	memcpy(pkt->pktDataPtr, fp, sncr->sncr_len);
#ifdef sammy	
	dp->db_actcnt = sncr->sncr_len;	/* frame length */
	dp->db_rcvportno = sncr->sncr_seq >> 11;	/* receiving port */
	memcpy(dp->db_buffer, fp, sncr->sncr_len);
	/*SendMessage(dp, kernelMbox); */
#endif
	}

/*
 *	build a "pkt" from "sncr"
 */

sncr2pkt(SNCR *sncr, PKT *pkt)

	{
	byte	*data = (byte *)*(uint *)&sncr->sncr_blo;
	
	pkt->pktTotalSize = sncr->sncr_len;
	/***** ???? ****/
	pkt->pktDriverInfo = sncr->sncr_seq;
	pkt->pktRcvPort = sncr->sncr_seq >> 11;
	memcpy(pkt->pktBufPtr, data, sncr->sncr_len);
#ifdef sammy
	dp->nb_flags = 0;
	dp->db_actcnt = sncr->sncr_len /*- 4 */; /* CRC has been taken care  */
	dp->db_rcvportno = sncr->sncr_seq >> 11; 
	dp->db_indent = 0;
	memcpy(dp->db_buffer, data, sncr->sncr_len);
#endif
	}


/************************************************************************
snct_recover()
this routine is used to check the xmitter if it is block
1. check if xmit len is uncrease or not
2. if not increase check if xmit is on
3. if xmit is on then do software reset
4. rexmit the head of xmit packet
************************************************************************/
static record_len;
snct_recover()
{
  register port;
  register SDV *sdvp;

  for(port=0; port < NumberOfSonicPort; port++)
    {
      sdvp=&sv_sdvs[port];
      if(record_len != sdvp->sv_var_loc->sv_inb)
	{
	  record_len=sdvp->sv_var_loc->sv_inb;
	  continue;
	}
      /* check if xmit choke */ 
      if(sdvp->sv_snc->snc_cr & SNC_CR_TXP)
	{
	  /* software reset the sonic */
	  sdvp->sv_snc->snc_cr = SNC_CR_RST;
	  sdvp->sv_snc->snc_cr = 0;
	  sdvp->sv_snc->snc_cr = SNC_CR_TXP;
	}
    }
}

free_fail_snct(port)
word port;
{
  register SDV *sdvp;
  register SNCT *snct;
  register snct_hom;
  register SNCT *snctnxt;
  register PKT *pkt;
  extern int snc_put_snct();

  sdvp = &sv_sdvs[port];

  if(!(sdvp->sv_txqlen)) {
	return;
  }

  snct = (SNCT *)(sdvp->sv_xmthd);
  sdvp->sv_xmthd = (SNCT *)(*(word *)&snct->snct_nxt&0xfffffffe);
  snct->snct_sta = 0;
  snc_put_snct(snct, (1 << port));
  sdvp->sv_txqlen--;
#ifdef sammy
  for(;sdvp->sv_txqlen ;sdvp->sv_txqlen--)
    {
      snct = (SNCT *)(sdvp->sv_xmthd);
	if(pkt = snct->snct_pkt)
	if(!(pkt->pktXmtPort))
	enter_debug(0x5555,sdvp,snct,snct->snct_sta,pkt);
      sdvp->sv_xmthd=snctnxt=(SNCT *)(*(word *)&snct->snct_nxt&0xfffffffe);
      /* clear the status field */
      snct->snct_sta=0;
      snc_put_snct(snct, (1 << port));
    }
#endif
}


snc_receive_lock(port)
{
  register SDV *sdvp = &sv_sdvs[port];
  register SV *svp = sdvp->sv_var_loc;
  register SNC *sp = sdvp->sv_snc;
  register SNCR *sncr = svp->sv_sncr;
  register i;

  /* reset the chip registers */
  sp->snc_cr   = SNC_CR_RXDIS;          /* disable receiver */
  sp->snc_cr   = SNC_CR_RST;		/* put into software reset */

  sp->snc_rsa  = (shrt)( (word)svp->sv_sncp);	/* rcv resource start addr */
  sp->snc_rea  = (shrt)( (word)svp->sv_plend);	/* rcv resource end addr */
  sp->snc_rrp  = (shrt)( (word)svp->sv_sncp);	/* rcv resource read pointer */
  sp->snc_rwp  = (shrt)( (word)svp->sv_plend);   /* rcv resrc wrt pntr */

  /*****************/
  /* init the RDAs */
  /****************/
  svp->sv_rcvhd = (SNCR *)SNCR_NXT_EOL;
  sdvp->sv_rcvhd = (SNCR *)SNCR_NXT_EOL;
  for (i = 0; i < SV_NMBR_PFRM; i++, sncr++)
    {
      /* init & chain the rdas together */
      sncr->sncr_hom = port;	/* record the home port num */
      sncr->sncr_nus = 1;	/* rda is avail to the driver */
      sncr->sncr_cnt = 0;   /* clear the counter */
      sncr->sncr_nxt = SNCR_NXT_EOL;       /* mark as end of lst */
      if (sdvp->sv_rcvhd == (SNCR *)SNCR_NXT_EOL) 
	sdvp->sv_rcvhd = sncr;
      else
	{
	  sdvp->sv_rcvtl->sncr_nxt = (shrt)( (word)sncr);
	  sdvp->sv_rcvtl->sncr5 = SHRAM_HI + port;
	}
      sdvp->sv_rcvtl = sncr;
    }
  sdvp->sv_rcvtl->sncr_nxt = (shrt)( (word)sdvp->sv_rcvhd);
  sdvp->sv_rcvtl->sncr5 = SHRAM_HI + port;
  (sdvp->sv_rcvtl->sncr_nxt) |= SNCR_NXT_EOL; 
  
  /* load RDAs if any available */
  sp->snc_crda = (shrt)( (word)sdvp->sv_rcvhd);	/* load head of rda  */
  sp->snc_cr   = SNC_CR_RXEN;		/* enable receiver */
}
















