/***************************************************************************
*	Program Name:	nim960 bridge
*
*	Filename:	snctest.c
*
*       $Log:   /b/gregs/bridge/sonic/snctest.c_v  $
 * 
 *    Rev 1.6   02 Nov 1993 08:42:36   gregs
 * No change.
 * 
 *    Rev 1.5   12 Oct 1993 09:05:12   franks
 * No change.
 * 
 *    Rev 1.4   06 Oct 1993 16:28:32   sammyc
 * 
 *    Rev 1.3   29 Sep 1993 08:48:20   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:07:58   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 09:45:46   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:04:58   franks
 * Initial revision.
 * 
 *    Rev 1.1   06 Jul 1993 14:17:38   sammyc
 * 
 *    Rev 1.0   05 Apr 1993 17:20:44   ramki
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:40:04   pvcs
 * Initial revision.
*
*	Comments:	Port to i960 platform.
*
*       This section contains the self test routines.  
*       Prior to testing, snc_config must have been called.
*
*       Functions are: 
*       Self tests - all three loopback modes
*
*       All calls are by port, numbered 1 thru 1<<N.
*       Loopback test choices are:
*          0 - internal
*          1 - external
*
*	Copyright (c) 1991 by Hughes LAN Systems
******************************************************************/

#include "krnl.h"
#include <target.h>
#include <memory.h>
#include "sncvar.h"

byte test_frame[] = 
	{
	0x22,0x22,0x22,0x22,0x22,0x22,		/* destination node id */
	0x44,0x44,0x44,0x44,0x44,0x44,		/* source node id */
	0,0x2e,			/* size in reverse order */
	0xaa, 0xaa, 0x03, 0x00, 0x00, 0x10, 0x00, 0x00,	/* HLS SNAP */
	22,23,24,25,26,27,28,29,	/* 8 bytes data */
	30,31,32,33,34,35,36,37,38,39,	/* 10 bytes data */
	40,41,42,43,44,45,46,47,48,49,	/* 10 bytes data */
	50,51,52,53,54,55,56,57,58,59,	/* 10 bytes data */
	60,61,62,63,64,65,66,67,68,69	/* 10 bytes data */
	};
#define TSTSIZ sizeof(test_frame)
extern NID *MyNid();

word stest[1000];
  word stest_ind;    
snc_test_rcvr(port)
word port;
	{
	register SDV *sdvp=&sv_sdvs[port];
	register SV *svp=sdvp->sv_var_loc;
	register SNCR *sncr=(SNCR *)sdvp->sv_rcvhd;
	register SNCT *snct=(SNCT *)sdvp->sv_xmthd;
	register SNCT *snctnxt;
	register SNCR *sncrnxt;
	register i;
	short *ledptr;
	word retval;
	word xmitfail=1;
	extern short chnl_flk_rx_led;
	extern short chnl_flk_tx_led;
	extern int FlkPortLeds();

	stest_ind=0;
	i=0;
	/*ledptr = (short *) 0x80000060;
	*ledptr = 0x5555;*/
	while( i < 0x1000)
	  {   
	      if(stest_ind <1000)
	      {
		/* Magic line is here! */
		/*ledptr = (short *) 0x80000060;
		*ledptr = 0x5555;*/
		/*ledptr = (short *) 0x300ffff0;
		*ledptr = 0x5555;*/
		/*stest[stest_ind++]=snct->snct_sta;*/
		/*stest[stest_ind++]=sncr->sncr_sta;  */
	      }
	    if( snct->snct_sta & 0x00ff)
	      {
		/*ledptr = (short *) 0x80000040;
		*ledptr = 0x5555;*/
		/* clear the xmit status & move to next one*/
		snctnxt = (SNCT *)SNCADDR(port,(snct->snct_nxt & 0xfffe));
		sdvp->sv_xmthd = snctnxt;
	        /*ledptr = (short *) 0x80000040;
	        *ledptr = 0x5555;*/
		if(snct->snct_sta & SNC_TCR_PTX)
		  {
		    svp->sv_outu++;  /* increment # of unicast packet out */
		    xmitfail=0;
		    chnl_flk_tx_led |= (1 << port);
		    FlkPortLeds();
		    chnl_flk_tx_led = 0;
		  }
		else
		  {
	            ledptr = (short *) 0x80000040;
	            *ledptr = 0x5555;
		    if(snct->snct_sta & SNC_TCR_EXC)
		      svp->sv_tx_exc++;
		    else if(snct->snct_sta & SNC_TCR_EXD)
		      svp->sv_tx_exd++;
		    else if(snct->snct_sta & SNC_TCR_FU)
		      svp->sv_tx_fu++;
		    else if(snct->snct_sta & SNC_TCR_BMC)
		      svp->sv_tx_bcm++;
		    else
		      ;
		    /* restart the xmitter */
		    sdvp->sv_snc->snc_ctda=(shrt)( (word)snctnxt);
		    sdvp->sv_snc->snc_cr=SNC_CR_TXP;
		    xmitfail=1;
		    i=10000;
		    retval=1;
		    break;
		  }
		snct->snct_sta = 0;
	      }
	      
	    if(sncr->sncr_nus==0 && !xmitfail) 
	      {
		/* get the echo if any */
		sncr->sncr_adr = sncr->sncr_bhi;/* make 32 bit addr */
		/* detach from sonic received list */
		sdvp->sv_rcvhd = (SNCR *)((*(word *)&sncr->sncr_nxt) & 0xfffffffe);
		/* verify the frame */
		if ((sncr->sncr_sta & SNCR_STA_PRX)
		    && sncr->sncr_len == (TSTSIZ+4)
		    && !memcmp(*(word *)&sncr->sncr_blo, test_frame, TSTSIZ)) 
		  {
		    chnl_flk_rx_led |= ( 1 << port);
		    FlkPortLeds();
		    chnl_flk_rx_led =0;
		    sv_vars[sncr->sncr_hom].sv_tstrpt++;
		    retval=0;
		  }
		else
		  {
		    retval=1;
		  }
		snc_put_frame(sncr,port);	/* toss it back on rcvd list */
		break;
	      }
	    i++;
	  }/* end of while */
	if(i==10000)
	  {
	    retval=1;
	  }
	/* clear the snc_isr */
	sdvp->sv_snc->snc_isr=0xffff;
	return(retval);
      }

shrt snc_test(portlst, rcvmode, xmts, upcall)
word portlst;	        /* port(s) to be tested */
word rcvmode;           /* receiver mode option */
word xmts;		/* number frames to send */
int (*upcall)();	/* upcall to permit aborting */
	{
	register SV *svp;
	register SDV *sdvp;
        register xmtcnt;
	register prt;
	register port;
	register PKT *pkt;
	register char *pktbuf;
	word abrtflg=0;
	word retval=0;
	extern word *port_lst2num; 
	extern word *port_num2lst;
	extern int snc_null();
	extern word snc_init;
	extern PKT *GetPkt();
	extern char *GetShramBuf();

	/* start the driver and clear the counters */
	portlst &= SV_VLD_PRTS;
	/* create the self test frame */
	
	if( (pkt = GetPkt()) == NULL)
	  return(NULL);
        if( (pktbuf = GetShramBuf(TSTSIZ)) == NULL)
	  {
	    FreePkt(pkt);
	    return(NULL);
	  }
	pkt->pktBufPtr = pktbuf;
	ncopy(test_frame, MyNid(0));
	ncopy(test_frame+6, MyNid(0));
	memcpy(pkt->pktBufPtr, test_frame, TSTSIZ);
	for (prt=1,port=0; port<NumberOfSonicPort; prt <<= 1,port++)
	  {
	    /* only test the selected port(s) */
	    if (!(prt & portlst))
	      continue;
	    snc_cam_add(port,MyNid(0));
	  }
	for(prt=1,port=0; port < NumberOfSonicPort; prt <<=1,port++)
	  {

		if(!(prt & portlst))
		  continue;
		
		/* Send the frame, wait for an echo, repeat */
		for (xmtcnt = xmts; xmtcnt; xmtcnt--)
		  {
		    /* send the test frame */
		    pkt->pktXmtPort = prt;
		    snc_transmit_pkt_test(pkt,TSTSIZ,prt);
		    
		    /* wait for transmit complete & chk for abort */
		    /* check xmitter and receiver */
		    retval |= snc_test_rcvr(port);
		    abrtflg = (*upcall)();
		    if(abrtflg)
		      return(0);  
		    /* detach from queue */
		  }
	      }
	/* put the transmit frame back */
	FreeShramBuf(pkt->pktBufPtr);
	FreePkt(pkt);

	/* check the xmit & receive count */
	for(prt=1,port=0; port <NumberOfSonicPort;prt <<=1,port++)
	  {
	    if(!(prt & portlst))
	      continue;
	    sdvp=&sv_sdvs[port_lst2num[prt]];
	    svp=sdvp->sv_var_loc;
	    if(xmts >3) /* give 3 packet margin */
	      xmts -= 3;
	    if(svp->sv_outu < xmts || svp->sv_tstrpt <  xmts)
	      {
		if(rcvmode == SNC_RCR_LB_MAC)
		  printf("\n port %d Internal LoopbackTest Fail \n",port_lst2num[prt] + 1);
		else
		  printf("\n port %d External LoopbackTest Fail \n",port_lst2num[prt] + 1);

		printf(" xmit succeed   = %d collison =%d\n",svp->sv_outu,
		       svp->sv_tx_exc);
		printf(" received count = %d\n",svp->sv_tstrpt);
	      }
	    else
	      retval=0;
	  }
	       
	/* report results */
        return retval? SV_TEST_FAIL_ABORT : SV_TEST_FAIL_AOK;/* tst cmpltd */
      }











