/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
	
#
# --	declare the below symbols public
#
	.globl	_start
	.globl	_error
	.globl  _abort
	.globl	_fatal

	.globl	_debug_stack
        .globl  _sup_stack
        .globl  _EntryFromTftp
        .globl  _reset_entry

	.globl	_Nim960Header

	.set	ENTRY_FROM_TFTP,	0x54465450	# "TFTP"
  	.set	NIM960_MAGIC,		0x5566	
	.set	NIM960_HDR_SIZE,	336
	.set	PROGRAM_NAME_OFFSET,	48	
	.set	COPYRIGHT_OFFSET,	80	

	.set	LEDBIO,			0x90000040
	.set	LEDMIO,			0x90000060
	.set	LEDIO,			0x90000040
	.set	INT_STACK,		0x2ff91000

	.text
        .align  4

#
# --	The nim960 module header
#

_Nim960Header:
	.short	NIM960_MAGIC		# signature for the header
	.short	0			# check sum
	.word	0			# file length
	.word	0			# time of creation
_tlen:	.word	0			# length of text
_dlen:	.word	0			# length of data
_blen:	.word	0			# length of bss
_eaddr:	.word	_start			# entry address
_taddr:	.word	0			# text load address
_daddr:	.word	0			# Data load address

	.word	999			# Program ID
	.asciz	"1.11  "		# version No more than 8 char

	.org	PROGRAM_NAME_OFFSET	# program name should <= 32 characters
					# including terminating NULL.
	.asciz	"836 FDDI - ETHERNET BRIDGE" 


	.org	COPYRIGHT_OFFSET	# copyright should be <= 256 characters
					# including terminating NULL.
	.asciz	"Copyright (C) Hughes LAN Systems 1993"

	.org	NIM960_HDR_SIZE	- 1	/* offset starts at 0	*/

#
# --	End of nim 960 header
#

	.align 4

#
# --	The BOOT programme transfers congtrol here
#

#
# --	Initialize the cpu registers
#
#	g0 contains a magic number to tell us whether this program
#	is coming from the booter or tftp
#	We set _EntryFromTftp if we come from tftp and reset
#	it otherwise.
#
_start:
	lda	ENTRY_FROM_TFTP, g5
	cmpibne.f	g5, g0, FromBooter	# branch if not from tftp
	mov	1, g0				# set EntryFromTftp as we
						# come from tftp
	b	SetEntryFromTftp	
FromBooter:
	mov	0, g0
SetEntryFromTftp:
	st	g0, _EntryFromTftp
_reset_entry:
	lda	0xc01f2002, g0
	lda	0xc01f2002, g1
	modpc	g1, g1, g0

	lda	0x40000001, g0
	lda	0x40000001, g1
	modtc	g1, g0, g0

	mov 0, sf0
	mov 0, sf1
	mov 0, sf2

#
# --  zero out uninitialized data area
#
	lda 	_end, g0		# end of .bss
	lda 	_bss_start, g1		# beginning of .bss
	lda	0, g2		

zero_loop:
	st	g2, (g1)		# to zero out uninitialized
	addo	4, g1, g1		# data area
	cmpoble g1, g0, zero_loop	# loop until _end reached

#
# --	Turn RDY led off, and ACT led on
#
	lda	LEDBIO, g0
	lda	0x00000001, g1
	stos	g1, (g0)

#
# --	Turn all uni_color led's on, off, on
#
	lda	LEDMIO, g0
	lda	0x00000000, g1
	stos	g1, (g0)
# --
# --  setup the interrupt stack pointer in the PRCB table
# --
	lda	INT_STACK, g1		# load address
	lda	_ram_prcb, g0		# load destination
	st	g1, 28(g0)		# store into PRCB

# 
# --	It is time to issue the 
# --	REINITIALIZE sysctl, which will start us anew with
# --	our new PRCB.
#
	ldconst 0x300, r4
	ldconst start_again_ip, r5
	ldconst _ram_prcb, r6
	sysctl	r4, r5, r6

#
# --	execution will now resume at start_again_ip
#

#
# --	The processor will begin execution here after being
# --	reinitialized.  We will now set up the stacks and continue.
# --	The sysctl sets up sp register with the interrupt stack ptr.
#

start_again_ip:
	st	sp,(sp)			# dummy pfp -> dummy frame
	mov	sp,fp			# allocate dummy frame
	ldconst	64, g0			# .
	addo	sp, g0, sp		# .
	call	fix_stack		# go in as a normal call, come
					#   out as an interrupt return
	lda	_sup_stack, fp 		# set up sup stack space
	lda	(fp), pfp		# load pfp (just in case)
	lda	0x40(fp), sp		# set up current stack ptr


	mov	 0, g14			# g14 used by C compiler
					# for arguement lists past
					# 13 arguements.
					# Initialize to 0
#	call	_Di			# disable board interrupts


#
# --	loop added here for debug purpose only.
#

#loop:	b	loop

#
# --   call main from here
#
	callx	 _main

#
# --	execution will never return to this point
#

_fatal:
_abort:
_error:
#
# --	Turn B1 led red, and B2 led off. (turn all uni_color led's off)
#
	lda	LEDIO, g0
	lda	0x00000005, g1
	stos	g1, (g0)

error_loop:
	b	error_loop


#
# --- routine to turn off int state
#

        .align  4
fix_stack:
	flushreg
	or	pfp, 7, pfp		# put interrupt return
					# code into pfp
#
# -- 	we have reserved area on the stack before the call to this
# --	routine.  We need to build a phony interrupt record here
# --	to force the processor to pick it up on return.  Also, we
# --	will take advantage of the fact that the processor will
# --	restore the PC and AC to it's registers
# --	old value 0xd81f0002
#

	ldconst	0xd8000003, g0  	# the upper "d8" is required
					#   by the CX microcode for
					#   interrupt return
	st	g0, -16(fp)		# store contrived PC
	ldconst	0x3b001000, g0 		# set up arith. controls 
	st	g0, -12(fp)		# store contrived AC
	ret

# -- Stacks
	.bss	_sup_stack,  0x1000, 6	# supervisor stack
	.bss	_debug_stack, 0x1000, 6	# interrupt stack
	.data
	_EntryFromTftp:	.word	0	# are we coming from the booter or
					# tftp
