#include <types.h>
#include <krnl.h>
#include <dbd.h>
#include <tcpip.h>
#include <libfuncs.h>
#include <buffer.h>
#include <decode.h>
#include <localio.h>
#include <asn1.h>
#include <snmp.h>
#include <mib.h>
#include <buildpkt.h>
#include <syteksnm.h>
#include <telnet.h>
#include <nvrecs.h>

extern int snmpInProgress;

POINTER pstart;
POINTER pend;
POINTER pnext;
VB_P pVarBin;
SNMP_PKT_P dsnmp;

SNMP_PKT_P rcv_snmp_pkt;
SNMP_PKT_P trap_snmp_pkt;
SNMP_GP_P snmp_count;
POINTER tx_rebuffp;
POINTER trap_rebuffp;

POINTER pdu_typep;
POINTER err_statusp;
POINTER err_indxp;

unsigned int   dot1dBridgeId[] = {
	/* ISO */			1,
        /* ORG */                       3,
        /* DOD */                       6,
        /* INTERNET */                  1,
        /* MGMT */                      2,
        /* MIB-2 */                     1,
	/* dot1dBridge */		17};

int dot1dBridge_id_count = 
	sizeof(dot1dBridgeId)/sizeof(unsigned int);


/*
**
**	Send the trap related to STP
**
*/
send_stp_trap(id)
int id;
{
	in_name mgr1 = 0, mgr2 = 0;
	EBUFFER_T trap_ebufp;
	char    *snmp_trap_communityp;
	int  prod_oid_cnt, prod_oid[16];
	int x,i;


	if(snmpInProgress)
		return;
/***
	GetSnmpMgr(&mgr1,&mgr2,SPECIFIC_TRAP,id);
***/
	if(BridgeStatus->SnmpMgr[0] )
		mgr1 = BridgeStatus->SnmpMgr[0];
	else if(BridgeStatus->SnmpMgr[1] )
		mgr2 = BridgeStatus->SnmpMgr[1];


	if(mgr1 == 0 && mgr2 == 0)
		return;

	snmpInProgress = 1;
	init_mem();
	/* prepare the packet */
	trap_snmp_pkt->pdu.trap_pdu.trap_vbl.vbl_count=0;
        trap_snmp_pkt->pdu_type = TRAP_PDU;
        trap_snmp_pkt->snmp_version = VERSION_RFC1067;
        if (build_object_id(dot1dBridge_id_count,
            (unsigned int  *)dot1dBridgeId,
            (OBJ_ID_T  *)&(trap_snmp_pkt->pdu.trap_pdu.enterprise_objid)) == -1)
                return ;
        memcpy((POINTER)trap_snmp_pkt->pdu.trap_pdu.net_address,
            (POINTER)&_initp->in_me,4);
        
       trap_snmp_pkt->pdu.trap_pdu.generic_trap = ENTERPRISE_SPECIFIC;
       trap_snmp_pkt->pdu.trap_pdu.specific_trap = id;
       trap_snmp_pkt->pdu.trap_pdu.trap_time_ticks = RealTimeTicks();

	send_alarms(mgr1,mgr2);
	snmpInProgress = 0;

}

send_alarms(mgr1,mgr2)
in_name	mgr1,mgr2;
{
	EBUFFER_T ebuffp;
	register len,stat;

	if(SNMP_Encode_Packet((SNMP_PKT_P)trap_snmp_pkt,(EBUFFER_P)&ebuffp) == -1)
	{
		printf("SNMP_Encode_Packet failed.\n");
		return;
	}
	len =ebuffp.next_bp-ebuffp.start_bp;
	if(mgr1)
	{
		stat=udp_send(mgr1,SNMP_TRAP_PORT,
		    SNMP_REQUEST_PORT,(OCTET_P)ebuffp.start_bp,
		    len,_initp->in_me);
		/*
		printf("udpd_send stat for mgr 1 = %x\n",stat);
		*/
	}
	if(mgr2)
	{
		udp_send(mgr2,SNMP_TRAP_PORT,
		    SNMP_REQUEST_PORT,(OCTET_P)ebuffp.start_bp,
		    len,_initp->in_me);
		/*
		printf("udp_send status for mgr 2 = %x\n",stat);
		*/
	}
	Free_VarBin_list(trap_snmp_pkt->pdu.trap_pdu.trap_vbl.vblist);
	trap_snmp_pkt->pdu.trap_pdu.trap_vbl.vblist=NULL;
}
