/**
 *	Program Name:	nim960 bridge
 *
 *	Filename:	PrintBoot.c
 *
 *	$Log:   /b/gregs/bridge/tester/PrintBoot.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 09:22:30   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 09:44:46   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:25:38   franks
 * Initial revision.
 * 
 *    Rev 1.1   10 Apr 1992 16:40:52   kwok
 * Remove some '\n' to make the output not scrolling off the screen
 * 
 *    Rev 1.0   30 Mar 1992 17:42:20   pvcs
 * Initial revision.
 *
 *	Comments:
 *	
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/

#include <types.h>
#include <eeprecs.h>
#include <sys.h>

/*
 *	PrintBootRecord	- print the boot record
 */
PrintBootRecord(EEP_BOOT *BootRec)

	{
	int	offset;
	/*
	 *	Display the boot record, i.e. my ip address, server ip
	 *	tftp file ...etc.
	 */
	printf("IP addresses:\n");
	printf("\tThis station:\t%-12s", inet_ntoa(BootRec->eep_IP));
	printf("\tSubnet mask:\t\t%-12s\n", inet_ntoa(BootRec->eep_NetMask));
	printf("\tPrimary router:\t%-12s", 
		inet_ntoa(BootRec->eep_RouterIP[0]));
	printf("\tSecondary router:\t%-12s\n", 
		inet_ntoa(BootRec->eep_RouterIP[1]));
	printf("\tBoot server:\t%-12s", inet_ntoa(BootRec->eep_ServerIP));
	printf("\tTime server:\t\t%-12s\n", inet_ntoa(BootRec->eep_TimeServer));
	printf("Boot files:\n");
	printf("\t%-16s%s\n", "Request:", BootRec->eep_request_file);
	printf("\t%-16s%s\n", "Configuration:", BootRec->eep_config_file);
	printf("\t%-16s%s\n", "Image:", BootRec->eep_image_file);
	offset = BootRec->eep_OffsetGMT;
	printf("%-27s", "Time Offset from GMT:");
	/*
	 *	printf cannot handler negative number and hence...
	 */
	if (offset < 0)
		{
		offset = 0 - offset;
		printf("-");
		}
	printf("%d hours %d minutes\n", offset / (60 * 60),
		(offset % (60 * 60)) / 60);
	printf("%-27s", "Application source:"); 
	if(BootRec->eep_ThinNet == 0x0) 
		printf("%s\n","NETWORK");
	if(BootRec->eep_ThinNet == 0x1) 
		printf("%s\n","FLASH");
	if(BootRec->eep_ThinNet == 0x2) 
		printf("%s\n","Load from network & Update FLASH");

	}

	
