/**			       
*
*	Program Name:	STANLEY TESTER
*
*	Filename:	diagnos.c
*
*	$Log:   /b/gregs/bridge/tester/diagnos.c_v  $
 * 
 *    Rev 1.6   20 Oct 1993 11:10:14   gregs
 * clr parms (pt_prm...) for 'q' cmd as for 'p' cmd.
 * 
 *    Rev 1.5   20 Oct 1993 08:18:52   gregs
 * Added fddi port ('q') cmd (fddi loopback test).
 * 
 *    Rev 1.4   13 Oct 1993 13:33:48   gregs
 * Added 'b' to the list of valid commands.
 * 
 *    Rev 1.3   12 Oct 1993 09:22:36   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 09:44:54   franks
 * No change.
 * 
 *    Rev 1.1   02 Sep 1993 17:41:34   vinay
 * changed the port numbers from 4 to 3
 * 
 *    Rev 1.0   30 Jul 1993 13:25:44   franks
 * Initial revision.
 * 
 *    Rev 1.1   13 Apr 1992 17:34:10   suresh
 * Disable the X command for the booter.
 * 
 *    Rev 1.0   30 Mar 1992 17:42:20   pvcs
 * Initial revision.
*
*	Creation Date:	6.12.91
*
*	Date:
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	This is the TESTER module.  It allows an user
*			to invoke tests on the hardware.
*			This is based on the nim386 tester program.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <types.h>
#include <memory.h>
#include <cmd.h>
#include <led.h>

extern	int	NumberOfSonicPort;

/* control flags */
static int test_cnt = 0;	/* counts tests specified */
static int qtst_cnt = 0;	/* counts quasi tests specified */
static int info_cnt = 0;	/* counts info stuff specified */
static int repeat_flg = 0;	/* repeat mode flag */
static int report_flg = 0;	/* give report flag */
static int abort_flg  = 0;	/* abort activity flag */
static int break_flg  = 0;	/* break on error flag */
static int test_pass = 0;	/* test sequence number */
static int exit_flg = 0;	/* exit the tester	*/

/* local variables */
static char str[LINEMAX];
extern PT ptbl[];

tester()
	{
	register PT *p;

/*
	delay(300);
*/

	set_leds(LED_BI, LED_BI_COLOR, LED_TESTER);
	for (p = ptbl; p->pt_name != NULL; p++)
		if (p->pt_type == TEST) 
			if ((p->pt_name == 'a') || (p->pt_name == 'h'))
				if (IsStandalone())
				{
					p->pt_type = HIDE;
					p->pt_name = 'q';
				}

	exit_flg = 0;
	TestConfig();
	for (;;)
		{
		printf("\n Enter options (CR for menu)> ");
		gets(str);
		if (yyparse() != 0)
			{
			TestMenu();
			continue;
			}
		if (exit_flg != 0)
			{
			return 1;
			}
		/* perform selected informations */
		if (info_cnt)
			yyinfo();
		if (abort_flg)
			continue;

		/* perform selected tests and quasis */
		if (test_cnt || qtst_cnt)
			{
			do
				{
				yyaction();
				if (test_cnt)
					yyreport();
				}
			while (repeat_flg && !abort_flg);
			}
		}
	}

TestMenu()
	{
	register PT *p;
	int i = 0;

	PrintHdr();
	printf("\t\t\t\t\t\tDiagnostic Program Test Menu\n");
	printf("Tests:\n");
	for (p = ptbl; p->pt_name != NULL; p++)
		if (p->pt_type == TEST)	
				printf("  %c) %33-s%s",
				       p->pt_name, p->pt_desc, ++i&1 ? "" : "\n");
	if (i & 1)
		putchar('\n');
	printf("\tPORT options: [1 | 2 | 3 | A(ll)]  [i(nternal) | e(xternal)]\n");
/*	printf("\t'A' all ports, 'i' internal loopback, 'e' external loopback\n");*/

	printf("\nNon-Error Detecting Tests:\n");
	for (i = 0, p = ptbl; p->pt_name != 0; p++)
		if (p->pt_type == QTST)	
			printf("  %c) %33-s%s", p->pt_name, p->pt_desc, ++i&1 ? "" : "\n");
	if (i & 1)
		putchar('\n');

	printf("\nInformation Utilities:\n");
	for (i = 0, p = ptbl; p->pt_name != 0; p++)
		if (p->pt_type == INFO)	
			printf("  %c) %33-s%s", p->pt_name, p->pt_desc, ++i&1 ? "" : "\n");
	if (i & 1)
		putchar('\n');

	/* special symbol 'menu' */
	printf("\nTest Options:\n");
	printf("\t'A' all tests, '-' skip test,");
	printf(" '*' continous testing, '#' stop on error");
	printf("\n");
	}


TestStatus()
	{
	yyreport();
 	}

/*
 * fetch and parse a line of input from the screen
 */
yyparse()
	{
	register char	*s;
	register PT	*p;
	int	to_do = 0;
	int	flag = 1;
	char *prschnl();
	int	port = 0;

	/* reset control flags */
	test_cnt = 0;	/* real test counter */
	qtst_cnt = 0;	/* pseudo test counter */
	info_cnt = 0;	/* info counter */
	repeat_flg = 0;	/* repeat mode flag */
	report_flg = 0;	/* give report flag */
	abort_flg  = 0;	/* abort activity flag */
	break_flg  = 0;	/* break on error flag */
	test_pass = 0;	/* test sequence number */

	/* reset tableau options */
	for (p = ptbl; p->pt_name != 0; p++)
		{
		p->pt_slct = 0;	/* command not selected */
		p->pt_fail = 0;	/* no error yet */
		if (p->pt_name == 'p'  ||  p->pt_name == 'q')
			{	
			p->pt_prm1 = 0;	/* clears port option on 'p' */
			p->pt_prm2 = 0;	/* clears loopback option on 'p' */
			}
		}

	/* parse the commands */
	for (s = str; *s != EOS; s++)
		{
		switch(*s)
			{
		/* tests, quasi-tests, info */
		case 'S':	/* status */
			report_flg = 1;
		case 'a': 
		case 'b': 
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'k':
		case 'm':
		case 'n':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'x':
		case 'p':
		case 'q':
		case 'z':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'L':
		case 'R':
		case 'M':
		case 'N':
		case 'P':
		case 'Y':
		case 'X':
			/* find referenced test */
			for (p = ptbl; p->pt_name != *s; p++)
				if (p->pt_name == 0)
				{
					printf("Unrecognized command\n");
					return 0;
				}
			if (*s == 'X')
			{
				exit_flg = 1;
				return 0;
			}

			/* note selected test */
			switch(p->pt_type)
				{
			case TEST: 
				test_cnt += flag ? 1 : -1;
			case QTST:
				qtst_cnt += flag ? 1 : -1;
			case HIDE:
			case INFO: 
				info_cnt += flag ? 1 : -1;
				}
			p->pt_slct = flag;


			/* for ports, look for port number and int/ext */
			if (*s == 'p'  ||  *s == 'q')
			{
				while (1)
					{
					s++;
					if (*s == 'i')
						p->pt_prm2 |= 1; /* internal loop back */
					else if (*s == 'e')
						p->pt_prm2 |= 2; /* external loopback */
					else if ('1' <= *s && *s <= '3')
						{
						port = *s - '0';
						p->pt_prm1 |= (1 << (port - 1));
						}
					else if (*s == 'A')
						{
						/*
						 *	All 4 ports
						 */
						p->pt_prm1 = 0x0f;
						}
					else if (*s == ' ')
						{
						/* eat white spaces */
						}
					else
						{
						s--;
						break;
						}
					}	/* end while */
			}

			if (*s == 'm')
			{
				if ((*(s+1) != 'f') || (*(s+2) != 'g') || p->pt_type != HIDE)
				{
					printf("Unrecognized command\n");
					info_cnt = test_cnt = qtst_cnt = 0;
					return 0;
				}
				else
					return !(info_cnt + test_cnt + qtst_cnt);
			}
			if (*s == 'z')
			{
				if ((*(s+1) != 'c') || (*(s+2) != 'c') || p->pt_type != HIDE)
				{
					printf("Unrecognized command\n");
					info_cnt = test_cnt = qtst_cnt = 0;
					return 0;
				}
				else
					return !(info_cnt + test_cnt + qtst_cnt);
			}

			break;

		/* modifiers */
		case 'A':	/* all commands */
			for (p = ptbl; p->pt_name != 0; p++)
				if (p->pt_type == TEST && p->pt_slct == 0)
					{
					test_cnt++;
					p->pt_slct = 1;
					}
			break;
		case '-':	/* deselection */
			flag = 0;
			break;
		case '*':	/* repeat */
			repeat_flg++;	/* store up repeat counter */
			break;
		case '#':	/* repeat */
			break_flg = 1; 
			break;
		case '?':	/* get menu */
			return 1;

		/* white space */
		case ' ':
		case '\n':
		case '\t':
		case '':
		case '\r': 
			break;

		default:
			printf("Unrecognized command\n");
		/*	printf("'%c': Unrecognized option\n", *s);*/
			info_cnt = test_cnt = qtst_cnt = 0;
			return 0;
			}
		}

	/* no selections gives menu */
	return !(info_cnt + test_cnt + qtst_cnt);
	}


/*
 * perform the tests (one iteration)
 */
yyinfo()
	{
	register PT *p;

	/* perform the infos */
	for (p = ptbl; p->pt_name != 0; p++)
		{
		if (chkabort())	/* aborted */
			return abort_flg = TRUE;
		if (p->pt_slct && ((p->pt_type == INFO) || (p->pt_type == HIDE)))
			(*p->pt_actn)(p->pt_prm1, p->pt_prm2);
		}
	}

yyaction()
	{
	register PT *p;

	/* perform the infos */
	test_pass++;
	for (p = ptbl; p->pt_name != 0; p++)
		{
		if (chkabort())	
			{
			printf("\n\t\t-- Testing Aborted--\n");
			return;
			}
		if (p->pt_slct && p->pt_type != INFO)
			{
			if (p->pt_name == 'e' && test_pass > 10 && repeat_flg < 2)
				printf("\n  SKIPPING TEST  %c) %-30s\n\n",
				       p->pt_name, p->pt_desc);
			else
				{
				printf("\n  Now running %c) %-30s run %d\n\n",
				      p->pt_name, p->pt_desc, ++p->pt_runs);
				flush();
				if (p->pt_fail = (*p->pt_actn)(p->pt_prm1, p->pt_prm2))
					{	/* errored */
					p->pt_errs++;
					delay(30);
					if (break_flg)
						return abort_flg = TRUE;	/* no more repeating */
					}
				else
					if (p->pt_type != QTST)
						printf("\tTest Passed\n");
				}
			}
		}
	}


yyreport()
	{
	register PT *p;

	/* give error report */
	putchar('\n');
	putchar('\n');
	if (repeat_flg)
		printf("STATUS REPORT FOR TEST PASS %d\n", test_pass);
	else
		printf("STATUS REPORT FOR TEST(S)\n");
	
	putchar('\n');
	for (p = ptbl; p->pt_name != 0; p++)
		if (p->pt_type == TEST && (p->pt_slct || report_flg))
				printf(" %c) %-30s %5dF %5dR %s\n",
					p->pt_name,	p->pt_desc,
					p->pt_errs, p->pt_runs,
					p->pt_errs ? "FAILURE" : "       ");
	putchar('\n');
	delay(30);
	}



/*
 * HERE ARE INPUT ORGANIZING ROUTINES 
 *
 * getline - fetch a line of input from the screen.  newline terminates
 */
getline(prm, str, len)
char *prm;	/* prompt */
char *str; 	/* buffer for input */
int len;	/* buffer length */
	{
	register char *s;

	printf("%s", prm);	/* command request line */
	printf("getline\n");
	gets(str);
	}

/* 
 * scanline - break the line into words. return word count
 */
scanline(s, argv, argm)
char *s;		/* input source line */
char **argv;	/* arg vector */
int argm;		/* max number words */
	{
	register int argc = 0;
	register int wasblank = TRUE;
	
	while (*s != EOS)
		{
		if (charisblank(*s))
			{
			*s++ = EOS;
			wasblank = TRUE;
			}
		else
			{
			if (wasblank)
				{
				if (argc == argm)
					break;
				argv[argc++] = s;
				}
			s++;
			wasblank = FALSE;
			}
		}
	return argc;
	}

charisblank(c)
char c;
	{
	if (c==' ' || c=='\n' || c=='\r' || c=='\t' || c=='') 
		return TRUE;
	return FALSE;
	}


chkabort()
	{
	while (getch() != -1)
		{
		abort_flg = 1;
		}
	return abort_flg;
	}

delay(c)
int c;	/* number of 10 ms delay, i.e. 100 = 1 seconds	*/
	{
	volatile unsigned	i;
	volatile unsigned	k;

	while (c--)
		{
		if (chkabort())
			return;
		for (i = 0; i != 0x3333; i++)
			k = 0;
		}
	}

