/**			       
*
*	Program Name:	TESTER	for stanley
*
*	Filename:	memmod.c
*
*	$Log:   /b/gregs/bridge/tester/memmod.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 09:22:46   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 09:45:04   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:25:52   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:42:26   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		6.17.91
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:	
*
*	Comments:	The momory editor. 
*			-	display memory 
*			-	modify memory
*			-	fill memory
*
*			These functions are based on nindy.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/
/******************************************************************/
/* 		Copyright (c) 1989, 1990, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/

#include <defines.h>


static void badarg(char *);
static int read_data(unsigned int *);

/************************************************/
/* Modify Memory           			*/
/*                           			*/
/* if a hex address is				*/
/* specified, display/modify contents of memory	*/
/* at that address.				*/
/************************************************/
mem_modify( size, nargs, where, cnt )
int size;	/* BYTE or INTEGER  or SHORT */
int nargs;	/* Number of following arguments that are valid (1 or 2) */
char *where;	/* hex address (required)		*/
int cnt;	/* Number of items to display/mod (optional, default 1)	*/
{
char *addr;
unsigned int data;
int r;

	if ( !atoh(where,&addr) ){
		badarg(where);
		return 0;

	} else {
		if ( nargs < 2 )
			cnt = 1;  /* Set default */
		printf("\n");
		while ( cnt-- ) {
			printf( "%08X : ", addr );
			switch(size) {
			case BYTE:
				if ( read_data(&data) ){
					/*
					 *	Ask the user to enter
					 *	data again if the value
					 *	if greater than 0xff
					 */
					if (data > 0xff){
						cnt++;
						printf("Error: out of range (cannot > FF)\n");
						continue;
					}
					*(unsigned char*)addr = (unsigned char)data;
				}
				addr++;
				break;
			case SHORT:
				if ( read_data(&data) ){
					/*
					 *	Ask the user to enter
					 *	data again if the value
					 *	if greater than 0xff
					 */
					if (data > 0xffff){
						cnt++;
						printf("Error: out of range (cannot > FFFF)\n");
						continue;
					}
					*(unsigned short*)addr = (unsigned short)data;
				}
				addr += 2;;
				break;
				
			case INT:
				read_data((unsigned *)addr);
				addr += 4;
				break;
			}
		}
	}
	return 0;
}

/************************************************/
/* Display Memory               		*/
/*                           			*/
/* display contents of memory at that address.	*/
/************************************************/

mem_display( size, nargs, where, cnt )
int size;	/* BYTE, SHORT, or  INT */
int nargs;	/* Number of the following args that are valid (1 or 2) */
char * where;	/* hex address (required)		*/
int cnt;	/* Number of items to display (optional, default 1	*/
{
unsigned char byte_data;
int i;
int r;
int addr;

	if ( nargs < 2 ){
		cnt = 1;	/* Set default */
	}

	if ( !atoh(where,&addr) ){
		badarg( where );
		return 0;
	}


	while ( cnt-- ) {
		printf( "\n%08X : ", addr );

		switch (size) {
		case BYTE:
			byte_data = *(unsigned char *)addr;
			printf( "%02X", byte_data );

			/* print in ASCII if a printable character */
			if ((byte_data > 0x20) && (byte_data < 0x7f)) {
				printf("    %c", byte_data);
			}
			addr++;
			break;
		case SHORT:
			printf( "%04X",*(unsigned short *)addr );
			addr += sizeof(unsigned short);
			break;
		case INT:
			printf("%08X", *(unsigned int*)addr);
			addr += sizeof(unsigned int);
			break;

		}
	}
	return 0;
}

/************************************************/
/* Fill Memory 					*/
/*                           			*/
/************************************************/
mem_fill( size, dummy2, addr1, addr2, data )
int size;	/* BYTE, SHORT, or  INT */
int dummy2;	/* Ignored */
int *addr1;	/* Starting address to be filled */
int *addr2;	/* Ending address to be filled	*/
int data;	/* Word of data to fill with	*/
{
	switch(size) {
	case BYTE:
		while(addr1 <= addr2) 
			*((unsigned char *)addr1)++ = (unsigned char)data;
		break;

	case SHORT:
		while(addr1 <= addr2) 
			*((unsigned short *)addr1)++ = (unsigned short)data;
		break;

	case INT:
		while (addr1 <= addr2) {
			*addr1++ = data;
		}
		break;
	}
	return 0;
}


mem_exit()

	{
	return 1;
	}

static void badarg(s)
char *s;
{
	printf( "Bad argument: '%s'\n", s );
}


/************************************************/
/* Read Data                       	 	*/
/*                           			*/
/* Read a line of input from the user, and	*/
/* convert it to a hex value.  Return TRUE on	*/
/* success;  print "unchanged" and return FALSE	*/
/* on failure.					*/
/************************************************/
static int
read_data(data)
unsigned int *data;
{
char buf[16];
int retval;

	gets( buf);
	retval = atoh(buf,data);
	printf( "%s\n", retval ? "" : "unchanged" );
	return retval;
}

