/**			       
*
*	Program Name:	STANLEY TESTER
*
*	Filename:	diagnos.c
*
*	$Log:   /b/gregs/bridge/tester/ptbl.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 09:22:50   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 09:45:06   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:25:52   franks
 * Initial revision.
 * 
 *    Rev 1.1   20 Apr 1992 17:06:10   pvcs
 * No change.
 * 
 *    Rev 1.0   30 Mar 1992 17:42:28   pvcs
 * Initial revision.
*
*	Creation Date:	6.12.91
*
*	Date:
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	This is the TESTER module.  It allows an user
*			to invoke tests on the hardware.
*			This is based on the nim386 tester program.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <types.h>
#include <memory.h>
#include <nim960h.h>
#include <cmd.h>

/* external routines to do testing */
extern	int	TestAdminBus();
/*extern	int	TestBridge();*/
extern	int	TestConfig();
extern	int	TestDips();
/*extern	int	TestDram();*/
extern	int	TestEepEdit();
extern	int	TestEeprom();
extern	int	TestFlash();
/*extern	int	TestHSB();*/
extern	int	TestLeds();
extern	int	TestMemEdit();
/*extern	int	TestNVedit(); */
extern	int	TestNvram();
extern	int	reset();
extern	int	TestRefresh();
/*extern	int	TestSram();*/
extern	int	TestSharedRam();
extern	int	TestPort();
extern	int	TestStatus();
/*extern	int	TestTimer(); */
extern	int	TestUart();
extern	int	TestExit();

/* control flags */
static int test_cnt = 0;	/* counts tests specified */
static int qtst_cnt = 0;	/* counts quasi tests specified */
static int info_cnt = 0;	/* counts info stuff specified */
static int repeat_flg = 0;	/* repeat mode flag */
static int report_flg = 0;	/* give report flag */
static int abort_flg  = 0;	/* abort activity flag */
static int break_flg  = 0;	/* break on error flag */
static int test_pass = 0;	/* test sequence number */
static int exit_flg = 0;	/* exit the tester	*/

/* local variables */

static char str[LINEMAX];

PT ptbl[] = 
	{
/*	{ 'a', TEST, TestAdminBus,    -1, 0, 0, 0, 0, 0, "Admin bus"}, */
/*	{ 'd', TEST, TestDram,	 -1, 0, 0, 0, 0, 0, "Dynamic RAM"}, */
	{ 'e', TEST, TestEeprom, -1, 0, 0, 0, 0, 0, "EEPROM"},
	{ 'f', TEST, TestFlash,	 -1, 0, 0, 0, 0, 0, "Flash EPROM"},
/*	{ 'h', TEST, TestHSB, 	 -1, 0, 0, 0, 0, 0, "High speed bus"}, */
	{ 'L', QTST, TestLeds,   -1, 0, 0, 0, 0, 0, "LEDs sequence"},
	{ 'D', QTST, TestDips,	 -1, 0, 0, 0, 0, 0, "DIP switches"},
	{ 'n', TEST, TestNvram,  -1, 0, 0, 0, 0, 0, "Non-Volatile RAM"},
/*	{ 'r', TEST, TestRefresh,  -1, 0, 0, 0, 0, 0, "Refresh circuitry"}, */
/*	{ 's', TEST, TestSram,  -1, 0, 0, 0, 0, 0, "Static RAM"}, */
/*	{ 't', QTST, TestTimer,  -1, 0, 0, 0, 0, 0, "TIMER"}, */
	{ 'u', TEST, TestUart,   -1, 0, 0, 0, 0, 0, "UART"}, 
	{ 'x', TEST, TestSharedRam, -1, 0, 0, 0, 0, 0, "Shared RAM"}, 
	{ 'p', TEST, TestPort,    -1, 0, 0, 0, 0, 0, "PORT(s)"},
/*  	{ 'B', INFO, TestBridge,   -1, 0, 0, 0, 0, 0, "invoke the BRIDGE application"},*/
	{ 'C', INFO, TestConfig,   -1, 0, 0, 0, 0, 0, "Configuration status"},
/*	{ 'E', INFO, TestEepEdit,  0, 0, 0, 0, 0, 0, "Edit EEPROM"}, */
	{ 'R', INFO, reset,   -1, 0, 0, 0, 0, 0, "Reboot (power reset)"},
/*	{ 'M', INFO, TestMemEdit,  0, 0, 0, 0, 0, 0, "memory editor"},	*/
/*  	{ 'N', INFO, TestNVedit, -1, 0, 0, 0, 0, 0, "Edit non-volatile RAM"},*/
	{ 'S', INFO, TestStatus, -1, 0, 0, 0, 0, 0, "Status of Tests"},
	{ 'X', INFO, TestExit, -1, 0, 0, 0, 0, 0, "Exit the TESTER"},
	{ 0 }
	};
/*******************************************************************/

extern NIM960_HDR Nim960Header;		/* My nim960 header	*/

PrintHdr()
{
	int i, offset;

	printf("\r\n\n");
	offset = (80 - (strlen(Nim960Header.name) + 9 + 5))/2;
	for (i = 0; i != offset; i++)
		printf(" ");
	printf(Nim960Header.name);
	printf(" Version ");
	printf(Nim960Header.version);
	printf("\r\n");
	offset = (80 - strlen(Nim960Header.CopyRightMessage))/2;
	for (i = 0; i != offset; i++)
		printf(" ");
	printf(Nim960Header.CopyRightMessage);
	printf("\r\n");
}
