/*
 * name		QuadTest
 *
 * synopsis	void *QuadTest(address, length)
 *		QUAD	*address; <<	starting address of the memory
 *					to be tested.
 *		in	length; <<	of memory in number of bytes to
 *					be tested.
 *
 * description	It tests the memory by doing quad word writes to all memory
 *		starting at "address" with length "length" and then
 *		does quad word reads to check if the memory is ok or not.
 *		This test is non-destructive.
 *
 *		QuadTest(QUAD *address, int length)
 *			{
 *			QUAD	data;
 *		
 *			length = length / 16; 
 *			while(length--)
 *				{
 *				data = *address;
 *				*address = PATTERN;
 *				if (*address != PATTERN)
 *					{
 *					*address = data;
 *					return address;
 *					}
 *				*address++ = data;
 *				}
 *			return NULL;
 *			}
 *
 * returns	NULL	all memory is ok
 *		otherwise	address of the memory that fails the test
 */
	.text
	.align 4
 	.globl	_QuadTest
#
#	g0 = address
#	g1 = length
#
_QuadTest:
	shro	4, g1, g1	#	g1 in number of quad word
	subo	1, g1, g1	#	g1 = number of quad word to be 
				#	tested
	subo	1, 0, g2	#	ldconst -1, g2
	cmpibe.f	g1, g2, DoneReturn	# jump if we are done
						# all quad word
#
#	pattern to be written to ram
#
	ldconst	0x55555555, g4
	ldconst	0xaaaaaaaa, g5
	ldconst	0x99999999, g6
	ldconst	0x66666666, g7

NextQuadTest:
	ldq	(g0), r4		#	save quad word in r4 - r7
	stq	g4, (g0)		#	load quad word

	ldq	(g0), g8		#	read back the data from
					#	memory
					#	It should be ok most of the
					#	time
#
#	Check if the data in ram is the same as the data in
#	the register
#
	cmpibne.f	g4, g8, RestoreDataReturn
	cmpibne.f	g5, g9, RestoreDataReturn
	cmpibne.f	g6, g10, RestoreDataReturn
	cmpibne.f	g7, g11, RestoreDataReturn

QuadWordOk:
	stq	r4, (g0)		#	restore the original data
	addo	g0, 16, g0		#	next quad word address
	subo	1, g1, g1
	cmpibne.t	g1, g2, NextQuadTest

DoneReturn:
	mov	0, g0
	ret

RestoreDataReturn:
	stq	r4, (g0)	#	restore the original data
	ret

