/**
 *	Program Name:	nim960 bridge
 *	
 *	Filename:	testflash.c
 *
 *	$Log:   /b/gregs/bridge/tester/testflash.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 09:22:54   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 09:45:12   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:25:56   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:42:30   pvcs
 * Initial revision.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */
#include <types.h>
#include <memory.h>
#include <eeprecs.h>
#include <dips.h>
#include <nim960h.h>
/*
 *	Test the flash eprom.
 */
int TestFlash()

	{
	NIM960_HDR	*header = (NIM960_HDR *)FEPROM;
	unsigned short	csum;


	if (CheckFlash(FEPROM, eep_mfg_rec.eep_fprom_size) != 0)
		{
		return 1;
		}
	/*
	 *	Check if there is a program in the flash
	 */
	if (header->signature != NIM960_MAGIC ||
		header->Entry == NULL		||
		header->Entry == 0xffffffff	||
		((csum = cksum(FEPROM, header->FileLength >> 1)) != 0xffff && csum != 0))
		{
		printf("FPROM error: there is no program in flash\n");
		return 1;
		}
	return 0;
	}
