
/**
 *	Program Name:	nim960 bridge
 *	
 *	Filename:	ttest.c
 *
 *	$Log:   /b/gregs/bridge/tester/ttest.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 09:22:58   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 09:45:14   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:26:00   franks
 * Initial revision.
 * 
 *    Rev 1.1   12 May 1992 09:45:06   kwok
 * Do not modify "fault_cnt".
 * 
 *    Rev 1.0   30 Mar 1992 17:42:34   pvcs
 * Initial revision.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */
#include <types.h>
#include <dips.h>
#include <memory.h>
#include <uart.h>
#include <tmr.h>

volatile int tmr_flag;

extern tmrInt();
extern usecInt();
extern TimeTicksInt();
extern TimeSliceInt();

tmr_test(tmr, krnl_running)
int tmr;
int krnl_running;
{
	int i, vect;

#ifdef notdef
	Di();
	stop_timers();
#endif
	Ei();

	tmr_flag = 0;

	/* some places the timers are numbered 0 to 2, other places 1 to 3 */
	if (tmr >= 0  &&  tmr <= 2 )	/* if legal timer no. */
	{
#ifdef notdef
		Init_timers();
#endif
		prog_timers(tmr+1, tmrInt, 2, 1);
	}
#ifdef notdef
	if (tmr == 0)
	{
		Init_timers();
		prog_timers(1, tmrInt, 2, 1);
	}
	else if (tmr == 1)
	{
		Init_timers();
		prog_timers(2, tmrInt, 2, 1);
	}
#endif
	else
	{
		tmr_error(tmr, "Unknown timer specified\n");
		return 1;
	}

	for (i = 0; i != 0x4000; i++)
		if (tmr_flag != 0)
			break;

	if (tmr_flag == 0)
	{
		tmr_error(tmr, "No timer Interrupt\n");
		return 1;
	}

	Di();
	if (krnl_running)
	{
		/* Di(); */
		stop_timers();
		InitKrnlTimers();
		Ei();
	}
	return 0;
}



tmr_error(tmr, str)
int tmr;
char *str;
{
	clr_hw_int(tmr);
	printf("ERROR TIMER %d : ", tmr);
	printf(str);
}

