/**
 *	Program Name:	nim960 bridge
 *	
 *	Filename:	utest.c
 *
 *	$Log:   /b/gregs/bridge/tester/utest.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 09:22:58   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 09:45:16   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:26:00   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:42:34   pvcs
 * Initial revision.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */
#include <types.h>
#include <dips.h>
#include <memory.h>
#include <uart.h>
#include <sys.h>

volatile unsigned char test_char_out;
volatile struct SCCport *uart_port;

extern TimeTicksInt();
extern TimeSliceInt();
extern uartInt();


uart_test(port)
volatile struct SCCport *port;
{
	static unsigned char cmds[] = {
	    /*	wreg#	value					*/
	    /*	-----	-----					*/
		0x01,	0x12,	/* Int on All Rx, Tx Int Ena	*/
		0x03,	0xc0,	/* Read 8 bit data, auto enabled*/
		0x04,	0x44,	/* 16x clock, 1 stop bits	*/
		0x05,	0xe0,	/* Write 8 bit data use DTR	*/
		0x09,	0x0a,	/* No Reset, MIE		*/
		0x0b,	0xd2,	/* TxClk = RxClk = Baud Rate Gen*/
		0x0c,	0x12,
		0x0d,	0x00,
		0x0e,	0x11,	/* Local Loopback, Start Baud Rate Generator */
		0x03,	0xc1,	/* Enable Receiver		*/
		0x05,	0xea,	/* Enable Transmitter		*/
	};
	int i,j;
	int tc; 
	char c, test_char_in;
  	register word *DIP_SWITCH_ADDR = (word *)DIPIO;
	register SYS *sys_ptr = &sys;
	int	error_ret = 0;

	Di();
	stop_timers();
	if (!((port == CONSOLE) || (port == SLIP_PORT)))
	{
		uart_error(port, "Unknown port specified\n");
		return 1;
	}

	tc = (PCLK / (sys_ptr->sys_baud * 2 *16)) - 2;

	cmds[13] = (unsigned char)tc;

	cmds[15] = (unsigned char)(tc >> 8);


	SCCreset(port);

	eat_time(40);

	for ( i = 0; i < sizeof(cmds); i++ ){
		port->control = cmds[i];
		wait_uart(); /* wait for 15 cycles before start next cmd */
	}

	eat_time(80);

	init_hw_int(2, 50, uartInt);

	uart_port = port;
	test_char_out = 0x21;
	uart_data_out(port, test_char_out);
	for ( test_char_in = 0x21; test_char_in != 0x80; test_char_in++)
	{
		Ei();
		Di();
		for (i = 0; i != 0x5000; i++)
		{
			for (j = 0; j != 0x1000; j++)
				;
			if (SCCinrdy(port))
				break;
		}
		if (test_char_out == 0x21)
			{
			uart_error(port, "No transmit interrupt\n");/* no xmt int */
			return 1;
			}
		if (i == 0x5000)
			{
			uart_error(port, "No receive character\n");/* no rec char */
			return 1;
			}
		c = uart_data_in(port);
		if (c != test_char_in)
			{	
			uart_error(port, "Bad transmit character%c,%c\n", c, test_char_in);/* bad rec char */
			return 1;
			}
	}
	clr_hw_int(2);
	SCCinit(port, sys_ptr->sys_baud);
	eat_time(80);
	InitKrnlTimers();
	Ei();
	return 0;
}


uart_int_c()
{
	int i;

	uart_control_out(uart_port, 0);
	i = uart_control_in(uart_port);
	/* check for transmit buffer empty */
	if ((i & 0x04) || (i & 0x40))
	{
		if (test_char_out < 0x80)
		{
			uart_data_out(uart_port, ++test_char_out);
		}
	}
/*
	else
		error();
	eat_time(80);
*/
}

uart_error(port, str)
volatile struct SCCport *port;
char *str;
{
	register SYS *sys_ptr = &sys;

	clr_hw_int(2);
	SCCinit(CONSOLE, sys_ptr->sys_baud);
	printf("ERROR ");
	if (port == CONSOLE)
		printf("CONSOLE PORT : ");
	else if (port == SLIP_PORT)
		printf("SLIP PORT : ");
	printf(str);
}
