
/***********************************************************
 *
 *	Program Name:	nim960 multiport token ring bridge
 *
 *	Filename:
 *
 *	$Log:   /b/gregs/bridge/tr_config/auto.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:17:06   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:38:08   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:14:56   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 10:24:32   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:28:10   franks
 * Initial revision.
 *
 *	Creation Date:
 *
 *	Date:
 *
 *	Programmers:	Yan Ke
 *
 *	Modifications:
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 *
 ************************************************************/

#include	<types.h>
/*
#include <memory.h>
#include	"/b/gregs/bridge/include/memory.h"
*/
#include	<krnl.h>
#include	<scc_defs.h>
#include	<scc_buff.h>
#include	<brip.h>
#include	<dips.h>
#include	<sys.h>
#include	<eeprecs.h>
#include	<nvrecs.h>

#define SWAP_S(x) \
	( ((((x) & 0x00ff) << 8) & 0xff00) | \
	  ((((x) & 0xff00) >> 8) & 0x00ff) )

extern int		bootStage;
extern NVR_BSTATUS	*BridgeStatus;


byte	configCmds[4];
/*-------------------------------------------------------------------------
* Used by auto config to verify if downloaded commands
* are complete for ports. If not complete, Nvram parameters
* will be used instead. Each port use one byte, with bit assignment:
* 	bit 0: 1 if speed is set
*	bit 1: 1 if ring number is set
* 	bit 2: 1 if bridge number is set
*	bit 3: 1 if hub ring number is set
*	bit 4: 1 if virtual ring number is set (for port 0 only)
*-------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------
* build backplane ring map
* seearch for bootp and tftp server on all rings
* ports are attatched to rings with promiscuous mode
* config ports for connectivity
*-----------------------------------------------------------------------*/
TR_AutoConfig()
{
	int	port;
	int	mode;
	word	my_time;

	/*
	* port 1, 2 and 3 will be used to rotate backplane rings
	* during bootp stage, all ports are running promiscuous
	* mode so bootp reply can be recieved even without matching
	* mac address
	*/

	/*
	* We assume all ports are configured, run 16Mbps, and
	* port 0 is switched to the front with backplane disabled
	* port 1 is standalone with backplane disabled
	* port 2 is offline with backplane disabled
	* port 3 is offline with backplane disabled
	*/
	for (port=2; port<=3; port++)
		if ( GetOneBridgeLine(port) )
			printf("Warning: port %d can't be standalone\n", port);

	/*
	* to be safe, wait for 3 seconds to have
	* backplane ring map updated
	*/
	my_time = RealTimeTicks() + 300;
	while (my_time > RealTimeTicks())
		ReSchedule();

StartConfigAgain:

	if (BootpDisabled() || SearchBootpServer())
	{
		/*
		* bootp server disabled, or not found
		*/
		printf("Bootp disabled or failed\n");
		if (!SameHubSlotId())
		{
			/* location change */
			printf("location change\n");
			if (ConsoleConfig())
			{
				/*
				* go ahead with port deinserted
				* and with default config
				*/
				mode = 1;
				goto ExitAutoConfig;
			}
			else
				goto StartConfigAgain;	/* retry */
		}
	}

	/*
	* we come here because
	* (1) bootp is disabled and no location change, or
	* (2) bootp server is found, or
	* (3) bootp server is not found and no location change
	*/

	if (!VerifyBootRecord())
	/* boot record ok */
	{
		if (!SearchTftpServer())
		{
			/*
			* config the port with tftped
			* commands
			*/
			mode = 2;
			goto ExitAutoConfig;
#ifdef yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy
			/*
			* tftp server found and config file
			* parsed and executed
			*/
			if (!VerifyNvram())
			/* nvram parameter ok */
			{
				printf("Auto Configuration completed\n");
				mode = 0;
				goto ExitAutoConfig;
			}
			else
			{
				printf("Bad nvram parameters\n");
				if (ConsoleConfig())
				/* go ahead with port disabled */
				{
					mode = 1;
					goto ExitAutoConfig;
				}
				else
					goto StartConfigAgain;	/* retry */
			}
#endif /*yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy*/
		}
	}

	/*
	* we come here because
	* (1) boopt record is bad, or
	* (2) tftp server is not found
	*/

	/******************
	if (!SameHubSlotId() && UseNvramParamOK() && !VerifyNvram())
	******************/
	if (!SameHubSlotId() && UseNvramParamOK())
	{
		/* 
		* if no location change and
		* use of nvram parameter ok
		* then jump to application with ports
		* configured according to nvram
		*/
		mode = 0;
		goto ExitAutoConfig;
	}

	/*
	* oh well, nothing works, so this
	* is the only thing we can do
	*/

	if (!ConsoleConfig())
		goto StartConfigAgain;	/* retry */

	/* port deinserted */
	mode = 1;

	/*
	* configure the ports before leaving Auto Configuration
	* mode = 0 -> to config ports with nvram parameters
	* mode = 1 -> to deinsert ports with default config
	* mode = 2 -> to config ports with tftped cmds
	*/

ExitAutoConfig:
	/*
	* cause port config to be updated into BridgeStatus
	*/
	bootStage = 0;	/* no longer in bootp stage */

	/*
	* Update the hud id and slot id if I am inside a hub, and
	* the hubid slotid pairs is not the same as my last
	* Hubid and slotid.
	*/
	if (!SameHubSlotId())
	{
		eep_boot_rec.eep_hubid = GetHubID();
		eep_boot_rec.eep_slotid = GetSlotID();
		SaveEepBoot();
	}

	{
		/*
		* We set all ports to known starts before
		* executing config commands
		* Note: This is not very efficient
		* we will improve this later
		*/
		for (port=0; port<4; port++)
		{
			DeinsertPort(port);		/* StandAlone */
			SetPortSpeed(port, 1);		/* 16 Mbps */
		}
		SetPortFront(port, 1);
	}

	if (mode == 0)
	{
		SetPortByNvramParam();
	}
	else if (mode == 2)
	{
		for (port=0; port<4; port++)
			configCmds[port] = 0;

		ExeConfigCmd();

		/*
		* check if config commands are complete
		* print warning messages if not
		* current messages are concise
		* if necessary, we can make it more elaberate
		*/
		/*********
		for (port=0; port<4; port++)
		{
			if ( (configCmds[port] & 0xf) != 0xf)
				printf("Warning: missing port %d config commands, use NVRAM parameters\n", (port==0) ? 4 : port);
		}
		if ( (configCmds[0] & 0x10) == 0 )
			printf("Warning: missing virtual ring config command, use NVRAM parameter\n");
		*********/
	}
	/*
	* when leaving auto config, port status and nvram parameters
	* should be consistent
	*/
}


/*-------------------------------------------------------------------
* use port 1, 2 and 3 to rotate all backplane rings
* to find the booter server
* return 0 if bootp server is found
* return 1 otherwise
*-------------------------------------------------------------------*/
SearchBootpServer()
{
	int	ring;
	int	port;
	int	bootp_ring;
	int	more = 1;
	int	numberOfPortInserted = 0;

	if (bootp_ring = GetBootpRing())
	{
		printf("try bootp on the bootp ring %d\n", bootp_ring);
		/*
		* a ring is recorded and still available
		* use front port for external ring
		* use port 1 for backplane ring
		*/
		port = (bootp_ring == 15) ? 0 : 1;
		InsertPort(port, bootp_ring, 1);

		if (!DoBootp())
		{
			/* found bootp server on this ring */
			return 0;
		}

		DeinsertPort(port);
	}

	/*
	* no bootp ring available or server can not be
	* found any more on that ring, do poll next
	*/

	if (bootp_ring != 15)
	{
		/*
		* we didn't try the enxternal ring
		* so insert port 4 to external ring
		*/
		if (InsertFrontPort() == 0)
			numberOfPortInserted = 1;
	}

	printf("poll bootp server\n");
	/*
	* use port 1, 2 and 3 to rotate all available backplane rings
	*/
	for (ring=1; ring<=14 && more;)
	{
		if (ring == bootp_ring)
		{
			/* we have tried this ring, skip it */
			ring++;
			continue;
		}

		/*
		* insert each port into ring
		* stop until all ports tried
		* or all rings are tried
		*/
		for (port=1; port<=3 && ring<=14;)
		{
			if ( IsRingAvailable(ring) == 0 )
			/* this ring does not exist */
			{
				ring++;		/* goto next ring */
				continue;
			}

			/* find a available ring */

			if (!IsPortStandAlone(port))
			/* this port is not standalone, not usable */
			{
				port++;		/* goto next port */
				continue;
			}

			/* find a available port */

			printf("try insert port %d into ring %d\n", port, ring);
			if (InsertPort(port, ring, 1))
			/* insert failed */
			{
				/* mark this event */
				MarkRingFailure(port, ring);
				ring++;			/* goto next ring */
				continue;
			}
			numberOfPortInserted++;
		}

		if (numberOfPortInserted)
		{
			/*
			* we will do bootp when at least one port inserted
			*/
			printf("ready to try bootp server\n");
			if (more = DoBootp())
			/* bootp failed in this round */
			{
				printf("no bootp server, deinsert all ports\n");
				for (port=1; port<=3; port++)
					DeinsertPort(port);
				/*
				* since front port has been tried
				* we only count backring next
				*/
				numberOfPortInserted = 0;
			}
			else
			{
				/*
				* server is found, save the hub ring
				* number where server is located
				*/
				port = eep_boot_rec.eep_ThinNet;
				ring = GetPortHRingNum(port);
				/*
				* for fddi, we may not need this
				*/
				#ifdef yke
				BridgeStatus->bootp_hring = ring;
				#endif
				/* save into nvram */
				SaveBStatus();
				/*
				* we leave the ports as they are
				* and let ExitAutoConfig clean up
				*/
			}
		}
	}
	return more;
}


/*-------------------------------------------------------------------
* return 0 if ok
* return 1 otherwise
*-------------------------------------------------------------------*/
DoBootp()
{
	/*
	* BootpReqSend will call udpboot to send the bootp request
	* upon successful, it will copy the reply info to boot_rec
	*/
	return (!BootpReqSend(&eep_boot_rec));
}


/*-------------------------------------------------------------------
* return 1 if bootp is disabled
* return 0 if bootp is enabled
*-------------------------------------------------------------------*/
BootpDisabled()
{
	return (eep_boot_rec.eep_LocalConfig);
}


/*-------------------------------------------------------------------
* return 0 if get config file
* return 1 if otherwise
*-------------------------------------------------------------------*/
SearchTftpServer()
{
	int	ring;
	int	bootp_ring;
	int	port;
	int	more = 1;
	int	numberOfPortInserted = 0;

	if (bootp_ring = GetBootpRing())
	{
		printf("try tftp on the bootp ring %d\n", bootp_ring);
		/*
		* a ring is recorded and still available
		* use front port for external ring
		* use port 1 for backplane ring
		*/
		port = (bootp_ring == 15) ? 0 : 1;
		InsertPort(port, bootp_ring, 1);

		if (!DoTftp())
		{
			/* found bootp server on this ring */
			return 0;
		}

		DeinsertPort(port);
	}

	/*
	* no bootp ring available or server can not be
	* found any more on that ring, do poll next
	*/

	if (bootp_ring != 15)
	{
		/*
		* we didn't try this
		* so insert port 4 to external ring
		*/
		if (InsertFrontPort() == 0)
			numberOfPortInserted = 1;
	}

	printf("poll tftp server\n");
	/*
	* use port 1, 2 and 3 to rotate all available backplane rings
	*/
	for (ring=1; ring<=14 && more;)
	{
		if (ring == bootp_ring)
		{
			/* we already tried this ring, skip it */
			ring++;
			continue;
		}

		/* insert each port into ring */
		/* stop until all ports tried */
		/* or all rings are tried */
		numberOfPortInserted = 0;
		for (port=1; port<=3 && ring<=14;)
		{
			if ( IsRingAvailable(ring) == 0 )
			/* this ring does not exist */
			{
				ring++;		/* goto next ring */
				continue;
			}

			/* find a available ring */

			if (!IsPortStandAlone(port))
			/* this port is not standalone, not usable */
			{
				port++;		/* goto next port */
				continue;
			}

			/* find a available port */

			printf("try insert port %d into ring %d\n", port, ring);
			if (InsertPort(port, ring, 1))
			/* insert failed */
			{
				/* mark this event */
				MarkRingFailure(port, ring);
				ring++;			/* goto next ring */
				continue;
			}
			numberOfPortInserted++;
		}

		if (numberOfPortInserted)
		{
			/*
			* we will do tftp when at least one port inserted
			*/
			printf("ready to try tftp server\n");
			if (more = DoTftp())
			/* tftp failed in this round */
			{
				printf("no tftp server, deinsert all ports\n");
				for (port=1; port<=3; port++)
					DeinsertPort(port);
			}
			/*
			* we do not record ring number upon
			* successful tftp
			*/
		}
	}
	return more;
}


/*-------------------------------------------------------------------
* return 0 if ok
* return 1 otherwise
*-------------------------------------------------------------------*/
DoTftp()
{
	return ( !Configure(eep_boot_rec.eep_ServerIP,
		eep_boot_rec.eep_config_file) );
}


#ifdef yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy
/*--------------------------------------------------------------------
* return 1 if there are violations
* return 0 if all ok
*--------------------------------------------------------------------*/
VerifyNvram()
{
	int	i,j;
	int	ring[4];
	int	bridge[4];
	int	vring;
	word	portbit;

	/* decode bridge numbers, ring numbers and virtual */
	/* ring number from the nvram records */
	for (i=0; i<4; i++)
	{
		ring[i] = GetPortRingNum(i);
		bridge[i] = GetPortBridgeNum(i);
	}
	vring = GetVirtualRing();

	/* ring numbers and bridge numbers should be within range */
	if (vring < 1 || 4095 < vring)
		return 1;
	for (i=0; i<4; i++)
	{
		if (ring[i] < 1 || 4095 < ring[i])
			return 1;
		if (bridge[i] < 0 || 15 < bridge[i])
			return 1;
	}

	/* no two ring numbers should be the same */
	for (i=0; i<4; i++)
	{
		if (vring == ring[i])
			return 1;
		for (j=0; j<i; j++)
			if (ring[i] == ring[j])
				return 1;
	}
	
	/* speed of the port should be consistant with the speed */
	/* of the ring they intends to insert to */
	for (i=0, portbit=1; i<4; i++, portbit<=1)
	{
		int ring_speed;
		int hring = BridgeStatus->h_ring[i];
		int speed = BridgeStatus->ring_speed & portbit;

		if ( ((ring_speed = GetRingSpeed(hring)) != 2) &&
			(ring_speed != speed) )
		{
			/*
			* ring exists and with different speed
			*/
			return 1;
		}
	}

	/* everything is ok */
	return 0;
}
#endif /*yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy*/


/*---------------------------------------------------------------------
* Config all ports according nvram parameters
* For each port it does:
*	(1): set up port speed
*	(2): insert port into hub ring
*	(3): set up SRA
* return 0 if all ok
* return 1 otherwise
*---------------------------------------------------------------------*/
SetPortByNvramParam()
{
	int hring;
	int speed;
	int port;
	int result;

	result = 0;
	for (port=0; port<4; port++)
	{
		if (IsPortOffLine(port))
		{
			/*
			* get a bridge line for this port
			* we continue even when it failed
			*/
			GetOneBridgeLine(port);
		}

		/* set port speed */
		SetPortSpeed(port, GetPortSpeed(port));

		/* set ring attachment */
		if ( (hring = GetPortHRingNum(port)) == 0 )
			continue;

		/*
		* check validity of SRA parameters
		*/
		if ( GetVirtualRingNum(port) < 1 ||
			GetVirtualRingNum(port) > 0xfff ||
			GetPortRingNum(port) < 1 ||
			GetPortRingNum(port) > 0xfff ||
			GetPortBridgeNum(port) < 0 ||
			GetPortBridgeNum(port) > 0xf )
		{
			printf("Invalid ring or bridge numbers, Abort\n");
			continue;
		}

		if (InsertPort(port, hring, 0))
		{
			printf("insert port %d into ring %d failed\n",
				port, hring);
			result |= 1;
			continue;
		}

		/*
		* next set up SRA
		*/
		chnl_set_sra(port, GetPortRingNum(port),
			GetPortBridgeNum(port), GetVirtualRingNum());
	}
	return result;
}


/*----------------------------------------------------------------------
* Insert front port into the external ring, try with different speed
* return 0 if ok 
* return 1 otherwise
*----------------------------------------------------------------------*/
InsertFrontPort()
{
	int 	speed;

	printf("insert front port\n");

	/*
	* first try with the current speed setting
	*/

	/*
	* for fddi, there is only one speed
	*/
	#ifdef yke
	speed = (BridgeStatus->ring_speed & 0x1) ? 1 : 0;
	SetPortSpeed(0, speed);
	if ( InsertPort(0, 15, 1) )
	{
		/*
		* failed, change speed and try again
		*/
		printf("failed, change speed and try again\n");
		speed = (speed == 1) ? 0 : 1;
		SetPortSpeed(0, speed);
		/* try again */
	#endif
		if ( InsertPort(0, 15, 1) )
		{
			/*
			* failed again, give up
			*/
			printf("failed again, give up\n");
			/*
			* give up, since port 0 has no
			* bridge line now, so put it offline
			*/
			SetPortOffLine(0);
			SetPortRcvLine(0, 23);
			return 1;
		}
	#ifdef yke
	}
	#endif
	return 0;
}


/*----------------------------------------------------------------------
* Check if I am in the same Hub and Slot as before.
* return 1 if yes
* return 0 if no
*----------------------------------------------------------------------*/
int
SameHubSlotId()
{
	if (IsStandalone())
	{
		if (GetHubID() != eep_boot_rec.eep_hubid || 
			GetSlotID() != eep_boot_rec.eep_slotid)
		{
			return 0;
		}
	}
	return 1;
}


/*----------------------------------------------------------------------
* Tftp parameters are ok if
* - my ip address is ok, and
* - server ip address is ok, and
* - config file is not NULL, and
* - if server on a differnet net, at least one router ip is valid
* return 0 if ok
* return 1 otherwise
*----------------------------------------------------------------------*/
int
VerifyBootRecord()
{
	EEP_BOOT	*boot_rec;

	boot_rec = &eep_boot_rec;

	if (!IsIpMulticast(boot_rec->eep_IP, boot_rec->eep_NetMask) && 
		!IsIpMulticast(boot_rec->eep_ServerIP, boot_rec->eep_NetMask) &&
		boot_rec->eep_config_file[0] != '\0')
	{
		if ((boot_rec->eep_IP & boot_rec->eep_NetMask) == (boot_rec->eep_ServerIP & boot_rec->eep_NetMask) ||
			!IsIpMulticast(boot_rec->eep_RouterIP[0], boot_rec->eep_NetMask) ||
			!IsIpMulticast(boot_rec->eep_RouterIP[1], boot_rec->eep_NetMask))
			return 0;
	}
	return 1;
}


/*----------------------------------------------------------------------
* Ask the user if he/she wants to config. the module 
* manually or start the auto-config sequence again.
* If there is no response after 5 min., it times out and return.
* return 1 if user wants manual configuration
* return 0 if user does not want manual config, or timeout.
*----------------------------------------------------------------------*/
int
ConsoleConfig()
{
	int	ticks;		/* for 5 minutes time out	*/
	int	PromptTicks;	/* for 10 seconds time out	*/
	int	ch;
	int	prompt = 1;

	ticks = RealTimeTicks();
	PromptTicks = ticks;
	for (;;)
	{
		if ((RealTimeTicks() - PromptTicks) > 1000)
		{
			prompt = 1;
			PromptTicks = RealTimeTicks();
		}
		if (prompt)
		{
			printf("\n\nDo you want to configurate this module manually [y/n] ? \n");
			printf("[y] to jump to the bridge program with all ports disabled\n");
			printf("[n] to re-start the auto-configuration ==>");
			prompt = 0;
		}
		if ((RealTimeTicks() - ticks) > 30000)
		{
			printf("\nConsole prompt times out, auto-configuration is re-started\n\n");
			return 0;
		}
		ch = getch();
		if (ch != -1)
		{
			putchar(ch);
			putchar('\n');
			if (ch == 'y' || ch == 'Y')
				return 1;
			if (ch == 'N' || ch == 'n')
				return 0;
			ticks = RealTimeTicks();
			PromptTicks = RealTimeTicks();
			prompt = 1;
		}
		ReSchedule();
	}
}


/*-----------------------------------------------------------------------
* return 1 if yes
* return 0 if no
*-----------------------------------------------------------------------*/
int
UseNvramParamOK()
{
	return (sys.sys_switch & DIP_DEFAULT_OK);
}


/*-----------------------------------------------------------------------
* Check if a ring has been recorded for the bootp server
* If yes, check if it is still exists, then attach to it
* return 0 if no ring recorded
* otherwise return the recorded hub ring number
*-----------------------------------------------------------------------*/
int
GetBootpRing()
{
	int hring;
	int result;

	/*
	* for fddi, we may not need this
	*/
	return 0;
	#ifdef yke
	hring = BridgeStatus->bootp_hring;
	if (hring < 1 || hring > 15)
	/* no ring recorded */
		return 0;

	if ( hring != 15 && IsRingAvailable(hring) == 0 )
	/* recorded ring no long exists */
		return 0;

	return hring;
	#endif
}


MarkRingFailure(ring)
int ring;
{}


static int IsIpMulticast(in_name ip, in_name netmask)
{
	return ip == 0 || ip == -1 || (ip & ~netmask) == ~netmask;
}
