#include <types.h>
#include <krnl.h>
#include <dbd.h>
#include <task.h>
#include <error.h>
/*
#include <usernvra.h>
*/
#include <netbuf.h>
#include <tcpip.h>
/*
#include <sytek.h>
*/
#include <memory.h>

#include <ascii.h>
#include <param.h>
#include <834parser.h>
#include <cpb.h>

#define	SIZE_CONFIG_CMD_BUFF	1024

static char     crovrbuff[256];
static char	line[256];

static int	firstline = 0;
static int    	crossoverflag;
static int	resetLflag;
static int	prevResetLev;
static int	lastResetLevel;		/* level of last reset */
static char	*currentPtr;
static char	*cmdBufStart;
static int	cmdBufOverflow = 0;

int	ConfigTsrvr();

extern RAM_PIT	rampit;
extern CPB_T	cpb;

int Configure(ipaddr,configfile)
long	ipaddr;
char	*configfile;
{
	int FileLength;
	
	crossoverflag = 0;
	resetLflag = 0;
	prevResetLev = 1;
	firstline = 0;

	/*
	* prepare the config command buffer
	*/
	if ( (cmdBufStart = (char *)lmalloc(SIZE_CONFIG_CMD_BUFF)) == 0 )
	{
		printf("no space for config commands, abort Tftp!!\n");
		return FALSE;
	}
	memset(cmdBufStart, 0, SIZE_CONFIG_CMD_BUFF);
	currentPtr = cmdBufStart;

	/*
	* get last time's reset level
	* if no records, set to 1
	*/
	if ( (lastResetLevel = GetLastResetLevel()) == 0 )
		lastResetLevel = 1;

	FileLength = TftpLoadFile(ipaddr,configfile,"netascii",ConfigTsrvr);

	if(FileLength == 0)
		return FALSE;

	if (cmdBufOverflow)
	{
		printf("Warning: Command buffer overflow!\n");
		printf("Some commands not executed!\n");
	}

	return TRUE;
}


int ConfigTsrvr(int BlockNumber, char *Packet, int PacketLength)
{
        static char     *next = line;
        int     length;
	char	*cmd_ptr();
	char	*cmdptr;
	int	status;
	int	localSize;

	/*print_mem(Packet, PacketLength);*/

	localSize = PacketLength;
        while (localSize > 0)
        {
		memset(line, 0, 256);
		if((cmdptr = cmd_ptr(next,Packet,&localSize,&status)) == NULL)
		{
			if(PacketLength < 512)
			{
				crossoverflag = 0;
				if(strlen(next) == 0)
					break;
			}
			else
				return TRUE; /* There is a line cross-over */
		}
		Packet = cmdptr;

		/*
		printf("Packet = %08x\n", Packet);
		print_mem(next, 0x20);
		*/

		if(status)
		{
			status = 0;
			Errorlog(1,"Line exceeded the buffer length");
			continue;
		}

		if (length = processLine(next))
		{
			/*
			* need to execute this command later
			* save it into our cmd buffer
			*/
			SaveConfigCmd(next, length);
			continue;
		}
	}

	Errorlog(1,"\nToken Ring Bridge Configuration Complete.\n");
        return TRUE;
}


/*------------------------------------------------------------------------
* This function returns a char pointer to the next occurrence of a
* character. 
*------------------------------------------------------------------------*/
char	*cmd_ptr(buffer,packet,len,stat)
char	*buffer;
char	*packet;
int	*len;
int	*stat;
{
        int     c,j,
		i = 0;
        char    *p = buffer;

	j = *len;
	
	while (*len > 0)
	{
		/*
		* Handle the 0xd and 0xa 's here if there is no
		* crossover.  If the command ends at the 512th 
		* byte and the next packet has only 0xd and 0xa
		* then it is handled in the else after this if.
		*/
		if(!crossoverflag && (*packet == '\r' || *packet == '\n'))
		{
			packet++;
			(*len)--;
		}
		else
		{
			if(crossoverflag)
			{
				if(*packet == '\r' || *packet == '\n')
				{
					crossoverflag = 0;
					strcpy(p,crovrbuff);
					memset(crovrbuff, 0, 256);
					while(*packet == '\r' || *packet == '\n')
					{
						packet++;
						(*len)--;
					}	
					return(packet);
				}
			}
			/* Copy the line into a buffer */
        		while((*len) > 0 &&
				((c = *buffer++ = *packet++) != '\r')
				&& c != '\n')
        		{
				(*len)--;
                		if((buffer - p) > 0x84)
				{
					*stat = 1;
					while((*len)-- && (*packet++ != '\n' || *packet++ != '\r'));
                        		return packet;
				}
                		continue;
        		}
			if(crossoverflag == 1)
			{
				crossoverflag = 0; 
				buffer--;
				*buffer++ = '\0';
				*stat = 0;
				strcat(crovrbuff,p);
				strcpy(p,crovrbuff);
				memset(crovrbuff, 0, 256);
				return(packet);
			}
			/*
			* if there is no crossover, terminate the line and
			* return a pointer to the next command line. If the
			* line copied into buffer is a comment go back into
			* the loop.
			*/

			if(*len > 0 && !crossoverflag)
			{
				buffer--;
				*buffer++ = '\0';
				return packet;
			}
		}
	}

	/*
	* There is a cross over, set the flags and
	* copy the data into a buffer
	*/
	if(*len == 0)
	{
		crossoverflag = 1;

		if(p != buffer)
		{
			*++buffer = '\0';
			strcpy(crovrbuff,p);
		}

		if(p == buffer)
			buffer[0] = '\0';
		return(NULL);
	}
}


/*--------------------------------------------------------------------------
* This function returns the length of the command line.  If the
* command line is a comment or $, it returns 0.  It also returns 0 for
* a legal command if the reset level number associated with the $ sign is
* greater than the last time's reset level. Help, Show and initialize
* commands are not allowed. A zero is returned for those commands.	
*--------------------------------------------------------------------------*/
processLine(buffer)
char	*buffer;
{
	int i = 0;
	int compare_cmd();
	if(*buffer == '#')
		return 0;

	if(firstline == 0)
	{
        	if(strncmpx(buffer,"load",4) == 0)
                {
			/*printf("this is a load command\n");*/
			firstline = 1;
			return 0;
                }
	}	
	else
	{
		if(compare_cmd(buffer) == TRUE)
		{
			/*printf("this is a bad command\n");*/
			return 0;
		}

		if((*buffer != '$') && (resetLflag == 1))
			return 0;

		if(*buffer == '$')
		{
			printf("this is a reset command\n");
			i = atoi(&buffer[1]);
			/*printf(" reset  level = %d\n", i);*/

			if((i < 1) || (i > 4))
			{
				Errorlog(1,"Invalid Reset Level\n");
				resetLflag = 1;
				return 0;
			}

			if(i <= lastResetLevel )
			{
				if(i < prevResetLev)
				{
					resetLflag = 1;
					return 0;
				}
				else
				{
					prevResetLev = i;
					resetLflag = 0;
					return 0;
				}
			}
			else
			{
				resetLflag = 1;
				return 0;
			}
		}
		/*printf(" this is a normal command\n");*/
		return (strlen(buffer));
	}
}


compare_cmd(buf)
char *buf;
{
	if(strncmpx(buf,"ini",3) == 0 || strncmpx(buf,"h",1) == 0
 		|| strncmpx(buf,"sho",3) == 0)
		return TRUE;
	else 
		return FALSE;
}

 
/*-------------------------------------------------------------------------
* This function executes the command passed to it
*-------------------------------------------------------------------------*/
int Xcutecmd(ptr,pit,pcpb)
char	*ptr;
RAM_PIT	*pit;
CPB_P	pcpb;
{
	int sta;

	strcpy(pit->cmd_line,ptr);
	prepare_cpb();

        if((sta=executecmd(pcpb)))
	{
		Errorlog(0,"%s CANNOT BE EXECUTED ON CONSOLE\n",ptr);
      	  	usererr(sta,pcpb);
		return FALSE;
	}
	return TRUE;
}


SaveConfigCmd(thisline, len)
char *thisline;
int len;
{
	/* we need to have space for two nulls at the end */
	if (currentPtr + len + 2 < cmdBufStart + SIZE_CONFIG_CMD_BUFF)
	{
		/* have room for saving this command */
		memcpy(currentPtr, thisline, len);
		currentPtr += len;
		*currentPtr++ = 0;	/* put a null at end */
	}
	else
	{
		/*
		* no more space for this space
		* we will still continue tftp
		* as we might save smaller command
		*/
		cmdBufOverflow = 1;
	}
}


ExeConfigCmd()
{
	int	i;
	int	count = 0;
	RAM_PIT *pram=&rampit;
        CPB_P	pcpb=&cpb;

	printf("Looking through saved commands\n");
	currentPtr = cmdBufStart;
	while (*currentPtr)
	{
		memset(line, 0, 256);
		for (i=0; *currentPtr && (i<256); i++)
			line[i] = *currentPtr++;

		if (i == 256)
		{
			/*
			* command too long
			* something is wrong, quit
			*/
			printf("Error: configuration file corrupted\n");
			break;
		}

		/* i number of char copied */
		pram->ii = i;
		printf("(%d) Executing command %s\n", ++count, line);
		if (Xcutecmd(line, pram, pcpb) == FALSE)
		{
			printf("Warning: unknown command in config file\n");
		}
		/* move to next cmd */
		currentPtr++;
	}
}


#ifdef yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy
SetLoadAddress(header,LdAddress)
char *header;
byte **LdAddress;
{
	return TRUE;
}
AddressInSram(byte *address, int size)
{
	return TRUE;
}
AddressInDram(byte *address, int size)
{
	return TRUE;
}
#endif /*yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy*/
