/**
 *	Program Name:	nim960 program
 *
 *	Filename:	ctrlio.c
 *
 *	$Log:   /b/gregs/bridge/util/ctrlio.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:20:00   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:39:48   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:16:18   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 10:34:18   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:30:06   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:44:44   pvcs
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/
#include "types.h"
#include "memory.h"
#include "sys.h"


set_ctrl1(mask, value)
register word mask;
register word value;
{
	register word val;
	register SYS *sys_ptr = &sys;

	val = sys_ptr->sys_ctrl1;
	val &= ~mask;
	val |= value;
	sys_ptr->sys_ctrl1 = val;
	*(ushort *)SNCENA = (ushort)val;
}

set_ctrl2(mask, value)
register word mask;
register word value;
{
	register word val;
	register SYS *sys_ptr = &sys;

	val = sys_ptr->sys_ctrl2;
	val &= ~mask;
	val |= value;
	sys_ptr->sys_ctrl2 = val;
	*(ushort *)CONTROL_IO = (ushort)val;
}

enable_wdt()
{
	register SYS *sys_ptr = &sys;

	if (sys_ptr->sys_wdt_enable)
		--sys_ptr->sys_wdt_enable;

	if (!(sys_ptr->sys_wdt_enable))
		set_ctrl1(CTRL1_SYS_WDT, ENABLE_SYS_WDT);
}

disable_wdt()
{
	register SYS *sys_ptr = &sys;

	if (!(sys_ptr->sys_wdt_enable))
		set_ctrl1(CTRL1_SYS_WDT, DISABLE_SYS_WDT);
	sys_ptr->sys_wdt_enable++;
}

Enable_wdt()
{
	set_ctrl1(CTRL1_SYS_WDT, ENABLE_SYS_WDT);
}

