
/**
 *	Program Name:	nim960 program
 *
 *	Filename:	dbdbuf.c
 *
 *	$Log:   /b/gregs/bridge/util/dbdbuf.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:20:02   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:39:48   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:16:18   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 10:34:20   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:30:06   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:44:46   pvcs
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/
#include <krnl.h>
#include <types.h>
#include <dbd.h>

extern	int fault_cnt;

MBOX FreeMbox;
DBD *dbd_start;

init_dbd(mem_ptr, buf_size, cnt)
byte *mem_ptr;
int  buf_size;
int  cnt;
{
	int	i;
	DBD	*dbdp = (DBD *)mem_ptr;
	byte	*bufp = (byte *)(mem_ptr + (sizeof(DBD) * cnt));
	
	dbd_start=dbdp;
	CreatMailbox(&FreeMbox);	/* mailbox for free pkts for SNMP */
	for (i = 0; i < cnt; i++, dbdp++, bufp += buf_size)
	{
		dbdp->db_idmark = DBD_MARK; 	/* buffer type */
		dbdp->db_nxtdbd = NULL;	/*	     */
		dbdp->db_buffer = bufp;	/* user's buffer addr */
		dbdp->db_bufsiz = buf_size;	/* set buffer length */
		dbdp->db_actcnt = 0;		/* no data in it yet */
		dbdp->db_indent = 0;		/* user's receive indent */
		dbdp->db_contrl = 0;		/*DBDNWUSR;*/
		dbdp->db_index  = i;            /* index for channel driver */
		SendMessage((MSGHDR *)dbdp, &FreeMbox);/* buffers */
	}
}

DBD *get_dbd()
{
	DBD	*dbdp;

	Di();
	if (dbdp = (DBD*)AcptMessage(&FreeMbox))	/* get a free buffer */
	{
		dbdp->db_idmark = DBD_MARK; 	/* buffer type */
		dbdp->db_nxtdbd = NULL;		/*	     */
		dbdp->db_contrl = 1; 		/* one user */
		dbdp->db_actcnt = 0;		/* no data in it yet */
		dbdp->db_snccnt = 0;            /* no xmit now */
		dbdp->db_indent = 0; 		/* no indenting */
		dbdp->db_rcvportno=0;		/* mark as chnl 1 */
		dbdp->db_xmtportlist=0;			
	}
	Ei();
	return dbdp;
}


free_dbd(dbdp) 
DBD	*dbdp;		/* DBD ptr */
{
	Di();
	if ((dbdp->db_contrl == 0) || (dbdp->db_idmark != DBD_MARK))
	{
	    printf("fatal error %x\n", dbdp);
	    if (dbdp->db_contrl == 0)
		printf("db_contrl is 0");
	    if (dbdp->db_idmark != DBD_MARK)
		printf("Bad dbd marker %x", dbdp->db_idmark);
	}

	--dbdp->db_contrl;
	if (dbdp->db_contrl == 0)          /* last user is done free it */
	{
		dbdp->db_nxtdbd = 0;	/* end of list has null fwp */
		SendMessage((MSGHDR*)dbdp, &FreeMbox);		
	}
	Ei();
}

