/**			       
*
*	Program Name:	TESTER for stanley
*
*	Filename:	memhelp.c
*
*	$Log:   /shasta/pvcs/boot/tester/boothelp.c_v  $
 * 
 *    Rev 1.0   07 Jan 1993 09:46:26   holeman
 * Initial revision.
 * 
 *    Rev 1.2   12 Nov 1992 10:52:08   jlin
 * 
 *    Rev 1.1   12 Nov 1992 10:50:58   jlin
 * 
 *    Rev 1.1   11 Nov 1992 16:15:00   jlin
 * Add FDDI help
 * 
 *    Rev 1.0   01 Jul 1992 13:12:34   holeman
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		6.17.91
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	This is the help function for the memory editor. 
*			It is based on the nindy user interface.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/


/******************************************************************/
/* 		Copyright (c) 1990, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/


#include "defines.h"

static const char
help_all[] =
	".                - repeat previous command\n"
	"? [cmd]          - help info for optional cmd\n"
	"he[lp] [cmd]     - help info for optional cmd\n"
	"cl[ear]          - clear the boot record\n"
	"di[splay]        - display the boot record\n"
	"ed[it]           - modify the boot record\n"
#ifdef __FDDI_CON
        "df[ddi]          - display the FDDI boot record\n"
        "ef[ddi]          - modify the FDDI boot record\n"
#endif
	"ex[it]           - exit the editor\n"
	"up[date]         - update the boot record\n"
	;

static const char
dot_help[] =
	".\n"
	"  Repeat previous command.\n";

static const char
cl_help[] =
	"cl[ear]\n\n"
	"  Clear the boot record copy in RAM.\n";

static const char
di_help[] =
	"di[splay]\n\n"
	"  Display the boot record copy in RAM.\n";

static const char
ed_help[] =
	"ed[it]\n\n"
	"  Modify the boot record copy in RAM.\n";

#ifdef __FDDI_CON
static const char
df_help[] =
	"df[ddi]\n\n"
	"  Display the FDDI boot record copy in RAM.\n";

static const char
ef_help[] =
	"ef[ddi]\n\n"
	"  Modify the FDDI boot record copy in RAM.\n";
#endif

static const char
ex_help[] =
	"ex[it]\n\n"
	"  Exit the boot editor and return to the main menu.\n";

static const char
up_help[] =
	"up[date]\n\n"
	"  Write the RAM copy of the boot record to nvram\n";

static const char
he_help[] =
	"he[lp] [<command>]\n"
	"? [<command>]\n"
	"  Gives help for optional 'command'.  If no 'command' is specified\n"
	"  or unknown 'command', print short version of all commands.\n";

const char *
boot_help_table[] = {
	help_all, dot_help, he_help, cl_help, di_help, ed_help, 
#ifdef __FDDI_CON
	df_help, ef_help, 
#endif
	ex_help, up_help, 
	NULL
};


#ifdef __FDDI_CON
extern const char edfddi_help_all[];
extern const char dfddi_help_all[];

const char *
edfddi_boot_help_table[] = {
        edfddi_help_all, dot_help, he_help, ex_help,
	NULL
	};

const char *
dfddi_boot_help_table[] = {
        dfddi_help_all, dot_help, he_help, ex_help, 
	NULL
	};
#endif
