/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of
   Intel Corporation not be used in advertising or publicity
   pertaining to distribution of the software or the documentation
   without specific, written prior permission.

   Intel Corporation does not warrant, guarantee or make any
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness,
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own
   risk.							  */
/******************************************************************/

# ------ declare the below symbols public
        .globl  _Nim960Header

  	.set	TRC_MAGIC,		0x5566
	.set	PROGRAM_NAME_OFFSET,	48
	.set	COPYRIGHT_OFFSET,	80

	.text
        .align  4

/*
 *************	The nim960 header ******************
 *
 *	struct nim960_header
 *		{
 *		unsigned short	signature;
 *		unsigned short	CheckSum;
 *		unsigned long	FileLength; 
 *		unsigned long	time;
 *		unsigned long	TextLength;
 *		unsigned long	DataLength;
 *		unsigned long	BssLength;
 *		unsigned long	Entry;
 *		unsigned long	TextLoadAddress;
 *		unsigned long	DataLoadAddress;
 *		unsigned long	ProgramId;
 *		unsigned char	version[8];
 *		char	name[32];
 *		char	CopyRightMessage[256];
 *		};
 */


/*
 *	The nim960 module header
 *	The application programmer must not touch these
 *	fields.
 */
_Nim960Header:
	.short	TRC_MAGIC	/* signature for the header	*/
	.short	0		/* check sum			*/
	.word	0		/* file length			*/
	.word	0		/* time of creation		*/
_tlen:	.word	0		/* length of text		*/
_dlen:	.word	0		/* length of data		*/
_blen:	.word	0		/* length of bss		*/
_eaddr:	.word	_start		/* entry address		*/
_taddr:	.word	0		/* text load address		*/
_daddr:	.word	0		/* Data load address		*/

/*
 *	The application programmer should fill in the following
 *	records.
 */
	.word	4		/* Program ID			*/
	.asciz	"0.00  B"	/* version No more than 8 char	*/

	.org	PROGRAM_NAME_OFFSET
	/*
	 *	program name
 	 *	should no more than 32 characters
	 *	(including terminating NULL).
	 */
	.asciz	"FDDI Concentrator Booter"

	.org	COPYRIGHT_OFFSET
	/*
	 *	Copy right notice,
 	 *	should no more than 256 characters
	 *	(including terminating NULL).
	 */
	.asciz	"Copyright (C) Hughes LAN Systems 1992"

/*****	End of nim 960 header		********/


