/*************************************************************************
 *  File        BMAC.H
 *
 *  Description
 *      This file has all the definitions for BMAC chips.
 *
 *  Copyright (c) 1992, 1993 Hughes Lan Systems
 *
 *  Author:     Jia-wei Jang
 ************************************************************************/


#ifndef _BMAC_H_
#define _BMAC_H_




#include <fddi.h>
#include <bsi.h>
#include <fddimap.h>

#define BMAC_INHIBIT_RECOVERY     1
#define BMAC_AUTO_RECOVERY         2

/****
mac registers base address
***/
#define BMAC_MAX                BSI_MAX
#define BMAC_0                  BSI_0
#define BMAC_1                  BSI_1
#define BMAC_A                  BMAC_1
#define BMAC_B                  BMAC_0
#define BMAC_UNKNOWN            BSI_NUM_UNKNOWN

	/* operation registers */
#define BMAC_MR          	0x00    /* mode register */
#define BMAC_OR 		0x01    /* option register */
#define BMAC_FR	                0x02    /* function register */
#define BMAC_REV 	        0x07

	/* event registers */
#define BMAC_CMP		0x08
#define BMAC_CRS0		0x0c
#define BMAC_CTS0		0x0e
#define BMAC_RELR0		0x10
#define BMAC_REMR0		0x11
#define BMAC_RELR1	 	0x12
#define BMAC_REMR1		0x13
#define BMAC_TELR0		0x14
#define BMAC_TEMR0		0x15
#define BMAC_CILR		0x18
#define BMAC_CIMR		0x19
#define BMAC_COLR		0x1c
#define BMAC_COMR		0x1d
#define BMAC_IELR		0x28
#define BMAC_ESR 		0x2c
#define BMAC_EMR		0x2d
#define BMAC_ICR		0x2e
#define BMAC_IMR		0x2f

	/* parameter registers */
#define BMAC_MLA 		0x40
#define BMAC_MLA0		0x40
#define BMAC_MLA1		0x41
#define BMAC_MLA2		0x42
#define BMAC_MLA3		0x43
#define BMAC_MLA4		0x44
#define BMAC_MLA5		0x45

#define BMAC_MSA		0x46
#define BMAC_MSA0		0x46
#define BMAC_MSA1		0x47
#define BMAC_GLA		0x48
#define BMAC_GLA0		0x48
#define BMAC_GLA1		0x49
#define BMAC_GLA2		0x4a
#define BMAC_GLA3		0x4b
#define BMAC_GLA4		0x4c
#define BMAC_GSA		0x4e
#define BMAC_GSA0		0x4e
#define BMAC_TREQ		0x50
#define BMAC_TREQ0		0x50
#define BMAC_TREQ1		0x51
#define BMAC_TREQ2		0x52
#define BMAC_TREQ3		0x53
#define BMAC_TBT		0x54
#define BMAC_TBT0		0x54
#define BMAC_TBT1		0x55
#define BMAC_TBT2		0x56
#define BMAC_TBT3		0x57
#define BMAC_SGM		0x58
#define BMAC_FGM0		0x58
#define BMAC_FGM1		0x59
#define BMAC_PGM		0x60
#define BMAC_PGM10		0x60
#define BMAC_PGM11		0x61
#define BMAC_PGM12		0x62
#define BMAC_PGM13		0x63
#define BMAC_PGM14		0x64
#define BMAC_PGM15		0x65
#define BMAC_PGM16		0x66
#define BMAC_PGM17		0x67
#define BMAC_PGM18		0x68
#define BMAC_PGM19		0x69
#define BMAC_PGM1A		0x6a
#define BMAC_PGM1B		0x6b
#define BMAC_PGM1C		0x6c
#define BMAC_PGM1D		0x6d
#define BMAC_PGM1E		0x6e
#define BMAC_PGM1F		0x6f

#define BMAC_PGM0		0x70
#define BMAC_PGM1		0x71
#define BMAC_PGM2		0x72
#define BMAC_PGM3		0x73
#define BMAC_PGM4		0x74
#define BMAC_PGM5		0x75
#define BMAC_PGM6		0x76
#define BMAC_PGM7		0x77
#define BMAC_PGM8		0x78
#define BMAC_PGM9		0x79
#define BMAC_PGMA		0x7a
#define BMAC_PGMB		0x7b
#define BMAC_PGMC		0x7c
#define BMAC_PGMD		0x7d
#define BMAC_PGME		0x7e
#define BMAC_PGMF		0x7f



	/* timer threshold registers */
#define BMAC_TMR_THSH		0x87
#define BMAC_TMR_THSH1		0x87
#define BMAC_TMR_THSH2		0x8B
#define BMAC_TMR_THSH3		0x8F
#define BMAC_TMR_TMAX		0x93
#define BMAC_TMR_TVX		0x97
#define BMAC_TMR_TNEG		0x98
#define BMAC_TMR_TNEG0		0x98
#define BMAC_TMR_TNEG1		0x99
#define BMAC_TMR_TNEG2		0x9a
#define BMAC_TMR_TNEG3		0x9b

	/* counter registers */
#define BMAC_LTCT		0x9f
#define BMAC_FRCT		0xa0
#define BMAC_FRCT0		0xa0
#define BMAC_FRCT1		0xa1
#define BMAC_FRCT2		0xa2
#define BMAC_FRCT3		0xa3
#define BMAC_EICT		0xa4
#define BMAC_EICT0		0xa4
#define BMAC_EICT1		0xa5
#define BMAC_EICT2		0xa6
#define BMAC_EICT3		0xa7
#define BMAC_LFCT		0xa8
#define BMAC_LFCT0		0xa8
#define BMAC_LFCT1		0xa9
#define BMAC_LFCT2		0xaa
#define BMAC_LFCT3		0xab
#define BMAC_FCCT		0xac
#define BMAC_FCCT0		0xac
#define BMAC_FCCT1		0xad
#define BMAC_FCCT2		0xae
#define BMAC_FCCT3		0xaf
#define BMAC_FNCT		0xb0
#define BMAC_FNCT0		0xb0
#define BMAC_FNCT1		0xb1
#define BMAC_FNCT2		0xb2
#define BMAC_FNCT3		0xb3
#define BMAC_FTCT		0xb4
#define BMAC_FTCT0		0xb4
#define BMAC_FTCT1		0xb5
#define BMAC_FTCT2		0xb6
#define BMAC_FTCT3		0xb7
#define BMAC_TKCT		0xb8
#define BMAC_TKCT0		0xb8
#define BMAC_TKCT1		0xb9
#define BMAC_TKCT2		0xba
#define BMAC_TKCT3		0xbb
#define BMAC_RLCT		0xbc
#define BMAC_RLCT0		0xbc
#define BMAC_RLCT1		0xbd
#define BMAC_RLCT2		0xbe
#define BMAC_RLCT3		0xbf

	/* MODE register bits */
#define BMAC_MR_RUN		0x01
#define BMAC_MR_CBP		0x02
#define BMAC_MR_MRP		0x04
#define BMAC_MR_PIP		0x08
#define BMAC_MR_ILB		0x40
#define BMAC_MR_DIAG		0x80
#define BMAC_MR_RES             0xcf

	/* OPTION register bits */
#define BMAC_OR_ESA		        0x01
#define BMAC_OR_ELA		        0x02
#define BMAC_OR_ITR		        0x04
#define BMAC_OR_IRR		        0x08
#define BMAC_OR_IRPT		        0x10
#define BMAC_OR_IFCS		        0x20
#define BMAC_OR_EMIND		        0x40
#define BMAC_OR_ITC		        0x80

	/* FUNCTION register bits */
#define BMAC_FR_MARST		        0x01
#define BMAC_FR_MCRST		        0x04
#define BMAC_FR_BCN		        0x08
#define BMAC_FR_CLM		        0x10
#define BMAC_FR_RES                     0x1d

#define BMAC_LGROUP                     1       /* indicate long group addr */
#define BMAC_SGROUP                     2       /* incidate short group addr */

/* mask for FGM0, FGM1 */
#define BMAC_FGM_MASK                   0x0f
/* mask for THSH1 */
#define BMAC_THSH1_MASK                 0x0f
/* mask for TMAX */
#define BMAC_TMAX_MASK                  0x0f
/* mask for TVAX */
#define BMAC_TVX_MASK                   0x0f

/* CRS0 */
#define BMAC_CRS0_RFLAG                 0x80

	/* CRS register bits */
#define CRSR_RC_T_STATE	        0x07
#define CRSR_RC_STATE	        0x70
#define CRSR_RFLAG		0x80

	/* RC_T_STATE values */
#define T_AWAIT_SD	0x00
#define CHECK_FC	0x01
#define CHECK_SA	0x02
#define CHECK_DA	0x03
#define CHECK_INFO	0x04
#define CHECK_MAC	0x05

	/* RC_STATE values */
#define LISTEN		0x00
#define AWAIT_SD	0x10
#define RC_FR_CTRL	0x20
#define RC_FR_BODY	0x30
#define RC_FR_STATUS1	0x40
#define CHECK_TK	0x50
#define RC_FR_STATUS2	0x60

/* CTS register bits */
#define BMAC_CTS0_TTS_IDLE	0
#define BMAC_CTS0_TTS_PREMABLE  0X01
#define BMAC_CTS0_TTS_WAIT      0X02
#define BMAC_CTS0_TTS_TX_SD     0X03
#define BMAC_CTS0_TTS_TX_DA     0X04
#define BMAC_CTS0_TTS_TX_SA     0X05
#define BMAC_CTS0_TTS_TX_INFO   0X06
#define BMAC_CTS0_TTS_TX_FCS    0X07
#define BMAC_CTS0_TTS_TX_ED     0X08
#define BMAC_CTS0_TS_IDLE       0
#define BMAC_CTS0_TS_REPEAT     0X10
#define BMAC_CTS0_TS_DATA       0X20
#define BMAC_CTS0_TS_TOKEN      0X30
#define BMAC_CTS0_TS_CLAIM      0X40
#define BMAC_CTS0_TS_BEACON     0x50
#define BMAC_CTS0_TS_RES        0X60
#define BMAC_CTS0_TS_VOID       0X70
#define BMAC_CTS0_ROP		0x80

	/* TR_T_STATE values */
#define	T_IDLE		0x00
#define TR_PREAMBLE	0x01
#define DATA_WAIT	0x02
#define TR_SD		0x03
#define TR_DA		0x04
#define TR_SA		0x05
#define TR_INFO		0x06
#define TR_FCS		0x07
#define TR_ED		0x08

/* TR_STATE values */
#define IDLE_ST		0x00
#define REPEAT_ST	0x10
#define DATA_ST		0x20
#define ISSUE_TK_ST	0x30
#define CLAIM_ST	0x40
#define BEACON_ST	0x50
#define VOID_ST		0x70

/* RELR0/REMR0 register bits */
#define BMAC_RELR0_ROP		0x01
#define BMAC_RELR0_RNOP		0x02
#define BMAC_RELR0_BCNR		0x04
#define BMAC_RELR0_CLMR		0x08
#define BMAC_RELR0_OTRMAC	0x10
#define BMAC_RELR0_PINV		0x20
#define BMAC_RELR0_DUPADD	0x40

#define BMAC_REMR0_ROP		0x01
#define BMAC_REMR0_RNOP		0x02
#define BMAC_REMR0_BCNR		0x04
#define BMAC_REMR0_CLMR		0x08
#define BMAC_REMR0_OTRMAC	0x10
#define BMAC_REMR0_PINV		0x20
#define BMAC_REMR0_DUPADD	0x40

/* RELR1/REMR1 register bits */
#define BMAC_RELR1_OTRBCN		0x01
#define BMAC_RELR1_MYBCN		0x02
#define BMAC_RELR1_MYCLM		0x20
#define BMAC_RELR1_HICLM		0x40
#define BMAC_RELR1_LOCLM		0x80

#define BMAC_REMR1_OTRBCN		0x01
#define BMAC_REMR1_MYBCN		0x02
#define BMAC_REMR1_MYCLM		0x20
#define BMAC_REMR1_HICLM		0x40
#define BMAC_REMR1_LOCLM		0x80

/* TELR/TEMR register bits */
#define BMAC_TELR0_ENTRMD		0x01
#define BMAC_TELR0_TVXEXP		0x02
#define BMAC_TELR0_TRTEXP		0x04
#define BMAC_TELR0_DUPTKR		0x08
#define BMAC_TELR0_CBERR		0x10
#define BMAC_TELR0_TKCAPT		0x20
#define BMAC_TELR0_TKPASS		0x40
#define BMAC_TELR0_RLVD		        0x80

#define BMAC_TEMR0_ENTRMD		0x01
#define BMAC_TEMR0_TVXEXP		0x02
#define BMAC_TEMR0_TRTEXP		0x04
#define BMAC_TEMR0_DUPTKR		0x08
#define BMAC_TEMR0_CBERR		0x10
#define BMAC_TEMR0_TKCAPT		0x20
#define BMAC_TEMR0_TKPASS		0x40
#define BMAC_TEMR0_RLVD		        0x80

/* CILR/CIMR/COLR/COMR register bits */
#define BMAC_COLR_FRRCV		0x01
#define BMAC_COLR_FREI		0x02
#define BMAC_COLR_FRLST		0x04
#define BMAC_COLR_FRCOP		0x08
#define BMAC_COLR_FRNCOP		0x10
#define BMAC_COLR_FRTRX		0x20
#define BMAC_COLR_TKRCVD		0x40

#define BMAC_COMR_FRRCV		0x01
#define BMAC_COMR_FREI		0x02
#define BMAC_COMR_FRLST		0x04
#define BMAC_COMR_FRCOP		0x08
#define BMAC_COMR_FRNCOP	0x10
#define BMAC_COMR_FRTRX		0x20
#define BMAC_COMR_TKRCVD        0x40
#define BMAC_COMR_RES           0x7f

/* IELR register bits */
#define BMAC_IELR_MPE		0x01
#define BMAC_IELR_RSMERR        0x04
#define BMAC_IELR_TSMERR	0x08

/* ESR/EMR register bits */
#define BMAC_ESR_PPE		0x01
#define BMAC_ESR_MPE		0x02
#define BMAC_ESR_CPE		0x20
#define BMAC_ESR_CCE		0x40
#define BMAC_ESR_CWI		0x80

#define BMAC_EMR_PPE		0x01
#define BMAC_EMR_MPE		0x02
#define BMAC_EMR_CPE		0x20
#define BMAC_EMR_CCE		0x40
#define BMAC_EMR_CWI		0x80
#define BMAC_EMR_RES            0x1e

/* ICR/IMR register bits */
#define BMAC_ICR_RNG		0x01
#define BMAC_ICR_TTE		0x02
#define BMAC_ICR_CIE		0x04
#define BMAC_ICR_COE		0x08
#define BMAC_ICR_IERR		0x40
#define BMAC_ICR_ESE		0x80

#define BMAC_IMR_RNG		0x01
#define BMAC_IMR_TTE		0x02
#define BMAC_IMR_CIE		0x04
#define BMAC_IMR_COE		0x08
#define BMAC_IMR_IERR		0x40
#define BMAC_IMR_ESE		0x80




/* request service classes */
#define NO_CLASS	0
#define APRI1		1
#define APRI2	 	2
#define APRI3	 	3
#define SYN	   	4
#define IMM	   	5
#define IMMN	  	6
#define IMMR  		7
#define ASYN  		8
#define RBEG		9
#define REND		10
#define RCNT		11
#define ASYND		12
#define RBEGD		13
#define RENDD		14
#define RCNTD		15

/*----------------------------------------------------------------------
The max TREQ BMAC can support is 1.34 sec. The minimun TREQ can support
is 20.48 us. A 2's complement number for 1.34 sec is 0xff000000. (use
80 ns as an unit).
-----------------------------------------------------------------------*/
#define BMAC_TREQ_MAX           0Xff000000      /* 1.34 sec */
#define BMAC_TREQ_MIN           0xffffff00      /* 20.48 usec */
#define BMAC_COUNTER_MASK       0x000fffff      /* all the counters bit 20
                                                   to bit 31 are 0s */



typedef struct bmac_cbus {
    /* operation registers */
   byte mr;		/* Mode Register */
   byte or;		/* Option Register */
   byte fr;		/* Function Register */
   byte res0[4];
   byte rr;		/* Revision Register */

   /* event registers */
   byte cmp;		/* Compare Register */
   byte res1[3];
   byte crs0;		/* Current Receiver Status Register */
   byte res2;
   byte cts0;		/* Current Transmitter Status Register */
   byte res3;
   byte relr0;		/* Ring Event Latch Register 0 */
   byte remr0;		/* Ring Event Mask Register 0 */
   byte relr1;		/* Ring Event Latch Register 1 */
   byte remr1;		/* Ring Event Mask Register 1 */
   byte telr0;		/* Token & Timer Event Latch Register */
   byte temr0;		/* Token & Timer Event Mask Register */
   byte res4[2];
   byte cilr;		/* Counter Increment Latch Register */
   byte cimr;		/* Counter Increment Mask Register */
   byte res5[2];
   byte colr;		/* Counter Overflow Latch Register */
   byte comr;		/* Counter Overflow Mask Register */
   byte res6[10];
   byte ielr;		/* Internal Event Latch Register */
   byte res7[3];
   byte esr;		/* Exception Status Register */
   byte emr;		/* Exception Mask Register */
   byte icr;		/* Interrupt Condition Register */
   byte imr;		/* Interrupt Mask Register */
   byte res8[16];

   /* MAC Parameter RAM */
   byte mla0;		/* My Long Address */
   byte mla1;
   byte mla2;
   byte mla3;
   byte mla4;
   byte mla5;
   byte msa0;		/* My Short Address */
   byte msa1;
   byte gla0;		/* Group Long Address */
   byte gla1;
   byte gla2;
   byte gla3;
   byte gla4;
   byte res9;
   byte gsa0;		/* Group Short Address */
   byte res10;
   byte treq0;		/* Requested Target Rotation Timer */
   byte treq1;
   byte treq2;
   byte treq3;
   byte tbt0;		/* Transmit Beacon Type */
   byte tbt1;
   byte tbt2;
   byte tbt3;
   byte fgm0;		/* SMT Group Address Map */
   byte fgm1;
   byte res11[6];
   byte pgm10;		/* Group Address Map */
   byte pgm11;
   byte pgm12;
   byte pgm13;
   byte pgm14;
   byte pgm15;
   byte pgm16;
   byte pgm17;
   byte pgm18;
   byte pgm19;
   byte pgm1a;
   byte pgm1b;
   byte pgm1c;
   byte pgm1d;
   byte pgm1e;
   byte pgm1f;
   byte pgm0;		/* 0x70 */
   byte pgm1;
   byte pgm2;
   byte pgm3;
   byte pgm4;
   byte pgm5;
   byte pgm6;
   byte pgm7;
   byte pgm8;
   byte pgm9;
   byte pgma;
   byte pgmb;
   byte pgmc;
   byte pgmd;
   byte pgme;
   byte pgmf;

    /* MAC Counters and Timer Threshold */
   byte res12[7];
   byte thsh1;		/* 0x87, Async Pri Threshold 1 */
   byte res14[11];
   byte tmax;		/* 0x93, Max Token Rotation Timer */
   byte res17[3];
   byte tvx;		/* 0x97, Valid Transmission Timer */
   byte tneg0;		/* Negotiated Target Rotation Timer */
   byte tneg1;
   byte tneg2;
   byte tneg3;
   byte res18[3];
   byte ltct;		/* Late Count Counter */
   byte frct0;          /* 0xa0 */
   byte frct1;		/* Frame Received Counter */
   byte frct2;
   byte frct3;
   byte eict0;
   byte eict1;		/* Error Isolated Counter */
   byte eict2;
   byte eict3;
   byte lfct0;
   byte lfct1;		/* Lost Frame Counter */
   byte lfct2;
   byte lfct3;
   byte fcct0;
   byte fcct1;		/* Frame Copied Counter */
   byte fcct2;
   byte fcct3;
   byte fnct0;
   byte fnct1;		/* Frame Not Copied Counter */
   byte fnct2;
   byte fnct3;
   byte ftct0;
   byte ftct1;		/* Frame Transmitted Counter */
   byte ftct2;
   byte ftct3;
   byte tkct0;
   byte tkct1;		/* Token Received Counter */
   byte tkct2;
   byte tkct3;
   byte rlct0;
   byte rlct1;		/* Ring Latency Counter */
   byte rlct2;
   byte rlct3;
} BMAC_REG_TYPE;

typedef struct _bmac_default_table {
    byte    mr;
    byte    or;
    byte    fr;
    byte    remr0;
    byte    remr1;
    byte    temr0;
    byte    cimr;
    byte    comr;
    byte    emr;
    byte    imr;
} BMAC_DEFAULT_TABLE;

typedef struct _bmac_ctrl {
   byte imr;		/* Interrupt Mask Register */
   byte treq1;          /* TTRT value, high byte */
   byte treq2;
   byte fgm0;           /* fix group address */
   byte fgm1;
} BMAC_CTRL_TYPE;

#define INTERNAL_BEACON     0       /* MAC internally generates beacon frame */
#define EXTERNAL_BEACON     1       /* smt formats beacon frame */

/********
This structure contains the default values for the BMAC chips during
initialization/reset time
*********/
typedef struct _bmac_init_struct {
    BMAC_REG_TYPE *reg_base;
    int           mac_num;
    int           BeaconType;
    uint16        status; 
} BMAC_INIT_TYPE;

/***
NOTE: be sure to have a 4 bytes aligment.
***/
typedef struct _bmac_type {
  BMAC_REG_TYPE   *reg_base;
  BMAC_CTRL_TYPE  *image_ptr;
  DRV_FDDI_MIBS   *mib_ptr;
  byte    ring_op;   /* ring op flag. TRUE 0->1, FALSE 1->0 */
  byte    revision;
  uint16    status;
  byte    long_addr[6];
  byte    short_addr[2];
  byte    grp_long_addr[6];
  byte    grp_short_addr[2];
  int     mac_num;       /* mac #: 0 is mac B, 1 is mac A */
  int     BeaconType;    /* INTERNAL_BEACON | EXTERNAL_BEACON */
  unsigned char *swRingOp; /* pointer to MIB of s/w ring_op flag */
  int tmax;              
  int ringop_set;       /* count of ring_op is set */
  int ringop_clr;       /* count of ring_op is clear */
}   BMAC_TYPE;





/***
Functions prototype
***/    
extern status_type BMAC_Init(uint32,int);
extern void BMAC_CMTTestInit(void);
extern void BMAC_Reset(uint32);
extern void BMAC_ClearBMACs(uint32,uint32);
extern void BMAC_SetLoopback(uint32,uint32);
extern bool BMAC_ChkDupAddr(uint32);

extern void BMAC_SetLongAddr(uint32,byte*);
extern void BMAC_SetShortAddr(uint32,byte*);
extern void BMAC_StopRepeat(uint32);
extern void BMAC_StartRepeat(uint32);
extern status_type BMAC_SetTreq(uint32,uint32);
extern bool BMAC_Read_Rflag(uint32);
extern status_type BMAC_Set_AsyncThreshold(uint32,uint32);
extern status_type BMAC_SetTimerRegs();
extern status_type BMAC_Set_TVX(uint32,uint32);
extern uint32 BMAC_Get_TTRT(uint32);
extern byte *BMAC_GetShortAddr(uint32);
extern byte *BMAC_GetLongAddr(uint32);
extern status_type BMAC_SetGrpLongAddr(uint32,byte *);
extern int BMAC_GetBMACMode(uint32);
extern void BMAC_StopBmac(uint32);
extern void BMAC_StartBmac(uint32);
extern int BMAC_BeaconRequest(uint32);
extern status_type BMAC_ClaimRequest(uint32);
extern void BMAC_DisableInt(volatile BMAC_REG_TYPE *);
extern void BMAC_EnableInt(uint32);
extern void BMAC_DisableEvents(uint32);
extern void BMAC_EnableEvents(uint32);
extern status_type BMAC_TestClaim(uint32,uint32);
extern status_type BMAC_TestBeacon(uint32,uint32);
extern status_type BMAC_InternalLBTest(uint32);
extern void BMAC_SetBeaconType(uint32,uint32,byte *);
extern uint32 BMAC_GetMacCounters(uint32,uint32);
extern void BMAC_ShowMacCounts(uint32);
extern void BMAC_ConfigRecovery(uint32,uint32);
extern int bmac_ReadTMAX(uint32,byte *);
extern int bmac_SetTMAX(uint32,byte);




#endif   /* _BMAC_H_ */
