/****************************************************************************
 *  File    PHY.H
 *
 *  Description
 *      This file contains all the definitions for the PLAYER chip
 *
 *  Copyright (c) Hughes Lan Systems
 *
 *  Author:     Jia-wei Jang
 *
 *  $Log:   /user/pvcs/fddicon/drv/include/phy.h_v  
 * 
 *    Rev 1.24   02 Aug 1993 16:19:28   gregs
 * Added FRONT/BACK defs for FDDI-eth bridge.
 * 
 *    Rev 1.23   17 Apr 1993 15:37:36   jang
 * added one var to PLAYER_TYPE to indicate the current phy configuration
 * 
 *    Rev 1.22   13 Apr 1993 13:37:18   jang
 * added one function prototype
 * 
 *    Rev 1.21   10 Apr 1993 16:59:28   jang
 * added functions prototype
 * 
 *    Rev 1.20   10 Apr 1993 16:17:16   jang
 * changed function prototypes
 * 
 *    Rev 1.19   05 Apr 1993 07:36:46   jang
 * added more defines to MODE2 register for PLAYER+
 * 
 *    Rev 1.18   09 Mar 1993 17:28:58   jang
 * added player+
 * 
 *    Rev 1.17   22 Feb 1993 14:18:34   jang
 * moved some constants to fddimap.h to be shared with bridge code
 * 
 *    Rev 1.16   12 Jan 1993 09:45:34   jang
 * fixed the type error of unint32 to uint32
 * 
 *    Rev 1.15   12 Jan 1993 09:43:34   jlin
 * 
 *    Rev 1.14   12 Jan 1993 09:36:20   jang
 * changed filler_s in PLAYER_TYPE to p_type. also added a function 
 * prototype PHY_ChangePortType()
 ***************************************************************************/

#ifndef _PHY_H_
#define _PHY_H_



#include <fddi.h>
#include <fddimap.h>

/*
#define READ_PHY(r_ptr,reg_num)     (*((byte*)(r_ptr+reg_num)))
*/

#define PHY_BIT7_MASK           0x7f    /* mask for reserved bit 7 */

#define PHY_ID_PLAYER                   0x00    /* rev # is mask off */
#define PHY_ID_PLAYERPLUS               0x10
#define PHY_IDR_REV_MASK                0X0F
#define PHY_IDR_ID_MASK                 0XF0



/***
the bigger one of PHY_MASTER_PORTS & PHY_SLAVE_PORTS
***/
#define PHY_MAX_PORTS             (PHY_BACKPLANE_PORTS+PHY_MASTER_PORTS)


/***
 PHY registers offsets
***/
#define PHY_MR                  0x00	/* Mode Register */
#define PHY_CR                  0x01	/* Configuration Register */
#define PHY_ICR		        0x02	/* Interrupt Condition Register */
#define PHY_ICMR		0x03	/* Interrupt Condition Mask Register */
#define PHY_CTSR   		0x04	/* Current Transmit State Register */
#define PHY_IJTR   		0x05	/* Injection Threshold Register */
#define PHY_ISRA   		0x06	/* Injection Symbol Register A */
#define PHY_ISRB   		0x07	/* Injection Symbol Register B */
#define PHY_CRSR   		0x08	/* Current Receive State Register */
#define PHY_RCRA   		0x09	/* Receive Condition Register A */
#define PHY_RCRB		0x0a	/* Receive Condition Register B */
#define PHY_RCMRA  		0x0b	/* Receive Condition Mask Register A */
#define PHY_RCMRB		0x0c	/* Receive Condition Mask Register B */
#define PHY_NTR                 0x0d	/* Noise Threshold Register */
#define PHY_NPTR		0x0e	/* Noise Prescale Threshold Register */
#define PHY_CNCR		0x0f	/* Current Noise Count Register */
#define PHY_CNPCR		0x10	/* Current Noise Prescale Count Register */
#define PHY_STR                 0x11	/* State Threshold Register */
#define PHY_SPTR		0x12	/* State Prescale Threshold Register */
#define PHY_CSCR		0x13	/* Current State Count Register */
#define PHY_CSPCR		0x14	/* Current State Prescale Count Register */
#define PHY_LETR		0x15	/* Link Error Threshold Register */
#define PHY_CLECR		0x16	/* Current Link Error Count Register */
#define PHY_UDR                 0x17	/* User Definable Register */
#define PHY_IDR                 0x18	/* Device ID Register */
#define PHY_CIJCR		0x19	/* Current Injection Count Register */
#define PHY_ICCR		0x1a	/* Interrupt Condition Comparison Register */
#define PHY_CTSCR		0x1b	/* Current Transmit State Comparison Register */
#define PHY_RCCRA		0x1c	/* Receive Condition Comparison Register A */
#define PHY_RCCRB		0x1d	/* Receive Condition Comparison Register B */
#define PHY_RR0                 0x1e	/* Reserved Register 0 */
#define PHY_RR1                 0x1f	/* Reserved Register 1 */


 /* Mode Register (MR) bits */
#define PHY_MR_RUN		0x01	/* RUN */
#define PHY_MR_ILB		0x02	/* Internal Loopback */
#define PHY_MR_EXLB		0x04	/* External Loopback */
#define PHY_MR_CM		0x08	/* Cascade Mode */
#define PHY_MR_TQL		0x10	/* Transmit Quiet Level */
#define PHY_MR_TE		0x20	/* Transmit Enable */
#define PHY_MR_TNRZ		0x40	/* Transmit NRZ */
#define PHY_MR_RNRZ		0x80	/* Receive NRZ */


/***
 Configuration Register (CR) bits
***/
#define PHY_CR_AIND_INVALID     0x00    /* a indicate with phy invalid */
#define PHY_CR_AIND_RBUS        0x01    /* A indicate with Rcv bus */
#define PHY_CR_AIND_AREQ        0x02    /* A indicate with A.req */
#define PHY_CR_AIND_BREQ        0x03    /* A.ind with B.req */
#define PHY_CR_BIND_INVALID     0x00    /* B.ind with PHY invalid */
#define PHY_CR_BIND_RBUS        0x04    /* B.ind with rcv bus */
#define PHY_CR_BIND_AREQ        0x08    /* B.ind with A.req */
#define PHY_CR_BIND_BREQ        0x0c    /* B.ind with B.req */
#define PHY_CR_TRS_INVALID      0x00    /* tx req with PHY invalid */
#define PHY_CR_TRS_RBUS         0x10
#define PHY_CR_TRS_AREQ         0x20
#define PHY_CR_TRS_BREQ         0x30
#define PHY_CR_AIE              0x40
#define PHY_CR_BIE              0x80

/***
Interrupt Condition Register (ICR)
***/
#define PHY_ICR_DPE		0x01	/* PHY Request Data Parity Error */
#define PHY_ICR_CPE		0x02	/* CBUS Data Parity Error */
#define PHY_ICR_CCR		0x04	/* CBUS Write Command Reject */
#define PHY_ICR_CWI		0x08	/* Conditional Write Inhibit */
#define PHY_ICR_LEMT		0x10	/* Link Error Monitor Threshold */
#define PHY_ICR_RCA		0x20	/* Receive Condition A */
#define PHY_ICR_RCB		0x40	/* Receive Condition B */
#define PHY_ICR_UDI		0x80	/* User Definable Interrupt */

/***
 Mask (ICRM)
***/
#define PHY_ICMR_DPEM		0x01	/* PHY Request Data Parity Error */
#define PHY_ICMR_CPEM		0x02	/* CBUS Data Parity Error */
#define PHY_ICMR_CCRM		0x04	/* CBUS Write Command Reject */
#define PHY_ICMR_CWIM		0x08	/* Conditional Write Inhibit */
#define PHY_ICMR_LEMTM		0x10	/* Link Error Monitor Threshold */
#define PHY_ICMR_RCAM		0x20	/* Receive Condition A */
#define PHY_ICMR_RCBM		0x40	/* Receive Condition B */
#define PHY_ICMR_UDIM		0x80	/* User Definable Interrupt */

/***
Comparison (ICCR) bits
***/
#define PHY_ICCR_DPEC		0x01	/* PHY Request Data Parity Error */
#define PHY_ICCR_CPEC		0x02	/* CBUS Data Parity Error */
#define PHY_ICCR_CCRC		0x04	/* CBUS Write Command Reject */
#define PHY_ICCR_CWIC		0x08	/* Conditional Write Inhibit */
#define PHY_ICCR_LEMTC		0x10	/* Link Error Monitor Threshold */
#define PHY_ICCR_RCAC		0x20	/* Receive Condition A */
#define PHY_ICCR_RCBC		0x40	/* Receive Condition B */
#define PHY_ICCR_UDIC		0x80	/* User Definable Interrupt */


/***
 Current Transmit State Register (CTSR) bits
***/
#define PHY_CTSR_TM_MASK    0xf8    /* to mask TM bits to 0s */
#define PHY_CTSR_ATM        0x80
#define PHY_CTSR_ITM        0x81
#define PHY_CTSR_OTM        0X82
#define PHY_CTSR_RES1       0X83
#define PHY_CTSR_MTM        0X84
#define PHY_CTSR_HTM        0X85
#define PHY_CTSR_QTM        0X86
#define PHY_CTSR_RES2       0X87
#define PHY_CTSR_NOINJ      0X80
#define PHY_CTSR_ONESHOT    0X88
#define PHY_CTSR_PERIODIC   0X90
#define PHY_CTSR_CONTINUE   0X98
#define PHY_CTSR_SE         0XA0
#define PHY_CTSR_PRDPE      0XC0

/** current receive state register **/
#define PHY_CRSR_ALS        0
#define PHY_CRSR_ILS        0X01
#define PHY_CRSR_NSD        0X02
#define PHY_CRSR_RES        0X03
#define PHY_CRSR_MLS        0X04
#define PHY_CRSR_HLS        0X05
#define PHY_CRSR_QLS        0X06
#define PHY_CRSR_NLS        0X07
#define PHY_CRSR_LSU        0X08
#define PHY_CRSR_LS_MASK    0X07        /* mask of LS0, LS1, LS2 */

/** receive condition register A **/
#define PHY_RCRA_NSD        0X01
#define PHY_RCRA_QLS        0X02
#define PHY_RCRA_HLS        0X04
#define PHY_RCRA_MLS        0X08
#define PHY_RCRA_NLS        0X10
#define PHY_RCRA_NT         0X20
#define PHY_RCRA_LSC        0X40
#define PHY_RCRA_LSUPI      0X80

#define PHY_RCRB_ILS        0X01
#define PHY_RCRB_ST         0X02
#define PHY_RCRB_ALS        0X04
#define PHY_RCRB_LSUPV      0X08
#define PHY_RCRB_CSE        0X10
#define PHY_RCRB_EBOU       0X20
#define PHY_RCRB_SILS       0X40

#define PHY_RCMRA_NSDM      0X01
#define PHY_RCMRA_QLSM      0X02
#define PHY_RCMRA_HLSM      0X04
#define PHY_RCMRA_MLSM      0X08
#define PHY_RCMRA_NLSM      0X10
#define PHY_RCMRA_NTM       0X20
#define PHY_RCMRA_LSCM      0X40
#define PHY_RCMRA_LSUPIM    0X80

#define PHY_RCMRB_ILSM      0X01
#define PHY_RCMRB_STM       0X02
#define PHY_RCMRB_ALSM      0X04
#define PHY_RCMRB_LSUPVM    0X08
#define PHY_RCMRB_CSEM      0X10
#define PHY_RCMRB_EBOUM     0X20
#define PHY_RCMRB_SILSM     0X40
#define PHY_RCMRB_RESM      0X80


#define PHY_NTR_DEFAULT     49          /* 20usec * (49+1) = 1 msec */
#define PHY_NPTR_DEFAULT    249         /* 80ns * (249+1) = 20 usec */
#define PHY_STR_DEFAULT     49          /* 20usec * (49+1) = 1 msec */
#define PHY_SPTR_DEFAULT    249         /* 80ns * (249+1) = 20 usec */


#define PHY_MODE2_PHYRST    0X01
#define PHY_MODE2_CBPE      0X02
#define PHY_MODE2_CLKSEL    0X20
#define PHY_MODE2_ESTC      0x80


typedef struct _player_cbus {
   byte mr;		/* Mode Register */
   byte cr;		/* Configuration Register */
   byte icr;		/* Interrupt Condition Register */
   byte icmr;		/* Interrupt Condition Mask Register */
   byte ctsr;		/* Current Transmit State Register */
   byte ijtr;		/* Injection Threshold Register */
   byte isra;		/* Injection Symbol Register A */
   byte isrb;		/* Injection Symbol Register B */
   byte crsr;		/* Current Receive State Register */
   byte rcra;		/* Receive Condition Register A */
   byte rcrb;		/* Receive Condition Register B */
   byte rcmra;		/* Receive Condition Mask Register A */
   byte rcmrb;		/* Receive Condition Mask Register B */
   byte ntr;		/* Noise Threshold Register */
   byte nptr;		/* Noise Prescale Threshold Register */
   byte cncr;		/* Current Noise Count Register */
   byte cnpcr;		/* Current Noise Prescale Count Register */
   byte str;		/* State Threshold Register */
   byte sptr;		/* State Prescale Threshold Register */
   byte cscr;		/* Current State Count Register */
   byte cspcr;		/* Current State Prescale Count Register */
   byte letr;		/* Link Error Threshold Register */
   byte clecr;		/* Current Link Error Count Register */
   byte udr;		/* User Definable Register */
   byte idr;		/* Device ID Register */
   byte cijcr;		/* Current Injection Count Register */
   byte iccr;		/* Interrupt Condition Comparison Register */
   byte ctscr;		/* Current Transmit State Comparison Register */
   byte rccra;		/* Receive Condition Comparison Register A */
   byte rccrb;		/* Receive Condition Comparison Register B */
   byte mode2;		/* Reserved Register 0 */
   byte cmtccr;		/* Reserved Register 1 */

   /* PLAYER+ registers */
   byte cmtcr;
   byte cmtmr;
   byte rr22;
   byte rr23;
   byte sttr;
   byte stvr;
   byte tdr;
   byte ttcr;
   byte rr28;
   byte rr29;
   byte rr2a;
   byte rr2b;
   byte rr2c;
   byte rr2d;
   byte rr2e;
   byte rr2f;
   byte rr30;
   byte rr31;
   byte rr32;
   byte rr33;
   byte rr34;
   byte rr35;
   byte rr36;
   byte rr37;
   byte rr38;
   byte rr39;
   byte rr3a;
   byte cgmreg;
   byte rr3c;
   byte rr3d;
   byte rr3e;
   byte rr3f;
} PHY_REG_TYPE;

typedef struct _phy_image {
   byte cr;		/* Configuration Register */
   byte icmr;		/* Interrupt Condition Mask Register */
   byte ctsr;           /* save ctsr before doing LCT */
   byte ijtr;		/* Injection Threshold Register */
   byte isra;		/* Injection Symbol Register A */
   byte isrb;		/* Injection Symbol Register B */
   byte rcmra;		/* Receive Condition Mask Register A */
   byte rcmrb;		/* Receive Condition Mask Register B */

   byte cscr;		/* Current State Count Register */
   byte cspcr;		/* Current State Prescale Count Register */
   byte letr;
   byte clecr;		/* Current Link Error Count Register */
   byte cijcr;		/* Current Injection Count Register */
} PHY_CTRL_TYPE;

typedef struct _phy_init_struct {
    PHY_REG_TYPE *base_addr;
    int    id;        /* UI/SNMP port number */
    int    mac_num;
    int    status;
}   PHY_INIT_TYPE;

/*****
this table holds the default value for initialization
*****/
typedef struct _phy_default_table {
    byte    mr;
    byte    icmr;
    byte    ctsr;
    byte    ijtr;
    byte    isra;
    byte    isrb;
    byte    rcmra;
    byte    rcmrb;
    byte    ntr;
    byte    nptr;
    byte    str;
    byte    sptr;
} PHY_DEFAULT_TABLE;

typedef struct _phy_type {
    PHY_REG_TYPE *base_addr;
    PHY_CTRL_TYPE *image_ptr;
    byte   rev;
    byte   lem_int;    /* set if LEM is monitored */
    short  p_type;     /* port type */
    int    id;         /* ID in IDR */
    int    mac_num;
    int    status;
    int     config_state;     /* port's current configuration switch */
#define PHY_ISOLATE      1
#define PHY_INSERT_P     2
#define PHY_INSERT_S     3
#define PHY_INSERT_X     4
#define PHY_WRAP         5
    uint32  noise_count;      /* total lem count since reset */
    uint32  state_count;
    uint32  lem_count;     
    uint32  LerCutoff;      /* remaining ler_cutoff */
    uint32  BufErrCount;    /* elasticity buffer overflow/underflow */
} PLAYER_TYPE;

	
/***
functions prototypes
***/


extern status_type PHY_Init(uint32,uint32);
extern status_type PHY_Reset(uint32,uint32);
extern bool PHY_ReadUDR(void);
extern status_type PHY_ClearPhys(uint32,uint32);
extern void PHY_ChangePortType(uint32,uint32);
extern int PHY_SetRR38(volatile PHY_REG_TYPE *);
extern int PHY_GetPortType(uint32);
extern void PHY_Run(uint32);
extern void PHY_Stop(uint32);
extern void PHY_SetLerCutoff(uint32,uint32);
extern void PHY_GetLerCutoff(uint32,uint32 *);
extern uint32 PHY_GetElBufErr(uint32);
extern void PHY_RestoreCR(uint32);
extern void PHY_Insert_S(uint32);
extern void PHY_Insert_P(uint32);
extern void PHY_Insert_X(uint32);
extern void PHY_Isolate(uint32);
extern void PHY_Wrap(uint32);
extern status_type PHY_TxSymbols(uint32,uint32);
extern uint32 PHY_GetTxLs(uint32);
extern uint32 PHY_GetRxLs(uint32);
extern void PHY_ConfigEBOU(uint32,uint32);
extern void PHY_StartLCTest(uint32);
extern void PHY_StopLCTest(uint32);
extern void PHY_ClearInt(uint32);
extern void PHY_RestoreInt(uint32);
extern void PHY_ConfigLEM(uint32,uint32);
extern void PHY_SetExterLoopback(uint32);
extern void PHY_SetInterLoopback(uint32);
extern void PHY_StopLoopback(uint32);
extern void PHY_ClearIcr(volatile PHY_REG_TYPE *);
/* extern void PHY_SetIcr(volatile PHY_REG_TYPE *,byte); */
extern void PHY_ClearRCRA(volatile PHY_REG_TYPE *);
extern void PHY_ConfigSILS(uint32,uint32);
extern void PHY_ClearRCRB(volatile PHY_REG_TYPE *);
extern void PHY_SetNoiseThresh(volatile PHY_REG_TYPE *);
extern byte PHY_ReadCncr(volatile PHY_REG_TYPE *);
extern void PHY_ConfigTx(uint32,uint32);
extern byte PHY_ReadCnpcr(volatile PHY_REG_TYPE *);
extern void PHY_PstatsMACPkts(uint32);


extern void PHY_ChangePortType(uint32,uint32);

/* Some Defines to describe the bridge's A/B port configuration states	*/
/* They correspond to variable AB_Port_Config_State.					*/
#ifdef __FEBRIDGE

#define	FRONT		1
#define BACK		2

#endif
	
#endif  /* _PHY_H_ */

