/*************************************************************************
 *  File    bsi.c
 *
 *  Description
 *      This module
 *
 *  Copyright (c) Hughes Lan Systems 1992, 1993
 *
 *  Author: J. Jang
 *
 *  $Log:   /n/pvcs_conc/fddicon/drv/src/bsi.c_v  
 * 
 *    Rev 1.103.1.22   10 Jan 1994 14:13:30   gregs
 * Made changes to increase bridge performance.
 * 
 *    Rev 1.103.1.21   22 Oct 1993 11:09:14   gregs
 * Balanced MaskAllInts() / RestoreIntMask() calls in BSI_SendReq().
 * 
 *    Rev 1.103.1.20   21 Oct 1993 14:51:10   jang
 * don't do address swap when sending out direct beacon
 * 
 *    Rev 1.103.1.19   12 Oct 1993 11:11:36   gregs
 * Fixed missing PKT header problems
 * 
 *    Rev 1.103.1.18   01 Oct 1993 13:08:50   franks
 * This file includes a fix to stop a beacon frame from being freed twice.
 * 
 *    Rev 1.103.1.17   29 Sep 1993 13:28:58   gregs
 * No change.
 * 
 *    Rev 1.103.1.16   28 Sep 1993 11:06:54   jang
 * fixed the bug that a pkt was freed when we skip the ODUD
 * 
 *    Rev 1.103.1.15   27 Sep 1993 15:17:28   jang
 * fixed the bug of consistency failure
 * 
 *    Rev 1.103.1.14   24 Sep 1993 09:51:10   jang
 * added an export function BSI_AbortTx()
 * 
 *    Rev 1.103.1.13   21 Sep 1993 10:44:20   jang
 * integrated with concentrator code 
 * 
 *    Rev 1.103.1.11   19 Aug 1993 10:23:52   gregs
 * Modified BuildMultipleODUD routine, it will now use pktTotalSize to
 * get the number of bytes to be transmitted from the last pkt in a chain.
 * 
 *    Rev 1.103.1.9   12 Aug 1993 09:59:08   gregs
 * some minor changes to speed up
 * 
 *    Rev 1.103.1.8   10 Aug 1993 19:26:32   jang
 * checked in to compile
 * from bats
 * 
 *    Rev 1.103.1.7   10 Aug 1993 18:31:14   gregs
 * modified BSI_ProcessCNF(), put some local variables to registers.
 * checked in to use emacs
 * 
 *    Rev 1.103.1.6   10 Aug 1993 17:11:30   gregs
 * changed BSI_SendReq() to make tx faster
 * 
 *    Rev 1.103.1.5   09 Aug 1993 18:49:42   gregs
 * checked in to get hard copy from pc
 * 
 *    Rev 1.103.1.4   06 Aug 1993 09:18:06   gregs
 * Bug fixes for bridge pkt driver.
 * 
 *    Rev 1.103.1.3   02 Aug 1993 14:30:22   gregs
 * No Change..
 * 
 *    Rev 1.103.1.2   30 Jul 1993 09:33:54   jang
 * get rid of the debug msg
 * 
 *    Rev 1.103.1.1   29 Jul 1993 15:02:14   jang
 * fixed BSI_DoDiag()
 * 
 *    Rev 1.103.1.0   28 Jul 1993 13:40:44   jang
 * ch 1 & 2 work! checked in so it can be 
 * backup to tape
 * 
 *    Rev 1.103   15 Jul 1993 18:07:24   jang
 * added function to do performance test
 * 
 *    Rev 1.102   15 Jul 1993 12:03:14   jang
 * in self loop test, printf out a . for every 100 frames
 *
 *    Rev 1.101   14 Jul 1993 09:12:18   jang
 * added code to do bsi self loop test during initialization
 * 
 *    Rev 1.100   08 Jul 1993 17:40:40   jang
 * chagned timer_count to int from uint32
 * 
 *    Rev 1.99   08 Jul 1993 14:57:08   jang
 * clean house to delete compiler warning message
 * 
 *    Rev 1.98   02 Jul 1993 10:31:28   shekhar
 * modified the bsi test.
 * 
 *    Rev 1.97   30 Jun 1993 18:50:58   jang
 * put back the chained dbds back in BSI_SendReq() because the bridge needs it
 * 
 *    Rev 1.96   30 Jun 1993 18:33:26   shekhar
 * now prints address of memory where the pattern doesn't match.
 * 
 *    Rev 1.95   28 Jun 1993 17:06:34   shekhar
 * modified trasmit tests for SMT and LLC.
 * 
 *    Rev 1.94   28 Jun 1993 11:15:02   shekhar
 * fixed problem related to MyNid in Diag.
 * 
 *    Rev 1.93   25 Jun 1993 14:49:38   gregs
 * shmalloc, BSI_DoMACScrub mods for fddi-eth bridge.
 * 
 *    Rev 1.92   23 Jun 1993 16:48:16   jang
 * fixed the telnet bug
 * 
 *    Rev 1.91   22 Jun 1993 19:45:50   jang
 * changed BMAC_INHIBIT_RECOVERY TO BMAC_AUTO_RECOVERY
 * 
 *    Rev 1.90   22 Jun 1993 18:29:38   jang
 * restart bmac after stop direct beacon
 * 
 *    Rev 1.89   21 Jun 1993 11:47:00   jang
 * checked the db_contrl == 0 in FreeBufsInODUD()
 * 
 *    Rev 1.88   17 Jun 1993 14:27:18   jang
 * added more debug info.
 * 
 *    Rev 1.88   17 Jun 1993 14:10:22   jang
 * added more debug info
 * 
 *    Rev 1.87   12 Jun 1993 10:50:06   jang
 * fixed the bug of cnf no space cause req machine to stop
 * 
 *    Rev 1.87   12 Jun 1993 10:48:32   jang
 * fixed the bug of cnf no space cause req machine to stop
 * 
 *    Rev 1.86   07 Jun 1993 19:15:44   jang
 * 
 *    Rev 1.85   07 Jun 1993 18:28:50   jang
 * changed from interrupt driven to polling, and alos moved vars to
 * internal data ram
 * 
 *    Rev 1.85   07 Jun 1993 18:21:56   jang
 * changed from interrupt driven to polling
 * 
 *    Rev 1.74   06 May 1993 14:28:06   jang
 * changed direct beacon
 * 
 *    Rev 1.73   06 May 1993 13:37:44   jang
 * deleted crit_on() from DirectBeacon()
 * 
 *    Rev 1.72   29 Apr 1993 15:12:36   jang
 * called strobe_wdt() so wdt won't reset the system
 * 
 *    Rev 1.71   28 Apr 1993 17:05:24   shekhar
 * deleted the debug info ChkDBDs()
 * 
 *    Rev 1.70   28 Apr 1993 15:00:04   jang
 * changed the BSI_SendReq() so that when chip is not ready, throw away the tx pkt instead of queueing it
 * 
 *    Rev 1.70   28 Apr 1993 14:48:34   jang
 * changed the BSI_SendReq() so that when chip is not ready, throuaway the tx pkt
 * instead of queueing it up.
 * 
 *    Rev 1.70   28 Apr 1993 14:37:04   jang
 * changed the code so that when chip is not ready, throw away the tx pkt instead of
 * queueing it.
 * 
 *    Rev 1.69   26 Apr 1993 19:35:34   jang
 * deleted the debug info of bsi mailbox address
 * 
 *    Rev 1.68   26 Apr 1993 17:23:34   jang
 * fixed the bug in BSI_SendReq()
 * 
 *    Rev 1.67   24 Apr 1993 16:13:04   jang
 * 
 *    Rev 1.67   24 Apr 1993 15:18:18   jang
 * display debug info only debug switch is in on position
 * 
 *    Rev 1.66   24 Apr 1993 12:21:18   jang
 * added one debug info when tx pkt was blocked
 * 
 *    Rev 1.65   22 Apr 1993 17:40:24   jang
 * fixed the uid unmatch bug
 * 
 *    Rev 1.64   21 Apr 1993 18:36:16   jang
 * added more infor to debug cnf.uid unmatch
 * 
 *    Rev 1.63   21 Apr 1993 15:31:12   jang
 * added code to do direct beacon
 * 
 *    Rev 1.62   20 Apr 1993 16:58:30   jang
 * added code to debug the dbd_count == 0
 * 
 *    Rev 1.61   13 Apr 1993 13:34:56   jang
 * modified BSI_SendReq(). Last rev checked in incorrect file
 * 
 *    Rev 1.60   10 Apr 1993 16:20:12   jang
 * added bsi/bmac mode checking before tx pkt, redo the ICR config
 * 
 *    Rev 1.59   09 Apr 1993 14:32:40   jang
 * 
 *    Rev 1.58   05 Apr 1993 11:56:36   jang
 * added more debug info
 * 
 *    Rev 1.57   05 Apr 1993 07:57:22   jang
 * added more code to handle exception
 * 
 *    Rev 1.55   02 Apr 1993 12:11:32   jang
 * added code to handle the exception
 * 
 *    Rev 1.54   31 Mar 1993 19:00:46   jang
 * changed the get_dbd_count from extern to local
 * 
 *    Rev 1.53   31 Mar 1993 18:39:28   jang
 * added code to do more self test and handle the exception
 * 
 *    Rev 1.51   25 Mar 1993 10:29:14   jang
 * added ptop self test
 * 
 *    Rev 1.50   23 Mar 1993 12:00:20   jang
 * 
 *    Rev 1.49   18 Mar 1993 18:27:08   jang
 * 
 *    Rev 1.48   08 Mar 1993 09:25:34   jang
 * deleted my_hosts[]
 * 
 *    Rev 1.47   05 Mar 1993 10:16:22   jang
 * changed channel from pkt to dbd
 * 
 *    Rev 1.46   01 Mar 1993 19:40:00   jang
 * removed the test code and replace it with the release code
 * 
 *    Rev 1.45   01 Mar 1993 15:17:18   jang
 * 
 *    Rev 1.43   19 Feb 1993 17:57:54   jang
 * changed BSIREG_ClearIAR()
 * 
 *    Rev 1.41   16 Feb 1993 11:01:46   jang
 * changed BSI_ProcessCNF() parameter from 2 to 1
 * 
 *    Rev 1.40   12 Feb 1993 10:29:04   jlin
 * 
 *    Rev 1.39   08 Feb 1993 18:49:10   jang
 * modified the code to make it faster
 * 
 *    Rev 1.38   05 Feb 1993 14:36:14   jang
 * checked in for performance test
 * 
 *    Rev 1.37   04 Feb 1993 19:19:24   jang
 * all the debug printf are gone
 * 
 *    Rev 1.36   03 Feb 1993 13:22:32   jang
 * this version works with lanhawk dumping data
 * 
 *    Rev 1.35   03 Feb 1993 09:02:22   jang
 * work version in slow traffic
 * 
 *    Rev 1.34   01 Feb 1993 14:31:56   jang
 * a bug of cnf queue overflow
 * 
 *    Rev 1.33   30 Jan 1993 16:25:44   jang
 * modified the memory allocation
 * 
 *    Rev 1.32   29 Jan 1993 16:56:28   jang
 * 
 *    Rev 1.30   26 Jan 1993 11:22:22   jang
 * checked in for integration only
 * 
 *    Rev 1.29   19 Jan 1993 15:05:34   jang
 * 
 *    Rev 1.28   07 Jan 1993 09:33:10   jang
 * put rev 1.26 back
 * 
 *    Rev 1.26   06 Jan 1993 16:32:38   jang
 ************************************************************************/
#include <fddi.h>
#include <krnl.h>
#include <error.h>    
#include <drv.h>
#include <bsi.h>
#include <fdrmonty.h>
#include <monp.h>
#include <dips.h>
#include <pkt.h>
#include <dbd.h>
#include <mpd.h>
#include <cspmacro.h>
#include <tcpip.h>
#include <bmac.h>
#include <nodbd.h>

#ifndef __FEBRIDGE
#define dprintf   printf
#endif  /* ! __FEBRIDGE   */


#define EXC  0
#define BR_DEBUG   0
#define JWJ  0
#if JWJ
extern int drv_free_cnt;
int bsi_tx_cnt = 0;
int bsi_odud_cnt = 0;
int cnf_drop_cnt = 0;
int bsi_drop_cnt = 0;
int bsi_reset_cnt = 0;
int cnf_num = 0;


volatile char *ptr_c0 = (char *) 0x900000c0;
volatile char *ptr_c8 = (char *) 0x900000c8;
volatile char *ptr_d4 = (char *) 0x900000d4;
volatile char *ptr_d8 = (char *) 0x900000d8;
volatile char *ptr_c4 = (char *) 0x900000c4;
volatile char *ptr_cc = (char *) 0x900000cc;
volatile char *ptr_d0 = (char *) 0x900000d0;
volatile char *ptr_dc = (char *) 0x900000dc;
#endif



extern int fault_cnt;

#define BSI_DEBUG    0
#define HOST_DEBUG   0
#define RESET_DEBUG  0
#define RINGOP_DEBUG 0

#define PKT_DEBUG           0
#if 1
int free_pkt_buff = 0;
int free_txpkt = 0, free_txpkt_cnt = 0, get_txpkt_cnt = 0;
#endif



/*------------------------------------------------------------------------
 *          export variables
 *------------------------------------------------------------------------
 */
TIMER bsiTimer;   /* a timer used to check queued DBD */
/* BSI_TYPE bsis[BSI_MAX];  ***** MOVED TO IRAM ***** FRANK S.. */
extern BSI_TYPE bsis[BSI_MAX];
bool bsi_init_flag;
PKT *test_pktp;
int  drv_get_dbd_cnt, drv_free_dbd_cnt;   /* used to debug */




/*------------------------------------------------------------------------
 *          import variables
 *------------------------------------------------------------------------
 */
extern uint32 FddiDrvStartPtr;  /* start memory location for the FDDI driver */
extern uint32 FddiDrvMemSize;   /* total memory size for the FDDI driver */
extern BSI_INIT_TYPE bsi_master_default[];
extern FDDI_CON_TYPE fddi_board;
extern DRV_MIBS_TYPE drv_mibs[];
extern void free_dbd();
extern  MBOX ReceiveMbox, RxSMTFrameMBox;
extern void FDDIChipIsr();
extern BMAC_TYPE  bmacs[];
extern IF_ENTRY *ifcntrs;
extern BSI_ADDR_TYPE bsi_dev[];
extern BSI_INDCH_INFO bsi_inch_info[][BSI_INDCH_NUM];
extern BSI_INDQ_TYPE bsi_indq[][BSI_INDCH_NUM*BSI_IND_DESC_NUM];
extern BSI_INCH_TYPE bsi_inch[];
extern BSI_DEFAULT_TABLE bsicon_default_table,bsibr_default_table;
extern BSI_REQCH_INFO bsi_reqch_info[][BSI_REQCH_NUM];
extern BSI_REQCH_TYPE bsi_reqch[];
extern BSI_REQQ_TYPE bsi_reqq[][BSI_REQCH_NUM * BSI_REQ_DESC_NUM];
#ifndef __FEBRIDGE
extern int counter_1_count;
#endif
extern int free_psp_count;
extern drv_init_flag;

/*
 *------------------------------------------------------------------------
 *          local variables
 *------------------------------------------------------------------------
 */
 

#define TEST_FRAME_LEN      (100+FDDI_HEADER_LEN)
#define TEST_FRAME_FC       0x67        /* FC field of the test frame */


static byte *desc_que_head;   /* head ptr of descriptor queues */
static byte *desc_que_ptr;    /* point to the free space */


/* stack to store the free BSI_REQ_MSG */
extern BSI_REQ_MSG *req_start;


static byte pattern;

static int total_rx_pkt;

/*------------------------------------------------------------------------
 *          local functions
 *------------------------------------------------------------------------
 */ 


#ifdef DO_LINT
static void ResetReq(uint32);
static void ResetReqDesc(BSI_REQQ_TYPE*);
static void ResetReqCh(BSI_REQCH_TYPE *);
static status_type InitReqChannel(BSI_REQCH_TYPE *,uint32);
static status_type InitReq(uint32);
static void ResetInd(uint32);
static statys_type InitInd(uint32);
static status_type InitIndChannel(BSI_INCH_TYPE *,uint32,uint32);
static status_type lmop(uint16,uint16,uint32,uint32 *);
static status_type ptop(uint16,uint16,byte,uint32 *);
static status_type PollReg(byte,uint16);
static status_type ChkRamOp(byte,uint16);
static status_type InitReqDesc(BSI_REQQ_TYPE *,uint16);
static status_type InitIndDesc(BSI_INDQ_TYPE *,uint16);
static void ResetIndDesc (BSI_INDQ_TYPE *);
static status_type LoadPointerRegs(int);
static void ResetIndCh (BSI_INCH_TYPE *);
static DBD *InitTestFrame (void);
static status_type ResetBsiRegs (uint32);
static void ResetPSPDesc(uint32);
static status_type InitLimitRegs(uint32);
#else
static void ResetReq();
static void ResetReqDesc();
static void ResetReqCh();
static status_type InitReqChannel();
static status_type InitReq();
static void ResetInd();
static status_type InitInd();
static status_type InitIndChannel();
static status_type lmop();
static status_type ptop();
static status_type PollReg();
static status_type ChkRamOp();
static status_type InitReqDesc();
static status_type InitIndDesc();
static void ResetIndDesc ();
static status_type LoadPointerRegs();
static status_type ResetBsiRegs ();
static void ResetPSPDesc();
static status_type InitLimitRegs();
static void GetBsiDefault();
static DBD *InitTestFrame ();
static status_type AllocDescQuePool();

static void put_req_msg();
static BSI_REQ_MSG *get_req_pkt();
static int init_req_list();


/* function for diagnostic */

static int BuildDUD();
static int BuildMultipleODUD();
static byte *get_descque_mem();
static void ResetReqMachine();



static status_type ChkAllPsp();
static status_type test_lmop();
static status_type test_ptop();
static void ProcessBSIException();
static void FreeBufsInODUD();
static void FreeAllBufs();
static void ResetUnserviceReq();
static void StartBSITimer();
static int  init_cnf_ql();
static int init_idud_ql();
static status_type ReadREQDesc();
static void ReadIdudDesc();


#endif      /* !DO_LINT */

show_fddi_debug() 
{
#if  JWJ
  extern int drv_tx_cnt, drvsendcnt,drv_drop_cnt,drv_free_cnt;

  printf("drv_tx_cnt %d, drvsendcnt %d, drv_drop_cnt %d, drv_free_cnt %d\n",
	 drv_tx_cnt,drvsendcnt,drv_drop_cnt,drv_free_cnt);
  printf("bsi_tx_cnt %d, bsi_odud_cnt %d, cnf_drop_cnt %d, bsi_drop_cnt %d, bsi_reset_cnt %d\n",bsi_tx_cnt,bsi_odud_cnt,cnf_drop_cnt,bsi_drop_cnt,bsi_reset_cnt);
  drv_tx_cnt=drvsendcnt=drv_drop_cnt=drv_free_cnt = 0;
  bsi_tx_cnt=bsi_odud_cnt=cnf_drop_cnt=bsi_drop_cnt=bsi_reset_cnt = 0;  
#endif
}

/*************************************************************************
 *  Function    BSI_INIT
 *
 *  Description
 *      This function initializes 2 BSI chips. It allocates memory for the
 *      the BSI chips. 
 *
 *  Parameter:
 *      num_bsi - number of total BSI
 *
 *  Return: [OK | FDDI_ERROR]
 *************************************************************************/
status_type BSI_Init (num_bsi,source)
uint32 num_bsi;
int source;   /* 0 from booter, 1 from application */
{
  uint32 i;
  BSI_CTRL_TYPE *i_ptr;

  if ((num_bsi > fddi_board.bsi_num) || (bsi_init_flag == TRUE))
    return (FDDI_ERROR);

  if (AllocDescQuePool(num_bsi) != OK)
    return FDDI_ERROR;

  CreatTimer(&bsiTimer);
  for (i = 0; i < num_bsi; i++) {
    strobe_wdt();
    GetBsiDefault(i);
    if ((i_ptr=(BSI_CTRL_TYPE *)lmalloc(sizeof(BSI_CTRL_TYPE))) == NULL)
      return (FDDI_ERROR);

    memset(i_ptr,0,sizeof(BSI_CTRL_TYPE));
    bsis[i].image_ptr = i_ptr;

    if (InitReq(i) != OK) {
      printf("BSI %d REQ initialized error\n",i);
      return (FDDI_ERROR);
    }
    if (InitInd(i) != OK) {
      printf("BSI %d IND initialized error\n",i);
      return (FDDI_ERROR);
    }
    ResetReq(i);
    ResetInd(i);

    if (init_req_list() != OK)
      return FDDI_ERROR;

    if (ResetBsiRegs(i,source) != OK) {
      return (FDDI_ERROR);
    }
  }       /* for */

  for (i=0; i < fddi_board.bsi_num; i++)  {
    strobe_wdt();
    ResetPSPDesc(i,source);  
    if (verify_ptop(i,AUTO_TEST) != OK) {
      bsis[i].chip_test = FALSE;
    }
    else {
      BSIREG_BsiRun(i);  
      bsis[i].chip_test = TRUE;
    }
  }

  bsi_init_flag = TRUE;

  return (OK);
}

/**************************************************************************
 *  Function BSI_CMTTestInit
 *
 *  Description
 *    This function configs the BSIs for the CMT release only. It only 
 *    clears R0CR and R1CR.
 *
 *  Parameter:  none
 *
 *  Return:  void
 *************************************************************************/
void BSI_CMTTestInit ()
{
    int i;
    volatile BSI_REG_TYPE *r_ptr;

    for (i=0; i < 2; i++) {
        GetBsiDefault(i);
	r_ptr = bsi_dev[i].base_addr;
	r_ptr->r0cr0 = 0;
	r_ptr->r1cr0 = 0;
    }
}

/**************************************************************************
 *  Function BSI_ResetBsi
 *
 *  Description
 *      This function resets the two BSI chips and the memory as well
 *
 *  Parameter:
 *      uint32 bsi_num
 *
 *  Return: [OK | FDDI_ERROR]
 **************************************************************************/
status_type BSI_ResetBsi (bsi_num)
uint32 bsi_num;
{
  long s;

  s = crit_on();
  BSIREG_ResetBsi(bsi_num);

  /* release all the data buffers in the chip descriptors */
  FreeAllBufs(bsi_num);

  ResetReq(bsi_num);
  ResetInd(bsi_num);
  ResetBsiRegs(bsi_num,DRV_FROM_APP);
  ResetPSPDesc(bsi_num);    /* reset PSP to the descriptor */
  BSIREG_BsiRun(bsi_num);

  crit_off(s);
  return (OK);
}


/**************************************************************************
 *  Function   BSI_SendDirectBeacon
 *
 *  Description
 *    This function sends out a directed beacon frame. The steps is 
 *    following the bug report in the National User Information
 *
 *  Parameter:
 *    uint32 bsi_num
 *    byte *pkt_ptr - point to the beacon frame
 *
 *  Return: [OK | FDDI_ERROR]
 *************************************************************************/
int BSI_SendDirectBeacon (bsi_num,pkt_ptr)
uint32 bsi_num;
byte *pkt_ptr;
{
  volatile BSI_REG_TYPE *r_ptr = bsi_dev[bsi_num].base_addr;
  BSI_REQCH_TYPE *ch_ptr = bsi_dev[bsi_num].rch0;
  REQ_DESCR_TYPE reqq;
  uint32 val, s;
  PKT *pktp, *pkt2;

  if (bsi_init_flag == FALSE)
    return FDDI_ERROR;

#if RESET_DEBUG
  printf("calling ResetReqMachine() from direct beacon\n");
#endif
  ResetReqMachine(bsi_num);  /* flush out all the queued tx pkts */
  if ((pktp=MEM_GetPkt()) == NULL) {
    printf("Warning: can't get pkt, no direct beacon will be sent\n");
    return FDDI_ERROR;
  }
  memcpy(pktp->pktBufPtr,pkt_ptr,23);   /* build direct beacon DBD */
  pktp->pktDataSize = 23;
  if ((pkt2 = MEM_GetPkt()) == NULL) {
    pktp->pktFree(pktp);
	return FDDI_ERROR;	
  }
  memcpy(pkt2->pktBufPtr,pkt_ptr,23);
  pkt2->pktDataSize = 23;

  s = crit_on();
  r_ptr->r0cr0 |= (BSI_RxCR0_SAT | BSI_RxCR0_FCT);    /* enable FCT */
  r_ptr->rnr = 0;                /* disable request interrupt */
#ifdef __FEBRIDGE
  /* turn off swap function */
  r_ptr->acr &= 0x07;
#endif

  /* build 1st reqq */
  reqq.loc = BSI_FIRST | (ch_ptr->odudq->ql & BSI_ADDR28);
  reqq.size = 1;  /* always send one frame */
  if (ch_ptr->reqq->uid == 0)
    ch_ptr->reqq->uid = 1;
  reqq.uid = ch_ptr->reqq->uid & BSI_REQ_UID_MASK;
  reqq.res = 0;
  reqq.cnfcls = BSI_REQ_CNFCLS_TENDR;
  reqq.rqcls = BSI_REQ_RQCLS_IMM;
  /* since the reqq desc are reset, BuildODUD should always return OK */
  BuildODUD(ch_ptr,pkt2->pktBufPtr,23,BSI_ONLY,pkt2);
  memcpy(ch_ptr->reqq->ql,&reqq,BSI_DESC_SLOT_SIZE);
  NEXT_QSLOT_ADDR(ch_ptr->reqq->ql);

  /* build 2nd reqq */
  reqq.loc = BSI_LAST | (ch_ptr->odudq->ql & BSI_ADDR28);
  reqq.size = 1;  /* always send one frame */
  if (ch_ptr->reqq->uid == 0)
    ch_ptr->reqq->uid = 1;
  reqq.uid = ch_ptr->reqq->uid & BSI_REQ_UID_MASK;
  reqq.res = 0;
  reqq.cnfcls = BSI_REQ_CNFCLS_TENDR;
  reqq.rqcls = BSI_REQ_RQCLS_IMM;
  BuildODUD(ch_ptr,pktp->pktBufPtr,23,BSI_ONLY,pktp);
  memcpy(ch_ptr->reqq->ql,&reqq,BSI_DESC_SLOT_SIZE);

  /* stop bmac */
  BMAC_StopBmac(bsi_num);
  BMAC_ReadTMAX(bsi_num,(byte *)&(bmacs[bsi_num].tmax));/* change the value in TMAX register to 0x0f */
  BMAC_SetTMAX(bsi_num,0x0f);
  BMAC_ConfigRecovery(bsi_num,BMAC_INHIBIT_RECOVERY);
  BMAC_StartBmac(bsi_num);
  BMAC_Reset(bsi_num);
  /* tell bsi to send it */
  val = ch_ptr->reqq->ql;
  if ((lmop(bsi_num,ch_ptr->info_ptr->rqlr_addr,LMOP_WRITE,&val)) != OK) {
#if BSI_DEBUG
      printf("---  lmop write new tx reqq error\n");
#endif
  }
  
  bsis[bsi_num].direct_beacon = TRUE;
  crit_off(s);

  return OK;
}

/**************************************************************************
 *  Function   BSI_StopDirectBeacon
 *
 *  Description
 *    THis function stops send the direct beacon
 *
 *  Parameter:
 *    uint32 bsi_num
 *
 *  Return: void
 ************************************************************************/
void BSI_StopDirectBeacon (bsi_num)
uint32 bsi_num;
{
  volatile BSI_REG_TYPE *r_ptr = bsi_dev[bsi_num].base_addr;
  BSI_REQCH_TYPE *ch_ptr = bsi_dev[bsi_num].rch0;
  BSI_DEFAULT_TABLE *tbl_ptr;
  long s;

  s = crit_on();
  r_ptr->sar &= ~BSI_SAR_ABR0;    /* abort the transmission */
  
  /* increment reqq->ql before exit */
  ClearTxDesc(bsi_num,ch_ptr);
  if (fddi_board.type == FDDI_BRIDGE)
    tbl_ptr = &bsibr_default_table;
  else /* if (fddi_board.type == FDDICON_MASTER) */
    tbl_ptr = &bsicon_default_table;

  r_ptr->r0cr0 = tbl_ptr->r0cr0;
  BSIREG_ClearRAR(bsi_num);
  r_ptr->rnr = tbl_ptr->rnr;
#ifdef __FEBRIDGE
  r_ptr->acr = tbl_ptr->acr;
#endif

  /* stop bmac */
  BMAC_StopBmac(bsi_num);
  BMAC_SetTMAX(bsi_num,bmacs[bsi_num].tmax);    /* restore tmax */
  BMAC_ConfigRecovery(bsi_num,BMAC_AUTO_RECOVERY);
  BMAC_StartBmac(bsi_num);
  crit_off(s);
}


/**************************************************************************
 *  Function   BSI_AbortTx
 *
 *  Description
 *    This function aborts transmit and reclaim the buffers in the
 *    transmit queue. This is an export function.
 *
 *  Parameter:
 *    uint32 bsi_num
 *
 *  Return: void
 ************************************************************************/
void BSI_AbortTx (bsi_num)
uint32 bsi_num;
{
  ResetReqMachine(bsi_num);
}

/*************************************************************************
 *  Function    BSI_Qfull
 *
 *  Description
 *      This function tests whether or not PSPq is full. Because of the PSP
 *      pipeline and the stupid way BSI chip to handle the PSP, the queue
 *      is full when qp is 2 slots ahead of ql, and queue is empty when
 *      qp is one slot ahead of ql. During the initial condition, qp == ql
 *      also measns empty. Therefore we don't test queue empty in this
 *      function.
 *
 *  Parameters
 *      BSI_REQQ_TYPE *ptr - point to request queue
 *
 *  Return: [TRUE | FALSE]
 *************************************************************************/
bool BSI_Qfull (qp,ql)
uint32 qp;
uint32 ql;
{
  if (qp > ql) {
    if (ql + 0x40 >= qp)
      return TRUE;
  }
  else {   /* ql > qp */
    if ((ql+0x40 - qp) >= BSI_QUEUE_SIZE)
      return TRUE;
  }

  return (FALSE);
}

/**************************************************************************
 *  Function    BSI_WRITEPSP
 *
 *  Description
 *      This function writes the loc field in the PSP queue. 
 *      The Limit register will be updated only when reach the threshold.
 *      It only returns ERROR if the psp queue is full.
 *
 *  Parameters:
 *      uint32 bsi_num
 *      ch_ptr - which channel
 *      phy_addr - the PSP buffer address
 *
 *  Return: [OK | FDDI_ERROR]
 ************************************************************************/
status_type BSI_WritePsp (bsi_num,ch_ptr,phy_addr,force)
uint32  bsi_num;
BSI_INCH_TYPE *ch_ptr;
uint32 phy_addr;
bool force;
{
  volatile uint32 *ptr;
  register BSI_INDQ_TYPE *q_ptr = ch_ptr->pspq;
  uint32 val;
    
  if (BSI_Qfull(q_ptr->qp,q_ptr->ql)) {
    return FDDI_ERROR;
  }

  ptr = (uint32 *)q_ptr->ql;
  *ptr = 0L;
  *(ptr + 1) = (CPU2BSI(phy_addr) & BSI_ADDR28) | BSI_ONLY;
  q_ptr->lmop_count += 1;

  /* write to the PSP queue limit reg only if over the threshold */
  if ((force && (q_ptr->lmop_count >= BSI_PSP_PIPELINE_NUM)) || (q_ptr->lmop_count >= q_ptr->lmop_threshold)) {
    val = ch_ptr->pspq->next_slot & BSI_OFFSET_MASK;
    if ((lmop(bsi_num,ch_ptr->pqli_addr,LMOP_WRITE,&val)) == OK) {
      q_ptr->lmop_count = 0;
    }
  }

  NEXT_QSLOT_ADDR(q_ptr->next_slot);
  NEXT_QSLOT_ADDR(q_ptr->ql);
  return OK;
}
 
/*************************************************************************
 *  Function  BSI_AbortReq
 *
 *  Description
 *    This function asks the BSI to abort the request
 *
 *  Parameter: 
 *    uint32 bsi_num
 *
 *  Return: void
 ************************************************************************/
void BSI_AbortReq (bsi_num)
uint32 bsi_num;
{
  volatile BSI_REG_TYPE *r_ptr = bsi_dev[bsi_num].base_addr;
  long s;

  s = crit_on();
  r_ptr->sar &= ~BSI_SAR_ABR0;
  /* clear all the attention registers */
  r_ptr->nsar &= ~(BSI_NSAR_NSR0 | BSI_NSAR_NSR1);
  r_ptr->rar &= ~(BSI_RAR_USRR0 | BSI_RAR_EXCR0 | BSI_RAR_USRR1 | BSI_RAR_EXCR1);

  r_ptr->star &= ~BSI_STAR_RQSTOP; /* resume request machine */
  crit_off(s);
}

/*************************************************************************
 *  Function    BSI_PipelinePSP
 *
 *  Description
 *    This function sneaks 2 DBDs into PSP descriptor without update the
 *    QL in the PSP descriptor. This is because the chip will read 2 more
 *    descriptors when QP == QL. So we have to make sure that there are
 *    always 2 more free DBDs available for chip to read.
 *
 *  Parameters:
 *
 *  Return : [OK | FDDI_ERROR]
 ************************************************************************/
status_type BSI_PipelinePSP (bsi_num,ch_ptr)
uint32  bsi_num;
BSI_INCH_TYPE *ch_ptr;
{
    volatile uint32 *ptr;
    BSI_INDQ_TYPE *q_ptr;
    uint32 i;
    PKT *pktp;

    q_ptr = ch_ptr->pspq;
    
    for (i=0; i < BSI_PSP_PIPELINE_NUM; i++) {
      if (BSI_Qfull(q_ptr->qp,q_ptr->ql)) {
	return FDDI_ERROR;
      }
      if ((pktp = (PKT *)MEM_GetDataBuf()) == NULL)
	return FDDI_ERROR;

      ptr = (uint32 *)q_ptr->ql;
      *ptr = 0L;
      *(ptr + 1) = (CPU2BSI(pktp) & BSI_ADDR28) | BSI_ONLY;
      NEXT_QSLOT_ADDR(q_ptr->ql);
    }

    return OK;
}

/*************************************************************************
 *  Function    BSI_SetICR
 *
 *  Description
 *    This function sets the criteria of copying receive frames by 
 *    sets the configuration register. Currently it only sets ch 1.
 * 
 *  Parameters:
 *    uint32 bsi_num
 *    uint32 act - [ BSI_CP_PROMIS | BSI_CP_RESTORE]
 *
 *  Return: void
 ************************************************************************/
void BSI_SetICR (bsi_num,act)
uint32 bsi_num;
uint32 act;
{
/*  byte icr;  */
  volatile BSI_REG_TYPE *r_ptr = bsi_dev[bsi_num].base_addr;
  
  if (act == BSI_CP_PROMIS) {
    bsis[bsi_num].icr_val = r_ptr->icr;
    r_ptr->icr |= BSI_ICR_CC1;
  }
  else {
    r_ptr->icr = bsis[bsi_num].icr_val;
  }
}

/*************************************************************************
 *  Function    BSI_SETINR
 *
 *  Description
 *      This function sets Indicate Nofity Register. It is used to enable/
 *      disable the interrupts for a given BSI channel.
 *
 *  Parameters:
 *      byte action - [BSI_RESET | BSI_SET]
 *      byte bit_map
 *      byte *inr_ptr - pointer to INR
 *
 *  Return: void
 **************************************************************************/
void BSI_SetInr(action,bit_map,inr_ptr)
uint32 action;
uint32 bit_map;
volatile byte *inr_ptr;
{
    byte inr;

    inr = *inr_ptr;
    if ((byte)action == BSI_SET)
        inr |= (byte)bit_map;
    else if ((byte)action == BSI_RESET)
        inr &= (byte)~bit_map;

   *inr_ptr = inr;
}

/****************************************************************************
 *  Function   BSI_ChkUnserReq
 *
 *  Description:
 *    This function checks whether or not the request machine is blocked
 *    due to RingOp is reset.
 *
 *  Parameters:
 *    uint32 bsi_num
 *    
 *  Return: void
 ***************************************************************************/
void BSI_ChkUnserReq (bsi_num)
uint32 bsi_num;
{
  if (bsis[bsi_num].bsi_status & REQ_STOP_RINGOP) {
    ResetUnserviceReq(bsi_num,0);
    bsis[bsi_num].bsi_status &= ~REQ_STOP_RINGOP;   
  }
}

/****************************************************************************
 *  Function  BSI_GetBSIMode
 *
 *  Descripton
 *    This function checks whether or not the BSI is in the run mode
 *
 *  Parameters:
 *    uint32 bsi_num
 *
 *  Return: [DRV_STOP | DRV_START]
 ***************************************************************************/
int BSI_GetBSIMode (bsi_num)
uint32 bsi_num;
{
  if ((!bsis[bsi_num].chip_test) || ((bsis[bsi_num].bsi_status & REQ_STOP) != 0)) {
    return DRV_STOP;
  }

  return DRV_START;
}


/****************************************************************************
 *  Function    BSI_ChkCh2NoSpace
 *
 *  Description
 *      This function checks to see whether or not the  NSI2 in NSAR is set.
 *      If it is, it will clear the bit if the flag 'clear_it' is TRUE. It
 *      return TRUE if the bit is set, FALSE otherwise.
 *
 *  Parameter:
 *      uint32 bsi_num
 *      bool clear_it - TRUE if clear the NSI2 bit, FALSE leave the bit alone
 *
 *  Return: [TRUE | FALSE]
 *****************************************************************************/
bool BSI_ChkCh2NoSpace (bsi_num,clear_it)
uint32 bsi_num;
bool clear_it;
{
    byte nsar;
    bool retn_val = FALSE;
    
    nsar = bsi_dev[bsi_num].base_addr->nsar;
    if (nsar & BSI_NSAR_NSI2) {
        retn_val = TRUE;
        if (clear_it) {
            BSIREG_SetNsar(bsi_num,~BSI_NSAR_NSI2);
            if (bsi_dev[bsi_num].ich2->info->status == DRV_MODE_STOP)
                bsi_dev[bsi_num].ich2->info->status = DRV_MODE_RUN;
        }
    }
    return (retn_val);
}
 
/**************************************************************************
 *  Function    BSI_WriteCNF
 *
 *  Description
 *      This function increases one slot of CNF queue
 *
 *  Parameters:
 *    bool force_flag - TRUE if force to write, otherwise it only writes
 *                      when reach the threshold.
 *
 *  Return: OK | FDDI_ERROR
 *************************************************************************/
status_type BSI_WriteCNF (bsi_num,ch_ptr,force_flag)
uint32 bsi_num;
BSI_REQCH_TYPE *ch_ptr;
bool force_flag;
{
  register BSI_REQQ_TYPE *q_ptr;
  uint32 val;
  /************************/
  register int Flag = FALSE;
  register uint32 qp;
  register uint32 ql;
  /************************/

  q_ptr = ch_ptr->cnfq;
  /************************/
    qp = q_ptr->qp;
	ql = q_ptr->ql;
  /************************/
#if FS_PERFORM  
  /* take the pipeline to the consideration */
  if (BSI_Qfull(q_ptr->qp,q_ptr->ql)) { 
    return FDDI_ERROR;
  }
#endif 
  /*************** FS_PERFORM ***************/
  if (qp > ql) {
    if (ql + 0x40 >= qp)
      Flag = TRUE;
  }
  else {   /* ql > qp */
    if ((ql+0x40 - qp) >= BSI_QUEUE_SIZE)
      Flag = TRUE;
  }
  if(Flag == FALSE)
	  return FDDI_ERROR;
  /*******************************************/

  NEXT_QSLOT_ADDR(q_ptr->ql);
  val = q_ptr->ql & BSI_OFFSET_MASK;

  if ((force_flag) || ((++q_ptr->lmop_count) >= q_ptr->lmop_threshold)) {
    q_ptr->lmop_count = 0;
    lmop(bsi_num,ch_ptr->info_ptr->cqlr_addr,LMOP_WRITE,&val);
  }  

  return OK;
}
 

/***************************************************************************
 *  Function   DoMACScrub
 *
 *  Description:
 *    This function does the MAC scrubbing
 *
 *  Parameter:
 *    uint32 mac_num
 *
 *  Return: OK | ERROR
 **************************************************************************/
status_type BSI_DoMACScrub (bsi_num, action)
uint32 bsi_num;
uint32 action;
{
  volatile BSI_REG_TYPE *r_ptr = bsi_dev[bsi_num].base_addr;


  if (action == DRV_ENABLE) {
    r_ptr->r0cr0 |= BSI_RxCR0_VST;
    bsis[bsi_num].do_scrub = TRUE;
  }
  else {
    r_ptr->r0cr0 &= ~BSI_RxCR0_VST;
    bsis[bsi_num].do_scrub = FALSE;
  }
  
  return OK;
}

/***************************************************************************
 *  Function    BSI_SendReq
 *
 *  Description
 *      This function sends out one REQ. If the tx frame size is greater
 *      than 4096 bytes, this function will get 2 PSPs and do the copy.
 *
 *  Parameter
 *      uint16 action - what token to grab
 *      uint16 bsi_num
 *      BSI_RECH_TYPE *ch_ptr;
 *      PKT *pktp - pointer to the TX DBD
 *      uint32 ch_num - channel number
 *      bool chk_bmac - flag to check BMAC Mode
 *
 *  Return: [ OK | FDDI_ERROR]
 **************************************************************************/
int BSI_SendReq (action,bsi_num,ch_ptr,pktp,chk_bmac)  
uint32 action;
uint32 bsi_num;
BSI_REQCH_TYPE *ch_ptr;
PKT *pktp; 
bool chk_bmac;
{
  register BSI_REQQ_TYPE *reqq = ch_ptr->reqq;
  register REQ_DESCR_TYPE *ql = (REQ_DESCR_TYPE *)reqq->ql;
  bool chk_pass = TRUE;
/*************** FRANKS PERFORMANCE ******************/

  volatile BMAC_REG_TYPE *r_ptr = bmacs[bsi_num].reg_base;
  register unsigned char *ptr = bmacs[bsi_num].swRingOp;
  volatile byte rop = r_ptr->cts0 & BMAC_CTS0_ROP;

/*************** FRANKS PERFORMANCE ******************/
/*************** FRANKS PERFORMANCE REMOVE LMOP CALL *******************/
 volatile BSI_REG_TYPE *re_ptr = (bsi_dev+bsi_num)->base_addr;
 register int i = 0;     /**** FS_PERF ****/
 register int Flag = FALSE;
/************* FS_PERF *******************/ 
#ifdef __FEBRIDGE
  register word saveMask;
#else
  register word save_pc = modpc(0x001f0000,0x001f0000);
#endif

  /*----- build reqq. always only -----*/
  ql->size = 1;  /* always send one frame */
  if (reqq->uid == 0)
    reqq->uid = 1;
  ql->uid = reqq->uid & BSI_REQ_UID_MASK;
  ql->res = 0;
  ql->cnfcls = BSI_REQ_CNFCLS_TEND;
  ql->fc = (byte) *(pktp->pktDataPtr); 
  ql->rqcls = action;
#ifdef __FEBRIDGE
  MaskAllInts(saveMask);
#endif

  /* tell bsi to send it if chips are in run mode */
/*************** FRANKS PERFORMANCE ******************/
  if ((!bsis[bsi_num].chip_test) || ((bsis[bsi_num].bsi_status & REQ_STOP) != 0)) {
    chk_pass = FALSE;
  }
/*************** FRANKS PERFORMANCE END ******************/

#ifdef FS_PERF
  if (BSI_GetBSIMode(bsi_num) == DRV_STOP)
    chk_pass = FALSE;
#endif
  else if (chk_bmac) {
#if RINGOP_DEBUG
    if (BMAC_DebugGetBMACMode(bsi_num) == DRV_STOP)
#else
#ifdef FS_PERF
    if (BMAC_GetBMACMode(bsi_num) == DRV_STOP)
#endif
/*************** FRANKS PERFORMANCE END ******************/
  if (!(r_ptr->mr & BMAC_MR_RUN) || (rop != BMAC_CTS0_ROP) ||
      (*ptr != RM_RING_OP))  
/*************** FRANKS PERFORMANCE END ******************/
#endif
      chk_pass = FALSE;
  }
  /* tell bsi to send it if chips are in run mode */
  if (chk_pass) {
    if (pktp->pktBufLink == NULL) /* packet in one PKT */ {
#ifndef __FEBRIDGE
      pktp->pktUseCount |= PKTINXMT;   /* put DBD in xmt queue */
#endif
      if (BuildODUD(ch_ptr,pktp->pktDataPtr,pktp->pktDataSize,BSI_ONLY,pktp) !=
	  OK) {
	RestoreIntMask(saveMask);
	return NO_RESOURCE;
      }
    }
    else 
    {   /* handle the chained PKTs */
      if (BuildMultipleODUD(ch_ptr,pktp) == 1) {
	FreePktBuf(pktp);
    	RestoreIntMask(saveMask);
	return NO_RESOURCE;
      }			
    }

    reqq->uid++;    
    if (reqq->uid >= BSI_REQ_UID_MAX)
      reqq->uid = 1;

	/*************** FRANKS PERFORM *******************/
/*    lmop(bsi_num,ch_ptr->info_ptr->rqlr_addr,LMOP_WRITE,&(reqq->ql)); */

  while (i++ < 5) { 
	  if (re_ptr->sar & BSI_SAR_LMOP == BSI_SAR_LMOP) {
		Flag = TRUE;
		break;
	  }
  }
   if(Flag == TRUE) {
   /* write to LDR and LAR */
   re_ptr->ldr = (reqq->ql >> 3) & 0xff;
   re_ptr->lar = ((ch_ptr->info_ptr->rqlr_addr << 4) & BSI_LAR_LRA)|((reqq->ql >> 11)&BSI_LAR_LRD8);

   /* send command to do it */
   re_ptr->sar &= ~BSI_SAR_LMOP;   /* ask BSI to do the transfer */
   }
 



	/*************** FRANKS PERFORM *******************/
#ifdef FS_PERF
    if ((lmop(bsi_num,ch_ptr->info_ptr->rqlr_addr,LMOP_WRITE,&(reqq->ql))) != OK) {
#if BSI_DEBUG
      printf("Warning: lmop write new tx reqq error\n");
#endif
    }
#endif

	StartBSITimer(bsi_num);
    NEXT_QSLOT_ADDR(reqq->ql);
#if JWJ
    bsi_tx_cnt++;
#endif
	
#ifdef __FEBRIDGE	
    RestoreIntMask(saveMask);
#else
    modpc(0x001f0000,save_pc);
#endif

    return OK;
  }
  else {
    /* throw away the packet */
#if JWJ
   drv_free_cnt += 2;
   bsi_drop_cnt++;
#endif

   FreePktBuf(pktp);
#ifdef __FEBRIDGE  
   RestoreIntMask(saveMask);
#else
   tcp_transmit_complete(); 
   modpc(0x001f0000,save_pc);
#endif
   (ifcntrs+bsi_num)->outdiscardpkts++;
   return RING_NOT_OP;
  }
}


/************************************************************************
 *  Function    BSI_ChkIdudStatus
 *
 *  Description
 *      This function checks the received IDUD status. It returns OK is
 *      no error in the received IDUD
 *
 *  Parameter:
 *      uint32 idud_addr - idud slot address
 *
 *  Return: [OK | FDDI_ERROR]
 **********************************************************************/
status_type BSI_ChkIdudStatus (d_ptr,frame_type)
IDUD_DESCR_TYPE *d_ptr;
uint32 frame_type;
{
  uint32  status;

  status = (uint32) (((GENERIC_DESC_TYPE *)d_ptr)->w0);
  if ((status & 0x82000000) || (~status & 0x00c00000) || (status & 0xf0000000 == 0))
    return FDDI_ERROR;

  return OK;
}
 
/***************************************************************************
 *  Function    BSI_ProcessCNF
 *
 *  Description
 *      This function processes all the cnf descriptors. It can be polled
 *      or put in ISR
 *
 *  Parameters:
 *
 *  Return: void
 **************************************************************************/
void BSI_ProcessCNF (bsi_num)
uint32 bsi_num;
{
  uint32 ch_num; 
  register ODUD_DESCR_TYPE *odud_descr;
  register PKT *pktp;
  register CNF_DESCR_TYPE *cnf_ptr;
  register BSI_REQCH_TYPE *ch_ptr;
  register BSI_REQQ_TYPE *q_ptr;
  register REQ_DESCR_TYPE *req_desc;
  CNF_DESCR_TYPE *tmp_cnf;
  byte uid;
  HOSTENTRY *hostp;
  register int *ticks;
#if BR_DEBUG
  uint32 *wp;
#endif

  /* check the flag because chnl_poll() is actived before driver
     is initialized */
  if (bsi_init_flag == FALSE)
      return;
#if JWJ
  cnf_num = 0;
#endif
  ch_ptr = bsi_dev[bsi_num].rch0;
  for (ch_num=0; ch_num < BSI_REQCH_NUM; ch_num++,ch_ptr=bsi_dev[bsi_num].rch1) {
    ticks = &(bsi_dev[bsi_num].timer_count);
    
    /* check to see if request machine stop due to the BSI h/w bug. if
       the tx frames are queued more than BSI_MAX_TXQ, reset the bsi.
       See National Bug List: transmit sleep on 10/22/92 */
    if (*ticks > 0)
      *ticks -= 1;
#ifdef __FEBRIDGE
    if ((--(*ticks) <= 0) && (ch_ptr->info_ptr->queued_cnt >= 52)) {
#else  /* concentrator */
    if ((--(*ticks) <= 0) && (ch_ptr->info_ptr->queued_cnt >= DRV_TXBUF_CNT)) {
#endif
#if RESET_DEBUG
      printf("calling ResetReqMachine() due to transmit sleep, queued_cnt %d\n",ch_ptr->info_ptr->queued_cnt);
#endif
      ResetReqMachine(bsi_num);
      return;
    }

    q_ptr = ch_ptr->cnfq;
    cnf_ptr = (CNF_DESCR_TYPE *)q_ptr->qp;

    /* when no cnf produced, the cfc fields may be 1 which is invalid for
       not full confirmation. Therefore we can't check both words are 0.
       Instead, we check the RS field. It it is 0, then the cnf is NULL. */
    while (cnf_ptr->rs != 0) {
#if JWJ
      cnf_num++;
#endif
      *(ticks) = BSI_TXSLEEP_TIME;
      BSI_WriteCNF(bsi_num,ch_ptr,FALSE);

      req_desc = (REQ_DESCR_TYPE *)ch_ptr->reqq->qp;
      /* check status of CNF. */
      if (cnf_ptr->rs < BSI_CNF_RS_BAD_CONF) {
	uid = req_desc->uid;
	if (uid != cnf_ptr->uid) {   /* tx frame successfully */
#if BR_DEBUG
	  enter_debug(0x1,uid,cnf_ptr->uid);
#endif
	  ClearTxDesc(bsi_num,ch_ptr);
	  return;
	}
      }   /* else frame transmitted successfully */
      else {
	    ProcessBSIException(bsi_num,ch_ptr,cnf_ptr->rs);
#ifndef __FEBRIDGE
	if ((hostp=MONP_hash(bmacs[bsi_num].long_addr,bsi_num,FALSE)) != NULL)
	  hostp->hostOutErrors++;
#endif  /* __FDDI_CON */
      }

      /* free the tx buffer */
      ch_ptr->odudq->qp = BSI2CPU(req_desc->loc & BSI_ADDR28);
      while (TRUE) {
	odud_descr = (ODUD_DESCR_TYPE *)ch_ptr->odudq->qp;
	/* if we are in direct beacon, the dbd needs to be reused, so don't free it */
	if (!bsis[bsi_num].direct_beacon) {  
	  if (pktp = (PKT *)GetReqPkt(ch_ptr)) {
	    pktp->pktUseCount &= ~PKTINXMT;
	    pktp->pktFree(pktp);
	    ch_ptr->info_ptr->queued_cnt -= 1;
#if JWJ
	    drv_free_cnt++;
#endif
#ifndef __FEBRIDGE
	    tcp_transmit_complete();
#endif /* __FEBRIDGE */
	  }
	  else 
	    enter_debug(0x02);
	}
#if BR_DEBUG
	else     /* in direct beacon mode */
	  enter_debug(0x3,bsi_num,bsis[bsi_num].direct_beacon);
#endif    /* BR_DEBUG */

	if ((((odud_descr->loc & BSI_ADDRFL_MASK) & BSI_LAST) == BSI_LAST) ||
	    (odud_descr->cnt == 0))
          break;
	else {
	  NULLIFY_DESC1ST(ch_ptr->odudq->qp);
          NEXT_QSLOT_ADDR(ch_ptr->odudq->qp);
        }
      }
#if BR_DEBUG
      /*  only for debugging */
      wp = (uint32 *)ch_ptr->reqq->qp;
      *wp &= 0x3f000000;
#endif
      NEXT_QSLOT_ADDR(ch_ptr->reqq->qp);

      NULLIFY_DESC1ST(ch_ptr->odudq->qp);
      NEXT_QSLOT_ADDR(ch_ptr->odudq->qp);
      /* because we only check the 1st word, no need to
         clear the 2nd word */
      NULLIFY_DESC1ST(cnf_ptr); 

      NEXT_QSLOT_ADDR(q_ptr->qp);
      cnf_ptr = (CNF_DESCR_TYPE *)q_ptr->qp;

      if ((q_ptr->status & CNF_NO_SPACE) == CNF_NO_SPACE) {
	q_ptr->status &= ~CNF_NO_SPACE;
	ResetUnserviceReq(bsi_num,ch_num);
      }
    }       /* while */  
  }   /* for ch_num */
}


/**************************************************************************
 *  Function    BSI_WriteIDUD
 *
 *  Description
 *      This function updates the idud queue structure and writes IDUD
 *      Limit RAM register if necessary.
 *
 *  Parameters:
 *      BSI_INCH_PTR *ch_ptr - point to the channel
 *
 *  Return: void
 ***************************************************************************/
status_type BSI_WriteIDUD (bsi_num,ch_ptr,force) 
uint32 bsi_num;
BSI_INCH_TYPE *ch_ptr; 
bool force;
{
  uint32 value;
  BSI_INDQ_TYPE *q_ptr;
  /*************************/
  register int Flag = FALSE;
  register uint32 qp;
  register uint32 ql;
  /*************************/

    q_ptr = ch_ptr->idudq;

  /*************************/
    qp = q_ptr->qp;
	ql = q_ptr->ql;
  /*************************/
#if FS_PERFORM 
    if (BSI_Qfull(q_ptr->qp,q_ptr->ql))
      return (FDDI_ERROR);
#endif
  /*************** FS_PERFORM ****************/
  if (qp > ql) {
    if (ql + 0x40 >= qp)
      Flag = TRUE;
  }
  else {   /* ql > qp */
    if ((ql+0x40 - qp) >= BSI_QUEUE_SIZE)
      Flag = TRUE;
  }
  if(Flag == FALSE)
	  return FDDI_ERROR;
  /********************************************/

    /* updates IDUD next process slot */
    NEXT_QSLOT_ADDR(q_ptr->ql);
    value = q_ptr->ql & BSI_OFFSET_MASK;
    q_ptr->lmop_count += 1;

    /* write to IDUD Queue Limit Register */
    if ((force) || (q_ptr->lmop_count >= q_ptr->lmop_threshold)) {
      q_ptr->lmop_count = 0;
      lmop(bsi_num,ch_ptr->iqli_addr,LMOP_WRITE,&value);
    }

    return OK;
}

/**************************************************************************
 *  Function   BSI_ShutdownIndChnl
 * 
 *  Description
 *    This function shuts down a specified indicate channel.
 *
 *  Parameters:
 *    uint32 bsi_num
 *    uint32 ch_num - BSI_INDCH0 | BSI_INDCH1 | BSI_INDCH2]
 *
 *  Return: void
 *************************************************************************/
void BSI_ShutdownIndChnl (bsi_num,ch_num)
uint32 bsi_num;
uint32 ch_num;
{
  volatile BSI_REG_TYPE *r_ptr;

  r_ptr = bsi_dev[bsi_num].base_addr;

  switch (ch_num) {
  case BSI_INDCH0:
    r_ptr->icr &= BSI_ICR_CC0_NO;
    break;

  case BSI_INDCH1:
    r_ptr->icr &= BSI_ICR_CC1_NO;
    break;

  case BSI_INDCH2:
    r_ptr->icr &= BSI_ICR_CC2_NO;
    break;

  default:
    break;
  }
}

 

/****************************************************************************
 *  Function   BSI_GetDbufCtrl
 *
 *  Description
 *      This function returns the control header of the data buffer. *
 *  Parameter:
 *      uint32 addr - addr of the data buffer
 *
 *  Return: byte * - pointer to control header
 ****************************************************************************/
byte *BSI_GetDbufCtrl (addr)
uint32 addr;
{
  uint32 *wp;

  wp = (uint32 *) (addr - BSI_BUF_CTRL);

#if 0
  if (*wp == 0L)
    printf("wp is 0, addr is %lx\n",addr);
#endif

  return ((byte *)*wp);
}

/*
 *------------------------------------------------------------------------
 *      Local Functions
 *------------------------------------------------------------------------
 */ 


/**************************************************************************
 *  Function  AllocDescQuePool
 *
 *  Description
 *    This function allocates a chunk of memory for all the descriptor 
 *    queues. Every descriptor queue has to alignment with 1k boundary.
 *
 *  Parameter:
 *    uint32 num - number of bsi
 *
 *  Return [OK | FDDI_ERROR]
 **************************************************************************/
static status_type AllocDescQuePool (num)
uint32 num;
{
  uint32 total_que;

  total_que = (BSI_REQCH_NUM * BSI_REQ_DESC_NUM + BSI_INDCH_NUM * BSI_IND_DESC_NUM) * num;
  total_que += 1;
#ifdef __FEBRIDGE
  if ((desc_que_head=(byte *)shmalloc(sizeof(byte) * BSI_QUEUE_SIZE*total_que))
       == NULL) {
#else
  if ((desc_que_head=(byte *)lmalloc(sizeof(byte) * BSI_QUEUE_SIZE*total_que))
       == NULL) {
#endif
#if BSI_DEBUG
      printf("Error: no memory for descriptor queues\n");
#endif
    return FDDI_ERROR;
  }

  desc_que_head = (byte *)ALIGN(desc_que_head,BSI_QUEUE_SIZE);
  desc_que_ptr = desc_que_head;

#if 0
  printf("que head %lx\n",desc_que_ptr);
#endif
  return OK;
}

/**************************************************************************
 *  Function   get_descque_mem
 *
 *  Description
 *    This function returns a BSI_QUEUE_SIZE memory which aligned to 1k
 *    boundary.
 *
 *  Parameter:  none
 *
 *  Return: byte *
 *************************************************************************/
static byte *get_descque_mem ()
{
  byte *ptr;

  ptr = desc_que_ptr;
  desc_que_ptr += BSI_QUEUE_SIZE;
  return (ptr);
}

/**************************************************************************
 *  Function    ResetBsiRegs
 *
 *  Description
 *      THis function initializes BSI registers. Note that the BSI will
 *      not be put in the run mode by this function. 
 *
 *  Parameter:
 *      uint16 bsi_num
 *
 *  Return: void
 *************************************************************************/
static status_type ResetBsiRegs (bsi_num,source)
uint32 bsi_num;
int source;
{
    BSI_REG_TYPE *r_ptr;
    BSI_CTRL_TYPE *i_ptr;
    BSI_DEFAULT_TABLE *tbl_ptr;

    
    r_ptr = (BSI_REG_TYPE *)(bsi_dev+bsi_num)->base_addr;
    i_ptr = (bsis+bsi_num)->image_ptr;
    if (fddi_board.type == FDDI_BRIDGE)
        tbl_ptr = &bsibr_default_table;
    else /* if (fddi_board.type == FDDICON_MASTER) */
        tbl_ptr = &bsicon_default_table;

    /*--- reset registers image ---*/
    memset((byte *)i_ptr,0,sizeof(BSI_CTRL_TYPE));

    /*-------
       stop BSI before configure the registers
    -------*/
    BSIREG_ResetBsi(bsi_num);

    /*------
         read revision number and set mailbox reg.
    ------*/
    BSIREG_ReadRev(bsi_num);  
    if (test_ptop(bsi_num) != OK)
      return (FDDI_ERROR);
    if (test_lmop(bsi_num) != OK)
      return (FDDI_ERROR);

    /*-------
        set mode registers - stop bsi 
    -------*/
    r_ptr->mr0 = tbl_ptr->mr0;
    if (((bsis+bsi_num)->rev_num != BSI_1_REV_A)
                    && ((bsis+bsi_num)->rev_num != BSI_1_REV_B)) {
      r_ptr->mr1 = tbl_ptr->mr1;
    }

    /*-------
        load pointer RAM registers
     -------*/
    if (LoadPointerRegs(bsi_num) != OK)
        return (FDDI_ERROR);

    /*-------
        set notify registers: MNR, STNR, SNR, NSNR, RNR, and INR.
    -------*/
    i_ptr->mnr = tbl_ptr->mnr;
    r_ptr->mnr = 0; /* don't enable any interrupt before init complete */

    /*  set state notify register */
    r_ptr->stnr = tbl_ptr->stnr;

    /*  set service notify register */
    r_ptr->snr = tbl_ptr->snr;

    /*  set no space notify register */
    r_ptr->nsnr = tbl_ptr->nsnr;

    /*  set request notify register */
    r_ptr->rnr = tbl_ptr->rnr;

    /*  set indicate notify register */
    r_ptr->inr = i_ptr->inr = tbl_ptr->inr;

    /*-------
        set request configuration registers
    -------*/
    r_ptr->r0cr0 = tbl_ptr->r0cr0;
    r_ptr->r1cr0 = tbl_ptr->r1cr0;

    /*-------
        set request expect frame status register
    -------*/
    r_ptr->r0efsr = tbl_ptr->r0efsr;
    r_ptr->r1efsr = tbl_ptr->r1efsr;

    /*-------
        set indicate configuration register - copy promiscuously.
    --------*/
    if (source == DRV_FROM_BOOT)
      r_ptr->icr = (byte) bsis[bsi_num].icr_val_boot;
    else
      r_ptr->icr = (byte) bsis[bsi_num].icr_val;

    /*-------
        set indicate mode register
    --------*/
    r_ptr->imr = tbl_ptr->imr;

    BSIREG_SetIHLR(bsi_num,tbl_ptr->ihlr);
    
    /*-------
        set indicate threshold register. Set threshold to 1.
    --------*/
    BSIREG_SetITR(bsi_num,tbl_ptr->itr);
        
    /*-------
        set address configuration register: swap address to all the channels
    --------*/
    if (((bsis+bsi_num)->rev_num != BSI_1_REV_A)
                    && ((bsis+bsi_num)->rev_num != BSI_1_REV_B)) {
        r_ptr->acr = tbl_ptr->acr;
    }

    /*-------
        set request channel configuration register: no early token request.
    --------*/
    r_ptr->r0cr1 = tbl_ptr->r0cr1;
    r_ptr->r1cr1 = tbl_ptr->r1cr1;

    /*-------
        load Limit RAM registers
    --------*/
    if (InitLimitRegs(bsi_num) != OK) {
#if BSI_DEBUG
	printf("InitLimitRegs() failed\n");
#endif
      return (FDDI_ERROR);
    }
        
    /*-------
        clear attention registers
    --------*/
    BSIREG_ClearRAR(bsi_num);
    BSIREG_ClearIAR(r_ptr);
    BSIREG_SetNsar(bsi_num,0x2a);
    
    return (OK);
}

/*****************************************************************************
 *  Function FreeAllBufs
 *
 *  Description:
 *    This function releases all the buffers stored in the chips descriptors
 *
 *  Parameter:
 *    int bsi_num
 *
 *  Return: void
 *****************************************************************************/
static void FreeAllBufs (bsi_num)
uint32 bsi_num;
{
  BSI_REQCH_TYPE *ch_ptr;
  BSI_INCH_TYPE  *ich_ptr;
  int i;
#if NODBD_DEBUG
  printf("FreeAllBufs()\n");
#endif
  /* free buffers in odudq */
  for (i=0; i < BSI_REQCH_NUM; i++) {
    if (i == BSI_REQCH0)
      ch_ptr = bsi_dev[bsi_num].rch0;
    else if (i == BSI_REQCH1)
      ch_ptr = bsi_dev[bsi_num].rch1;
    else
      break;

    FreeBufsInODUD(ch_ptr);
  }  /* for */

  /* free buffers in PSP descriptor */
  for (i=0; i < BSI_INDCH_NUM; i++) {
    if (i == BSI_INDCH0)
      ich_ptr = bsi_dev[bsi_num].ich0;
    else if (i == BSI_INDCH1)
      ich_ptr = bsi_dev[bsi_num].ich1;
    else if (i == BSI_INDCH2)
      ich_ptr = bsi_dev[bsi_num].ich2;
    else
      break;

    FreeBufsInPSP(ich_ptr);
  }
}


/*****************************************************************************
 *  Function  FreeBufsInODUD
 *
 *  Description
 *    This function frees all the buffers in the ODUD descriptor
 *
 *  Parameter:
 *    BSI_REQCH_TYPE *ch_ptr - which channel
 *
 *  Return: void
 ****************************************************************************/
static void FreeBufsInODUD (ch_ptr)
register BSI_REQCH_TYPE *ch_ptr;
{
  register word saveMask;
  ODUD_DESCR_TYPE *odud_descr;
  PKT *pktp;
  register BSI_REQCH_INFO *info_ptr = ch_ptr->info_ptr;
 
  MaskAllInts(saveMask);

#if NODBD_DEBUG
  printf("FreeBufsInODUD(), qp %x, ql %x\n",ch_ptr->odudq->qp,ch_ptr->odudq->ql);
#endif
#if 0
  enter_debug(0x7788,info_ptr,info_ptr->req_head);
#endif
  while (ch_ptr->odudq->qp != ch_ptr->odudq->ql) {
    NULLIFY_DESC((ODUD_DESCR_TYPE *)ch_ptr->odudq->qp);
    NEXT_QSLOT_ADDR(ch_ptr->odudq->qp);
  }

  while (info_ptr->req_head) {
    if (pktp = (PKT *)GetReqPkt(ch_ptr)) {
      pktp->pktUseCount &= ~PKTINXMT;
      pktp->pktFree(pktp);
#if JWJ
      drv_free_cnt++;
#endif
      ch_ptr->info_ptr->queued_cnt -= 1;
#ifndef _FEBRIDGE
      tcp_transmit_complete();
#endif
    }
#if PKT_DEBUG
    else  {
      printf("FreeBufsInODUD(), cant't find pktp, que_cnt %d\n",ch_ptr->info_ptr->queued_cnt);
    }
#endif
  }
  RestoreIntMask(saveMask);
}


/*****************************************************************************
 *  Function  FreeBufsInPSP
 *
 *  Description
 *    This function frees all the buffers in the PSP descriptor
 *
 *  Parameter:
 *    BSI_REQCH_TYPE *ch_ptr - which channel
 *
 *  Return: void
 ****************************************************************************/
void FreeBufsInPSP (ch_ptr)
BSI_INCH_TYPE *ch_ptr;
{
  register word saveMask;
  PSP_DESCR_TYPE *psp_descr;
  char *bufp;

  MaskAllInts(saveMask);

  while (ch_ptr->pspq->qp != ch_ptr->pspq->ql) {
    psp_descr = (PSP_DESCR_TYPE *)ch_ptr->pspq->qp;
    bufp = (char *) (BSI2CPU(psp_descr->loc & BSI_ADDR28));
    MEM_FreePSPBuf((uint32)bufp);
    NULLIFY_DESC(psp_descr);
    NEXT_QSLOT_ADDR(ch_ptr->pspq->qp);
  }
  RestoreIntMask(saveMask);
}
  
/*****************************************************************************
 *  Function POLLREG
 *
 *  Description
 *      This function polls BSI SAR register. It returns ERROR if timeout.
 *      Timeout is  1 second. NOTE THAT this function does not do
 *      reschdeule.
 *
 *  Parameter:
 *      byte bit_map - [BSI_SAR_ABR0 | BSI_SAR_ABR1 | BSI_SAR_LMOP |
 *                      BSI_SAR_PTOP]
 *      uint16 bsi_num;
 *
 *  Return: [ OK |FDDI_ERROR]
 ****************************************************************************/
static status_type PollReg (bit_map,r_ptr)
byte bit_map;
volatile BSI_REG_TYPE *r_ptr;
{
   uint32 time_out;
   byte sar;

    /* assume every tick is 10 msec */
    time_out = RealTimeTicks() + POLL_REG_ONE_SEC;
    while (TRUE) {
        if ((sar=r_ptr->sar) & bit_map == bit_map)
            return(OK);
        if (time_out < RealTimeTicks()) {
            return (FDDI_ERROR);
	  }
    }
}

/****************************************************************************
 *  Function    ChkRamOp
 *
 *  Description
 *      This function checks the PTOP bit or LMOP bit in the BSI_SAR. It
 *      returns OK if the bit is set to indicate to the calling routine that
 *      it's OK to do the Pointer RAM Operation or Limit RAM Operation.
 *
 *  Parameter:
 *      byte bit_map - [BSI_SAR_ABR0 | BSI_SAR_ABR1 | BSI_SAR_LMOP |
 *                      BSI_SAR_PTOP]
 *      uint16 bsi_num;
 *
 *  Return: [ OK |FDDI_ERROR]
 ****************************************************************************/
static status_type ChkRamOp (bit_map,r_ptr)
byte bit_map;
volatile BSI_REG_TYPE *r_ptr;
{
  int i = 0;

  while (i++ < 5) {
    if (r_ptr->sar & bit_map == bit_map)
        return(OK);
  }

    return (FDDI_ERROR);
}


/**************************************************************************
 *  Function    PTOP
 *
 *  Description
 *      This function does the Pointer RAM Operation. Because the Pointer
 *      RAM operation is only done in the reset/initialization, to poll
 *      register is OK.
 *
 *  Parameters:
 *      uint32  bsi_num
 *      byte reg_addr - pointer register offset
 *      uint32 action - [PTOP_WRITE | PTOP_READ]
 *      uint32 *value - the value to write or the value read from
 *
 *  Return: [OK | FDDI_ERROR]
 ***************************************************************************/
status_type ptop (bsi_num,reg_addr,action,value)
uint32 bsi_num;
byte reg_addr;
uint32 action;
uint32 *value;
{
    volatile BSI_REG_TYPE *r_ptr = bsi_dev[bsi_num].base_addr;
    volatile uint32 *mbox_ptr;

    mbox_ptr = (uint32 *)bsis[bsi_num].mbox_addr;

    /* check semaphore */
    if (PollReg(BSI_SAR_PTOP,r_ptr) != OK) {
            return (FDDI_ERROR);
    }

    if (action == PTOP_WRITE) {
        *mbox_ptr = *value; /* write new value to the mailbox */
        r_ptr->pcar = reg_addr & BSI_PCAR_A & ~BSI_PCAR_PTRW & ~BSI_PCAR_BP;
        r_ptr->sar &= ~BSI_SAR_PTOP;   /* ask BSI to do the transfer */
        /* wait until the transfer is done */
        if (PollReg(BSI_SAR_PTOP,r_ptr) != OK)
            return (FDDI_ERROR);
    }
    else {
        r_ptr->pcar = (reg_addr & BSI_PCAR_A) | BSI_PCAR_PTRW; 
        r_ptr->sar &= ~BSI_SAR_PTOP;   /* ask BSI to read the reg */
        /* wait until the transfer is done */
        if (PollReg(BSI_SAR_PTOP,r_ptr) != OK)
            return (FDDI_ERROR);
        *value = *mbox_ptr;
   }

   return (OK);
}


/**************************************************************************
 *  Function    LMOP
 *
 *  Description
 *      This function does the Limit RAM Operations.
 *
 *  Parameters:
 *      uint16 bsi_num - BSI number
 *      uint16 reg_addr - Limit RAM register address(offset)
 *      bool    action - [LMOP_READ | LMOP_WRITE]
 *      uint32  value - value in limit RAM register. Note this
 *                      is not physical address.
 *
 *  Return: [OK | FDDI_ERROR]
 *************************************************************************/
status_type lmop (bsi_num, reg_addr, action, value)
uint32 bsi_num;
byte reg_addr;
uint32 action;
uint32 *value;
{
 volatile BSI_REG_TYPE *r_ptr = (bsi_dev+bsi_num)->base_addr;
 register int i = 0;     /**** FS_PERF ****/
 register int Flag = FALSE;   /**** FS_PERF ****/

  /************* FS_PERF *******************/ 
  while (i++ < 5) { 
	  if (r_ptr->sar & BSI_SAR_LMOP == BSI_SAR_LMOP) {
        Flag=TRUE;
		break;
	  }
  }
  if(Flag == FALSE) {
  /************* FS_PERF *******************/ 

 /* check semaphore */
#ifdef FS_PERF
 if (ChkRamOp(BSI_SAR_LMOP,r_ptr) != OK) {
#endif
#if BSI_DEBUG
     printf("Error: Can't do lmop on bsi %d due to SAR_LMOP is 0\n",bsi_num);
#endif
   return FDDI_ERROR;
 }

 if (action == LMOP_WRITE) {
   /* write to LDR and LAR */
   r_ptr->ldr = (*value >> 3) & 0xff;
   r_ptr->lar = ((reg_addr << 4) & BSI_LAR_LRA) | ((*value >> 11) & BSI_LAR_LRD8);

   /* send command to do it */
   r_ptr->sar &= ~BSI_SAR_LMOP;   /* ask BSI to do the transfer */
 }
 else {
   /* setup LAR, indicate which Limit RAM register to read */
   r_ptr->lar = ((reg_addr << 4) & BSI_LAR_LRA) | BSI_LAR_LMRW;
   r_ptr->sar &= ~BSI_SAR_LMOP;     /* command BSI to start action */
   /* wait for BSI to process the command */
   if (ChkRamOp(BSI_SAR_LMOP,r_ptr) != OK) {
     return (FDDI_ERROR);
   }

   *value = ((r_ptr->lar & BSI_LAR_LRD8) << 11) | ((r_ptr->ldr) << 3);
 }
   
 return (OK);
}
 


/******************************************************************************
 *  Function    InitReq
 *
 *  Description
 *      This function allocate memory for the BSI request channel structure
 *
 *  Parameters:
 *      uint16 bsi_num
 *
 *  return: OK | FDDI_ERROR
 *****************************************************************************/
static status_type InitReq (bsi_num)
uint32 bsi_num;
{
  BSI_REQCH_TYPE *req_ptr;
  uint32 i;
  
  for (i = 0; i < BSI_REQCH_NUM; i++) {    
    req_ptr = &(bsi_reqch[bsi_num * BSI_REQCH_NUM + i]);
    switch (i) {
    case BSI_REQCH0:
      if (InitReqChannel(req_ptr,i,bsi_num) != OK)
	return (FDDI_ERROR);
      (bsi_dev+bsi_num)->rch0 = req_ptr;
      break;
	
    case BSI_REQCH1:
      if (InitReqChannel(req_ptr,i,bsi_num) != OK)
	return (FDDI_ERROR);
      (bsi_dev+bsi_num)->rch1 = req_ptr;
      break;
    }
  }

  return OK;
}


/**************************************************************************
 *  Function    InitReqDesc
 *
 *  Description
 *      This function sets up one request descriptor
 *
 *  Parameter:
 *      BSI_REQQ_TYPE *ptr - point to the descriptor
 *
 *  return: [OK | FDDI_ERROR]
 **************************************************************************/
static status_type InitReqDesc (ptr,threshold)
BSI_REQQ_TYPE *ptr;
uint32 threshold;
{
    if ((ptr->base=(uint32)get_descque_mem())== NULL) {
#if BSI_DEBUG
	printf("in InitReqDesc(), no memory, size %d\n",sizeof(char)*BSI_QUEUE_SIZE);
#endif
      return (FDDI_ERROR);
    }
    ptr->lmop_threshold = threshold;

    return OK;
}


/**************************************************************************
 *  Function    InitReqChannel
 *
 *  Description
 *      This function sets up one request channel
 *
 *  Parameter:
 *      *ch_ptr - pointer to request channel
 *      uint16 ch_num - channel number
 *
 *  return: [OK | FDDI_ERROR]
 *************************************************************************/
static status_type InitReqChannel (ch_ptr,ch_num,bsi_num)
BSI_REQCH_TYPE *ch_ptr;
uint32 ch_num,bsi_num;
{
    BSI_REQQ_TYPE *ptr;
    BSI_REQCH_INFO *info;
    extern REQ_RAM_REGS bsi_req_ram[];
    byte i;
    
    info = &(bsi_reqch_info[bsi_num][ch_num]);
    /* get request RAM registers offset */
    info->rqlr_addr = bsi_req_ram[ch_num].rqlr_addr;
    info->cqlr_addr = bsi_req_ram[ch_num].cqlr_addr;
    info->opr_addr = bsi_req_ram[ch_num].opr_addr;
    info->olpr_addr = bsi_req_ram[ch_num].olpr_addr;
    info->cqpr_addr = bsi_req_ram[ch_num].cqpr_addr;
    info->rqpr_addr = bsi_req_ram[ch_num].rqpr_addr;
    info->excep_flag = FALSE;
    ch_ptr->info_ptr = info;

    for (i=0; i < BSI_REQ_DESC_NUM; i++) {
      ptr = &(bsi_reqq[bsi_num][ch_num * BSI_REQ_DESC_NUM + i]);
        switch (i) {
            case BSI_REQQ:
                if (InitReqDesc(ptr,REQ_LMOP_THRES) != OK) {
#if BSI_DEBUG
		    printf("InitReqDesc() REQQ %d failed\n",i);
#endif
		  return (FDDI_ERROR);
		}
                ch_ptr->reqq = ptr;
                break;
            case BSI_ODUDQ:
                if (InitReqDesc(ptr,REQ_LMOP_THRES) != OK)  {
#if BSI_DEBUG
		    printf("InitReqDesc() ODUDQ %d failed\n",i);
#endif
		  return (FDDI_ERROR);
		}
                ch_ptr->odudq = ptr;
                break;
            case BSI_CNFQ:
                if (InitReqDesc(ptr,CNF_LMOP_THRES) != OK)  {
#if BSI_DEBUG
		    printf("InitReqDesc() CNFQ %d failed\n",i);
#endif
		  return (FDDI_ERROR);
		}
                ch_ptr->cnfq = ptr;
		ch_ptr->cnfq->status = CNF_NORMAL;
                break;
        }       /* switch */
    }       /* for */

    return OK;
}
   
/****************************************************************************
 *  Function    ResetReqCh
 *
 *  Description
 *      This function resets the request channel
 *
 *  Parameter:
 *
 *  Return: void
 ***************************************************************************/
static void ResetReqCh (ch_ptr)
BSI_REQCH_TYPE *ch_ptr;
{
  ch_ptr->info_ptr->queued_cnt = ch_ptr->info_ptr->err_count = ch_ptr->info_ptr->no_space_cnt = 0;
  ch_ptr->info_ptr->req_head = ch_ptr->info_ptr->req_tail = NULL;
  ch_ptr->info_ptr->status = DRV_MODE_STOP;
  ResetReqDesc(ch_ptr->reqq);
  ResetReqDesc(ch_ptr->cnfq);
  ResetReqDesc(ch_ptr->odudq);
}

/****************************************************************************
 *  Function    ResetReqDesc
 *
 *  Description
 *      This function resets the request channel descriptors
 *
 *  Parameter:
 *
 *  Return: void
 ***************************************************************************/
static void ResetReqDesc (q_ptr)
BSI_REQQ_TYPE *q_ptr;
{ 
  int i = BSI_QUEUE_SIZE/BSI_DESC_SLOT_SIZE;
  uint32 qp;
  
  qp = q_ptr->base;
  while (i-- > 0) {
    NULLIFY_DESC(qp);
    NEXT_QSLOT_ADDR(qp);
  }
  q_ptr->next_slot = q_ptr->qp = q_ptr->ql = q_ptr->base;
  q_ptr->uid = 0;
  q_ptr->lmop_count = 0;
}

/******************************************************************************
 *  Function    ResetReq
 *
 *  Description
 *      This function resets BSI request machine.
 *
 *  Parameters:
 *      uint16 bsi_num
 *
 *  return: void
 *****************************************************************************/
static void ResetReq (bsi_num)
uint32 bsi_num;
{
    uint32 i;

    for (i = 0; i < BSI_REQCH_NUM; i++) {    
        switch (i) {
            case BSI_REQCH0:
                ResetReqCh(bsi_dev[bsi_num].rch0);
                break;
            case BSI_REQCH1:
                ResetReqCh((bsi_dev+bsi_num)->rch1);
                break;
        }
    }
}

/******************************************************************************
 *  Function    ResetInd
 *
 *  Description
 *      This function resets indicate machine
 *
 *  Parameters:
 *      uint16 bsi_num
 *
 *  return: void
 *****************************************************************************/
static void ResetInd (bsi_num)
uint32 bsi_num;
{
    uint32 i;

    for (i = 0; i < BSI_INDCH_NUM; i++) {    
        switch (i) {
            case BSI_INDCH0:
                ResetIndCh((bsi_dev+bsi_num)->ich0);
                break;
            case BSI_INDCH1:
                ResetIndCh((bsi_dev+bsi_num)->ich1);
                break;
            case BSI_INDCH2:
                ResetIndCh((bsi_dev+bsi_num)->ich2);
                break;
        }
    }
}


/******************************************************************************
 *  Function    InitInd
 *
 *  Description
 *      This function allocate memory for the BSI indicate channel structure
 *
 *  Parameters:
 *      uint16 bsi_num
 *
 *  return: OK | ERROR
 *****************************************************************************/
static status_type InitInd (bsi_num)
uint32 bsi_num;
{
  BSI_INCH_TYPE *ind_ptr;
  uint16 i;

  for (i=0; i < BSI_INDCH_NUM; i++) {
    ind_ptr = &(bsi_inch[bsi_num * BSI_INDCH_NUM + i]);
    memset(ind_ptr,0,sizeof(BSI_INCH_TYPE));
    switch (i) {
    case BSI_INDCH0:
      if (InitIndChannel(ind_ptr,bsi_num,i,IND_LMOP_THRES) != OK)
	return (FDDI_ERROR);
      (bsi_dev+bsi_num)->ich0 = ind_ptr;
      break;
    case BSI_INDCH1:
      if (InitIndChannel(ind_ptr,bsi_num,i,IND_LMOP_THRES) != OK)
	return FDDI_ERROR;
      (bsi_dev+bsi_num)->ich1 = ind_ptr;
      break;
    case BSI_INDCH2:
      if (InitIndChannel(ind_ptr,bsi_num,i,IND_LMOP_THRES) != OK)
	return FDDI_ERROR;
      (bsi_dev+bsi_num)->ich2 = ind_ptr;
      break;
    }
  }   /* for */

  return OK;
}

/*****************************************************************************
 *  Function    InitIndChannel
 *
 *  Description
 *      This function initializes a indicate channel
 *
 *  Parameter
 *      BSI_INCH_TYPE *ch_ptr - pointer to the channel
 *      uint16 ch_num
 *      uint16 threshold - threshold value for lmop
 *
 *  return:  [OK | ERROR]
 ****************************************************************************/
static status_type InitIndChannel (ch_ptr,bsi_num,ch_num,threshold)
BSI_INCH_TYPE *ch_ptr;
uint32 bsi_num;
uint32 ch_num;
uint32 threshold;
{
    uint32 i;
    BSI_INDQ_TYPE *ptr;
    extern IND_RAM_REGS bsi_ind_ram[];
    
    ch_ptr->info = &(bsi_inch_info[bsi_num][ch_num]);
    
    /* get the indicate RAM register offset */
    ch_ptr->iqli_addr = bsi_ind_ram[ch_num].iqli_addr;
    ch_ptr->pqli_addr = bsi_ind_ram[ch_num].pqli_addr;
    ch_ptr->info->ipi_addr = bsi_ind_ram[ch_num].ipi_addr;
    ch_ptr->iqpi_addr = bsi_ind_ram[ch_num].iqpi_addr;
    ch_ptr->pqpi_addr = bsi_ind_ram[ch_num].pqpi_addr;
    ch_ptr->info->npi_addr = bsi_ind_ram[ch_num].npi_addr;
    
    for (i=0; i < BSI_IND_DESC_NUM; i++) {
      ptr = &(bsi_indq[bsi_num][ch_num * BSI_IND_DESC_NUM + i]);
      switch (i) {
      case BSI_IDUDQ:
	if (InitIndDesc(ptr,threshold) != OK)
	  return FDDI_ERROR;
	ch_ptr->idudq = ptr;
	break;
      case BSI_PSPQ:
	if (InitIndDesc(ptr,threshold) != OK)
	  return FDDI_ERROR;
	ch_ptr->pspq = ptr;
	break;
      }
    }       /* for */

    return OK;
}

/*************************************************************************
 *  Function    ResetIndCh
 *
 *  Description
 *      This function resets an indicate channel
 *
 *  Parameter:
 *      BSI_INCH_TYPE *ch_ptr
 *
 *  Return: void
 *************************************************************************/
void ResetIndCh (ch_ptr)
BSI_INCH_TYPE *ch_ptr;
{
  ch_ptr->info->status = DRV_MODE_STOP;
  ch_ptr->info->no_space_cnt = ch_ptr->info->low_space_cnt = 0; 
  ResetIndDesc(ch_ptr->idudq);
  ResetIndDesc(ch_ptr->pspq);
}
 
/*************************************************************************
 *  Function    InitIndDesc
 *
 *  Description
 *      This function initializes an indicate descriptor
 *
 *  Parameter:
 *      *ptr - point to the descriptor
 *      uint16 threshold - lmop threshold valud
 *
 *  Return: [OK | FDDI_ERROR]
 ************************************************************************/
static status_type InitIndDesc (ptr,threshold)
BSI_INDQ_TYPE *ptr;
uint32 threshold;
{
    ptr->base = (uint32)get_descque_mem();
    if (ptr->base == 0L) {
#if BSI_DEBUG
	printf("Error: memory error for descriptor queue\n");
#endif
      return FDDI_ERROR;
    }

    ptr->lmop_threshold = threshold;

    return OK;
}


/*************************************************************************
 *  Function    ResetIndDesc
 *
 *  Description
 *      This function resets an indicate descriptor
 *
 *  Parameter:
 *      *ptr - point to the descriptor
 *
 *  Return: void
 ************************************************************************/
static void ResetIndDesc (ptr)
BSI_INDQ_TYPE *ptr;
{
    ptr->next_slot = ptr->ql = ptr->qp = ptr->base;
    ptr->lmop_count = ptr->psp_count = 0;
}



/*************************************************************************
 *  Function    LoadPointerRegs
 *
 *  Description
 *      This function initializes the pointer RAM registers. This function
 *      is only called during reset.
 *
 *  Parameter
 *      uint16 bsi_num
 *
 *  Return: [OK | FDDI_ERROR]
 *************************************************************************/
static status_type LoadPointerRegs (bsi_num)
int bsi_num;
{
    BSI_REQCH_TYPE *rch_ptr;
    BSI_INCH_TYPE *ich_ptr;
    byte reg_offset;
    uint32 desc_base;
    int i;
    volatile BSI_REG_TYPE *r_ptr;

    r_ptr = bsi_dev[bsi_num].base_addr;
    for (i=0; i < BSI_REQCH_NUM; i++) {
        if (i == BSI_REQCH0) 
            rch_ptr = (bsi_dev+bsi_num)->rch0;
        else
            rch_ptr = (bsi_dev+bsi_num)->rch1;
            
        reg_offset = rch_ptr->info_ptr->rqpr_addr;
        desc_base = rch_ptr->reqq->base;

        if ((ptop(bsi_num,reg_offset,PTOP_WRITE,&desc_base)) != OK) {
#if BSI_DEBUG
	    printf("LoadPointerRegs(), ptop() failed\n");
#endif
          return (FDDI_ERROR);
	}

        reg_offset = rch_ptr->info_ptr->cqpr_addr;
        desc_base = rch_ptr->cnfq->base;
        if ((ptop(bsi_num,reg_offset,PTOP_WRITE,&desc_base)) != OK)
            return (FDDI_ERROR);
    }

    for (i=0; i < BSI_INDCH_NUM; i++) {
        if (i == BSI_INDCH0)
            ich_ptr = (bsi_dev+bsi_num)->ich0;
        else if (i == BSI_INDCH1)
            ich_ptr = (bsi_dev+bsi_num)->ich1;
        else
            ich_ptr = (bsi_dev+bsi_num)->ich2;

        reg_offset = ich_ptr->iqpi_addr;
        desc_base = ich_ptr->idudq->base;
        if ((ptop(bsi_num,reg_offset,PTOP_WRITE,&desc_base)) != OK)
            return (FDDI_ERROR);

        reg_offset = ich_ptr->pqpi_addr;
        desc_base = ich_ptr->pspq->base;
        if ((ptop(bsi_num,reg_offset,PTOP_WRITE,&desc_base)) != OK)
            return (FDDI_ERROR);
    }
    
    return (OK);
}

/****************************************************************************
 *  Function    ResetPSPDesc
 *
 *  Description
 *      This function resets the PSP descriptor of the BSI.
 *      It is based on:
 *      copy SMT frame if matches own MAC or group address,
 *      copy my LLC frame if matches own MAC and ~SA,
 *      copy other LLC frame ifmatches own MAC or group address.
 *
 *  Parameters:
 *      uint32 bsi_num
 *      int source - 0 from booter, 1 from application
 *
 *  Return: void
 ***************************************************************************/
static void ResetPSPDesc (bsi_num,source)
uint32 bsi_num;
int source;
{
    volatile BSI_REG_TYPE *r_ptr;
    r_ptr = bsi_dev[bsi_num].base_addr;

    /* load PSPs to indicate channels */
    if (source) {
#if NODBD_DEBUG
      printf("--- bsi %d, ch0: psp %d, ch1: %d,  ch2 %d\n",bsi_num,bsis[bsi_num].ich0_psp_num,bsis[bsi_num].ich1_psp_num,bsis[bsi_num].ich2_psp_num);
#endif
      MEM_SetChPsp(bsi_num,bsis[bsi_num].ich0_psp_num,
		 bsi_dev[bsi_num].ich0,BSI_INDCH0,FALSE);
      BSI_PipelinePSP(bsi_num,bsi_dev[bsi_num].ich0);
      MEM_SetChPsp(bsi_num,bsis[bsi_num].ich1_psp_num,   
		 bsi_dev[bsi_num].ich1,BSI_INDCH1,FALSE);
      BSI_PipelinePSP(bsi_num,bsi_dev[bsi_num].ich1);
      MEM_SetChPsp(bsi_num,bsis[bsi_num].ich2_psp_num,
		 bsi_dev[bsi_num].ich2,BSI_INDCH2,FALSE);
      BSI_PipelinePSP(bsi_num,bsi_dev[bsi_num].ich2);
    }
    else {   /* for the booter */
      MEM_SetChPsp(bsi_num,bsis[bsi_num].ich0_psp_boot,
		 bsi_dev[bsi_num].ich0,BSI_INDCH0,FALSE);
      BSI_PipelinePSP(bsi_num,bsi_dev[bsi_num].ich0);
      MEM_SetChPsp(bsi_num,bsis[bsi_num].ich1_psp_boot,   
		 bsi_dev[bsi_num].ich1,BSI_INDCH1,FALSE);
      BSI_PipelinePSP(bsi_num,bsi_dev[bsi_num].ich1);
      MEM_SetChPsp(bsi_num,bsis[bsi_num].ich2_psp_boot,
		 bsi_dev[bsi_num].ich2,BSI_INDCH2,FALSE);
      BSI_PipelinePSP(bsi_num,bsi_dev[bsi_num].ich2);
    }
}

/***************************************************************************
 *  Function  init_cnf_ql
 *
 *  Description
 *    This function initializes the ql of cnf descriptor
 *
 *  Parameters:
 *    uint32 bsi_num 
 *    rch_ptr
 *
 *  Return: [OK | FDDI_ERROR]
 **************************************************************************/
static int  init_cnf_ql (bsi_num,rch_ptr)
uint32 bsi_num;
BSI_REQCH_TYPE *rch_ptr;
{
  byte reg_offset;
  uint32 desc_base, i=0;

  reg_offset = rch_ptr->info_ptr->cqlr_addr;
  rch_ptr->cnfq->ql += BSI_DESC_SLOT_SIZE * CNFQ_INIT_NUM;
  desc_base = rch_ptr->cnfq->ql;
  while (TRUE) {
    if ((lmop(bsi_num,reg_offset,LMOP_WRITE,&desc_base)) == OK)
      break;
    if (i++ > CWI_REPEAT_MAX)
      return FDDI_ERROR;
  }

  return OK;
}

/***************************************************************************
 *  Function  init_idud_ql
 *
 *  Description
 *    This function initializes the ql of idud descriptor
 *
 *  Parameters:
 *    uint32 bsi_num 
 *    rch_ptr
 *
 *  Return: [OK | FDDI_ERROR]
 **************************************************************************/
static int init_idud_ql (bsi_num,ich_ptr)
uint32 bsi_num;     
BSI_INCH_TYPE *ich_ptr;
{
  byte reg_offset;
  uint32 desc_base, i=0;

  reg_offset = ich_ptr->iqli_addr;
  ich_ptr->idudq->ql += BSI_DESC_SLOT_SIZE * IDUDQ_INIT_NUM;   
  desc_base = ich_ptr->idudq->ql;
  while (TRUE) {
    if ((lmop(bsi_num,reg_offset,LMOP_WRITE,&desc_base)) == OK)
      break;
    if (i++ > CWI_REPEAT_MAX)
      return FDDI_ERROR;
  }

  return OK;
}

/****************************************************************************
 *  Function    InitLimitRegs
 *
 *  Description
 *      This function initializes the Limit RAM registers. The PSP is not
 *      initializes in this function.
 *
 *  Parameters:
 *      uint32 bsi_num
 *
 *  Return: [OK | FDDI_ERROR] 
 ***************************************************************************/
static status_type InitLimitRegs (bsi_num)
uint32 bsi_num;
{
    BSI_REQCH_TYPE *rch_ptr;
    BSI_INCH_TYPE *ich_ptr;


    int i;

    for (i=0; i < BSI_REQCH_NUM; i++) {
        if (i == BSI_REQCH0) 
            rch_ptr = (bsi_dev+bsi_num)->rch0;
        else
            rch_ptr = (bsi_dev+bsi_num)->rch1;
	init_cnf_ql(bsi_num,rch_ptr);
    }

    for (i=0; i < BSI_INDCH_NUM; i++) {
        if (i == BSI_INDCH0) {
            ich_ptr = (bsi_dev+bsi_num)->ich0;
	  }
        else if (i == BSI_INDCH1) {
            ich_ptr = (bsi_dev+bsi_num)->ich1;
	  }
        else {
            ich_ptr = (bsi_dev+bsi_num)->ich2;
	  }
	init_idud_ql(bsi_num,ich_ptr);
    }

    return (OK);
}

/*************************************************************************
 *  Function    ResetReqMachine
 *
 *  Description
 *    This function resets the bsi request machine
 *
 *  Parameter:
 *    uint32 bsi_num
 *
 *  Return: void
 ************************************************************************/
static void ResetReqMachine (bsi_num)
uint32 bsi_num;
{
  long s;
  volatile BSI_REG_TYPE *r_ptr = bsi_dev[bsi_num].base_addr;
  register int i;
#if JWJ
  bsi_reset_cnt++;
#endif
  s = crit_on();
#if RESET_DEBUG
  if (get_debug() == DEBUG_ON)
    printf("ResetReqMachine() on bsi %d\n",bsi_num);
#endif
  r_ptr->sar &= ~BSI_SAR_ABR0;  /* abort request */
  r_ptr->sar &= ~BSI_SAR_ABR1;
  r_ptr->star |= BSI_STAR_RQSTOP;  /* stop req machine */

  ClearTxDesc(bsi_num,bsi_dev[bsi_num].rch0);  /* clear dbds in the odud */
  ClearTxDesc(bsi_num,bsi_dev[bsi_num].rch1);  /* clear dbds in the odud */

  /* clear all the attention registers */
  r_ptr->nsar &= ~(BSI_NSAR_NSR0 | BSI_NSAR_NSR1);
  r_ptr->rar &= ~(BSI_RAR_USRR0 | BSI_RAR_EXCR0 | BSI_RAR_USRR1 | BSI_RAR_EXCR1);

  r_ptr->star &= ~BSI_STAR_RQSTOP; /* resume request machine */

  crit_off(s);
}

/*************************************************************************
 *  Function    GetBsiDefault
 *
 *  Description
 *      This function copies the bsi unchanged data from default table.
 *
 *  Parameter
 *      uint32  bsi_num
 *
 *  Return: void
 ************************************************************************/
static void GetBsiDefault (bsi_num)
uint32 bsi_num;
{
    bsi_dev[bsi_num].base_addr = bsi_master_default[bsi_num].base_addr;
    bsi_dev[bsi_num].timer_count = 0;
    bsis[bsi_num].isr = bsi_master_default[bsi_num].isr;
    bsis[bsi_num].osr = bsi_master_default[bsi_num].osr;
    bsis[bsi_num].ich0_psp_num = bsi_master_default[bsi_num].ich0_psp_num;
    bsis[bsi_num].ich1_psp_num = bsi_master_default[bsi_num].ich1_psp_num;
    bsis[bsi_num].ich2_psp_num = bsi_master_default[bsi_num].ich2_psp_num;
 
    bsis[bsi_num].ich0_psp_boot = bsi_master_default[bsi_num].ich0_psp_boot;
    bsis[bsi_num].ich1_psp_boot = bsi_master_default[bsi_num].ich1_psp_boot;
    bsis[bsi_num].ich2_psp_boot = bsi_master_default[bsi_num].ich2_psp_boot;
    bsis[bsi_num].icr_val = bsi_master_default[bsi_num].icr_val;
    bsis[bsi_num].icr_val_boot = bsi_master_default[bsi_num].icr_val_boot;
    bsis[bsi_num].bsi_status = 0L | BSI_IND_STOP | BSI_REQ_STOP | BSI_SP_STOP;
    bsis[bsi_num].do_scrub = FALSE;
    bsis[bsi_num].self_test = FALSE;
    bsis[bsi_num].direct_beacon = FALSE;
}

 
/***********************************************************************
 *  Function     ResetUnserviceReq
 *
 *  Description
 *    THis function resets the request machine which was stopped due
 *    to unserviceable request
 *
 *  Parameter:
 *    uint32 bsi_num
 *    uint32 ch_num
 *
 *  Return: void
 **********************************************************************/
static void ResetUnserviceReq (bsi_num,ch_num)
uint32 bsi_num;
uint32 ch_num;
{
  volatile BSI_REG_TYPE *r_ptr = bsi_dev[bsi_num].base_addr;

  if (ch_num == 0) {
    r_ptr->rar &= ~BSI_RAR_USRR0;
    r_ptr->rnr |= BSI_RNR_USRR0N;
  }
  else {
    r_ptr->rar &= ~BSI_RAR_USRR1;
    r_ptr->rnr |= BSI_RNR_USRR1N;
  }
}

/***********************************************************************
 *  Function     BuildODUD
 *
 *  Description
 *    This function builds an ODUD
 *
 *  Parameters:
 *    BSI_REQCH_TYPE *ch_ptr
 *    byte *frame_ptr - the start pointer of the frame, has to be word
 *                      alignment.
 *    uint32 frame_len - the frame length 
 *    uint32 mask - [BSI_LAST | BSI_FIRST | BSI_ONLY]
 *
 *  Return: void
 **********************************************************************/
static int BuildODUD (ch_ptr,frame_ptr,frame_len,mask,pktp)
BSI_REQCH_TYPE *ch_ptr;
byte *frame_ptr;
uint32 frame_len;
uint32 mask;
PKT *pktp;
{
  register ODUD_DESCR_TYPE *odud;
  register BSI_REQCH_INFO *info_ptr = ch_ptr->info_ptr;

  if (SavePktPtr(info_ptr,pktp) != OK) {
	pktp->pktFree(pktp);
	return FDDI_ERROR;
  }
  odud = (ODUD_DESCR_TYPE *) ch_ptr->odudq->ql;
  odud->res1b = odud->res1a = 0;
  odud->cnt = frame_len;
  odud->loc = (mask | (CPU2BSI(frame_ptr) & BSI_ADDR28));
  info_ptr->queued_cnt++;
  ((REQ_DESCR_TYPE *)ch_ptr->reqq->ql)->loc = BSI_ONLY | (ch_ptr->odudq->ql & BSI_ADDR28);

  NEXT_QSLOT_ADDR(ch_ptr->odudq->ql);
  return OK;
}

/***********************************************************************
 *  Function     BuildMultipleODUD
 *
 *  Description
 *    This function builds multiple ODUDs. the tx pkt is chained.
 *
 *  Parameters:
 *    BSI_REQCH_TYPE *ch_ptr
 *    byte *frame_ptr - the start pointer of the frame, has to be word
 *                      alignment.
 *
 *  Return: void
 **********************************************************************/
static int BuildMultipleODUD (ch_ptr,frame_ptr) 
BSI_REQCH_TYPE *ch_ptr;
PKT *frame_ptr;
{
  register word saveMask; 
  register BSI_REQCH_INFO *info_ptr = ch_ptr->info_ptr;
  ODUD_DESCR_TYPE *odud;
  register PKT *pkt;
  uint32 mask;
  ODUD_DESCR_TYPE *ptr;
  bool first = TRUE;

  if ((ch_ptr->odudq->ql & 0x000003f8) == 0x000003f8) {
    /* for chained packet, if odud.first & odud.last are not
       at continuous location, the chip won't wrap around,
       therefore we have to skip this one and go to the beginning
       of the odud queue. We set fl != BSI_LAST
       so that when we update odud->qp in ProcessCNF(),
       we will skip this one & go to the next one */
#if 0
    odud->loc = BSI_FIRST; 
#endif
    NEXT_QSLOT_ADDR(ch_ptr->odudq->ql);
  }
  for (pkt = frame_ptr; pkt; pkt = pkt->pktBufLink) {
#if FS_PERFORM 
    if (SavePktPtr(info_ptr,pkt) != OK) {
      if (first)  /* nothing has been put in ODUD descriptor yet */
	return 1;
      return 2;    /* at least one pkt has been put in ODUD descriptor */
    }
#endif 
/***************/
  {
	register BSI_REQ_MSG *msg;

	MaskAllInts(saveMask); 
 	msg = req_start;
  	if (req_start)
    		req_start = req_start->next;
  	if(msg) {
    		msg->bufp = (char *)pkt;
    		if (info_ptr->req_tail) {
     			info_ptr->req_tail->link = msg;
      			info_ptr->req_tail = msg;
    		}
    		else {
     			info_ptr->req_head = info_ptr->req_tail = msg;
    		}
  	}
  	else  {
		RestoreIntMask(saveMask); 
      		if (first)  /* nothing has been put in ODUD descriptor yet */
			return 1;
      		return 2;    /* at least 1 pkt has been put in ODUD descriptor */
  	}
	RestoreIntMask(saveMask); 
  }
/***************/
    odud = (ODUD_DESCR_TYPE *) ch_ptr->odudq->ql;
    odud->res1b = odud->res1a = 0;
#ifndef __FEBRIDGE
    odud->cnt = pkt->pktDataSize;
#endif
    if (first) {
      mask = BSI_FIRST;
#ifdef __FEBRIDGE
      odud->cnt = pkt->pktDataSize;
#endif
      first = FALSE;
      ((REQ_DESCR_TYPE *)ch_ptr->reqq->ql)->loc = BSI_ONLY | (ch_ptr->odudq->ql & BSI_ADDR28);
    }
    else if (pkt->pktBufLink)  {
      mask = BSI_MIDDLE;
#ifdef __FEBRIDGE
      odud->cnt = pkt->pktDataSize;
#endif
    }
    else {
      mask = BSI_LAST;
#ifdef __FEBRIDGE
      /* This hack is required for now due to the way packets are 
       ** translated from ethernet to fddi. Since a frame received
       ** on an ethernet port can potentially be transmitted both on
       ** another ethernet port and fddi, special allowances must be
       ** made. This is one in which the frame will be transmitted 
       ** without the padding bytes on FDDI requiring a non-standard
       ** way of telling the FDDI driver the number of bytes to xmt.
       ** The pktTotalSize field is normally unused for all but the
       ** first chained pkt. Therefore we use it to indicate the 
       ** number of bytes to be transmitted onto FDDI. The pktDataSize
       ** field will still be used by the SONIC driver and will contain
       ** the number of frame bytes including the pad bytes.
       ** ...Frank S.
       */
      odud->cnt = pkt->pktTotalSize;
#if 0
      if (odud->cnt == 0)
	enter_debug(0x5566,pkt,pkt->pktTotalSize,ch_ptr->odudq->ql);
#endif
#endif
    }
    odud->loc = (mask | (CPU2BSI(pkt->pktDataPtr) & BSI_ADDR28));
    info_ptr->queued_cnt++;
    NEXT_QSLOT_ADDR(ch_ptr->odudq->ql);
    pkt->pktUseCount |= PKTINXMT;   /* put DBD in xmt queue */
#if  JWJ
    bsi_odud_cnt++;
#endif
  }

  return OK;
}


/*************************************************************************
 *  Function  ProcessBSIException
 *
 *  Description
 *    This function process BSI request exception
 *
 *  Parameters:
 *   int bsi_num
 *   
 *
 *  Return:
 *************************************************************************/
static void ProcessBSIException (bsi_num,ch_ptr,rs)
uint32 bsi_num;
BSI_REQCH_TYPE *ch_ptr;
uint32 rs;
{
#if BR_DEBUG
  ODUD_DESCR_TYPE *odud;
  int *ptr, i;

  dprintf("BSI %d Exception (rs %x): ",bsi_num,rs);
#endif
  switch (rs) {
  case BSI_CNF_RS_CON_FAILURE:
#if 0
    enter_debug(0x111,bsis[bsi_num].direct_beacon,ch_ptr->info_ptr->queued_cnt);
#endif
    if (ch_ptr->info_ptr->excep_flag) {
      ch_ptr->info_ptr->excep_flag = FALSE;
      bsi_dev[bsi_num].base_addr->rnr |= BSI_RNR_EXCR0N;
    }
    break;

  case BSI_CNF_RS_FATAL_ERROR:
#if BR_DEBUG
      dprintf("ABus failure\n");
#endif
    BSI_ResetBsi(bsi_num);
    break;

  case BSI_CNF_RS_BAD_RINGOP	:
#if BR_DEBUG
      dprintf("Bad RingOp\n");
      dprintf("cnf qp %x, odud qp %x reqq qp %x\n",ch_ptr->cnfq->qp,ch_ptr->odudq->qp,ch_ptr->reqq->qp);
	  ptr = (int*) ch_ptr->odudq->qp;
      dprintf("odud w0: %x   ",*ptr);
	  ptr++;
	  dprintf("w1: %x\n",*ptr);
	  ptr = (int *)ch_ptr->reqq->qp;
	  dprintf("reqq qp w0: %x\n",*ptr);
      if (bmacs[bsi_num].ring_op)
		dprintf("BMAC RingOp is up\n\n");
      else
		dprintf("BMAC RingOp is down\n\n");
#endif
    break;

  case BSI_CNF_RS_MAC_RESET:
#if BR_DEBUG
      dprintf("MAC reset\n");
#endif
    break;

  case BSI_CNF_RS_NONE          :
  case BSI_CNF_RS_PREEMPTED	:
  case BSI_CNF_RS_PART_DONE	:
  case BSI_CNF_RS_SERV_LOSS	:
  case BSI_CNF_RS_COMPLETED_BC	:
  case BSI_CNF_RS_COMPLETED_OK	:
  case BSI_CNF_RS_BAD_CONF	:
  case BSI_CNF_RS_UNDERRUN	:
  case BSI_CNF_RS_HOST_ABORT	:
  case BSI_CNF_RS_MAC_ABORT	:
  case BSI_CNF_RS_TIMEOUT	:
#if BR_DEBUG
      dprintf("\n");
#endif
    break;
  }
#if JWJ
  cnf_drop_cnt++;
#endif
}


/*************************************************************************
 *  Function  StartBSITimer
 *
 *  Description
 *    This function starts the bsiTimer which is used to check the queded
 *    DBDs.
 *
 *  Parameter:
 *    uint32 bsi_num
 *
 *  Return: void
 ***********************************************************************/
static void StartBSITimer (bsi_num)
uint32 bsi_num;
{
  if (bsi_dev[bsi_num].timer_count > 0)
    return;
  bsi_dev[bsi_num].timer_count = BSI_TXSLEEP_TIME;
}

/*************************************************************************
 *  Function   ClearTxDesc
 *
 *  Description
 *    This function clears the transmit descriptors: REQ, CNF, and ODUD
 *
 *  Parameter:
 *    BSI_REQCH_TYPE *ch_ptr;
 *
 *  Return: void
 ************************************************************************/
void ClearTxDesc (bsi_num,ch_ptr)
uint32 bsi_num;
register BSI_REQCH_TYPE *ch_ptr;
{
  uint32 desc_base;
  register byte reg_offset;
/*******/
  register BSI_REQQ_TYPE *q_ptr;
  register int i = BSI_QUEUE_SIZE/BSI_DESC_SLOT_SIZE;
  register uint32 qp;
/*******/

#if NODBD_DEBUG
  printf("cnf qp %x, ql %x, cnt %d\n",ch_ptr->cnfq->qp,ch_ptr->cnfq->ql,ch_ptr->info_ptr->queued_cnt);
#endif
  /* free dbds in the odud */
  FreeBufsInODUD(ch_ptr);

  /* reinitialize the transmit queue */
#ifdef FS_PERFORM
  ResetReqCh(ch_ptr);
#endif
/************* FS_PERFORM *********************************/
  ch_ptr->info_ptr->queued_cnt = ch_ptr->info_ptr->err_count = ch_ptr->info_ptr->no_space_cnt = 0;
  ch_ptr->info_ptr->req_head = ch_ptr->info_ptr->req_tail = NULL;
  ch_ptr->info_ptr->status = DRV_MODE_STOP;

#if FS_PERFORM
  ResetReqDesc(ch_ptr->reqq);
#endif
/****/
  {
      q_ptr = ch_ptr->reqq;
      qp = q_ptr->base;
      while (i-- > 0) {
        NULLIFY_DESC(qp);
        NEXT_QSLOT_ADDR(qp);
      }
      q_ptr->next_slot = q_ptr->qp = q_ptr->ql = q_ptr->base;
      q_ptr->uid = 0;
      q_ptr->lmop_count = 0;
  }
/****/
  ResetReqDesc(ch_ptr->cnfq);
  ResetReqDesc(ch_ptr->odudq);

/**********************************************/
  reg_offset = ch_ptr->info_ptr->rqpr_addr;
  desc_base = ch_ptr->reqq->base;
  if ((ptop(bsi_num,reg_offset,PTOP_WRITE,&desc_base)) != OK) {
#if BSI_DEBUG
      printf("ClearTxDESC(), ptop failed\n");
#endif
  }

  reg_offset = ch_ptr->info_ptr->cqpr_addr;
  desc_base = ch_ptr->cnfq->base;
  if ((ptop(bsi_num,reg_offset,PTOP_WRITE,&desc_base)) != OK) {
#if BSI_DEBUG
      printf("ClearTxDESC(), ptop failed\n");
#endif
  }
  init_cnf_ql(bsi_num,ch_ptr);

#if 0
  printf("ClearTxDesc()\n");
  BSI_ChkDBDs();
#endif
}


/*************************************************************************
 *  Function  init_req_list
 *
 *  Description
 *    This function initializes the req desc list that used to store the
 *    free BSI_REQ_MSG.
 *
 *    ------------
 *    | next     | -> next free msg in the free list
 *    ------------
 *    | req_mark |
 *    ------------
 *    | link     | -> driver to link msg in the tx queue 
 *    ------------
 *    | bufp     | -> point to the pkt control header
 *    ------------
 *
 *    req_start - global in this module, to free msg list.
 *     free list          msg        msg
 *    -------------    --------    --------
 *    | req_start | -> | next | -> | next | -> ....
 *    ------------     --------    --------
 *
 *     reqch_ptr->info       msg          msg         msg
 *    ----------------     --------     --------    --------
 *    | req_head     | ->  | link |  -> | link | -> | link | -> NULL
 *    ----------------     --------     --------    --------
 *                                                     ^
 *    ----------------                                 |
 *    | req_tail     | --------------------------------|
 *    ----------------
 *  Parameter:  none
 *
 *  Return: OK | FDDI_ERROR
 ************************************************************************/
static int init_req_list ()
{
  BSI_REQ_MSG *ptr;
  int num, i;
  register word save_pc = modpc(0x001f0000,0x001f0000);

  num = BSI_REQCH_NUM * BSI_QUEUE_MAX_SLOT * (fddi_board.bsi_num);
  req_start = NULL;

  for (i=0; i < num; i++, ptr++) {
    if ((ptr = (BSI_REQ_MSG *)lmalloc(sizeof(BSI_REQ_MSG))) == NULL) {
      DebugStr("Error: no memory to store request list\n");
      return FDDI_ERROR;
    }
    ptr->bufp = NULL;
    ptr->link = NULL;
    ptr->req_mark = REQ_MARK;
    ptr->next = req_start;
    req_start = ptr;
  }

  modpc(0x001f0000,save_pc);
  return OK;
}

/**************************************************************************
 *  Function get_req_msg
 *
 *  Description
 *    This function gets the req msg from the free list. NOTE that this 
 *    function assumes that the interrupt is disable already.
 *
 *  Parameter
 *    BSI_REQ_MSG none
 *
 *  Return: [NULL | msg ptr]
 *************************************************************************/
static BSI_REQ_MSG *get_req_msg ()
{
  BSI_REQ_MSG *ptr;
  
  ptr = req_start;
  if (req_start)
    req_start = req_start->next;

  return (ptr);
}

/**************************************************************************
 *  Function put_req_msg
 *
 *  Description
 *    This function puts the req msg to the free list. NOTE that this 
 *    function assumes that the interrupt is disable already.
 *
 *  Parameter
 *    BSI_REQ_MSG *ptr
 *
 *  Return: void
 *************************************************************************/
static void put_req_msg (ptr)
BSI_REQ_MSG *ptr;
{
  if (ptr->req_mark == REQ_MARK) {
    ptr->link = NULL;
    ptr->next = req_start;
    req_start = ptr;
  }
  else
    DebugStr("Error: req msg trashed\n");
}


static int SavePktPtr (info_ptr, pkt)
register BSI_REQCH_INFO *info_ptr;
PKT *pkt;
{
  register word saveMask;
  register BSI_REQ_MSG *msg;
  int retn;

  MaskAllInts(saveMask);
#if FS_PERF 
  if (msg = get_req_msg()) {
#endif 
/***********/
  msg = req_start;
  if (req_start)
    req_start = req_start->next;
  if(msg) {
/***********/
    msg->bufp = (char *)pkt;
    if (info_ptr->req_tail) {
      info_ptr->req_tail->link = msg;
      info_ptr->req_tail = msg;
    }
    else {
#if  PKT_DEBUG
      if (info_ptr->req_head) {
	printf("Fatal error: req_head inconsistent, %x\n",info_ptr);
      }
#endif
      info_ptr->req_head = info_ptr->req_tail = msg;
    }
    retn = OK;
  }
  else  {
    DebugStr("Error: no req msg\n");  
    retn = FDDI_ERROR;
  }

  RestoreIntMask(saveMask);
  return (retn);
}

static PKT *GetReqPkt (ch_ptr)
BSI_REQCH_TYPE *ch_ptr;
{
  register word saveMask;
  register BSI_REQCH_INFO *info_ptr = ch_ptr->info_ptr;
  register BSI_REQ_MSG *msg;
  register PKT *ptr = NULL;

  MaskAllInts(saveMask);
  if (info_ptr->req_head) {
    msg = info_ptr->req_head;
    ptr = (PKT *)msg->bufp;
    if ((info_ptr->req_head = info_ptr->req_head->link) == NULL)
      info_ptr->req_tail = NULL;
#ifdef FS_PERFORM 
    put_req_msg(msg);
#endif 
/**********************************/
  if (msg->req_mark == REQ_MARK) {
    msg->link = NULL;
    msg->next = req_start;
    req_start = msg;
  }
  else
    DebugStr("Error: req msg trashed\n");
/**********************************/
  }
  else  {
    enter_debug(0x112,info_ptr->req_head,info_ptr->req_tail);
  }

  RestoreIntMask(saveMask);
  return (ptr);
}
