#include <fddi.h>
#include <krnl.h>
#include <error.h>    
#include <drv.h>
#include <bsi.h>
#include <fdrmonty.h>
#include <monp.h>
#include <dips.h>
#include <pkt.h>
#include <dbd.h>
#include <mpd.h>
#include <cspmacro.h>
#include <tcpip.h>
#include <bmac.h>
#include <nodbd.h>
#include <bmac.h>
#include <phy.h>



#ifdef __FEBRIDGE
#define	  chnl_free_dbd(p) free_dbd(p)
#endif



extern int bsi_init_flag;
extern BMAC_TYPE  bmacs[];
extern BSI_ADDR_TYPE bsi_dev[];
#ifndef __FEBRIDGE
extern int counter_1_count;
#endif
extern void (*drv_polling)();
extern BSI_TYPE bsis[];
extern void BSI_poll();
extern int free_psp_count;
extern int dbd_count;
extern  MBOX ReceiveMbox, RxSMTFrameMBox;






PKT *test_pktp;


static byte pattern;
static int total_rx_pkt;
static void RxPkt();


static int  bsino, timer, stop_ticks, start_ticks;
static byte icr;




static int bytecomp(ptr, cnt)
    byte *ptr;
    uint cnt;
    {
    uint    i;

    for ( i = 0 ; i < cnt; i++, ptr++)
        {
        if (*ptr != pattern)
            {
            printf("The pattern match failed at offset 0x%x at address 0x%x \n",
					 i+22, ptr);
			printf("pattern expected = 0x%x pattern got in received pkt = 0x%x\n",
					 pattern, *ptr);
            return (1);
            }
        }    

    return (0);

    }




 /*
 *------------------------------------------------------------------------
 *      Functions for unit test
 *------------------------------------------------------------------------
 */


/*************************************************************************
 *  Function bsi_diag
 *
 *  Description
 *    This is the entry point of testing BSIs.
 *
 *  Parameters:
 *      uint32 bsi_num
 *      uint32 act
 *
 *  Return: [OK | ERROR]
 ************************************************************************/
int bsi_diag (bsi_num,act)
uint32 bsi_num;
uint32 act;
{
  int i, smt_err=0, llc_err=0, s;
  unsigned pkt_len, pkts;
  byte bmac_mr, old_icr;
  volatile BMAC_REG_TYPE *mac_ptr = bmacs[bsi_num].reg_base;
  BSI_REG_TYPE *r_ptr = bsi_dev[bsi_num].base_addr;
  BSI_REG_TYPE *r0_ptr = bsi_dev[0].base_addr;
  BSI_REG_TYPE *r1_ptr = bsi_dev[1].base_addr;
  
  

  if (bsi_init_flag == FALSE) {
    DRV_ResetLANChips();
    DRV_InitFddiCon();
    if (BSI_Init(fddi_board.bsi_num,0) == OK) {
      printf("bsi init success\n");
    }
    else {
      printf("bsi init fail\n");
      return (FDDI_ERROR);
    }
  }
    
  switch (act) {
  case 'a':
#ifndef __FEBRIDGE
    s = crit_on();
    /* reset indicate machine */
    r0_ptr->sar |= BSI_STAR_INSTOP;
    r1_ptr->sar |= BSI_STAR_INSTOP;
    ClearRxDesc(0,bsi_dev[0].ich0,0,0);
    ClearRxDesc(0,bsi_dev[0].ich1,0,1);
    ClearRxDesc(1,bsi_dev[1].ich0,0,0);
    ClearRxDesc(1,bsi_dev[1].ich1,0,1);
    ClearRxDesc(1,bsi_dev[1].ich2,0,2);
    ClearRxDesc(0,bsi_dev[0].ich2,120,2);
    /* resume indicate machine */
    r0_ptr->sar &= ~BSI_STAR_INSTOP;
    r1_ptr->sar &= ~BSI_STAR_INSTOP;

    timer = counter_1_count;
    counter_1_count = 2 * 50;
    bsino = fddi_board.bsi_num;
    fddi_board.bsi_num = 1;
    total_rx_pkt = 0;
    icr = r_ptr->icr;
    r_ptr->icr = 0x03;
    start_ticks = RealTimeTicks();
    drv_polling = RxPkt;
    crit_off(s);
    break;
#endif
    case 'b':
#ifndef __FEBRIDGE
    s = crit_on();
    ClearRxDesc(0,bsi_dev[0].ich2,bsis[0].ich2_psp_boot,2);
    ClearRxDesc(0,bsi_dev[0].ich1,bsis[0].ich0_psp_boot,0);
    ClearRxDesc(0,bsi_dev[0].ich1,bsis[0].ich1_psp_boot,1);
    ClearRxDesc(1,bsi_dev[1].ich0,bsis[1].ich0_psp_boot,0);
    ClearRxDesc(1,bsi_dev[1].ich1,bsis[1].ich1_psp_boot,1);
    ClearRxDesc(1,bsi_dev[1].ich2,bsis[1].ich2_psp_boot,2);

    counter_1_count = timer;
    fddi_board.bsi_num = bsino;
    r_ptr->icr = icr;
    drv_polling = BSI_poll;
    stop_ticks = RealTimeTicks();
    crit_off(s);
    printf("total rx packet %d, time %d\n",total_rx_pkt,stop_ticks-start_ticks);
#endif
      break;

      case 'i':
#ifdef __FEBRIDGE
	pkts = QueryUnsigned("how many frames to send",1,0,1000);
	pkt_len = QueryUnsigned("frame len",100,30,3900);
#else
	pkts = 10000;
	pkt_len = 3000;
#endif

	i = 0;
	pattern = 0x00;

	bmac_mr = mac_ptr->mr;  
	old_icr = r_ptr->icr;
	mac_ptr->mr = BMAC_MR_RUN | BMAC_MR_ILB;
	mac_ptr->fr = BMAC_FR_MCRST | BMAC_FR_CLM;    /* force ringOp to be set */

	while (TRUE) {
	  r_ptr->icr = 0x18;
	  if (BSI_DoDiag(bsi_num,pkt_len,BSI_LLC_FRAME) != TRUE) {
	    printf("WRONG: LLC frame i: %d\n",i);
	    llc_err++;
	    break;
	  }
	  r_ptr->icr = 0xc0;
	  if (BSI_DoDiag(bsi_num,pkt_len,BSI_SMT_FRAME) != TRUE) {
	    printf("WRONG: SMT frame i: %d\n",i);
	    smt_err++;;
	    break;
	  }
	  if (pkts != 0) {
	    if (++i > pkts)
	      break;
	  }
	  else 
	    i++;
	  printf("total pkt %d\n",i);
	}
	printf("total pkt %d, smt_err %d, llc_err %d\n",i,smt_err,llc_err);

	mac_ptr->mr = bmac_mr;   /* restore registers */
	mac_ptr->fr = BMAC_FR_MCRST;
	r_ptr->icr = old_icr;   
        break;

      case 'm':
	verify_ptop(bsi_num,MANU_TEST);

	break;

      case 'n':
	verify_lmop(bsi_num);
	break;

      case 's':    /* test ptop. board need to reset after this test */
	printf("\nWarning: board needs to be reset after this test\n");
        if (test_ptop(bsi_num) == OK)
	  printf("PTOP on bsi %d success\n",bsi_num);

	break;

      case 'r':    /* run BSI */
	printf("\nWarning: board needs to be reset after this test\n");
	if (test_lmop(bsi_num) == OK)
		printf("LMOP on bsi %d success\n",bsi_num);
	break;

      case 'o':
	pattern = 0x00;
	pkt_len = QueryUnsigned("entering the pkt len",512,30,4500);
	bmac_mr = mac_ptr->mr;  
	old_icr = r_ptr->icr;
	r_ptr->icr = 0xc0;
	mac_ptr->mr = BMAC_MR_RUN | BMAC_MR_ILB;
	mac_ptr->fr = BMAC_FR_MCRST | BMAC_FR_CLM;    /* force ringOp to be set */

	if (BSI_DoDiag(bsi_num,pkt_len,BSI_SMT_FRAME) != TRUE) 
	  printf("SMT transmit test failed\n");

	mac_ptr->mr = bmac_mr;   /* restore registers */
	mac_ptr->fr = BMAC_FR_MCRST;
	r_ptr->icr = old_icr;   
	break;

      case 'e':     /* exit */
#if 1
/*	BSI_ChkDBDs();  */

	SetBeacon(0,1,bmacs[0].long_addr,0,NULL);
	BeaconRequest(0);
	i = RealTimeTicks() + 370;
	while (i > RealTimeTicks())
	  ReSchedule();
	printf("set beacon type to internal beacon to stop direct beacon\n");
	SetBeacon(0,0,bmacs[0].long_addr,0,NULL);
#endif
	break;

      case 'd':     /* printf registers */
	test_bsi_print_regs(bsi_num);
	break;

      case 't':   /* test frame */
	pattern = 0x00;
	pkt_len = QueryUnsigned("entering the pkt len",512,30,4000);

	bmac_mr = mac_ptr->mr;  
	old_icr = r_ptr->icr;
	r_ptr->icr = 0x18;
	mac_ptr->mr = BMAC_MR_RUN | BMAC_MR_ILB;
	mac_ptr->fr = BMAC_FR_MCRST | BMAC_FR_CLM;    /* force ringOp to be set */

	if (BSI_DoDiag(bsi_num,pkt_len,BSI_LLC_FRAME) != TRUE)
		printf("LLC transmit test failed\n");
	mac_ptr->mr = bmac_mr;   /* restore registers */
	mac_ptr->fr = BMAC_FR_MCRST;
	r_ptr->icr = old_icr;   
	break;
    }    /* switch */
  return OK;
}

/*************************************************************************
 *  Function    test_bsi_print_regs
 *
 *  Description
 *      This function prints all the bis registers
 *
 *  Parameter:  none
 *
 *  Return: void
 ************************************************************************/
int test_bsi_print_regs (bsi_num)
uint32 bsi_num;
{
    int i;
    BSI_REG_TYPE *r_ptr;
    BSI_DEFAULT_TABLE *tbl;
    extern BSI_DEFAULT_TABLE bsicon_default_table;
/*    uint32 mbox_addr;   */
    byte *addr;
    extern BMAC_TYPE bmacs[BMAC_MAX];
    tbl = &bsicon_default_table;
    printf("\n*****   print out all the registers in bsi %d  ********\n",bsi_num);

    r_ptr = bsi_dev[bsi_num].base_addr;
    printf("base address %lx, revision # is %lx\n",r_ptr,bsis[bsi_num].rev_num);
    if (fddi_board.type == FDDICON_MASTER)
      printf("fddi_board.type is FDDICON_MASTER\n");
    else if (fddi_board.type == FDDI_BRIDGE)
      printf("fddi_board.type is FDDI_BRIDGE\n");
    else
      printf("fddi_board.type is wrong\n");
    printf("MR0 reading is %x\n", r_ptr->mr0);
    printf("MR1 -> set to %x, reading is %x\n",tbl->mr1,r_ptr->mr1);
    printf("PCAR -> %x\n",r_ptr->pcar);
    printf("read mailbox address -> %lx\n",bsis[bsi_num].mbox_addr);
    printf("MNR reading is %x\n",r_ptr->mnr); 
    printf("STNR -> set to %x, reading is %x\n",tbl->stnr,r_ptr->stnr);
    printf("SNR -> set to %x, reading is %x\n",tbl->snr,r_ptr->snr);
    printf("NSNR -> set %x, read %x\n",tbl->nsnr,r_ptr->nsnr);
    printf("RNR ->set %x, read %x\n",tbl->rnr,r_ptr->rnr);
    printf("R0CR0 ->set %x, read %x\n",tbl->r0cr0,r_ptr->r0cr0);
    printf("R1CR0 ->set %x, read %x\n",tbl->r1cr0,r_ptr->r1cr0);
    printf("R0EFSR ->set %x, read %x\n",tbl->r0efsr,r_ptr->r0efsr);
    printf("R1EFSR ->set %x, read %x\n",tbl->r1efsr,r_ptr->r1efsr);
    printf("INR ->set %x, read %x\n",tbl->inr,r_ptr->inr);
    printf("ITR ->set %x, read %x\n",tbl->itr,r_ptr->itr);
    printf("IMR ->set %x, read %x\n",tbl->imr,r_ptr->imr);
    printf("ICR ->read %x\n",r_ptr->icr);
    printf("IHLR ->set %x, read %x\n",tbl->ihlr,r_ptr->ihlr);
    printf("ACR ->set %x, read %x\n",tbl->acr,r_ptr->acr);
    printf("R0CR1 ->set %x, read %x\n",tbl->r0cr1,r_ptr->r0cr1);
    printf("R1CR1 ->set %x, read %x\n",tbl->r1cr1,r_ptr->r1cr1);
    for (i=0; i < 6; i++,addr++)
      printf("%x.",bmacs[bsi_num].long_addr[i]);
    printf("   <--- my mac addr\n");
    return OK;
}

 /***************************************************************************
 *  Function    verify_ptop
 *
 *  Description
 *    This function test ptop function by reading from bsi and
 *    compare with the expect value. Note that the value read from the
 *    PSP Pointer RAM register should have an offset of 0x14 when 
 *    the LDI bits in the NSAR is clear. This is because when host writes
 *    2 or more PSP descriptors the BSI will read 2 descriptors.
 *
 *  Parameter:
 *      uint32 bsi_num
 *      uint32 source - MANU_TEST | AUTO_TEST
 *
 *  Return: OK | FDDI_ERROR
 **************************************************************************/
status_type verify_ptop (bsi_num,source)
uint32 bsi_num;
uint32 source;
{
  BSI_REG_TYPE *r_ptr;
  BSI_REQCH_TYPE *ch_ptr;
  BSI_REQQ_TYPE *q_ptr;
  uint32 value;
  BSI_INCH_TYPE *ich_ptr;
  BSI_INDQ_TYPE *iq_ptr;

  r_ptr = bsi_dev[bsi_num].base_addr;

  ch_ptr = bsi_dev[bsi_num].rch0;
  q_ptr = ch_ptr->reqq;
  ptop(bsi_num,ch_ptr->info_ptr->rqpr_addr,PTOP_READ,&value);
  if (source == MANU_TEST)
    printf("ch 0, q_ptr %x, reqq: %lx, read from bsi %lx\n",q_ptr,q_ptr->qp,BSI2CPU(value));
  else {
    if (q_ptr->qp != (BSI2CPU(value)))
      return FDDI_ERROR;
  }

  q_ptr = ch_ptr->cnfq;
  ptop(bsi_num,ch_ptr->info_ptr->cqpr_addr,PTOP_READ,&value);
  if (source == MANU_TEST)
    printf("ptr %x, cnfq %lx, read from bsi %lx\n",q_ptr,q_ptr->qp,BSI2CPU(value));
  else {
    if (q_ptr->qp != (BSI2CPU(value)))
      return FDDI_ERROR;
  }
 
  if (source == MANU_TEST) {
    q_ptr = ch_ptr->odudq;
    printf("ptr %x, odudq base: %lx, head %lx,  next %lx, end %lx\n",q_ptr,q_ptr->base,q_ptr->ql,q_ptr->next_slot,q_ptr->qp);
  }

  ch_ptr = bsi_dev[bsi_num].rch1;
  q_ptr = ch_ptr->reqq;
  ptop(bsi_num,ch_ptr->info_ptr->rqpr_addr,PTOP_READ,&value);
  if (source == MANU_TEST) 
    printf("ch 1, reqq: %lx, read from bsi %lx\n",q_ptr->qp,BSI2CPU(value));
  else {
    if (q_ptr->qp != (BSI2CPU(value)))
      return FDDI_ERROR;
  }

  q_ptr = ch_ptr->cnfq;
  ptop(bsi_num,ch_ptr->info_ptr->cqpr_addr,PTOP_READ,&value);
  if (source == MANU_TEST)
    printf("cnfq %lx, read from bsi %lx\n",q_ptr->qp,BSI2CPU(value));
  else {
    if (q_ptr->qp != (BSI2CPU(value)))
      return FDDI_ERROR;
  }

  if (source == MANU_TEST) {
    q_ptr = ch_ptr->odudq;
    printf("odudq base: %lx, head %lx,  next %lx, end %lx\n",q_ptr->base,q_ptr->ql,q_ptr->next_slot,q_ptr->qp);
  }

  /* verify the indicate channels */
  ich_ptr = bsi_dev[bsi_num].ich0;
  iq_ptr = ich_ptr->idudq;
  ptop(bsi_num,ich_ptr->iqpi_addr,PTOP_READ,&value);
  if (source == MANU_TEST)
    printf(" ptr %x, ind ch 0: idudq %lx, read from bsi %lx\n",iq_ptr,iq_ptr->qp,BSI2CPU(value));
  else {
    if (iq_ptr->qp != (BSI2CPU(value)))
      return FDDI_ERROR;
  }
  
  if (source == MANU_TEST) {
    iq_ptr = ich_ptr->pspq;
    ReadPspDesc(bsi_num,iq_ptr,ich_ptr);
  }

  ich_ptr = bsi_dev[bsi_num].ich1;
  iq_ptr = ich_ptr->idudq;
  ptop(bsi_num,ich_ptr->iqpi_addr,PTOP_READ,&value);
  if (source == MANU_TEST) 
    printf("ptr %x, ind ch 1: idudq %lx, read from bsi %lx\n",iq_ptr,iq_ptr->qp,BSI2CPU(value));
  else {
    if (iq_ptr->qp != (BSI2CPU(value)))
      return FDDI_ERROR;
  }

  if (source == MANU_TEST) {
    iq_ptr = ich_ptr->pspq;
    ReadPspDesc(bsi_num,iq_ptr,ich_ptr);
  }

  ich_ptr = bsi_dev[bsi_num].ich2;
  iq_ptr = ich_ptr->idudq;
  ptop(bsi_num,ich_ptr->iqpi_addr,PTOP_READ,&value);
  if (source == MANU_TEST) 
    printf("ptr %x, ind ch 2: idudq %lx, read from bsi %lx\n",iq_ptr,iq_ptr->qp,BSI2CPU(value));
  else {
    if (iq_ptr->qp != (BSI2CPU(value)))
      return FDDI_ERROR;
  }

  if (source == MANU_TEST) {
    iq_ptr = ich_ptr->pspq;
    ReadPspDesc(bsi_num,iq_ptr,ich_ptr);
  }
  
  return (OK);
}

/***************************************************************************
 *  Function    verify_lmop
 *
 *  Description
 *    This function test lmop functions by reading from bsi and
 *    compare with the expect value.
 *
 *  Parameter:
 *      uint32 bsi_num
 *
 *  Return: void
 **************************************************************************/
void verify_lmop (bsi_num)
uint32 bsi_num;
{
  BSI_REG_TYPE *r_ptr;
  BSI_REQCH_TYPE *ch_ptr;
  BSI_REQQ_TYPE *q_ptr;
  uint32 value, ch2_val;
  BSI_INCH_TYPE *ich_ptr;
  BSI_INDQ_TYPE *iq_ptr;

  r_ptr = bsi_dev[bsi_num].base_addr;
  printf("bsi %d,  mailbox %lx\n",bsi_num,bsis[bsi_num].mbox_addr);

  ch_ptr = bsi_dev[bsi_num].rch0;
  q_ptr = ch_ptr->reqq;
  lmop(bsi_num,ch_ptr->info_ptr->rqlr_addr,LMOP_READ,&value);
  value |= (ch_ptr->reqq->base & LMOP_ADDR_MASK);
  printf("ch 0, reqq: %lx, read from bsi %lx, base %lx\n",q_ptr->next_slot,value,ch_ptr->reqq->ql);

  q_ptr = ch_ptr->cnfq;
  lmop(bsi_num,ch_ptr->info_ptr->cqlr_addr,LMOP_READ,&value);
  value |= (ch_ptr->cnfq->base & LMOP_ADDR_MASK);
  printf("cnfq %lx, read from bsi %lx\n",q_ptr->ql,value);

  ch_ptr = bsi_dev[bsi_num].rch1;
  q_ptr = ch_ptr->reqq;
  lmop(bsi_num,ch_ptr->info_ptr->rqlr_addr,LMOP_READ,&value);
  value |= (ch_ptr->reqq->base & LMOP_ADDR_MASK);
  printf("ch 1, reqq: %lx, read from bsi %lx\n",q_ptr->next_slot,value);

  q_ptr = ch_ptr->cnfq;
  lmop(bsi_num,ch_ptr->info_ptr->cqlr_addr,LMOP_READ,&value);
  value |= (ch_ptr->cnfq->base & LMOP_ADDR_MASK);
  printf("cnfq %lx, read from bsi %lx\n",q_ptr->ql,value);

  q_ptr = ch_ptr->odudq;
  printf("odudq %lx\n\nindicate channel:\n",q_ptr->base);

  /* verify the indicate channels */
  ich_ptr = bsi_dev[bsi_num].ich0;
  iq_ptr = ich_ptr->idudq;
  lmop(bsi_num,ich_ptr->iqli_addr,LMOP_READ,&value);
  value |= (ich_ptr->idudq->base & LMOP_ADDR_MASK);
  printf("ind ch 0: idudq %lx, read from bsi %lx\n",iq_ptr->ql,value);
  printf("idud base %lx, # idud %d\n",iq_ptr->base,(iq_ptr->ql-iq_ptr->base) / 8);

  iq_ptr = ich_ptr->pspq;
  ReadPspDesc(bsi_num,iq_ptr,ich_ptr);
#if 0
  lmop(bsi_num,ich_ptr->pqli_addr,LMOP_READ,&value);
  value |= (ich_ptr->pspq->base & LMOP_ADDR_MASK);
  printf("ind ch 0, pspq %lx, read from bsi %lx\n",iq_ptr->ql,value);
#endif
  printf("base %lx, # of psp %d\n",iq_ptr->base,(iq_ptr->ql-iq_ptr->base)/8);

  ich_ptr = bsi_dev[bsi_num].ich1;
  iq_ptr = ich_ptr->idudq;
  lmop(bsi_num,ich_ptr->iqli_addr,LMOP_READ,&value);
  value |= (ich_ptr->idudq->base & LMOP_ADDR_MASK);
  printf("ind ch 1: idudq %lx, read from bsi %lx\n",iq_ptr->ql,value);
  printf("idud base %lx, # idud %d\n",iq_ptr->base,(iq_ptr->ql-iq_ptr->base) / 8);

  iq_ptr = ich_ptr->pspq;
  lmop(bsi_num,ich_ptr->pqli_addr,LMOP_READ,&value);
  value |= (ich_ptr->pspq->base & LMOP_ADDR_MASK);
  printf("ind ch 1, pspq %lx, read from bsi %lx\n",iq_ptr->ql,value);
  printf("base %lx, # of psp %d\n",iq_ptr->base,(iq_ptr->ql-iq_ptr->base)/8);

  ich_ptr = bsi_dev[bsi_num].ich2;
  iq_ptr = ich_ptr->idudq;
  lmop(bsi_num,ich_ptr->iqli_addr,LMOP_READ,&value);
  value |= (ich_ptr->idudq->base & LMOP_ADDR_MASK);
  printf("ind ch 2: idudq %lx, read from bsi %lx\n",iq_ptr->ql,value);
  printf("idud base %lx, # idud %d\n",iq_ptr->base,(iq_ptr->ql-iq_ptr->base) / 8);

  iq_ptr = ich_ptr->pspq;
  lmop(bsi_num,ich_ptr->pqli_addr,LMOP_READ,&value);
  ch2_val = value | (ich_ptr->pspq->base & LMOP_ADDR_MASK);
  printf("ind ch 2, next %lx, base %lx, read from bsi %lx, %lx\n",iq_ptr->ql,iq_ptr->base,value,ch2_val);
  printf("base %lx, # of psp %d\n",iq_ptr->base,(iq_ptr->ql-iq_ptr->base)/8);
}


 /***************************************************************************
 *  Function    test_ptop
 *
 *  Description
 *    This function test ptop function by reading from bsi and
 *    compare with the expect value. Note that the value read from the
 *    PSP Pointer RAM register should have an offset of 0x14 when 
 *    the LDI bits in the NSAR is clear. This is because when host writes
 *    2 or more PSP descriptors the BSI will read 2 descriptors.
 *
 *  Parameter:
 *      uint32 bsi_num
 *      uint32 source - MANU_TEST | AUTO_TEST
 *
 *  Return: OK | FDDI_ERROR
 **************************************************************************/
status_type test_ptop (bsi_num)
uint32 bsi_num;
{
  BSI_REG_TYPE *r_ptr;
  BSI_REQCH_TYPE *ch_ptr;
  uint32 value, i, j, k, *mbox;
  BSI_INCH_TYPE *ich_ptr;
/*  BSI_INDQ_TYPE *iq_ptr;  */

  r_ptr = bsi_dev[bsi_num].base_addr;
  mbox = (uint32 *)bsis[bsi_num].mbox_addr;
  r_ptr->mr0 = 0x40;   /*  1K queue descriptor */
  r_ptr->pcar = 0;
  r_ptr->mnr = 0;
  for (i=j=k=0; i < 0x400000; i += 0x1000, j = i) {
	strobe_wdt();
    ch_ptr = bsi_dev[bsi_num].rch0;
    ptop(bsi_num,ch_ptr->info_ptr->rqpr_addr,PTOP_WRITE,&j);
    *mbox = 0L;
    ptop(bsi_num,ch_ptr->info_ptr->rqpr_addr,PTOP_READ,&value);
    if (value != j ) {
      printf("\nBSI %d PTOP ERROR: ch 0 reqq write %x, read %x\n",bsi_num,j,value);
      return FDDI_ERROR;
    }

    j = i;
    ptop(bsi_num,ch_ptr->info_ptr->cqpr_addr,PTOP_WRITE,&j);
    *mbox = 0L;
    ptop(bsi_num,ch_ptr->info_ptr->cqpr_addr,PTOP_READ,&value);
    if (value != j ) {
      printf("\nBSI %d PTOP ERROR: ch 0 cnf write %x, read %x\n",bsi_num,j,value);
      return FDDI_ERROR;
    }

    ch_ptr = bsi_dev[bsi_num].rch1;
    j = i;
    ptop(bsi_num,ch_ptr->info_ptr->rqpr_addr,PTOP_WRITE,&j);
    *mbox = 0L;
    ptop(bsi_num,ch_ptr->info_ptr->rqpr_addr,PTOP_READ,&value);
    if (value != j ) {
      printf("\nBSI %d PTOP ERROR: ch 1 req write %x, read %x\n",bsi_num,j,value);
      return FDDI_ERROR;
    }

    j = i;
    ptop(bsi_num,ch_ptr->info_ptr->cqpr_addr,PTOP_WRITE,&j);
    *mbox = 0L;
    ptop(bsi_num,ch_ptr->info_ptr->cqpr_addr,PTOP_READ,&value);
    if (value != j ) {
      printf("\nBSI %d PTOP ERROR: ch 1 cnf write %x, read %x\n",bsi_num,j,value);
      return FDDI_ERROR;
    }


    /* verify the indicate channels */
    ich_ptr = bsi_dev[bsi_num].ich0;

    j = i;
    ptop(bsi_num,ich_ptr->iqpi_addr,PTOP_WRITE,&j);
    *mbox = 0L;
    ptop(bsi_num,ich_ptr->iqpi_addr,PTOP_READ,&value);
    if (value != j ) {
      printf("\nBSI %d PTOP ERROR: ch 0 idud write %x, read %x\n",bsi_num,j,value);
      return FDDI_ERROR;
    }

    j = i;
    ptop(bsi_num,ich_ptr->pqpi_addr,PTOP_WRITE,&j);
    *mbox = 0L;
    ptop(bsi_num,ich_ptr->pqpi_addr,PTOP_READ,&value);
    if (value != j + 4) {   
      printf("\nBSI %d PTOP ERROR: ch 0 psp write %x, read %x\n",bsi_num,j,value);
      return FDDI_ERROR;
    }

    ich_ptr = bsi_dev[bsi_num].ich2;

    j = i;
    ptop(bsi_num,ich_ptr->iqpi_addr,PTOP_WRITE,&j);
    *mbox = 0L;
    ptop(bsi_num,ich_ptr->iqpi_addr,PTOP_READ,&value);
    if (value != j ) {
      printf("\nBSI %d PTOP ERROR: ch 2 idud write %x, read %x\n",bsi_num,j,value);
      return FDDI_ERROR;
    }

    j = i;
    ptop(bsi_num,ich_ptr->pqpi_addr,PTOP_WRITE,&j);
    *mbox = 0L;
    ptop(bsi_num,ich_ptr->pqpi_addr,PTOP_READ,&value);
    if (value != j  + 4  ) {
      printf("\nBSI %d PTOP ERROR: ch 0 psp write %x, read %x\n",bsi_num,j,value);
      return FDDI_ERROR;
    }

    ich_ptr = bsi_dev[bsi_num].ich1;

    j = i;
    ptop(bsi_num,ich_ptr->iqpi_addr,PTOP_WRITE,&j);
    *mbox = 0L;
    ptop(bsi_num,ich_ptr->iqpi_addr,PTOP_READ,&value);
    if (value != j ) {
      printf("\nBSI %d PTOP ERROR: ch 1 idud write %x, read %x\n",bsi_num,j,value);
      return FDDI_ERROR;
    }

    j = i;
    ptop(bsi_num,ich_ptr->pqpi_addr,PTOP_WRITE,&j);
    *mbox = 0L;
    ptop(bsi_num,ich_ptr->pqpi_addr,PTOP_READ,&value);
    if (value != j  + 4  ) {
      printf("\nBSI %d PTOP ERROR: ch 1 psp write %x, read %x\n",bsi_num,j,value);
      return FDDI_ERROR;
    }
  }
  return (OK);

}




status_type test_lmop (bsi_num)
uint32 bsi_num;
{
  BSI_REG_TYPE *r_ptr;
  BSI_REQCH_TYPE *ch_ptr;
  uint32 value,  i, j, k;
  BSI_INCH_TYPE *ich_ptr;

  r_ptr = bsi_dev[bsi_num].base_addr;
  r_ptr->mr0 = 0x40;
  r_ptr->pcar = 0;
  r_ptr->mnr = 0;
  for (i=j=k=0; i < 0x0fff; i+= 0x08, j=i) {
	strobe_wdt();
    ch_ptr = bsi_dev[bsi_num].rch0;

    lmop(bsi_num,ch_ptr->info_ptr->rqlr_addr,LMOP_WRITE,&j);
    r_ptr->ldr = 0x7f;
    lmop(bsi_num,ch_ptr->info_ptr->rqlr_addr,LMOP_READ,&value);
    if ( j != value) {
      printf("\nLMOP ERROR: reqq write %x, read %x at bsi %d ch 0\n",j,value,bsi_num);
      return FDDI_ERROR;
    }
      
    j = i;
    lmop(bsi_num,ch_ptr->info_ptr->cqlr_addr,LMOP_WRITE,&j);
    r_ptr->ldr = 0x7f;
    lmop(bsi_num,ch_ptr->info_ptr->cqlr_addr,LMOP_READ,&value);
    if ( j != value) {
      printf("\nLMOP ERROR: cnfq write %x, read %x at bsi %d ch 0\n",j,value,bsi_num);
      return FDDI_ERROR;
    }
    ch_ptr = bsi_dev[bsi_num].rch1;

    lmop(bsi_num,ch_ptr->info_ptr->rqlr_addr,LMOP_WRITE,&j);
    r_ptr->ldr = 0x7f;
    lmop(bsi_num,ch_ptr->info_ptr->rqlr_addr,LMOP_READ,&value);
    if ( j != value) {
      printf("\nLMOP ERROR: req write %x, read %x at bsi %d ch 1\n",j,value,bsi_num);
      return FDDI_ERROR;
    }
      
    j = i;
    lmop(bsi_num,ch_ptr->info_ptr->cqlr_addr,LMOP_WRITE,&j);
    r_ptr->ldr = 0x7f;
    lmop(bsi_num,ch_ptr->info_ptr->cqlr_addr,LMOP_READ,&value);
    if ( j != value) {
      printf("\nLMOP ERROR: cnf write %x, read %x at bsi %d ch 1\n",j,value,bsi_num);
      return FDDI_ERROR;
    }


    /* verify the indicate channels */
    ich_ptr = bsi_dev[bsi_num].ich0;
    lmop(bsi_num,ich_ptr->iqli_addr,LMOP_WRITE,&j);
    r_ptr->ldr = 0x7f;
    lmop(bsi_num,ich_ptr->iqli_addr,LMOP_READ,&value);
    if ( j != value) {
      printf("\nLMOP ERROR: write %x, read %x at bsi %d ch 0 idud\n",j,value,bsi_num);
      return FDDI_ERROR;
    }  

    j = i;
    lmop(bsi_num,ich_ptr->pqli_addr,LMOP_WRITE,&j);
    r_ptr->ldr = 0x7f;
    lmop(bsi_num,ich_ptr->pqli_addr,LMOP_READ,&value);
    if ( j != value) {
      printf("\nLMOP ERROR: write %x, read %x at bsi %d ch 0 psp\n",j,value,bsi_num);
      return FDDI_ERROR;
    }  

    ich_ptr = bsi_dev[bsi_num].ich1;
    lmop(bsi_num,ich_ptr->iqli_addr,LMOP_WRITE,&j);
    r_ptr->ldr = 0x7f;
    lmop(bsi_num,ich_ptr->iqli_addr,LMOP_READ,&value);
    if ( j != value) {
      printf("\nLMOP ERROR: write %x, read %x at bsi %d ch 1 idud\n",j,value,bsi_num);
      return FDDI_ERROR;
    }  

    j = i;
    lmop(bsi_num,ich_ptr->pqli_addr,LMOP_WRITE,&j);
    r_ptr->ldr = 0x7f;
    lmop(bsi_num,ich_ptr->pqli_addr,LMOP_READ,&value);
    if ( j != value) {
      printf("\nLMOP ERROR: write %x, read %x at bsi %d ch 1 psp\n",j,value,bsi_num);
      return FDDI_ERROR;
    }  

    ich_ptr = bsi_dev[bsi_num].ich2;
    lmop(bsi_num,ich_ptr->iqli_addr,LMOP_WRITE,&j);
    r_ptr->ldr = 0x7f;
    lmop(bsi_num,ich_ptr->iqli_addr,LMOP_READ,&value);
    if ( j != value) {
      printf("\nLMOP ERROR: write %x, read %x at bsi %d ch 2 idud\n",j,value,bsi_num);
      return FDDI_ERROR;
    }  

    j = i;
    lmop(bsi_num,ich_ptr->pqli_addr,LMOP_WRITE,&j);
    r_ptr->ldr = 0x7f;
    lmop(bsi_num,ich_ptr->pqli_addr,LMOP_READ,&value);
    if ( j != value) {
      printf("\nLMOP ERROR: write %x, read %x at bsi %d ch 2 psp\n",j,value,bsi_num);
      return FDDI_ERROR;
    }  
  }
  return OK;
}


bool BSI_LoopTest (bsi_num) 
uint bsi_num;
{
  uint	pkt, pktlen, result = TRUE, loop_cnt = 0;
  volatile BMAC_REG_TYPE *mac_ptr = bmacs[bsi_num].reg_base;
  BSI_REG_TYPE *r_ptr = bsi_dev[bsi_num].base_addr;
  byte bmac_mr, old_icr;

  pktlen = 3000;
  DebugStr("Start BSI self loop test\n");
  disable_wdt();

  bmac_mr = mac_ptr->mr;    /* set bmac to run mode */
  old_icr = r_ptr->icr;
  r_ptr->icr = 0x18;
  mac_ptr->mr = BMAC_MR_RUN | BMAC_MR_ILB;
  mac_ptr->fr = BMAC_FR_MCRST | BMAC_FR_CLM;    /* force ringOp to be set */
  for (pkt = 0; pkt < 2000; pkt++) {
    if (BSI_DoDiag(bsi_num, pktlen ,BSI_LLC_FRAME) != TRUE)   {
      result = FALSE;
      break;
    }
    if (loop_cnt++ > 100) {
      DebugStr(".");
      loop_cnt = 0;
    }
  }
  if (result) {
    if (get_debug())
      printf("\nBSI %d loop test passed\n",bsi_num);
  }
  else   {
    printf("\nBSI %d loop test failed, loop %d\n",bsi_num,pkt);
  }

  mac_ptr->mr = bmac_mr;   /* restore registers */
  mac_ptr->fr = BMAC_FR_MCRST;
  r_ptr->icr = old_icr;   
  ClearTxDesc(bsi_num,bsi_dev[bsi_num].rch0);
  enable_wdt();

  return (result);
} 





/*****************************************************************************
 *  Function PollRxPkt
 *
 *  Description
 *    This function read rx pkts from the ch 2 and free the dbd immediately
 *
 *  Parameter: bsi_num - should always 0
 *
 *  Return: void
 ****************************************************************************/
static void PollRxPkt (bsi_num)
int bsi_num;
{
#ifndef __FEBRIDGE
  BSI_INCH_TYPE *ch_ptr = bsi_dev[bsi_num].ich2;
  BSI_INDQ_TYPE *q_ptr;
  BSI_INDQ_TYPE *psp_q;
  IDUD_DESCR_TYPE *d_ptr;
  DBD *dbd_ptr, *first_dbd = NULL;
  uint32 fl, addr, *wp, pkt_num = 0;
  byte fc;   /* field control field */

#if 0
  q_ptr = ch_ptr->idudq;
  psp_q = ch_ptr->pspq;
  while (pkt_num++ < 20) {
    d_ptr = (IDUD_DESCR_TYPE *)q_ptr->qp;
    if ((d_ptr->loc & IDUD_ADDR_MASK) == 0L) { 
      if (first_dbd != NULL) {  /* we've received a fragment pkt, discard it */
	if (first_dbd->db_contrl != 0)
	  chnl_free_dbd(first_dbd);
      }
      return;
    }
    MEM_SetChPsp(bsi_num,1,ch_ptr,BSI_INDCH2,FALSE);
    BSI_WriteIDUD(bsi_num,ch_ptr,FALSE);

    /* restore the DBD pointer. */
    fl = d_ptr->loc & BSI_ADDRFL_MASK;
    addr = (uint32) BSI2CPU(d_ptr->loc & BSI_ADDR28);

    wp = (uint32 *) (addr & BSI_DBD_ADDR_MASK);
    dbd_ptr = (DBD *)*wp;
    if (dbd_ptr->db_idmark != DBD_MARK) {
      NULLIFY_DESC(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      continue;
    }

    /* undocument bsi bug:
       if the cnt field is 0, the loc points to the previous psp */
    if (d_ptr->cnt == 0) {
      NULLIFY_DESC(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
      break;
    }

    if (dbd_ptr->db_contrl == 0) {
      dbd_ptr = NULL;
      NULLIFY_DESC(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      continue;
    }

    /* check the rx frame status. don't pass it up if error occured */
    if (fl & BSI_LAST) {
      if (BSI_ChkIdudStatus(d_ptr,BSI_LLC_FRAME) != OK) {
	chnl_free_dbd(dbd_ptr);
	if (first_dbd != NULL && first_dbd->db_contrl != 0)
	  chnl_free_dbd(first_dbd);
	NULLIFY_DESC(d_ptr);
	NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
	NEXT_QSLOT_ADDR(psp_q->qp);
	continue;
      }
    }

    /* the rcv frame is good, process it */
    if (fl == BSI_ONLY) {
      dbd_ptr->nb_prot = (byte *)(addr );  /* point to LLC header */
      first_dbd = NULL;
      dbd_ptr->db_actcnt = d_ptr->cnt - FDDI_FCS_BYTES;
      dbd_ptr->nb_destination = dbd_ptr->db_buffer + FDDI_DA_OFFSET;
      dbd_ptr->nb_source = dbd_ptr->db_buffer + FDDI_SA_OFFSET;
      dbd_ptr->nb_len = dbd_ptr->db_actcnt - FDDI_HEADER_LEN;
      dbd_ptr->nb_tstamp = RealTimeTicks();
      dbd_ptr->db_rcvportno = bsi_num;
      dbd_ptr->db_nxtdbd = NULL;
    }
    else if (fl == BSI_FIRST) {
#if 0
      printf("\nBSI_FIRST at bsi %d\n",bsi_num);
#endif
      dbd_ptr->nb_prot = (byte *)(addr );  /* point to LLC header */
      dbd_ptr->db_actcnt = d_ptr->cnt;
      dbd_ptr->nb_destination = dbd_ptr->db_buffer + FDDI_DA_OFFSET;
      dbd_ptr->nb_source = dbd_ptr->db_buffer + FDDI_SA_OFFSET;
      dbd_ptr->nb_len = dbd_ptr->db_actcnt - FDDI_HEADER_LEN;
      dbd_ptr->nb_tstamp = RealTimeTicks();
      dbd_ptr->db_rcvportno = bsi_num;
      dbd_ptr->db_nxtdbd = NULL;
      first_dbd = dbd_ptr;
      NULLIFY_DESC(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      continue;  /* continue until all the fragment pkt are done */
    }
    else {  /* BSI_MIDDLE or BSI_LAST */
      if (first_dbd == NULL) {  /* fragment pkt was processed last time */
	chnl_free_dbd(dbd_ptr);
        NULLIFY_DESC(d_ptr);
        NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
        NEXT_QSLOT_ADDR(psp_q->qp);
        continue;
      }
      if (fl == BSI_MIDDLE)  {
#if 0
	printf("BSI_MIDDLE\n");
#endif
	first_dbd->db_actcnt += d_ptr->cnt;
	chnl_free_dbd(dbd_ptr);
	NULLIFY_DESC(d_ptr);
	NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
	NULLIFY_DESC2ND(psp_q->qp);
	psp_q->psp_count--;
#endif
	NEXT_QSLOT_ADDR(psp_q->qp);
	continue;  /* continue until all the fragment pkt are done */
      }
      else        /* must be BSI_LAST */ {
#if 0
	printf("BSI_LAST\n");
#endif
	first_dbd->db_actcnt += d_ptr->cnt - FDDI_FCS_BYTES;
      }
      
      chnl_free_dbd(dbd_ptr);
    }

    if (first_dbd != NULL) {
      dbd_ptr = first_dbd;
      first_dbd = NULL;
    }
    total_rx_pkt++;
    chnl_free_dbd(dbd_ptr);
    NULLIFY_DESC(d_ptr);
    NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
    NULLIFY_DESC2ND(psp_q->qp);
    psp_q->psp_count--;
#endif
    NEXT_QSLOT_ADDR(psp_q->qp);
    continue;  
  }       /* while */
#endif

#endif
}



/*************************************************************************
 *  Function RxPkt
 *
 *  Description
 *    This function is used to test the max packets we can receive from
 *    chnl 2. The rx pkt will be thrown away
 *
 *  Parameter: bsi_num
 *
 *  Return: void
 *************************************************************************/
static void RxPkt (bsi_num)
uint32 bsi_num;
{
  volatile BSI_REG_TYPE *r_ptr;

  PollRxPkt(bsi_num);
  r_ptr = bsi_dev[bsi_num].base_addr;
  NoSpaceAtten(bsi_num,r_ptr);
}



int ReadPspDesc (bsi_num,q_ptr,ch_ptr)
uint32 bsi_num;
BSI_INDQ_TYPE *q_ptr;
BSI_INCH_TYPE *ch_ptr;
{
  uint32 qp, ql;
  int num;

  ptop(bsi_num,ch_ptr->pqpi_addr,PTOP_READ,&qp);
  qp = BSI2CPU(qp);
  printf("PSP qp-> %lx, bsi reg %lx\n",q_ptr->qp,qp);

  lmop(bsi_num,ch_ptr->pqli_addr,LMOP_READ,&ql);
  ql |= (ch_ptr->pspq->base & LMOP_ADDR_MASK);
  printf("ql-> pspq %lx, bsi reg %lx, # psp ",q_ptr->ql,ql);
  
  if (BSI_Qfull(qp,ql))
      printf("\n       PSP is full\n");
  if (q_ptr->qp > q_ptr->ql) {
    num = (128 - (q_ptr->qp - q_ptr->ql) / 8);
  }
  else if (q_ptr->qp < q_ptr->ql) 
    num =  (q_ptr->ql - q_ptr->qp)/8;
  else
    num = 0;
  printf("%d, lmop_count %d, psp_count %d\n",num,q_ptr->lmop_count,q_ptr->psp_count);

  return (num);
}

void ReadIdudDesc (bsi_num,q_ptr,ich_ptr)
uint32 bsi_num;
BSI_INDQ_TYPE *q_ptr;
BSI_INCH_TYPE *ich_ptr;
{
  uint32 qp, ql;


  ptop(bsi_num,ich_ptr->iqpi_addr,PTOP_READ,&qp);
  qp = BSI2CPU(qp);
  printf(" idud qp %lx, read from bsi %lx\n",q_ptr->qp,BSI2CPU(qp));
  lmop(bsi_num,ich_ptr->iqli_addr,LMOP_READ,&ql);
  ql |= (ich_ptr->idudq->base & LMOP_ADDR_MASK);
  printf("idud ql %lx, read from bsi %lx\n",q_ptr->ql,ql);

}



int BSI_DebugGetBSIMode (bsi_num)
uint32 bsi_num;
{
  if ((!bsis[bsi_num].chip_test) || ((bsis[bsi_num].bsi_status & REQ_STOP) != 0)) {
    printf("\nbsi %d not in ready state\n",bsi_num);
    if (!bsis[bsi_num].chip_test)
      printf("self test failed\n");
    if (bsis[bsi_num].bsi_status & REQ_STOP)
      printf("request machine stopped, %x\n",bsis[bsi_num].bsi_status);
    return DRV_STOP;
  }

  printf("\nbsi %d is ready\n",bsi_num);
  return DRV_START;
}



/**************************************************************************
 *  Function    BSI_DoDiag
 *
 *  Description
 *      This function does the diagnostics by sending a LLC frame out
 *      verify the receiving frame. This function assumes that all the path
 *      are already isolated.
 *
 *  Parameter:
 *      uint32 bsi_num
 *      uint32 wait_time - # of msec * 10
 *      uint32 frame_type BSI_SMT_FRAME | BSI_LLC_FRAME
 *      uint32 icr_val - BSI_ICR value
 *
 *  Return [TRUE | FALSE]
 *************************************************************************/
bool BSI_DoDiag (bsi_num,frame_len,frame_type) 
uint32 bsi_num;
uint32 frame_len;
uint32 frame_type;
{
#ifdef __FEBRIDGE
  uint32 ticks,result=FALSE, rx_pkt = FALSE;
  BSI_REQCH_TYPE *ch_ptr = bsi_dev[bsi_num].rch0;
  PKT *txpkt;
  volatile BSI_REG_TYPE *r_ptr;

	/* turn off void stripping */
  r_ptr = bsi_dev[bsi_num].base_addr;
  r_ptr->r0cr0 = r_ptr->r0cr0 & ~BSI_RxCR0_VST;
  r_ptr->r1cr0 = r_ptr->r1cr0 & ~BSI_RxCR0_VST;

  if (frame_type == BSI_SMT_FRAME) {
    if (frame_len >= 4096-23)
      frame_len = 4096-24;
  }
  txpkt = (PKT*)InitTestFrame(bsi_num, frame_len,frame_type);
  if (txpkt == NULL) {
	printf("Error: can't get PKT for self test frame\n");
    return (FALSE);
  }

  bsis[bsi_num].self_test = TRUE;
  BSI_SendReq(DRV_REQ_RQCLS_ASYN,bsi_num,ch_ptr,txpkt,FALSE);

  ticks = RealTimeTicks() + 100;
  while (RealTimeTicks() < ticks) {
	RxLLCFrameIsr(bsi_num);			/* poll ind. ch 1 for rcvd frames */
    if (bsis[bsi_num].self_test == FALSE) {
      rx_pkt = TRUE;		/* indicate frame rcvd */
	  /* chk rcvd frame */
      result = bytecomp(test_pktp->pktDataPtr+20, test_pktp->pktDataSize-21);
      test_pktp->pktFree(test_pktp);
      txpkt->pktFree(txpkt);
      if (result != 0)
		result = FALSE;
      else
		result = TRUE;
	break;
    }
    ReSchedule(); 
  }

#else
  BSI_REG_TYPE *r_ptr;
  DBD *tx_dbd, *test_dbdp;    /* receive frame */
  uint32 ticks,result=FALSE, rx_pkt = FALSE;
  BSI_REQCH_TYPE *ch_ptr = bsi_dev[bsi_num].rch0;
  PKT *txpkt, *rcvpkt;

  if ((test_dbdp = get_dbd()) == NULL) {
    printf("no dbd to receive loop back frame\n");
    return FALSE;
  }
  if (frame_type == BSI_SMT_FRAME) {
    if (frame_len >= 4096-23)
      frame_len = 4096-24;
  }
  tx_dbd = InitTestFrame(bsi_num, frame_len,frame_type);
  if (tx_dbd == NULL) {
	printf("Error: can't get dbd for self test frame\n");
    return (FALSE);
  }
  pktp = MEM_GetPkt();
  memcpy(pktp->pktBufPtr,tx_dbd->db_buffer,tx_dbd->db_indent+tx_dbd->db_actcnt);
  pktp->pktDataSize = tx_dbd->db_actcnt;
  pktp->pktDataPtr = pktp->pktBufPtr + tx_dbd->db_indent;
/*  pktp->pktUseCount += 1;    */
  r_ptr = bsi_dev[bsi_num].base_addr;

  bsis[bsi_num].self_test = TRUE;
  BSI_SendReq(DRV_REQ_RQCLS_ASYN,bsi_num,ch_ptr,pktp,FALSE);
/*  FreePktBuf(pktp);   */

  ticks = RealTimeTicks() + 100;
  while (RealTimeTicks() < ticks) {
    if (bsis[bsi_num].self_test == FALSE) {
      /* set rx_pkt to TRUE */
      rx_pkt = TRUE;

      test_dbdp->nb_prot = test_dbdp->db_buffer + 3;
      test_dbdp->db_actcnt = test_pktp->pktDataSize+1;
      memcpy(test_dbdp->nb_prot,test_pktp->pktDataPtr-1,test_dbdp->db_actcnt);

      test_pktp->pktFree(test_pktp);
      if (bytecomp(test_dbdp->nb_prot+21, tx_dbd->db_actcnt-21) != 0) {
#if 0
	{
	  int i;
	  byte *txp, *rxp;

	  printf("==== rx frame is different from tx frame\n");
	  printf("tx pkt_len %d, rx pkt_len %d\n",tx_dbd->db_actcnt,test_dbdp->db_actcnt);
	  txp = tx_dbd->db_buffer+tx_dbd->db_indent + 21;
	  rxp = test_dbdp->nb_prot + 21;
	  for (i=0; i < tx_dbd->db_actcnt-21; i++,txp++, rxp++) {
	    if (*txp != *rxp) {
	      printf("offset %d->  expect %x, got %x\n",i,*txp,*rxp);
	      break;
	    }
	  }
	}
#endif
	chnl_free_dbd(test_dbdp);
	chnl_free_dbd(tx_dbd);
	result = FALSE;
	break;
      }
      else {
	/* printf(".... receive OK\n"); */
	chnl_free_dbd(test_dbdp);
	chnl_free_dbd(tx_dbd);
	result = TRUE;
	break;
      }
    }
    ReSchedule(); 
  }
#endif
  if (!rx_pkt) {
    bsis[bsi_num].self_test = FALSE;
    result = FALSE;
  }
#if 0
  ClearTxDesc(bsi_num,bsi_dev[bsi_num].rch0);
#endif

  return (result);
}

/***********************************************************************
 *  Function     BSI_ReadCNFDesc
 *
 *  Description
 *    This function reads the cnf description qp and ql. It is used 
 *    mainly for debugging.
 *
 *  Parameter:
 *
 *  Return:
 ***********************************************************************/
status_type BSI_ReadCNFDesc (bsi_num,ch_ptr,q_ptr)
uint32 bsi_num;
BSI_REQCH_TYPE *ch_ptr;
BSI_REQQ_TYPE *q_ptr;
{
  uint32 qp, ql;

  lmop(bsi_num,ch_ptr->info_ptr->cqlr_addr,LMOP_READ,&ql);
  ql |= (ch_ptr->cnfq->base & LMOP_ADDR_MASK);
  ptop(bsi_num,ch_ptr->info_ptr->cqpr_addr,PTOP_READ,&qp);
  qp = BSI2CPU(qp);

  printf("BSIReadCNFDesc(), bsi %d: h/w qp %x, ql %x\n",bsi_num,qp,ql);
  printf("s/w qp %x, ql %x\n",q_ptr->qp,q_ptr->ql);
  printf("odud qp %x, ql %x\n",ch_ptr->odudq->qp,ch_ptr->odudq->ql);

  return OK;
}

/***********************************************************************
 *  Function  BSI_ChkREQ
 *
 *  Description
 *    This function reads the req descriptor
 *
 *  Parameter:
 *   uint32 bsi_num
 *
 *  Return: void
 **********************************************************************/
void BSI_ChkREQ (bsi_num)
uint32 bsi_num;
{
  printf("\n");
  ReadREQDesc(bsi_num,bsi_dev[bsi_num].rch0,bsi_dev[bsi_num].rch0->reqq);
}

/***********************************************************************
 *  Function  BSI_ChkDBDs
 * 
 *  Description
 *    This function checks # of DBDs is used by the chip now.
 *
 *  Parameter: none
 *
 *  Return: void
 **********************************************************************/
void BSI_ChkDBDs ()
{
  int cnt;
  extern MBOX MonpMbox, IpReceiveMbox;

  printf("\nrch0 %d, rch1 %d, ",bsi_dev[0].rch0->info_ptr->queued_cnt,bsi_dev[0].rch1->info_ptr->queued_cnt);
  cnt = (bsi_dev[0].rch0->info_ptr->queued_cnt + bsi_dev[0].rch1->info_ptr->queued_cnt);
  printf("   BSI 0 -->  DBD in queued %d\n",cnt);
  cnt = (bsi_dev[1].rch0->info_ptr->queued_cnt + bsi_dev[1].rch1->info_ptr->queued_cnt);
  printf("BSI 1 -->  DBD in queued %d\n",cnt);

  ReadREQDesc(0,bsi_dev[0].rch0,bsi_dev[0].rch0->reqq);
  BSI_ReadCNFDesc(0,bsi_dev[0].rch0,bsi_dev[0].rch0->cnfq);
  ReadREQDesc(1,bsi_dev[1].rch0,bsi_dev[1].rch0->reqq);
  BSI_ReadCNFDesc(1,bsi_dev[1].rch0,bsi_dev[1].rch0->cnfq);
  printf("\n");
  ChkAllPsp();
  printf("free_psp_count %d\n",free_psp_count);
#ifndef __FEBRIDGE
  printf("dbd_count %d\n",dbd_count);

  printf("RxSMTFRameMBox %d, ReceiveMbox %d, IpReceiveMbox %d, MonpMbox %d\n",RxSMTFrameMBox.mb_count,ReceiveMbox.mb_count,IpReceiveMbox.mb_count,MonpMbox.mb_count);
#endif
}

/***********************************************************************
 *  Function  BSI_BrChkDBDs
 * 
 *  Description
 *    This function checks # of DBDs is used by the chip now.
 *
 *  Parameter: none
 *
 *  Return: void
 **********************************************************************/
void BSI_BrChkDBDs ()
{
  int cnt;
  extern MBOX MonpMbox, IpReceiveMbox;

  printf("\nrch0 %d, rch1 %d, ",bsi_dev[0].rch0->info_ptr->queued_cnt,bsi_dev[0].rch1->info_ptr->queued_cnt);
  cnt = (bsi_dev[0].rch0->info_ptr->queued_cnt + bsi_dev[0].rch1->info_ptr->queued_cnt);
  printf("   BSI 0 -->  DBD in queued %d\n",cnt);

  ReadREQDesc(0,bsi_dev[0].rch0,bsi_dev[0].rch0->reqq);
  BSI_ReadCNFDesc(0,bsi_dev[0].rch0,bsi_dev[0].rch0->cnfq);
  printf("\n");
  ChkAllPsp();
  printf("free_psp_count %d\n",free_psp_count);
}




/***********************************************************************
 *  Function   ChkAllPsp
 *
 *  Description
 *    This function checks all the channels for # of PSPs is used by
 *    the driver now
 *
 *  Parameter:
 *
 *  Return:
 ***********************************************************************/
static status_type ChkAllPsp ()
{
  uint32 bsi;
  BSI_INCH_TYPE *ch_ptr;
  BSI_INDQ_TYPE *q_ptr;
  int num = 0;

#ifndef __FEBRIDGE
  for (bsi=0; bsi < 2; bsi++) {
#else
	bsi=0;
#endif
    printf("bsi %d ch 0:  ",bsi);
    ch_ptr = bsi_dev[bsi].ich0;
    q_ptr = ch_ptr->idudq;
    ReadIdudDesc(bsi,q_ptr,ch_ptr);
    q_ptr = ch_ptr->pspq;
    num += ReadPspDesc(bsi, q_ptr,ch_ptr);

    printf("ch 1:  ");
    ch_ptr = bsi_dev[bsi].ich1;
    q_ptr = ch_ptr->idudq;
    ReadIdudDesc(bsi,q_ptr,ch_ptr);
    q_ptr = ch_ptr->pspq;
     num += ReadPspDesc(bsi, q_ptr,ch_ptr);

    printf("ch 2:  ");
    ch_ptr = bsi_dev[bsi].ich2;
    q_ptr = ch_ptr->idudq;
    ReadIdudDesc(bsi,q_ptr,ch_ptr);
    q_ptr = ch_ptr->pspq;
     num += ReadPspDesc(bsi, q_ptr,ch_ptr);
#ifndef __FEBRIDGE
  }
#endif
  printf("Total psp in chips %d\n",num);
}


/***********************************************************************
 *  Function     ReadREQDesc
 *
 *  Description
 *    This function reads the req description qp and ql. It is used 
 *    mainly for debugging.
 *
 *  Parameter:
 *
 *  Return:
 ***********************************************************************/
status_type ReadREQDesc (bsi_num,ch_ptr,q_ptr)
uint32 bsi_num;
BSI_REQCH_TYPE *ch_ptr;
BSI_REQQ_TYPE *q_ptr;
{
  uint32 qp, ql;
  BSI_REQCH_INFO *info_ptr = ch_ptr->info_ptr;

  printf("req_head %x, req_tail %x\n",info_ptr->req_head,info_ptr->req_tail);
  lmop(bsi_num,ch_ptr->info_ptr->rqlr_addr,LMOP_READ,&ql);
  ql |= (ch_ptr->reqq->base & LMOP_ADDR_MASK);

  ptop(bsi_num,ch_ptr->info_ptr->rqpr_addr,PTOP_READ,&qp);
  qp = BSI2CPU(qp);
  printf("BSI_ReadREQDesc(), bsi %d: h/w qp %x, ql %x\n",bsi_num,qp,ql);
  printf("s/w qp %x, ql %x\n",q_ptr->qp,q_ptr->ql);

  return OK;
}


/*************************************************************************
 *  Function   ClearRxDesc
 *
 *  Description
 *    This function clears the transmit descriptors: PSP
 *
 *  Parameter:
 *    int bsi_num
 *    BSI_INCH_TYPE *ch_ptr;
 *    int buf_num - buffer numbers
 *    
 *  Return: void
 ************************************************************************/
void ClearRxDesc (bsi_num,ch_ptr,buf_num,ch_num)
uint32 bsi_num;
register BSI_INCH_TYPE *ch_ptr;
int buf_num;
int ch_num;
{
  uint32 desc_base;
  byte reg_offset;
  volatile BSI_REG_TYPE *r_ptr = bsi_dev[bsi_num].base_addr;

  /* free dbds in the odud */
  FreeBufsInPSP(ch_ptr);

  /* reinitialize the transmit queue */
  ResetIndCh(ch_ptr);

  reg_offset = ch_ptr->iqpi_addr;
  desc_base = ch_ptr->idudq->base;
  if ((ptop(bsi_num,reg_offset,PTOP_WRITE,&desc_base)) != OK) {
    r_ptr->sar &= ~BSI_STAR_INSTOP;
    return ;
  }

  reg_offset = ch_ptr->pqpi_addr;
  desc_base = ch_ptr->pspq->base;
  if ((ptop(bsi_num,reg_offset,PTOP_WRITE,&desc_base)) != OK) {
    r_ptr->sar &= ~BSI_STAR_INSTOP;
    return;
  }

  MEM_SetChPsp(bsi_num,buf_num,ch_ptr,ch_num,FALSE);
  BSI_PipelinePSP(bsi_num,ch_ptr);

#if NODBD_DEBUG
  printf("ClearRxDesc()\n");
  BSI_ChkDBDs();
#endif
}



#ifdef __FEBRIDGE
/********************************************************************
 *  Function  PutMacTestHdr
 *
 *  Description
 *    This function puts the FDDI mac header and LLC, SNAP header
 *    in front of the IP packet for FDDI loop-back test.
 *
 *  Parameters:
 *    PKT *p - point to the packet to send
 *
 *  Return: OK
 *******************************************************************/
PutMacTestHdr (p)
PKT *p;
{
  byte *header;
  extern byte Port4EthNid[];	/* fddi port MAC address */


  header = (byte*)p->pktDataPtr;   /* point header to the FC field */

  p->pktDataSize += FDDI_HEADER_LEN + sizeof(struct snap);

  *header++ = 0x51;   /* FC: long addr */
  ncopy(header, Port4EthNid);	/* dst addr (myself) */
  swap_bits(header,6);    
  header += 6;
  ncopy(header, Port4EthNid);	/* src addr */
  swap_bits(header,6);    
  header += 6;

  /* set LLC fields: snap auth=DOD type */
  *header++ = IEEESNP0;
  *header++ = IEEESNP1;
  *header++ = IEEESNP2;
  *header++ = IEEEDOD0;
  *header++ = IEEEDOD1;
  *header++ = IEEEDOD2;
  *header++ = 0x08;  			/* 1st half if 'IP' */
  *header++ = 0x00;  			/* 2nd half if 'IP' */

  return OK;
}
#endif


/*************************************************************************
 *  Function    InitTestFrame
 *
 *  Description
 *      This function initializes a test LLC frame.
 *
 *  Parameter:  
 *    uint32 len - the length of the test frame;
 *
 *  Return: DBD * - pointer to test frame
 *************************************************************************/
#ifdef __FEBRIDGE
static PKT *InitTestFrame (bsi_num,len, type)
uint32 bsi_num;
uint32 len;
uint32 type;
{
  int i, pkt_len;
  byte *ptr;
  PKT *pktp;

  if ((pktp = MEM_GetPkt()) == NULL) {
/*#if BSI_DEBUG */
      printf("Error: can't get test pkt\n");
/*#endif*/
    return (NULL);
  }

  pktp->pktBufLink = NULL;

  /* put start of frame (FC) at buffer+1 so addresses are on a 'short' boundary,
	because 'ncopy()' requires this */
  pktp->pktDataPtr = pktp->pktBufPtr+1;
  pktp->pktDataSize = len;

  PutMacTestHdr(pktp);
  if (type == BSI_SMT_FRAME)
    *((byte*)pktp->pktDataPtr) = 0x41;

  pattern++;		/* increment pattern */

  ptr = (byte*)pktp->pktDataPtr + 21;
  for (i=0; i < len; i++)
    *ptr++ = pattern;

  return (pktp);
}

#else
static DBD *InitTestFrame (bsi_num,len, type)
uint32 bsi_num;
uint32 len;
uint32 type;
{
  int i, pkt_len;
  byte *ptr;
  NID *dest_addr;
  DBD *dbdp, *f_dbd;

  if ((dbdp = (DBD *)get_dbd()) == NULL) {
#if BSI_DEBUG
      printf("Error: can't get test dbd\n");
#endif
    return (NULL);
  }

  if (len > BSI_PSP_SIZE - 22) {
    pkt_len = len - BSI_PSP_SIZE - 22;
    len = BSI_PSP_SIZE - 22;
    if ((f_dbd = (DBD *)get_dbd()) == NULL) {
#if BSI_DEBUG
	printf("Error: can't get test dbd\n");
#endif
	return (NULL);
    }
    f_dbd->db_actcnt = pkt_len;
    f_dbd->nb_prot = f_dbd->db_buffer;
    dbdp->db_nxtdbd = f_dbd;
    for (i=0, ptr = f_dbd->db_buffer; i < pkt_len; ptr++,i++) {
      *ptr = i % 0xff;
    }
  }
  else
    dbdp->db_nxtdbd = NULL;

  /* IP packet starts from offset 22 */
  dbdp->nb_prot = dbdp->db_buffer + 22;
  dbdp->db_actcnt = len;

  /* send it to myself */
  dest_addr = (NID *) MyNid(bsi_num);
  PutMacHeader(dbdp,dest_addr,(int)IP,NULL,0);
  if (type == BSI_SMT_FRAME)
    *((byte*)dbdp->db_buffer+1) = 0x41;

  ptr = dbdp->db_buffer + 22;

#ifdef 0  /* SDA  */
  for (i=22; i < len+22; ptr++,i++){
    *ptr = i % 0xff;
  }
#endif

  /* increment pattern */
  pattern++;

  ptr = dbdp->db_buffer + 22;
  for (i=22; i < len+22; ptr++,i++){
    *ptr = pattern;
  }


  return (dbdp);
}
#endif



#ifdef __FEBRIDGE
int test_init_flag = 0;
/*		portList  -  unused
 *		loopbackMode -
 *			0x03 or 0 for both internal and external loopback
 *			0x01 for internal loopback only.
 *			0x02 for external loopback only.
 *		Returns zero if OK, non-zero if loopback failure
 */
#define BSI_NUM 0
TestFddiLoop(int portList, int loopbackMode)
{
	int i, testOK;
	byte bmac_mr, old_icr;
	volatile BMAC_REG_TYPE *mac_ptr;
	volatile BSI_REG_TYPE *r_ptr;
    volatile PHY_REG_TYPE *pp;
	extern PLAYER_TYPE phys[];
	extern int A_Port_Config_State, B_Port_Config_State;


	if( loopbackMode == 0 )		/* 0 or 3 means 'both' */
		loopbackMode = 0x03;

	if (!test_init_flag)   /* if driver, etc. has not been initialized */
	{
	  if( A_Port_Config_State != B_Port_Config_State )
	  {
		printf("Both ports must be set to the same loc. (front or back).\n");
		return 1;
	  }
#ifdef notdef
	  if( get_ring_number() != 0 )
	  {
		printf("Backplane ring must be set to 0.\n");
		return 1;
	  }
#endif
	  if( InitPSPMem() == 0 )		/* if memory init OK */
	  	if( DRV_Init(0) == 0 )		/* if driver init OK */
		{
		  SetBPRingZero();			/* force to ring 0 */
		  StartBRIP();				/* init backplane stuff */
	  	  test_init_flag = TRUE;
		}
	  if( test_init_flag )		/* if init OK */
		printf("Initialization complete.\n");
	  else
		printf("**Initialization failure**\n");
	}

	testOK = test_init_flag;
	mac_ptr = bmacs[BSI_NUM].reg_base;
	r_ptr = bsi_dev[BSI_NUM].base_addr;

	bmac_mr = mac_ptr->mr;  	/* save current state of registers */
	old_icr = r_ptr->icr;
	r_ptr->icr = 0x18;

	if( testOK  &&  (loopbackMode & 0x01) )		 /* int. lpbk? */
	{
		printf("INTERNAL BMAC loopback\n");
		mac_ptr->mr = BMAC_MR_RUN | BMAC_MR_ILB;
		mac_ptr->fr = BMAC_FR_MCRST | BMAC_FR_CLM;    /* force ringOp set */
		testOK = BSI_DoLoopback();
	}
	if( testOK  &&  (loopbackMode & 0x01) )		 /* int. lpbk? */
	{
		/* configure PHYS to loopback frame at PHYs */
		PHY_Isolate(0);			/* isolate the A PHY */
	    phys[1].base_addr->cr = PHY_CR_AIND_AREQ | PHY_CR_BIND_BREQ | 
				PHY_CR_TRS_RBUS | PHY_CR_AIE; /*  | PHY_CR_BIE;*/
		printf("INTERNAL PHY loopback\n");
		mac_ptr->mr = BMAC_MR_RUN;
		mac_ptr->fr = BMAC_FR_MCRST | BMAC_FR_CLM;    /* force ringOp set */
		testOK = BSI_DoLoopback();
		/* restore PHYS to standard configuration */
		PHY_Insert_P(0);
    	phys[1].base_addr->cr = PHY_CR_AIND_RBUS | PHY_CR_BIND_BREQ | 
				PHY_CR_TRS_AREQ | PHY_CR_AIE | PHY_CR_BIE;
	}

	if( testOK  &&  (loopbackMode & 0x02) )		/* external loopback? */
	{
		PHY_TxSymbols (1, DRV_ACTIVE_LS);		/* active tx mode */
		printf("EXTERNAL loopback\n");
		mac_ptr->mr = BMAC_MR_RUN;
		mac_ptr->fr = BMAC_FR_MCRST | BMAC_FR_CLM;    /* force ringOp set */
		testOK = BSI_DoLoopback();
	}
	mac_ptr->mr = bmac_mr;   /* restore registers */
	mac_ptr->fr = BMAC_FR_MCRST;
	r_ptr->icr = old_icr;   
	return(!testOK);
}


BSI_DoLoopback()
{
	int i, failOnce;

	failOnce = FALSE;
	for(i=0; i<100; i++)		/* for multiple frames */
	{
		if (BSI_DoDiag(BSI_NUM, 500, BSI_LLC_FRAME) != TRUE) 
			if( failOnce )		/* if a failure already this time */
			{
				printf("    Loopback failure at frame %d\n", i);
				return FALSE;
			}
			else
				failOnce = TRUE;
	}
}
#endif
