
#include <fddi.h>
#include <fddimap.h>
#include <cam.h>
#include <drv.h>



#ifdef __FEBRIDGE
static short *cam_ptr[1];
#else
static short *cam_ptr[2];
#endif

/****************************************************************************
 *  Function  InitCAM
 *
 *  Description
 *    This function initializes CAM by taking CAM off line
 *
 *  Parameter:  none
 *
 *  Return: void
 ***************************************************************************/
void CAM_InitCAM ()
{
  volatile short *ptr;

#ifdef __FEBRIDGE
  cam_ptr[0] = (short *)BMAC_CAM_ADDR_BR;
  ptr = (short *)BMAC_CAM_ADDR_BR;
  *ptr = 0xff00;

#else
  cam_ptr[0] = (short *)BMAC_A_CAM_ADDR;
  cam_ptr[1] = (short *)BMAC_B_CAM_ADDR;
  ptr = (short *)BMAC_A_CAM_ADDR;
  *ptr = 0xff04;
  ptr = (short *)BMAC_B_CAM_ADDR;
  *ptr = 0xff04;
#endif

}


/**********************************************************************
 *  Function  CAM_ActiveCAM
 *
 *  Description
 *    This function enables CAM
 *
 *  Parameters:
 *
 *  Return: void
 *********************************************************************/
void CAM_ActiveCAM (cam_num)
uint32 cam_num;
{
  register short *ptr = cam_ptr[cam_num];
  short val;

  val = *ptr;
  *ptr = (val | CAM_ONLINE) & ~CAM_ADDSIZE;  /* assume its 48 bit addr */
}


/**********************************************************************
 *  Function  CAM_SetFrameStatus
 *
 *  Description
 *    This function manuplates A and C flag
 *
 *  Parameters:
 *
 *  Return: void
 *********************************************************************/
int CAM_SetFrameStatus (cam_num,action)
uint32 cam_num;
uint32 action;
{
  register short *ptr;
  short val;

  ptr = cam_ptr[cam_num];
  val = *ptr;

  switch (action) {
  case MAC_AC_NONE:
    /* clear EASET & COPYSET */
    *ptr = CAM_UNUSED_MASK | val & ~(CAM_EASET | CAM_COPYSET);
    break;

  case MAC_AC_COPIED:
    *ptr = val | CAM_COPYSET | CAM_UNUSED_MASK;
    break;

  case MAC_AC_RESET:

  default:
    return FDDI_ERROR;
  }

  return OK;
}


