/************************************************************************** *      File    drv.c
 *
 *      Description
 *          This file contains all the fddi drivers export functions to the
 *          rest of the system.
 *
 *      Copyright (c) 1992, 1993 Hughes Lan Systems
 *
 *      Author:     J. Jang
 *
 *  $Log:   /n/pvcs_conc/fddicon/drv/src/drv.c_v  
 * 
 *    Rev 1.115.1.10   11 Jan 1994 08:11:30   gregs
 * Made changes to increase bridge performance
 * 
 *    Rev 1.115.1.9   12 Oct 1993 11:12:46   gregs
 * Fixed missing PKT header problems
 * 
 *    Rev 1.115.1.8   05 Oct 1993 12:25:40   jang
 * deleted the test code which check the direct beacon. It would cause the problem during beaconing, the pkt was not free
 * 
 *    Rev 1.115.1.7   29 Sep 1993 13:29:48   gregs
 * No change.
 * 
 *    Rev 1.115.1.6   21 Sep 1993 10:44:58   jang
 * integrated with concentrator code 
 * 
 *    Rev 1.115.1.4   06 Aug 1993 14:54:56   gregs
 * Bug fixes for Bridge PKT changes
 * 
 *    Rev 1.115.1.3   02 Aug 1993 12:52:32   gregs
 * Modified DRV_SendFramBr such that the ptr argument is of type PKT*.
 * 
 *    Rev 1.115.1.2   02 Aug 1993 09:42:36   jang
 * took out the test code
 * 
 *    Rev 1.115.1.1   28 Jul 1993 13:41:38   jang
 * ch 1 & 2 work! checked in so it can be 
 * backup to tape
 * 
 *    Rev 1.115.1.0   16 Jul 1993 10:14:04   jang
 * test branch and modified DRV_GetOneRxPkt()
 * 
 *    Rev 1.115.1.0   16 Jul 1993 10:01:10   jang
 * modified DRV_GetOneRxPkt() by adding #ifdef to seperate fddi_con and bridge
 * 
 *    Rev 1.115   15 Jul 1993 18:04:50   jang
 * init function pointer drv_polling=BSI_poll()
 * 
 *    Rev 1.114   13 Jul 1993 14:33:26   jang
 * added code to do bsi self loop frame test during initialization
 * 
 *    Rev 1.113   08 Jul 1993 11:21:56   jang
 * fixed the bug in DRV_SendFrame() uninitialized ch_num
 * 
 *    Rev 1.112   02 Jul 1993 15:16:16   jang
 * seperate the bmac isr from phy isr
 * 
 *    Rev 1.111   28 Jun 1993 09:24:14   gregs
 * Fixed compile bug in DRV_SendFrameBr().
 * 
 *    Rev 1.110   28 Jun 1993 08:07:44   gregs
 * Added DRV_SendFrameBr() for FDDI_eth bridge tx.
 * 
 *    Rev 1.109   25 Jun 1993 16:48:08   jang
 * fixed the lost dbd bug in DRV_GetOneRxPkt()
 * 
 *    Rev 1.108   18 Jun 1993 14:42:22   jang
 * changed FBMActive to MACActive[]
 * 
 *    Rev 1.107   17 Jun 1993 14:57:04   jang
 * 
 *    Rev 1.106   17 Jun 1993 14:27:40   jang
 * added code to check dbd is OK before send it out. also added FBMActive checking
 * 
 *    Rev 1.106   17 Jun 1993 14:08:32   jang
 * added dbd checking before the frame is passed to bsi
 * 
 *    Rev 1.105   14 Jun 1993 19:18:44   jang
 * fixed frame status
 * y
 * 
 *    Rev 1.104   12 Jun 1993 10:58:18   jang
 * added function to clear all the mac counters after mac self test
 * 
 *    Rev 1.103   10 Jun 1993 19:06:20   jang
 * wait for 5 seconds until ringOp is stable
 * 
 *    Rev 1.102   10 Jun 1993 14:07:16   jang
 * added LLCActive
 * 
 *    Rev 1.101   08 Jun 1993 17:09:44   jang
 * ifdef __FDDI_CON in GetOneRxPkt() 
 * 
 *    Rev 1.100   08 Jun 1993 07:42:54   jang
 * added code to count IF_ENTRY/ifcntrs for smt frames and monitor frames
 * 
 *    Rev 1.99   07 Jun 1993 18:21:22   jang
 * changed interrupt driven to polling
 * 
 *    Rev 1.98   07 Jun 1993 12:30:54   jang
 * changed the code to do mac reset. don't do anything with BSI
 * 
 *    Rev 1.97   28 May 1993 14:36:30   jang
 * fixed the out of sync bug
 * 
 *    Rev 1.96   28 May 1993 10:13:22   jang
 * added SM_PH_STATUS_TX_LINE_STATE
 * 
 *    Rev 1.95   20 May 1993 11:43:22   jang
 * check if idud.cnt == 0, don't free dbd
 * 
 *    Rev 1.94   18 May 1993 16:30:14   jang
 * added one parameter for BSI_SendReq()
 * 
 *    Rev 1.93   12 May 1993 15:49:02   jang
 * changed DRV_Reset(), send out quiet symbols before isolate the PHY
 * 
 *    Rev 1.92   06 May 1993 16:20:04   jang
 * added code to send broadcast arp reply when ring is not wrapped.
 * 
 *    Rev 1.91   05 May 1993 14:50:48   jang
 * fixed the bug of disable mac interrupt by the RMT
 * 
 *    Rev 1.90   30 Apr 1993 11:45:28   jang
 * added function DRV_Reset()
 * 
 *    Rev 1.89   29 Apr 1993 11:41:40   jang
 * added a function DRV_VerifyABport() for flicking interface A/R LED.
 * 
 *    Rev 1.87   28 Apr 1993 15:40:02   jang
 * changed the get_debug() to #if DRV_DEBUG
 * 
 *    Rev 1.86   26 Apr 1993 10:34:18   jang
 * calling BMAC_EnableEvents() when asked to enable bmac interrupt.
 * 
 *    Rev 1.86   26 Apr 1993 10:20:56   jang
 * call BMAC_EnableEvent() when is asked to enable mac interrupt
 * 
 *    Rev 1.85   24 Apr 1993 17:07:06   jang
 * changed the function call of SM_MAC_CTRL_MAC_INT
 * 
 *    Rev 1.84   24 Apr 1993 16:10:00   jang
 * added code so that when bsi init fail, config the concentrator
 * to be a dumb MAU
 * 
 *    Rev 1.84   24 Apr 1993 16:05:44   jang
 * added code so that when bsi init failed, config the concentrator to be
 * a dumb MAU
 * 
 *    Rev 1.83   24 Apr 1993 12:05:38   jang
 * added SM_PH_CTRL_INT
 * 
 *    Rev 1.82   21 Apr 1993 15:29:16   jang
 * changed code to do direct beacon
 * 
 *    Rev 1.81   20 Apr 1993 16:02:52   jang
 * added a function to wait for 18 seconds for rmt to stable
 * 
 *    Rev 1.80   17 Apr 1993 14:08:28   jang
 * check the return code of BSI_DoDiag() in DRV_SelfTest() and return the value
 * 
 *    Rev 1.79   17 Apr 1993 13:56:30   jang
 * deleted fc checking from DRV_SendFrame()
 * 
 *    Rev 1.78   15 Apr 1993 14:25:24   jang
 * added code to debug ring_op with RINGOP_DEBUG set to 1
 * 
 *    Rev 1.77   13 Apr 1993 13:35:56   jang
 * changed pstats
 * 
 *    Rev 1.76   10 Apr 1993 16:19:32   jang
 * moved the bsi/bmac mode checking to BSI_SendReq()
 * 
 *    Rev 1.75   07 Apr 1993 10:32:28   jang
 * fixed FRAME_STATUS 2nd parameter
 * 
 *    Rev 1.74   07 Apr 1993 09:13:42   jang
 * took out ifctrs from DRV_GetOneRxPkt() because the rx pkt is only for
 * monitoring
 * 
 *    Rev 1.73   05 Apr 1993 08:21:36   jang
 * added ifcntrs for error packets and adjust indent
 * 
 *    Rev 1.70   31 Mar 1993 18:41:54   jang
 * added code to do frame status and do the InitFddiCon()
 * 
 *    Rev 1.69   29 Mar 1993 16:48:36   gregs
 * bridge CAM addr, and interrupt struct. changes.
 * 
 *    Rev 1.68   26 Mar 1993 13:28:18   jang
 * added function to init CAM
 * 
 *    Rev 1.67   25 Mar 1993 09:23:32   gregs
 * #ifdef for bridge h/w in ResetLANChips().
 * 
 *    Rev 1.66   25 Mar 1993 09:18:48   jang
 * 
 *    Rev 1.65   24 Mar 1993 18:42:36   jlin
 * 
 *    Rev 1.64   23 Mar 1993 12:02:22   jang
 * changed parameter of MEM_SetChPsp()
 * 
 *    Rev 1.63   18 Mar 1993 18:27:00   jang
 * 
 *    Rev 1.62   18 Mar 1993 18:00:48   jang
 * took out dbd->db_prev which was used for debugging only
 * 
 *    Rev 1.61   18 Mar 1993 17:51:32   jang
 * fixed bugs of running out of DBDs
 * 
 *    Rev 1.58   08 Mar 1993 12:07:16   shekhar
 * removed Monp_init from here and it's put in fdrutil.c
 * 
 *    Rev 1.57   08 Mar 1993 09:33:26   jang
 * deleted collecting feature from the driver and pass it up
 * to collector to do it
 * 
 *    Rev 1.56   05 Mar 1993 10:17:14   jang
 * changed DRV_GetOneRxPkt() from pkt to dbd
 * 
 *    Rev 1.55   02 Mar 1993 18:59:20   jang
 * clean out DRV_Init()
 * 
 *    Rev 1.54   01 Mar 1993 15:24:48   jang
 * changed drv_init_flag to a public variable
 * 
 *    Rev 1.53   24 Feb 1993 16:48:08   jang
 * for cmt  interop 
 * 
 *    Rev 1.52   22 Feb 1993 17:54:20   jang
 * added memory.h
 * 
 *    Rev 1.51   19 Feb 1993 18:03:00   jang
 * 
 *    Rev 1.50   16 Feb 1993 11:04:36   jang
 * changed DRV_SendFrame() to let the high layer to decide which mac the
 * tx frame is going out
 * 
 *    Rev 1.49   12 Feb 1993 17:16:56   jang
 * changed the return code of DRV_GetStatus()
 * also added drv_init_flag
 * 
 *    Rev 1.48   12 Feb 1993 10:29:44   jlin
 * 
 *    Rev 1.47   11 Feb 1993 14:21:42   jang
 * changed GetOnePkt()
 * 
 *    Rev 1.46   08 Feb 1993 18:47:58   jang
 * changed ctrl_int function calls to BMAC_DisableEvents() etc.
 * 
 *    Rev 1.45   05 Feb 1993 14:36:40   jang
 * checked in for performance test
 * 
 *    Rev 1.44   04 Feb 1993 19:20:06   jang
 * all the debug printf are gone

 * 
 *    Rev 1.43   03 Feb 1993 13:23:02   jang
 * No change.
 * 
 *    Rev 1.42   03 Feb 1993 09:03:24   jang
 * work version in slow traffic
 * 
 *    Rev 1.41   30 Jan 1993 16:26:10   jang
 * modified the memory allocation
 * 
 *    Rev 1.40   29 Jan 1993 16:59:02   jang
 * 
 *    Rev 1.39   26 Jan 1993 15:12:02   jang
 * added code to get the mac releated mibs
 * 
 *    Rev 1.38   26 Jan 1993 11:18:04   jang
 * do the BSI_Init() and BMAC_Init() in DRV_Init()
 * 
 *    Rev 1.37   22 Jan 1993 10:57:08   jang
 * added code to get TTRT value
 * 
 *    Rev 1.36   19 Jan 1993 14:24:16   jang
 * fixed type error DRVMIB_PTYPE
 * 
 *    Rev 1.35   19 Jan 1993 13:56:28   jang
 * checked in due to the new function DRV_MIBsReq()
 * 
 *    Rev 1.34   07 Jan 1993 09:38:40   jang
 * added rmon statistics
 * 
 *    Rev 1.32   17 Dec 1992 14:23:32   jang
 * fix a compiling error by adding ProcState pState to DRV_Init()
 **************************************************************************/

#include <fddi.h>
#include <drv.h>
#include <msgutil.h>
#include <pkt.h>
#include <bsi.h>
#include <bmac.h>
#include <phy.h>
#include <dips.h>
#include <memory.h>
#include <cmtflag.h>
#include <fdrmonty.h>
#include <cam.h>
#include <tcpip.h>
#include <monp.h>
#include <error.h>
#include <smtmacro.h>
#include <nodbd.h>


#define BR_DEBUG     0
#define JWJ 0
#if JWJ
int drv_tx_cnt = 0;
int drv_drop_cnt = 0;
int drv_free_cnt = 0;
extern volatile char *ptr_c0, *ptr_c4, *ptr_c8, *ptr_cc;
extern volatile char *ptr_d0, *ptr_d4, *ptr_d8, *ptr_dc;
#endif


#define CON_DEBUG              1  /* debug concentrator */
#if CON_DEBUG
#include <dbd.h>
#endif

#define  RINGOP_DEBUG          0
#define  DRV_DEBUG             0
#define  CLAIM_DEBUG           0


/*
 *------------------------------------------------------------------------
 *          Export variables
 *------------------------------------------------------------------------
 */
bool drv_init_flag;
bool drv_bootp_done;

FDDI_CON_TYPE fddi_board;
DRV_MIBS_TYPE drv_mibs[BSI_MAX];
volatile unsigned short *int_reg;        /* interrupt register */
void (*drv_polling)();


/*
 *------------------------------------------------------------------------
 *          Import variables
 *------------------------------------------------------------------------
 */
extern void FDDIChipIsr();
extern void FddiConPriMacIsr();
extern void FddiConSecMacIsr();
extern void BSI_poll();
extern BSI_TYPE bsis[];
extern BSI_ADDR_TYPE bsi_dev[];
extern FDDI_PSTATS fddi_port_pstats_tbl[];
extern FDDI_PSTATS fddi_if_pstats_tbl[];
extern MBOX ReceiveMbox;
extern PLAYER_TYPE phys[];
extern NID MyFDDINid[];
extern IF_ENTRY *ifcntrs;
extern BMAC_TYPE bmacs[];
extern tcpip *_initp;
extern void MEM_FreePSPBuf();

/*
 *------------------------------------------------------------------------
 *          Local variables
 *------------------------------------------------------------------------
 */ 
DRV_INIT_MIB init_mibs;
static char broadcast[6] = {0xff,0xff,0xff,0xff,0xff,0xff};
static bool get_drv_mib = FALSE;

/***
path test error code
***/
#define PATH_TEST_MAC_FAIL          -1
#define PATH_TEST_BSI_FAIL          -2

#ifdef DO_LINT

#else
static int DetailPathTest();
static void PathTestFail();
static status_type ResetMac();

#endif

extern void MacBsiIsrAsm(), PlayerIsrAsm();
extern void DRV_ResetLANChips();

	
/****************************************************************
 *  Function    DRV_init
 *
 *  Description
 *      This function initializes fddi driver without enable
 *      interrupts
 *
 *  Parameter:
 *      uint16 bsi_num - primary ring mac #
 *
 *  Return: [OK | FDDI_ERROR]
 ***************************************************************/
status_type DRV_Init (source)
int source;
{
  int i;
  extern unsigned long ram_control_table[];

  if (drv_init_flag)
    return (OK);

  drv_bootp_done = FALSE;
#if  0
  if (init_pspPkt() != OK) {
    printf("DRV_Init() error\n");
    return FDDI_ERROR;
  }
#endif

  DRV_ResetLANChips();
  drv_polling = BSI_poll;

#ifdef __CMT_ONLY
  memset(drv_mibs,0,sizeof(DRV_MIBS_TYPE) * BSI_MAX);
  /* read the FDDI concentrator ID to fill in the data structure */
  DRV_InitFddiCon();

  /* comment to test bsi */
  DRV_Timer3Init();

  /* comment to test bsi */
  BMAC_CMTTestInit(); 
  BSI_CMTTestInit(); 

  /* config PLAYERs first */
  if (PHY_Init(8,FDDICON_MASTER) != OK) {
    return (FDDI_ERROR);
  }

  int_reg = (unsigned short *)FDDI_INTREG_BASE;
  /* modify int 3,4,5 to level triggered */
  ram_control_table[7] &= 0xff1f;
  /* install the fddi chip set isr */
  init_hw_int(3,66,FDDIChipIsr);  /* PHYs interrupt:NEED TO MOVE TO END OF THE FUNCTION */

#else   /* __CMT_ONLY  */


  memset(drv_mibs,0,sizeof(DRV_MIBS_TYPE) * BSI_MAX);
  CAM_InitCAM();  
  /* read the FDDI concentrator ID to fill in the data structure */
  DRV_InitFddiCon();


  /* comment to test bsi */
  DRV_Timer3Init();

  /* config PLAYERs first */
  if (PHY_Init(fddi_board.phy_num,fddi_board.type) != OK) {
    return (FDDI_ERROR);
  }

  int_reg = (unsigned short *)FDDI_INTREG_BASE;
#ifdef __FEBRIDGE
	/* shutdown the 2 backplane PHYs */
	PHY_Stop(2);
	PHY_Stop(3);
  /* modify int 5,6 to level triggered */
  ram_control_table[7] &= 0xfe7f;
#else
  /* modify int 3,4,5 to level triggered */
  ram_control_table[7] &= 0xff1f;
  /* install the fddi chip set isr */
  init_hw_int(3,66,FDDIChipIsr);  /* PHYs interrupt:NEED TO MOVE TO END OF THE FUNCTION */
#endif

  if (fddi_board.bsi_num != 0) {
    if (BSI_Init(fddi_board.bsi_num,source) != OK) {
      BSI_CMTTestInit(); /* so at least we can be a dumb concentrator */
      BMAC_CMTTestInit();
      return (FDDI_ERROR);
    }
    if (BMAC_Init(fddi_board.bsi_num,source) != OK) {
      return (FDDI_ERROR);
    }
  }
    
#ifdef __FEBRIDGE
  init_hw_int(5,98,MacBsiIsrAsm);
  init_hw_int(6,114,PlayerIsrAsm);
#else
  init_hw_int(4,82,FddiConSecMacIsr);
  init_hw_int(5,98,FddiConPriMacIsr);
#endif


  for (i=0; i < fddi_board.bsi_num; i++) {
    if (DRV_SelfTest(i,DRV_BEACON_TEST) != SUCCEED) {
      printf("Error: BMAC %d Self Beacon Test failed\n",i);
      return (FDDI_ERROR);
    }
    if (DRV_SelfTest(i,DRV_CLAIM_TEST) != SUCCEED) {
      printf("Error: BMAC %d Self Claim Test failed\n",i);
      return (FDDI_ERROR);
    }
  }
#endif   /* __CMT_ONLY */

  drv_init_flag = TRUE;

#ifndef __FEBRIDGE
  for (i=0; i < fddi_board.bsi_num; i++) {
     BSI_LoopTest(i); 
     BMAC_ClearAllMacCounters(i);  
  }
#endif

#if 0
  disable_wdt();
#endif

  return (OK);        
}
 

/***************************************************************************
 *  Function    DRV_ControlReq
 *
 *  Description
 *      This funcion processes the control request from the application,
 *      which includes SMT, MAP, UI/SNMP.
 *
 *  Parameters:
 *      uint32 dev_num - device number based upon act
 *      uint32 req  - request, defined in drv.h
 *      int val - value of the request
 *
 *  Return: [RC_SUCCESS | RC_NO_PARAM | RC_ILLEGAL_PARAMETER | RC_OUT_OF_RANGE]
 ***************************************************************************/
int DRV_ControlReq (dev_num,req,val)
uint32 dev_num;
uint32 req;
int    val;
{
  int i;
  long s;

    switch (req) {
    case HLS_CTRL_MAC_STRIP:
      if (BMAC_GetBMACMode(dev_num) != DRV_STOP)
	  BSI_DoMACScrub(dev_num,val);

      return (RC_SUCCESS);

    case SM_MA_CTRL_RESET:      /* reset mac */
      if (dev_num >= fddi_board.bmac_num)
        return (RC_OUT_OF_RANGE);
#if RINGOP_DEBUG
      printf("DRV_ControlReq() calling ResetMac()\n");
#endif
      if (ResetMac(dev_num) == OK)
        return (RC_SUCCESS);
      else
        return (RC_OUT_OF_RANGE);
       break;

    case SM_MA_CTRL_EXTER_BEACON:
    case SM_MA_CTRL_INTER_BEACON:
       if (dev_num >= fddi_board.bmac_num)
          return (RC_OUT_OF_RANGE);
       BMAC_SetBeaconType(dev_num,req,(byte *)val);                
       return (RC_SUCCESS);

       break;
    case SM_MA_CTRL_SET_T_REQ:
       if (BMAC_SetTreq(dev_num,val) == OK)
	      return (RC_SUCCESS);

       return (RC_ILLEGAL_PARAMETER);

    case SM_MA_CTRL_BEACON_REQ:      /* request to send beacon */
      if (BMAC_BeaconRequest(dev_num) != FDDI_ERROR)
	return (RC_SUCCESS);
      else
	return(RC_ILLEGAL_PARAMETER);

    case SM_MA_CTRL_CLAIM_REQ:
            if (BMAC_ClaimRequest(dev_num) == OK)
                return (RC_SUCCESS);

          return (RC_OUT_OF_RANGE);
         
    case SM_MA_CTRL_SET_TMIN:       /* not supported */
            return (RC_OUT_OF_RANGE);
            
    case SM_MA_CTRL_SET_TVX:
        if (BMAC_SetTimerRegs(dev_num,val,BMAC_TMR_TVX) == OK)
          return (RC_SUCCESS);
   
        return (RC_OUT_OF_RANGE);
                
    case SM_MA_CTRL_SET_TMAX:
        if (BMAC_SetTimerRegs(dev_num,val,BMAC_TMR_TMAX) == OK)
          return (RC_SUCCESS);

        return (RC_OUT_OF_RANGE);
                
    case SM_MA_CTRL_SET_LONG_ADDR:
         BMAC_SetLongAddr(dev_num,(byte*)val);
         return (RC_SUCCESS);

    case SM_MA_CTRL_SET_TBID:
         if (BMAC_SetTreq(dev_num,val) == OK)
           return (RC_SUCCESS);

         return (RC_OUT_OF_RANGE);

        case SM_MA_CTRL_PHY2MAC:
            /* not supported because BMAC doesn't have the ability to
                disconnect PHY.indicate and to keep the PHY.request
                connecting at the same time.
            */
            return (RC_OUT_OF_RANGE);

        case SM_MA_CTRL_CONFIG_MAC:
#if 0
  printf("DRV_CtrlReq() SM_MA_CTRL_CONFIG_MAC, val %d\n",val);
#endif
            if (val == DRV_START) {
#if RINGOP_DEBUG
	      printf("DRV_ControlReq() to start bmac %d\n",dev_num);
#endif
                BMAC_StartBmac(dev_num);
	      }
            else if (val == DRV_STOP)
                BMAC_StopBmac(dev_num);
            else
                return (RC_ILLEGAL_PARAMETER);
            return (RC_SUCCESS);
        
        case SM_PH_CTRL_LCT:
            /* when doing LCT, the LEM threshold has already been loaded */
            if (val == DRV_START)
                PHY_StartLCTest(dev_num);
            else if (val == DRV_STOP)
                PHY_StopLCTest(dev_num);
            return (RC_SUCCESS);
            
	case SM_MA_CTRL_COPY_MODE:
	    if (val == DRV_COPY_PROMISC) {
	      if (dev_num == DRV_ALL_BSI) {
		for (i=0; i < fddi_board.bsi_num; i++)
		  BSI_SetICR(i,BSI_CP_PROMIS);
	      }
	      else
		BSI_SetICR(dev_num,BSI_CP_PROMIS);
	    }
	    else if (val == DRV_COPY_NON_PROMISC) {
	      if (dev_num == DRV_ALL_BSI) {
		for (i=0; i < fddi_board.bsi_num; i++)
		  BSI_SetICR(i,BSI_CP_RESTORE);
	      }
	      else
		BSI_SetICR(dev_num,BSI_CP_RESTORE);
	    }
	    else
	      return RC_ILLEGAL_PARAMETER;

	    return RC_SUCCESS;

        case SM_MA_CTRL_PATH_TEST:
	    if (dev_num >= fddi_board.bmac_num)
	      return (RC_OUT_OF_RANGE);
            if (DRV_SelfTest(dev_num,DRV_BEACON_TEST) == FAIL)
	      return (RC_OUT_OF_RANGE);
      
            return RC_SUCCESS;

        case SM_MA_CTRL_MAC_INT:
            if (val == DRV_DISABLE)  {
#if CLAIM_DEBUG
	      printf("drv.c disable bmac %d interrupt\n",dev_num);
#endif
	      BMAC_DisableEvents(dev_num);  
				}
            else  if (val == DRV_ENABLE)  {
#if CLAIM_DEBUG
	      printf("drv.c enable mac %d interrupt\n",dev_num);
#endif
	      BMAC_EnableEvents(dev_num);
				}
            else
	      return (RC_ILLEGAL_PARAMETER);
            return RC_SUCCESS;

        case SM_PH_CTRL_LEM_THRESHOLD:
            s = crit_on();
            PHY_SetLerCutoff(dev_num,val);                
            crit_off(s);
            return (RC_SUCCESS);
            
       case SM_PH_CTRL_LEM_CONFIG:
            PHY_ConfigLEM(dev_num,val); /* val = DRV_ENABLE | DRV_DISABLE */  
            return (RC_SUCCESS);

        case SM_PM_CTRL_TX_REQ:
            PHY_ConfigTx(dev_num,val); /* val = DRV_ENABLE | DRV_DISABLE */
            return (RC_SUCCESS);

    case SM_PH_CTRL_INT:
      if (dev_num > fddi_board.phy_num)
	return RC_ILLEGAL_PARAMETER;

      PHY_SetRCMRx(dev_num,val);
      return RC_SUCCESS;
      
        case SM_PM_CTRL_SILS_REQ:
            PHY_ConfigSILS(dev_num,val); /* val = DRV_ENABLE | DRV_DISABLE */
            return (RC_SUCCESS);

        case SM_PH_CTRL_CONFIG:
            switch (val) {
                case CE_ISOLATED:
                    PHY_Isolate(dev_num);
                    break;
                case CE_INSERT_P:
                    PHY_Insert_P(dev_num);
                    break;
                case CE_INSERT_S:
                    PHY_Insert_S(dev_num);
                    break;
                case CE_INSERT_X:       /* h/w not supported */
                    PHY_Insert_X(dev_num);
                    break;
                default:
                    return (RC_ILLEGAL_PARAMETER);
            }
            return (RC_SUCCESS);
            
        case SM_PM_CTRL_TX_SYMBOL:
            switch (val) {
                case MASTER_LINE_STATE:
                    val = DRV_MASTER_LS;
                    break;
                case IDLE_LINE_STATE:
                    val = DRV_IDLE_LS;
                    break;
                case HALT_LINE_STATE:
                    val = DRV_HALT_LS;
                    break;
                case QUIET_LINE_STATE:
                    val = DRV_QUIET_LS;
                    break;
                case ACTIVE_LINE_STATE:
                case TRANSMIT_PHY_DATA_REQUEST:
                    val = DRV_ACTIVE_LS;
                    break;
                default:
                    return (RC_ILLEGAL_PARAMETER);
            }

            if (PHY_TxSymbols(dev_num,val) == OK)
                return (RC_SUCCESS);

            return (RC_OUT_OF_RANGE);
                    
        case SM_PM_CTRL_EBUF:
            PHY_ConfigEBOU(dev_num,val);
	    return (RC_SUCCESS);

        case SM_MA_CTRL_SET_SHORT_ADDR:
                return (RC_ILLEGAL_PARAMETER);

	case SM_MA_CTRL_MAC_FRAME_STATUS:
#ifndef __FEBRIDGE
          if (dev_num > 2)
            return (RC_ILLEGAL_PARAMETER);
#endif
          BMAC_SetExtMatch(dev_num,val);
          if (CAM_SetFrameStatus(dev_num,val) != OK)
            return (RC_ILLEGAL_PARAMETER);

          return (RC_SUCCESS);

    case SM_PM_CTRL_BYPASS_REQ:
	{
#ifdef __FEBRIDGE
#define FDDI_BYPASS_IOADDR	0x60000017
#endif
	volatile char *ptr;

	if (val == DRV_ENABLE) {
				
#ifdef __FEBRIDGE
	  ptr = (volatile char *)FDDI_BYPASS_IOADDR;
	  *ptr = 0x48;
#else
	  ptr = (char *) FDDI_BYPASS_PRISWITCH;
	  *ptr = 0x01;
	  ptr = (char *) FDDI_BYPASS_SECSWITCH;
	  *ptr = 0x01;
#endif
	}
	else if (val == DRV_DISABLE)  {
#ifdef __FEBRIDGE
	  ptr = (volatile char *)FDDI_BYPASS_IOADDR;
	  *ptr = 0;
#else
	  ptr = (char *) FDDI_BYPASS_PRISWITCH;
	  *ptr = 0;
	  ptr = (char *) FDDI_BYPASS_SECSWITCH;
	  *ptr = 0;
#endif
	}                  
	else
	  return (RC_OUT_OF_RANGE);
         
	return(RC_SUCCESS);
      }
 
    case SM_MA_CTRL_ADD_LONG_ALIASES:
    case SM_MA_CTRL_ADD_SHORT_ALIASES:
    case SM_MA_CTRL_REMOVE_LONG_ALIASES:
    case SM_MA_CTRL_REMOVE_SHORT_ALIASES:
    case SM_MA_CTRL_REMOVE_SHORT_GRPADDR:
    case SM_MA_CTRL_REMOVE_LONG_GRPADDR:
    case SM_MA_CTRL_ADD_LONG_GRPADDR:
    case SM_MA_CTRL_ADD_SHORT_GRPADDR:

    default:
            return (RC_ILLEGAL_PARAMETER);
    }
}

/***************************************************************************
 *  Function    DRV_StatusReq
 *
 *  Description
 *      This function implements the Status Request function.
 *
 *  Parameters
 *      uint32 dev_num
 *      uint32 req - status request defineds in drv.h
 *      uint32 *val - return request status
 *
 *  Return: [OK | FDDI_ERROR]
 *      FDDI_ERROR if not supported.
 **************************************************************************/
int DRV_StatusReq (dev_num,req,val)
uint32 dev_num;
uint32 req;
uint32 *val;
{
  switch (req) {
  case SM_MA_STATUS_DUP_ADDR:
       *val = BMAC_ChkDupAddr(dev_num);
       return (RC_SUCCESS);
            
  case SM_MA_STATUS_R_FLAG:
       *val = BMAC_Read_Rflag(dev_num);
       return (RC_SUCCESS);
            
  case SM_PH_STATUS_LEM_COUNT:
       PHY_GetLerCutoff(dev_num,val);
       return (RC_SUCCESS);
            
  case SM_PH_STATUS_PTYPE:
       *val = (uint32) PHY_GetPortType(dev_num);
       return (RC_SUCCESS);

  case SM_PM_STATUS_RX_LINE_STATE:
       *val = PHY_GetRxLs(dev_num);
       return RC_SUCCESS;

  case SM_MA_STATUS_T_NEG:
       *val = BMAC_Get_TTRT(dev_num);
	return RC_SUCCESS;

  case SM_PH_STATUS_ELBUF_ERROR:
       *val = PHY_GetElBufErr(dev_num);
       return RC_SUCCESS;

  case SM_MA_STATUS_FRAME_CT:
  case SM_MA_STATUS_COPIED_CT:
  case SM_MA_STATUS_ERROR_CT:
  case SM_MA_STATUS_LOST_CT:
  case SM_MA_STATUS_NOT_COPIED_CT:
  case SM_MA_STATUS_LATE_CT:
  case SM_MA_STATUS_TX_CT:
  case SM_MA_STATUS_TOKEN_CT:
  case SM_MA_STATUS_TVX_EXPIRED_CT:
       *val = BMAC_GetMacCounters(dev_num,req);
       return RC_SUCCESS;

  case SM_PM_STATUS_TX_LINE_STATE:
	  *val = PHY_GetTxLs(dev_num);
	  return RC_SUCCESS;


  default:
       return (RC_ILLEGAL_PARAMETER);
  }       /* switch */
}


/*****************************************************************************
 *  Function   DRV_VerifyABport
 *
 *  Description:
 *    This function checks whether or not port A and/or B are A/B port, and
 *    any port connect to it currently.
 *
 *  parameter:
 *   uint32 [0 | 1] - primary/secondary
 *
 *  Return: [TRUE | FALSE]
 ****************************************************************************/
bool DRV_VerifyABport (mac_num)
uint32 mac_num;
{
  int type; 

  if (mac_num >= fddi_board.bmac_num)
    return FALSE;

  if (phys[mac_num].config_state == PHY_ISOLATE)
    return FALSE;

  if (((type = PHY_GetPortType(mac_num)) != PC_TYPE_A) && (type != PC_TYPE_B))
    return FALSE;

  return TRUE;
}


/*****************************************************************************
 *  Function   DRV_MIBsReq
 *
 *  Description
 *    This function is to inform that driver needs to change its local MIBs.
 *
 *  Parameter:
 *    uint32 dev_num
 *    uint32 mib_name
 *    int    val
 *
 *  Return: void
 *****************************************************************************/
void DRV_MIBsReq (dev_num,mib_name,val)
uint32 dev_num;
uint32 mib_name;
int val;
{
  switch (mib_name) {
  case DRVMIB_PTYPE:
    /* it expects dev_num starts from 0 for port 1 */
    /* val - [PC_TYPE_M | PC_TYPE_A | PC_TYPE_S | PC_TYPE_B] */
    PHY_ChangePortType(dev_num,val); 
    break;

  case DRVMIB_RINGTYPE:
    if (val != RING_WRAP) {   
      BroadcastArpReply(_initp->in_me);
    }

    break;

  case DRVMIB_MACSTATUS:
#if 0
    /* val - [DRV_DEV_DOWN | DRV_DEV_UP] */
    if (val == DRV_DEV_DOWN) {
      if (fddi_board.active_bsi == dev_num) {
	fddi_board.active_bsi = (dev_num == PRIMARY_MAC) ? SECONDARY_MAC : PRIMARY_MAC;
/*	BSIREG_BsiStop(dev_num);  */
	BMAC_StopBmac(dev_num);
      }
    }
    else if (val == DRV_DEV_UP) {
      if (dev_num == PRIMARY_MAC && fddi_board.active_bsi != dev_num)
	fddi_board.active_bsi = dev_num;
/*      BSIREG_BsiRun(dev_num);  */
      BMAC_StartBmac(dev_num);
    }
    break;
#endif

  default:
    break;
  }  /* switch */
}
 


/*****************************************************************************
 *  Function   DRV_IsMyFDDINid
 *
 *  Description
 *    This function checks the address bytes in the packet against my mac 
 *    mac address in FDDI order.
 *
 *  Parameter:
 *    NID *  - address in packet. IT MUST BE SHORT ALIGNMENT
 *
 *  Return: [TRUE | FALSE]
 ****************************************************************************/
bool DRV_IsMyFDDINid (addr,mac_num)
NID *addr;
uint32 mac_num;
{
  register NID *my_nid;
  my_nid = &(MyFDDINid[mac_num]);
  if (ncompare(addr,my_nid))
    return TRUE;

  return FALSE;
}

/*****************************************************************************
 *  Function  DRV_ClearMyNid
 *
 *  Description
 *    This function clears the MySlotNid field in the mac 1 hostentry
 *
 *  Parameter:  none
 *
 *  Return: void
 ****************************************************************************/
void DRV_ClearMyNid ()
{
  HOSTENTRY *host;
  long s;

  s = crit_on();
  host = MONP_hash(bmacs[0].long_addr,1,0);
  if (host == NULL) {
#if DRV_DEBUG
      printf("Error: Can't get host entry for MyNid\n");
#endif
    crit_off(s);
    return;
  }

/*  if (host->MySlotNid == TRUE) */
    host->MySlotNid = FALSE;
  drv_bootp_done = TRUE;
  crit_off(s);
}

/*****************************************************************************
 *  Function   DRV_WaitForChnlRdy
 *
 *  Description
 *    This function waits for RMT to make a stable connection
 *
 *  Parameter:  none
 *
 *  Return:  void
 ****************************************************************************/
void DRV_WaitForChnlRdy ()
{
#define STABLE_TICKS    600
  int ticks, cur, tmp=0;

  ticks = RealTimeTicks() + STABLE_TICKS * 3;  /* wait for 18 seconds */

  while (ticks > (cur = RealTimeTicks())) {
    if ((BMAC_GetBMACMode(0) != DRV_STOP) || (BMAC_GetBMACMode(1) != DRV_STOP)) {
      if (tmp == 0) 
	tmp = cur + STABLE_TICKS;   /* let it stable for at least 5 seconds */
      else if (tmp < cur)
	break;
    }
    else
      tmp = 0;
    ReSchedule();
  }
}

/*****************************************************************************
 *  Funciton    DRV_DriverStart
 *
 *  Description
 *      This function sets all the chips to RUN mode
 *
 *  Parameters:     none
 *
 *  Return:     void
 ***************************************************************************/
void DRV_DriverStart ()
{
    uint32 i;
    
    for (i=0; i < fddi_board.bsi_num; i++) {
        BSIREG_BsiRun(i);
        BMAC_StartBmac(i);
    }

    for (i=0; i < fddi_board.phy_num; i++)
        PHY_Run(i);
}

/*****************************************************************************
 *  Funciton    DRV_DriverStop
 *
 *  Description
 *      This function sets all the chips to STOP mode
 *
 *  Parameters:     none
 *
 *  Return:     void
 ***************************************************************************/
void DRV_DriverStop ()
{
    uint32 i;

    for (i=0; i < fddi_board.bsi_num; i++) {
        BSIREG_BsiStop(i);
        BMAC_StopBmac(i);
    }

    for (i=0; i < fddi_board.phy_num; i++)
        PHY_Stop(i);
}

/*****************************************************************************
 *  Function  DRV_ChkRingWrap
 *
 *  Description
 *    This function checks whether or not the ring is wrapped by 
 *    comparing the SA in the rx pkt with the other MAC address.
 *    IF they are same, the ring must be wrapped. The secondary
 *    bsi indicate channel 2 will be shut down after ring is wrapped.
 *
 *  Parameter:
 *    uint32 bsi_num
 *
 *  Return: [TRUE | FALSE]
 ****************************************************************************/
bool DRV_ChkRingWrap (bsi_num,src_addr)
uint32 bsi_num;
byte *src_addr;
{
  uint32 mac_no;
  byte *mac_addr;

  mac_no = (bsi_num == PRIMARY_MAC) ? SECONDARY_MAC : PRIMARY_MAC;
  mac_addr = init_mibs.s_mib[mac_no].mac_addr;
  if (memcmp(mac_addr,src_addr,6) != 0)
    return (FALSE);

  /* ring is wrapped, shut down the secondary bsi channel 2 */
  BSI_ShutdownIndChnl(mac_no,BSI_INDCH2);
  /* reset ind chnl 2 psp */

  return TRUE;
}


/*****************************************************************************
 *  Function    DRV_SelfTest
 *
 *  Description
 *      This function does the FDDI chip sets self test. This function 
 *      assumes all the chips have been initialized.
 *
 *  Parameters:
 *      uint32 dev_num - device number to test
 *      uint32 type - [DRV_BEACON_TEST | DRV_CLAIM_TEST | DRV_FRAME_TEST]
 *
 *  Return: [SUCCEED | FAIL]
 ****************************************************************************/
int DRV_SelfTest (dev_num,type)
uint32 dev_num;
uint32 type;
{
  int i, retn_code = SUCCEED;

#ifdef __FEBRIDGE
	/* In order to loop data from the MAC thru the PHYs, back to
		the MAC, we must change the PHY configuration for the FDDI-
		eth bridge. */
    PHY_Isolate(0);		/* a.req->b.ind, and b.req->a.ind */
	PHY_Wrap(1);		/* a.req->a.ind */
#else
  /* isolate all the ports */
  for (i=0; i < fddi_board.phy_num; i++) {
    PHY_Isolate(i);
  }
#endif

  /* disable interrupts for BMAC and BSI */
  BMAC_DisableInt(bmacs[dev_num].reg_base);

  if (type & DRV_BEACON_TEST) {
    if (BMAC_TestBeacon(dev_num,DRV_1SEC) != OK) {
      printf("Self Beacon Test on MAC %d failed\n",dev_num);
      retn_code = FAIL;
    }   
  }

  if (type & DRV_CLAIM_TEST) {
    if (BMAC_TestClaim(dev_num,DRV_1SEC) != OK) {
      printf("Self Claim Test on MAC %d failed\n",dev_num);
      retn_code = FAIL;
    }   
  }

  if (type & DRV_FRAME_TEST) {
    /* set bmac to internal loopbaclk mode */
    if (!BSI_DoDiag(dev_num,128,BSI_LLC_FRAME))
      retn_code = FAIL;
  }

  /* restore all the ports configuartion switch */
  for (i=0; i < fddi_board.phy_num; i++) {
    PHY_RestoreCR(i);
  }

  BMAC_EnableInt(dev_num);
  return (retn_code);
}


/*****************************************************************************
 *  Function    DRV_SetParityCheck
 *
 *  Description
 *      This function sets FDDI chip set to do the parity checking
 *
 *  Parameter:  none
 *
 *  Return: void
 ***************************************************************************/
void DRV_SetParityCheck ()
{
    int i;

    for (i=0; i < fddi_board.bsi_num; i++) {
        BSIREG_EnableParity(i);
        BMAC_EnableParity(i);
    }
}
 
/*****************************************************************************
 *  Function    DRV_GetOneRxPkt
 *
 *  Description
 *      This function reads the IDUD in channel 2 and returns the first
 *      unprocessed packet if there is one. The received packet will be
 *      put into PKT.
 * 
 *  Parameter: 
 *
 *  Return: HOSTENTRY * - pointer to DA host entry; NULL if no packet available.
 ****************************************************************************/
#ifndef __FEBRIDGE	
HOSTENTRY *DRV_ReadRxPkt (bsi_num, msg)
uint32 bsi_num;
drv_generic_msg **msg;
{
  PKT *pktp;
  HOSTENTRY *host_ptr;
  DBD *dbdp;
  drv_generic_msg *m_ptr;
  int frame_flag;
  byte fc;

  if ((pktp = DRV_GetOneRxPkt(bsi_num)) == NULL) {
    return NULL;
  }

  swap_bits(pktp->pktDataPtr,6);
  swap_bits(pktp->pktDataPtr+6,6);

  /* hash the DA to see if it is send to MAC 0 */
  if ((host_ptr = (HOSTENTRY *)MONP_hash((byte*)pktp->pktDataPtr,bsi_num,TRUE)) == NULL) {
    FreePktBuf(pktp);
    return NULL;
  }

  /* following code is mainly used to handle the bootp/tftp. If bootp
     server is connected to secondary ring or primary mac is dead,
     we have to handle it at secondary mac ch 2 because the stupid
     SUN workstation tftp doesn't go through arp table to find out
     h/w address
  */

  /* check to see whether or not this frame has been copied */
  /* check to see if it is to MAC 0, if it is, pass it up to nim_rcv */
  if (host_ptr->MySlotNid) {   /* only check for boot code */
    if (dbdp = get_dbd()) {
      swap_bits(pktp->pktDataPtr,6);
      swap_bits(pktp->pktDataPtr+6,6);
      memcpy(dbdp->db_buffer,pktp->pktDataPtr,pktp->pktDataSize);
      dbdp->db_actcnt = pktp->pktDataSize;
      dbdp->nb_destination = dbdp->db_buffer;
      dbdp->nb_source = dbdp->db_buffer + 6;
      dbdp->db_rcvportno = pktp->pktRcvPort;
      dbdp->nb_prot = dbdp->db_buffer + FDDI_HEADER_LEN - 1;
      dbdp->db_actcnt -= FDDI_HEADER_LEN + 1;
      FreePktBuf(pktp);
      /* pass it up */
      SendMessage((MSGHDR*)dbdp,&ReceiveMbox);
    }

    return NULL;
  }

  /* get a mailbox */
  if ((m_ptr = MONP_get_free_monp_msg()) == NULL) {
    FreePktBuf(pktp);
    MONP_MLstats(bsi_num,MLSTATS_DROP_EVNT);
#if 0
    printf("can't get monp msg\n");
#endif
    return NULL;
  }

  fc = *(pktp->pktDataPtr-1);

  if (phys[0].p_type == PC_TYPE_M) {
    MONP_PstatsDataPkt(&fddi_port_pstats_tbl[0],pktp->pktDataSize+1,fc);
  }
  MONP_PstatsDataPkt(&fddi_if_pstats_tbl[0],pktp->pktDataSize+1,fc);

  m_ptr->frame_len = pktp->pktDataSize + 1;
  memcpy(m_ptr->pkt,pktp->pktDataPtr-1,PKT_CP_LEN);
  m_ptr->dev_num = pktp->pktRcvPort;
  *msg = m_ptr;
  FreePktBuf(pktp);

  return (host_ptr);
}
#endif

PKT *DRV_GetOneRxPkt (bsi_num)
uint32 bsi_num;
{
  BSI_INCH_TYPE *ch_ptr = bsi_dev[bsi_num].ich2;
  BSI_INDQ_TYPE *q_ptr;
  BSI_INDQ_TYPE *psp_q;
  register IDUD_DESCR_TYPE *d_ptr;
  register PKT *pkt_ptr;
  register int fl;
  register int addr;
  int *tmp, tmp_cnt;
  /*******************************/
  extern PKT *FreePktHead;
  extern int FreeThisPktBuf();
  /*******************************/

  q_ptr = ch_ptr->idudq;
  psp_q = ch_ptr->pspq;

  while (TRUE) {
    d_ptr = (IDUD_DESCR_TYPE *)q_ptr->qp;
    if ((d_ptr->loc & IDUD_ADDR_MASK) == 0L) { 
      return NULL;
    }

    /* undocument bsi bug:
       if the cnt field is 0, the loc points to the previous psp */
    if (d_ptr->cnt == 0) {
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
      BSI_WriteIDUD(bsi_num,ch_ptr,FALSE);
      continue;
    }

#ifdef __FDDI_CON
    LED_SetInterfaceLED(bsi_num);  /* flicking LED */
#endif

    MEM_SetChPsp(bsi_num,1,ch_ptr,BSI_INDCH2,FALSE);
    BSI_WriteIDUD(bsi_num,ch_ptr,FALSE);

    fl = d_ptr->loc & BSI_ADDRFL_MASK;
    addr = (uint32) BSI2CPU(d_ptr->loc & BSI_ADDR28);
    INC_PKT_CNT(addr);  /* increment the pkt cnt */

    /* get PKT header & link the driver free function */
#if FS_PERFROM
    if (pkt_ptr = (PKT *)GetPkt()) {
#endif
/********* FS_PERFORM ****************/
	if( pkt_ptr = FreePktHead ) {
		FreePktHead = (PKT *)pkt_ptr->pktMsgHdr.mh_link;
		pkt_ptr->pktUseCount = 1;
		pkt_ptr->pktBufLink = NULL;
		pkt_ptr->pktFree = (void *)FreeThisPktBuf;
		pkt_ptr->pktXmtPort = 0;
/************************************/
		pkt_ptr->pktDriverFree = MEM_FreePSPBuf;
		pkt_ptr->pktDriverInfo = (unsigned) addr;
    }
    else {  /* no PKT, return */
      MEM_FreePSPBuf(addr);
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      (ifcntrs + bsi_num)->inDiscards++;
      return NULL;
    }

    /* check the rx frame status. don't pass it up if error occured */
    if (fl & BSI_LAST) {
      if (BSI_ChkIdudStatus(d_ptr,BSI_LLC_FRAME) != OK) {
#if DRV_DEBUG
	printf("MON idud frame status error, db_buf %x, %x\n",addr,((GENERIC_DESC_TYPE *)d_ptr)->w0);
#endif
        pkt_ptr->pktFree(pkt_ptr);
	NULLIFY_DESC2ND(d_ptr);
	NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
	NEXT_QSLOT_ADDR(psp_q->qp);
	continue;
      }
    }

    pkt_ptr->pktRcvPort = bsi_num;
    /* the rcv frame is good, process it */
    if (fl == BSI_ONLY) {  /* most case */
      /* point to MAC header */
      pkt_ptr->pktBufPtr = pkt_ptr->pktDataPtr = (char *)(addr) + 1;  
      pkt_ptr->pktTotalSize = pkt_ptr->pktDataSize = d_ptr->cnt - 1 - FDDI_FCS_BYTES;
    }
    else {
      pkt_ptr->pktFree(pkt_ptr);
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      continue;  /* continue until all the fragment pkt are done */
    }

    NULLIFY_DESC2ND(d_ptr);
    NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
    NULLIFY_DESC2ND(psp_q->qp);
    psp_q->psp_count--;
#endif
    NEXT_QSLOT_ADDR(psp_q->qp);
#if 0
    /* Is the frame sent by me? no pkt more than 4k will be sent by me */
    if (DRV_IsMyFDDINid(pkt_ptr->pktDataPtr+6,bsi_num)) {
      pkt_ptr->pktFree(pkt_ptr);  /* free PKT */
      continue;  
    }
#endif
    (ifcntrs + bsi_num)->inucastpkts++;
    (ifcntrs + bsi_num)->inbytecnt += pkt_ptr->pktTotalSize;
#if NOSAR
    swap_bits(pkt_ptr->pktDataPtr,6);
    swap_bits(pkt_ptr->pktDataPtr+6,6);
#endif
    return (pkt_ptr);
  }  /* while */
}

/*****************************************************************************
 *  Function    DRV_ClearParityCheck
 *
 *  Description
 *      This function resets FDDI chip set to do the parity checking
 *
 *  Parameter:  none
 *
 *  Return: void
 ***************************************************************************/
void DRV_ClearParityCheck ()
{
    int i;

    for (i=0; i < fddi_board.bsi_num; i++) {
        BSIREG_DisableParity(i);
        BMAC_DisableParity(i);
    }
}
 

/*****************************************************************************
 *  Function    DRV_SendFrame
 *
 *  Description
 *      This function takes the tx frames which passed from upper
 *      layers and puts it to the REQ & ODUD. It will always send
 *      to REQ channel 0 unless it is full. Note that this function expects
 *      FC and DA are already being put in. It is also expectd that the SA
 *      field is reserved. Also note that the DBD buffer size is 4096 bytes.
 *      If a frame is bigger than 4096, this function will copy it to 2 DBDs.
 *
 *  Parameters:
 *      DBD *ptr
 *      uint16 mac_num
 *      byte action - how to send this frame
 *              [DRV_REQ_RQCLS_NONE |	 None 
 *              DRV_REQ_RQCLS_APR1  |	Async Priority 1   
 *              DRV_REQ_RQCLS_APR2  |	Async Priority 2 
 *		DRV_REQ_RQCLS_APR3  |	Async Priority 3 
 *		DRV_REQ_RQCLS_SYN   |	Sync 
 *		DRV_REQ_RQCLS_IMM   |	Immediate, issue no token 
 *		DRV_REQ_RQCLS_IMMN  |	Immediate, issue non-restrict tok 
 *		DRV_REQ_RQCLS_IMMR  |	Immediate, issue restricted token 
 *		DRV_REQ_RQCLS_ASYN  |	Async 
 *		DRV_REQ_RQCLS_RBEG  |	Restricted Begin 
 *		DRV_REQ_RQCLS_REND  |	Restricted End 
 *		DRV_REQ_RQCLS_RCNT  |	Restricted Continue 
 *		DRV_REQ_RQCLS_ASYND |	Async without THT 
 *		DRV_REQ_RQCLS_RBEGD |	Restricted Begin without THT 
 *		DRV_REQ_RQCLS_RENDD |	Restricted End without THT 
 *		DRV_REQ_RQCLS_RCNTD ]	Restricted Continue with THT 
 *              
 *  Return: [OK | DRV_TX_MAC_STOP | DRV_TX_BSI_BUSY | DRV_TX_ILLEGAL_PARAM]
 *          FDDI_ERROR the frame is not sent out. OK if the frame is
 *          put into the BSI chip.
 *****************************************************************************/
int DRV_TxFrame (dbdp,mac_num,action)
DBD *dbdp;
uint32 mac_num;
uint32 action;
{
  PKT *pktp, *pktp1;
  int result;

  if (dbdp->db_idmark != DBD_MARK) {
    DebugStrBreak("tx pkt is not in dbd: %x\n",dbdp);
    return (ERR_DBD);
  }
  pktp = MEM_GetPkt();
  if (!pktp) {
    printf("no pkt\n");
    return (0x60);
  }
  /* copy FDDI header */
  memcpy(pktp->pktBufPtr,dbdp->db_buffer,dbdp->db_indent+13);
  pktp->pktDataSize = 13;
  pktp->pktDataPtr = pktp->pktBufPtr + dbdp->db_indent;

  pktp1 = MEM_GetPkt();
  if (!pktp1) {
    printf("no pkt 1\n");
    pktp->pktFree(pktp);
    return (0x61);
  }

  /* copy info field to the 2nd chain PKT */
  pktp1->pktDataSize = dbdp->db_actcnt - 13;
  memcpy(pktp1->pktBufPtr,dbdp->db_buffer+dbdp->db_indent+13,pktp1->pktDataSize);
  pktp1->pktDataPtr = pktp1->pktBufPtr;
  pktp->pktBufLink = pktp1;
#if 0
    enter_debug(0x765,dbdp,pktp,pktp1);
#endif
  result = DRV_SendFrame(pktp,mac_num,action);
  FreePktBuf(pktp);  /* so it frees the entire chain */

  return (result);
}

int DRV_SendFrame (pktp,mac_num,action)
PKT *pktp;
uint32 mac_num;
uint32 action;
{
    BSI_REQCH_TYPE *ch_ptr;
    PKT *pkt_tmp;

    if (!MACActive[mac_num])   /* if mac is disabled */
      return OK;
  
    if (mac_num >= fddi_board.bsi_num) {
      (ifcntrs + mac_num)->outdiscardpkts++;
#if DRV_DEBUG
      printf("ERROR: illegal mac num %d to send frame\n",mac_num);
#endif
      return OUT_OF_RANGE;
    }

    ch_ptr = (bsi_dev+mac_num)->rch0;
    /* check whether REQ full or not */
    if (ch_ptr->info_ptr->queued_cnt >= BSI_QUEUE_MAX_SLOT) {
      if (get_debug() == DEBUG_ON)
	printf("req 0 full: %d\n",ch_ptr->info_ptr->queued_cnt);
        ch_ptr = (bsi_dev+mac_num)->rch1;
        if (ch_ptr->info_ptr->queued_cnt >= BSI_QUEUE_MAX_SLOT) {
          return ERR_NORSRC;     /* both queues full */
	}
    }

    for (pkt_tmp = pktp; pkt_tmp; pkt_tmp = pkt_tmp->pktBufLink)
      pkt_tmp->pktUseCount += 1;  

    return (BSI_SendReq(action,mac_num,ch_ptr,pktp,TRUE));
}

int drvsendcnt = 0;
#ifdef __FEBRIDGE
/* version of send routine that does NOT bump use count (db_contrl) */
int DRV_SendFrameBr (ptr,action)
PKT *ptr;
uint32 action;
{
    BSI_REQCH_TYPE *ch_ptr;
    uint32 ch_num;
#define	BR_MAC_NUM	0		/* fddi-eth bridge only has one MAC */

#if JWJ
    int retn;
    volatile char dummy;
    drv_tx_cnt++;
    dummy  = *ptr_d0;
#endif

    ch_ptr = bsi_dev->rch0;
    if (ch_ptr->info_ptr->queued_cnt >= BSI_QUEUE_MAX_SLOT) {
      ch_ptr = bsi_dev->rch1;
      if (ch_ptr->info_ptr->queued_cnt >= BSI_QUEUE_MAX_SLOT) {
	FreePktBuf(ptr);
#if JWJ
	drv_free_cnt += 2;
	drv_drop_cnt++;
	dummy = *ptr_d8;
#endif
	return ERR_NORSRC;     /* both queues full */
      }
    }
    drvsendcnt++;
#if JWJ
  dummy = *ptr_dc;
  retn = BSI_SendReq(action, BR_MAC_NUM,ch_ptr,ptr,TRUE);
  dummy = *ptr_d4;
  return (retn);
#else
  return (BSI_SendReq(action,BR_MAC_NUM,ch_ptr,ptr,TRUE));
#endif
}
#endif

 
/***************************************************************************
 *  Function   DRV_Reset
 *
 *  Description
 *    This function is called before reset(). It does all the things need
 *    to be done.
 *
 *  Parameter:  none
 *
 *  Return: void
 ***************************************************************************/
void DRV_Reset ()
{
  int i;

  for (i = 0; i < fddi_board.phy_num; i++) {  /* isolate all the PHYs */
    PHY_TxSymbols(i,DRV_QUIET_LS);
    PHY_Isolate(i);
  }
}

/***************************************************************************
 *  Function    DRV_ResetLANChips
 *
 *  Description
 *      This function put all the FDDI chkpset to known state.
 *
 *  Parameter: none
 *
 *  Return: void
 **************************************************************************/
void DRV_ResetLANChips ()
{
    volatile byte *ptr = (byte *)FDDI_LANRST_REG;
    uint32 i;

#ifdef __FEBRIDGE
	set_ctrl1(0x0001, 0x0000); 		/* reset LAN 0 (fddi) */
    i = RealTimeTicks() + 40;
    while (RealTimeTicks() < i);
	set_ctrl1(0x0001, 0x0001); 		/* enable LAN 0 (fddi) */
#else
    *ptr = 0;
    i = RealTimeTicks() + 40;
    while (RealTimeTicks() < i);
    *ptr = 0xff;
#endif
}


/***************************************************************************
 *  Function    DRV_InitFddiCon
 *
 *  Description
 *      This function reads the fddi concentrator board revision ID, and
 *      then fills in the data structure.
 *      THIS IS A TEMPORARY FUNCTION.
 *      ALL THE FIELDS IN THIS DATA STRUCTURE SHOULD BE GET FROM THE MIB
 *      OR GET FROM THE SMT MODULE.
 *
 *  Parameter:  none
 *
 *  Return: void
 *************************************************************************/
void DRV_InitFddiCon ()
{
  if (get_drv_mib)
    return;

  InitSMTMib();    /* initialize SMT MIB */
  /* go get driver needed mibs */
  MIB_InitDrvMibs(&init_mibs);
  get_drv_mib = TRUE;
#if 0
  {
    int i;
    DRV_FDDI_MIBS *ptr;

    for (i=0; i < 2; i++) {
      ptr = &(init_mibs.d_mib[i]);
      printf("rx cnt %x\n",ptr->macFrameRxCount);
      printf("err cnt %x\n",ptr->macErrIsolateCount);
      printf("lost cnt %x\n",ptr->macLostFrameCount);
      printf("cp cnt %x\n",ptr->macFrameCopiedCount);
      printf("not cp cnt %x\n",ptr->macFrameNotCopiedCount);
      printf("tx cnt %x\n",ptr->macFrameTxCount);
      printf("token cnt %x\n",ptr->macTokenRxCount);
      printf("latency cnt %x\n",ptr->macRingLatencyCount);
      printf("late cnt %x\n\n",ptr->macLateCount);

    }
  }
#endif

  fddi_board.type =  init_mibs.board_id;
  fddi_board.bsi_num = init_mibs.mac_num;
  fddi_board.bmac_num = init_mibs.mac_num;
  fddi_board.phy_num = init_mibs.port_num;
  fddi_board.inactive_bsi = PRIMARY_MAC;
  fddi_board.active_bsi = SECONDARY_MAC;
}

/*
 *---------------------------------------------------------------------------
 *          Local Functions
 *---------------------------------------------------------------------------
 */



/***************************************************************************
 *  Function    DetailPathTest
 *
 *  Description
 *      This function do a path test on each individual chip and store the
 *      the failure info.
 *
 *  Parameter:  none
 *
 *  Return: [TRUE | FALSE]
 **************************************************************************/
static bool DetailPathTest ()
{
    int i;

    /* do BMACs internal loopback test */
    for (i=0; i < fddi_board.bsi_num; i++) {
        if (BMAC_InternalLBTest(i) != OK) {
            PathTestFail(PATH_TEST_MAC_FAIL);
            return (FALSE);
        }
    }
    
    /*********
         MACs are fine, do the phys path test
    **********/
    /*--- test port B and backplane port B with MAC 0 */
    PHY_Wrap(PORT_B);
    PHY_Wrap(fddi_board.bkport0);
    if (BMAC_TestClaim(BMAC_0,DRV_10MSEC) != OK) {
        PathTestFail(PORT_B);
        return (FALSE);
    }
    
    /*--- isolate backlane port B to test all the M ports --------*/     
    PHY_Isolate(fddi_board.bkport0);
    for (i = PORT_M5; i >= PORT_M2; i--) {
        PHY_Wrap(i);
        if (BMAC_TestClaim(BMAC_0,DRV_10MSEC * (PORT_M5+2-i)) != OK){
            PathTestFail(i);
            return (FALSE);
        }
        PHY_Isolate(i);
    }

    PHY_Wrap(fddi_board.bkport1);     /* test back plane port A */
    if (BMAC_TestClaim(BMAC_0,DRV_10MSEC * 5) != OK){
        PathTestFail(fddi_board.bkport1);
        return (FALSE);
    }

    PHY_Wrap(PORT_A);   /* test port A and MAC A */
    if (BMAC_TestClaim(BMAC_1,DRV_10MSEC) != OK) {
        PathTestFail(PORT_A);
        return (FALSE);
    }

    return (TRUE);
}
 

void PathTestFail (reason)
uint32 reason;
{

}

/***************************************************************************
 *  Function    ResetMac
 *
 *  Description
 *      This function resets both BSI and BMAC.
 *
 *  Parameters:
 *      mac_num - the number of the bmac to reset
 *
 *  Return: [OK | FDDI_ERROR]
 *************************************************************************/
static status_type ResetMac (mac_num)
uint32 mac_num;
{
  if (BSI_GetBSIMode(mac_num) == DRV_STOP)  /* if bsi is stopped */
    BSIREG_BsiRun(mac_num);

  BMAC_Reset(mac_num);
  BMAC_StartBmac(mac_num);
    
  return (OK);
}




























