/***************************************************************************
 *  File    fddi_isr.c
 *
 *  Description
 *      This file is the fddi concentrator interrupt handler.
 *
 *  Copyright (c) 1992, 1993 Hughes Lan Systems
 *
 *  Author: Jia-wei Jang
 **************************************************************************/

#include <drv.h>
#include <bsi.h>
#include <drv_timer.h>
#ifdef __FEBRIDGE
#include <phy.h>
#include <bmac.h>
#endif
 
/****
interrupt register bit map. The interrupts are active low
****/
#define DRV_INT_11      0X8000      /* PHY A */
#define DRV_INT_10      0X4000      /* PHY B */
#define DRV_INT_9       0X2000      /* BSI B */
#define DRV_INT_8       0X1000      /* BSI A */
#define DRV_INT_7       0X0800      /* PHY 7 */
#define DRV_INT_6       0X0400      /* PHY 6 */
#define DRV_INT_5       0X0200      /* PHY 5 */
#define DRV_INT_4       0X0100      /* PHY 4 */
#define DRV_INT_3       0X0080      /* PORT B */
#define DRV_INT_2       0X0040      /* PORT A */
#define DRV_INT_1       0X0020      /* MAC B - MAC 0 */
#define DRV_INT_0       0X0010      /* MAC A - MAC 1 */
#define DRV_CDINT       0X0008      /* ADMINBUS */
#define DRV_SCCINT      0X0004      /* SCC */
#define DRV_TMOUT1      0X0002      /* TIMER 1 */
#define DRV_TMOUT0      0X0001      /* TIMER 0 */
#define DRV_TMOUT2      0           /* TIMER 2 */
#define DRV_INT_MASK    0XFFFF      /* NO INTERRUPT */

#if 1
int isr_test_flag = 0;
#endif


#ifdef __FEBRIDGE
extern PLAYER_TYPE phys[PHY_MAX_PORTS];
extern BMAC_TYPE bmacs[BMAC_MAX];
extern BSI_TYPE bsis[BSI_MAX];
/****************************************************************

	PlayerIntHandler  -  PLAYER interrupt handler

	This routine catches PLAYER (level 6) interrupts, finds out
	which player interrupted (by polling the ICRs in the players),
	and calls the guilty party's interrupt service routine.

****************************************************************/
PlayerIntHandler()
{
	register word saveMask;
    volatile PHY_REG_TYPE *r_ptr;
    PHY_CTRL_TYPE *i_ptr;

    
	MaskAllInts(saveMask);

    r_ptr = phys[0].base_addr;		/* phy 0 base addr */
    i_ptr = phys[0].image_ptr;		/* phy 0 image ptr */
	/* if any bits in the ICR are 1, and the corresponding bit in
		the mask reg is set, then he wants service */
    if( r_ptr->icr & i_ptr->icmr )	/* if this guy is trying to int. */
        PHY_Isr(0);
    
    r_ptr = phys[1].base_addr;		/* phy 1 base addr */
    i_ptr = phys[1].image_ptr;		/* phy 1 image ptr */
    if( r_ptr->icr & i_ptr->icmr )	/* if this guy is trying to int. */
        PHY_Isr(1);
    
	clear_ipnd(1 << 6);    /* clr level 6 bit in int pending reg (SF0) */
	RestoreIntMask(saveMask);
}


/****************************************************************

	MacBsiIntHandler  -  MAC/BSI interrupt handler

	This routine catches MAC/BSI (level 5) interrupts, finds out
	which device interrupted (by polling the ICR in the MAC and
	the MAR in the BSI),
	and calls the guilty party's interrupt service routine.

****************************************************************/
MacBsiIntHandler()
{
	register word saveMask;
    volatile BMAC_REG_TYPE *r_ptr;
    BMAC_CTRL_TYPE *i_ptr;
    volatile BSI_REG_TYPE *br_ptr;
    BSI_CTRL_TYPE *bi_ptr;

	MaskAllInts(saveMask);

    r_ptr = bmacs[0].reg_base;		/* bmac 0 base addr */
    i_ptr = bmacs[0].image_ptr;		/* bmac 0 image ptr */
	/* if any bits in the ICR are 1, and the corresponding bit in
		the mask reg is set, then he wants service */
    if( r_ptr->icr & i_ptr->imr )	/* if this guy is trying to int. */
        BMAC_Isr(BMAC_B);
#if 0 
    /* changed it to polling, it is polled at chnl_poll() */
    br_ptr = bsis[0].base_addr;		/* bsi 0 base addr */
    bi_ptr = bsis[0].image_ptr;		/* bsi 0 image ptr */
    if( br_ptr->mar & bi_ptr->mnr )	/* if this guy is trying to int. */
        BSI_Isr(BSI_B);
#endif
	clear_ipnd(1 << 5);    /* clr level 5 bit in int pending reg (SF0) */
	RestoreIntMask(saveMask);
}
/* Dummy to satisfy unexecuted reference in drv_israsm.s (because 
	the assembler does NOT support conditional asembly). */
void FDDI_Isr (){}

#else			/* concentrator */

/***************************************************************************
 *  Function    FDDI_Isr
 *
 *  Description
 *      This function reads the interrupt register and dispatch
 *      to the appropriate interrupt service routine.
 *
 *  parameter:  none
 *
 *  Return: void
 **************************************************************************/
void FDDI_Isr ()
{
    extern volatile unsigned short *int_reg;
    unsigned short val;
    long s;

    s = crit_on();
    val = *int_reg;			/* read int reg to see who interrupted us */
    /* all the PHYs interrupt are tied up with int3_ */

    if (~val & DRV_INT_11) {
        PHY_Isr(PORT_MASTER_BA);
    }
    if (~val & DRV_INT_10) {
        PHY_Isr(PORT_MASTER_BB);
    }
    if (~val & DRV_INT_7) {
        PHY_Isr(PORT_M2);
    }
    if (~val & DRV_INT_6) {
        PHY_Isr(PORT_M3);
    }
    if (~val & DRV_INT_5) {
        PHY_Isr(PORT_M4);
    }
    if (~val & DRV_INT_4) {
        PHY_Isr(PORT_M5);
    }
	/* swap DRV_INT_3 and DRV_INT_2 */
    if (~val & DRV_INT_2) {
       PHY_Isr(PORT_B);
    }
    if (~val & DRV_INT_3) {
        PHY_Isr(PORT_A);
    }

#if 0
    /* poll them */
    if (~val & DRV_INT_9) {   
        BSI_Isr(BSI_B);
	int_5 = TRUE;
    }    
    if (~val & DRV_INT_8) {
        BSI_Isr(BSI_A);
	int_4 = TRUE;
    }

    if (~val & DRV_INT_1) {
        BMAC_Isr(BMAC_B);
	int_5 = TRUE;
    }
    if (~val & DRV_INT_0) {
        BMAC_Isr(BMAC_A);
	int_4 = TRUE;
    }
    if (int_4)
      clear_ipnd(1 << 4);    /* int 3 is level triggered */
    if (int_5)
      clear_ipnd(1 << 5);    /* int 3 is level triggered */

#endif

    clear_ipnd(1 << 3);    /* int 3 is level triggered */

    crit_off(s);
}
/* Dummies to satisfy unexecuted references in drv_israsm.s (because 
	the assembler does NOT support conditional asembly). */
PlayerIntHandler(){}		
MacBsiIntHandler(){}
#endif		/* __FEBRIDGE */
