/**************************************************************************
 *  File                    drv_tbl.c
 *
 *  Description
 *      This file contains all the initial value for the BSIs, BMACs, and
 *      PLAYERs chips on the FDDI Concentrator Master and Expansion board
 *
 *  Copyright (c) 1992, 1993 Hughes Lan Systems
 *
 *  Author: J. Jang
 *
 *  $Log:   /user/pvcs/fddicon/drv/src/drv_tbl.c_v  
 * 
 *    Rev 1.52.1.7   12 Oct 1993 11:12:40   gregs
 * No change.
 * 
 *    Rev 1.52.1.6   08 Oct 1993 13:32:22   gregs
 * Turned of the EMIND bit in the BMAC for the bridge initialization.
 * 
 *    Rev 1.52.1.5   29 Sep 1993 13:30:02   gregs
 * No change.
 * 
 *    Rev 1.52.1.4   21 Sep 1993 10:45:22   jang
 * integrated with concentrator code 
 * 
 *    Rev 1.52.1.2   02 Aug 1993 15:10:38   gregs
 * Added 3 extra PHY default tables. Changed the BSI ACR such that the BSI will
 * perform MAC address bitswapping.
 * 
 *    Rev 1.52.1.1   02 Aug 1993 14:46:52   jang
 * change bsi.acr
 * 
 *    Rev 1.52.1.0   28 Jul 1993 13:38:42   jang
 * checked in so it can be backup to the tape. ch 1 & 2 are working
 * 
 *    Rev 1.52   28 Jun 1993 09:01:54   gregs
 * Changed ICR for fddi-eth bridge.
 * 
 *    Rev 1.51   16 Jun 1993 10:44:48   jang
 * enabled token overflow counter BMAC_COMR_TKRCVD
 * 
 *    Rev 1.50   12 Jun 1993 14:06:40   jlin
 * deleted BMAC_OR_EMIND
 * 
 *    Rev 1.49   08 Jun 1993 08:09:02   jang
 * changed ch 0 to promiscuous mode
 * 
 *    Rev 1.48   07 Jun 1993 17:43:30   jang
 * changed bsi to polling
 * 
 *    Rev 1.41   05 May 1993 14:49:38   jang
 * reset the BMAC OR.IRR bit
 * 
 *    Rev 1.40   19 Apr 1993 14:49:44   jang
 * took out #if 0 to make code easier to read
 * 
 *    Rev 1.39   12 Apr 1993 12:52:36   gregs
 * fddi--eth bridge buffer counts in bsi_master_default
 * 
 *    Rev 1.38   12 Apr 1993 08:25:14   gregs
 * fix typo in bsi_master_default.
 * 
 *    Rev 1.37   10 Apr 1993 16:18:50   jang
 * added new default to config BSI ICR in boot
 * 
 *    Rev 1.36   05 Apr 1993 11:54:02   jang
 * set ch 0 psp desc to 0 when doing boot
 * 
 *    Rev 1.35   05 Apr 1993 08:24:50   jang
 * took out the PLAYER default table phy_master_table[]
 * 
 *    Rev 1.34   25 Mar 1993 08:24:54   gregs
 * #ifdefs for bridge bsi and mac master default tables.
 * 
 *    Rev 1.33   24 Mar 1993 18:42:46   jlin
 * 
 *    Rev 1.32   19 Mar 1993 11:27:26   gregs
 * GJS  -  To make common src with fddi-eth bridge
 * 
 *    Rev 1.31   19 Mar 1993 10:30:48   jang
 * added bridge default table
 * 
 *    Rev 1.30   09 Mar 1993 17:27:48   jang
 * added player+
 * 
 *    Rev 1.29   09 Mar 1993 15:55:30   jang
 * added player plus default table
 * 
 *    Rev 1.28   05 Mar 1993 10:08:32   jang
 * added psp default value to boot code
 * 
 *    Rev 1.27   01 Mar 1993 15:27:50   jang
 * deleted the token counter overflow interrupt from init table.
 * 
 *    Rev 1.26   21 Feb 1993 12:31:38   jang
 * changed BSI default init value of ACR & ICR
 * 
 *    Rev 1.25   19 Feb 1993 18:03:18   jang
 * changed BSI IAR initialization value
 * 
 *    Rev 1.24   12 Feb 1993 10:29:58   jlin
 * 
 *    Rev 1.23   09 Feb 1993 18:10:20   jang
 * changed the bmac TEMR0 default value
 * 
 *    Rev 1.22   04 Feb 1993 19:21:08   jang
 * all the debug printf are gone
 * 
 *    Rev 1.21   26 Jan 1993 11:27:04   jang
 * changed the bsi default table. both ind ch 2 have psps for monitoring rx 
 * frames
 * 
 *    Rev 1.20   19 Jan 1993 15:05:56   jang
 * 
 *    Rev 1.19   11 Jan 1993 15:27:50   jang
 * modified the default value of SNR, no attention should be generated
 * for ptop and lmop. Both of them will be polled
 * 
 *    Rev 1.18   07 Jan 1993 18:56:30   jang
 * added backplane phy default table
 * 
 *    Rev 1.17   07 Jan 1993 18:23:06   jang
 * modified bsi_default_table, deleted mr0_reset
 * 
 *    Rev 1.16   07 Jan 1993 09:39:14   jang
 * changed some default value
 *************************************************************************/

#include <fddi.h>
#include <drv.h>
#include <bsi.h>
#include <bmac.h>
#include <phy.h>


/*
 *------------------------------------------------------------------------
 *          PLAYERS
 *  number based on SMT ports number
 *------------------------------------------------------------------------
 */

PHY_INIT_TYPE phy_masplus_default[MAX_PORT_COUNT] = {
    {   /* SMT port 0 */
        (PHY_REG_TYPE*)PLAYER_PLUS_A_BASE,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_1,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 1 */
        (PHY_REG_TYPE*)PLAYER_PLUS_B_BASE,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 2 */
      (PHY_REG_TYPE*)PLAYER_PLUS_AB_BASE,
	PHY_ID_PLAYERPLUS,
      BMAC_UNKNOWN,
      DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 3 */
        (PHY_REG_TYPE*)PLAYER_PLUS_7_BASE,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_UNKNOWN,               /* not attach to any mac */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 4 */
        (PHY_REG_TYPE*)PLAYER_PLUS_6_BASE,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_UNKNOWN,               /* not attach to any mac */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 5 */
        (PHY_REG_TYPE*)PLAYER_PLUS_5_BASE,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_UNKNOWN,               /* not attach to any mac */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 6 */
        (PHY_REG_TYPE*)PLAYER_PLUS_4_BASE,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_UNKNOWN,               /* not attach to any mac */
        DRV_MODE_STOP               /* status */
    },
    
    {       /* backplane port  7 */
        (PHY_REG_TYPE*)PLAYER_PLUS_BB_BASE,    /* base_addr */
	PHY_ID_PLAYERPLUS,
         BMAC_UNKNOWN,                       /* attach to MAC B */
         DRV_MODE_STOP                 /* status */
    }
};

PHY_INIT_TYPE phy_br_default[4] = {
    {   /* SMT port 0 */
        (PHY_REG_TYPE*)PLAYP_A_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 1 */
        (PHY_REG_TYPE*)PLAYP_B_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 2 */
        (PHY_REG_TYPE*)PLAYP_AB_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 3 */
        (PHY_REG_TYPE*)PLAYP_BB_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    }
};


#ifdef __FEBRIDGE
 
PHY_INIT_TYPE phy_br_default_AB2BP[4] = {
    {   /* SMT port 0 */
        (PHY_REG_TYPE*)PLAYP_AB_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 1 */
        (PHY_REG_TYPE*)PLAYP_BB_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 2 */
        (PHY_REG_TYPE*)PLAYP_A_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 3 */
        (PHY_REG_TYPE*)PLAYP_B_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    }
};

PHY_INIT_TYPE phy_br_default_A2BP[4] = {
    {   /* SMT port 0 */
        (PHY_REG_TYPE*)PLAYP_AB_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 1 */
        (PHY_REG_TYPE*)PLAYP_B_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 2 */
        (PHY_REG_TYPE*)PLAYP_A_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 3 */
        (PHY_REG_TYPE*)PLAYP_BB_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    }
};

PHY_INIT_TYPE phy_br_default_B2BP[4] = {
    {   /* SMT port 0 */
        (PHY_REG_TYPE*)PLAYP_A_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 1 */
        (PHY_REG_TYPE*)PLAYP_BB_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 2 */
        (PHY_REG_TYPE*)PLAYP_AB_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 3 */
        (PHY_REG_TYPE*)PLAYP_B_BASE_BR,  /* base_addr */
	PHY_ID_PLAYERPLUS,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    }
};

#endif

 
#if 0
PHY_INIT_TYPE phy_master_default[MAX_PORT_COUNT] = {
    {   /* SMT port 0 */
        (PHY_REG_TYPE*)PHY_A_BASE,  /* base_addr */
	PHY_ID_PLAYER,
        BMAC_1,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 1 */
        (PHY_REG_TYPE*)PHY_B_BASE,  /* base_addr */
	PHY_ID_PLAYER,
        BMAC_0,                     /* mac # attached */
        DRV_MODE_STOP               /* status */
    },

    {       /* backplane port A */
      (PHY_REG_TYPE*)PHY_AB_BASE,
	PHY_ID_PLAYER,
      BMAC_UNKNOWN,
      DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 2 */
        (PHY_REG_TYPE*)PHY_7_BASE,  /* base_addr */
	PHY_ID_PLAYER,
        BMAC_UNKNOWN,               /* not attach to any mac */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 3 */
        (PHY_REG_TYPE*)PHY_6_BASE,  /* base_addr */
	PHY_ID_PLAYER,
        BMAC_UNKNOWN,               /* not attach to any mac */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 4 */
        (PHY_REG_TYPE*)PHY_5_BASE,  /* base_addr */
	PHY_ID_PLAYER,
        BMAC_UNKNOWN,               /* not attach to any mac */
        DRV_MODE_STOP               /* status */
    },

    {   /* SMT port 5 */
        (PHY_REG_TYPE*)PHY_4_BASE,  /* base_addr */
	PHY_ID_PLAYER,
        5,                          /* UI port number */
        BMAC_UNKNOWN,               /* not attach to any mac */
        DRV_MODE_STOP               /* status */
    },
    
    {       /* backplane port  B */
        (PHY_REG_TYPE*)PHY_BB_BASE,    /* base_addr */
	PHY_ID_PLAYER,
         BMAC_UNKNOWN,                       /* attach to MAC B */
         DRV_MODE_STOP                 /* status */
    }
};
#endif


/*
 *------------------------------------------------------------------------
 *          initialization value for FDDI concentrators
 *------------------------------------------------------------------------
 */
PHY_DEFAULT_TABLE phycon_deftbl = {
    PHY_MR_TE,
    PHY_ICMR_RCAM | PHY_ICMR_RCBM,        /* icmr */
    PHY_CTSR_OTM | PHY_CTSR_SE,             /* ctsr */
    0,                                      /* ijtr */
    0,                                      /* isra */
    0,                                      /* isrb */
    /* according to National, only set these 3 bits, don't set LSC */
    PHY_RCMRA_QLSM | PHY_RCMRA_HLSM | PHY_RCMRA_MLSM,
    0,                                      /* rcmrb */
    PHY_NTR_DEFAULT,                        /* ntr */
    PHY_NPTR_DEFAULT,                       /* nptr */
    PHY_STR_DEFAULT,                        /* str */
    PHY_SPTR_DEFAULT                        /* sptr  */
};

PHY_DEFAULT_TABLE phycon_bkp_deftbl = {
    PHY_MR_TE,
    0,                                      /* icmr */
    PHY_CTSR_OTM | PHY_CTSR_SE,             /* ctsr */
    0,                                      /* ijtr */
    0,                                      /* isra */
    0,                                      /* isrb */
    0,                                      /* rcmra */
    0,                                      /* rcmrb */
    PHY_NTR_DEFAULT,                        /* ntr */
    PHY_NPTR_DEFAULT,                       /* nptr */
    PHY_STR_DEFAULT,                        /* str */
    PHY_SPTR_DEFAULT                        /* sptr  */
};

/*
 *------------------------------------------------------------------------
 *          initialization value for FDDI bridge
 *------------------------------------------------------------------------
 */
PHY_DEFAULT_TABLE phybr_deftbl = {
    PHY_MR_TE,
    PHY_ICMR_RCAM | PHY_ICMR_RCBM,        /* icmr */
    PHY_CTSR_OTM | PHY_CTSR_SE,             /* ctsr */
    0,                                      /* ijtr */
    0,                                      /* isra */
    0,                                      /* isrb */
    PHY_RCMRA_QLSM | PHY_RCMRA_HLSM | PHY_RCMRA_MLSM,
    0,                                      /* rcmrb */
    PHY_NTR_DEFAULT,                        /* ntr */
    PHY_NPTR_DEFAULT,                       /* nptr */
    PHY_STR_DEFAULT,                        /* str */
    PHY_SPTR_DEFAULT                        /* sptr  */
};


 
/*
 *------------------------------------------------------------------------
 *          BMACs
 *  MAC A which connects to port A is numbered as mac 1;
 *  MAC B which connects to port B is numbered as mac 0.
 *------------------------------------------------------------------------
 */

BMAC_INIT_TYPE bmacs_master_default[BMAC_MAX] = {
#ifdef __FEBRIDGE		/* FDDI-Eth bridge */
    {       /* mac 0 */
     (BMAC_REG_TYPE *)BMAC_B_BASEADDR_BR,   /* reg_base */
     BMAC_B,                                /* mac # */
     INTERNAL_BEACON,                       /* BeaconType */
     DRV_MODE_STOP                          /* status */
    }
#else					/* concentrator */
    {       /* mac 0 */
     (BMAC_REG_TYPE *)BMAC_B_BASEADDR,      /* reg_base */
     BMAC_B,                                /* mac # */
     INTERNAL_BEACON,                       /* BeaconType */
     DRV_MODE_STOP                          /* status */
    },
     
    {   /* mac 1 */
     (BMAC_REG_TYPE *)BMAC_A_BASEADDR,      /* reg_base */
     BMAC_A,                                /* mac # */
     INTERNAL_BEACON,                       /* beacon type */
     DRV_MODE_STOP                          /* status */
    }           
#endif
};

/*
 *------------------------------------------------------------------------
 *          default initialization table for fddi master concentrator 
 *------------------------------------------------------------------------
 */
BMAC_DEFAULT_TABLE bmaccon_default_table = {
    ~BMAC_MR_RUN & ~BMAC_MR_ILB & ~BMAC_MR_DIAG & BMAC_MR_RES
                    & ~BMAC_MR_PIP & ~BMAC_MR_MRP & ~BMAC_MR_CBP,   /* mr */
     BMAC_OR_ELA,      /* OR */
     BMAC_FR_MARST,     /* fr */
     0,
     BMAC_REMR1_OTRBCN | BMAC_REMR1_MYBCN | BMAC_REMR1_MYCLM,
#if 0
     BMAC_TEMR0_ENTRMD | BMAC_TEMR0_TVXEXP | BMAC_TEMR0_TRTEXP  /* temr0 */
         | BMAC_TEMR0_DUPTKR | BMAC_TEMR0_CBERR | BMAC_TEMR0_TKCAPT,
#endif
     BMAC_TEMR0_CBERR | BMAC_TEMR0_ENTRMD,   /* smt code only process this interrupt */
    0,      /* cimr - always 0 */
#if 0
    /* comment out for testing only */
    BMAC_COMR_FRRCV | BMAC_COMR_FREI | BMAC_COMR_FRLST | BMAC_COMR_FRCOP | 
        BMAC_COMR_FRNCOP | BMAC_COMR_FRTRX /* | BMAC_COMR_TKRCVD */,  /* comr */
#else
      /* take out the frame lost overflow. Because when all the phys are
	 isolated, we keep getting frame lost interrupt. May be SMT should
	 let the driver know when to enable frame lost overflow interrupt*/
    BMAC_COMR_FRRCV | BMAC_COMR_FREI | BMAC_COMR_FRCOP | 
        BMAC_COMR_FRNCOP | BMAC_COMR_FRTRX | BMAC_COMR_TKRCVD,  /* comr */
#endif
    ~BMAC_EMR_CWI & ~BMAC_EMR_CCE & ~BMAC_EMR_CPE & ~BMAC_EMR_PPE
                    & ~BMAC_EMR_RES,        /* emr */
    BMAC_IMR_RNG | BMAC_IMR_TTE | BMAC_IMR_COE | BMAC_IMR_IERR  /* imr */
};

/*
 *------------------------------------------------------------------------
 *          default initialization table for fddi bridge
 *------------------------------------------------------------------------
 */
BMAC_DEFAULT_TABLE bmacbr_default_table = {
    ~BMAC_MR_RUN & ~BMAC_MR_ILB & ~BMAC_MR_DIAG & BMAC_MR_RES
                    & ~BMAC_MR_PIP & ~BMAC_MR_MRP & ~BMAC_MR_CBP,   /* mr */
     BMAC_OR_ELA ,      /* OR */
     BMAC_FR_MARST,     /* fr */
     0,
     BMAC_REMR1_OTRBCN | BMAC_REMR1_MYBCN | BMAC_REMR1_MYCLM,   /* remr1 */
#if 0
     BMAC_TEMR0_ENTRMD | BMAC_TEMR0_TVXEXP | BMAC_TEMR0_TRTEXP  /* temr0 */
         | BMAC_TEMR0_DUPTKR | BMAC_TEMR0_CBERR | BMAC_TEMR0_TKCAPT,
#endif
     BMAC_TEMR0_CBERR | BMAC_TEMR0_ENTRMD,   /* smt code only process this interrupt */
    0,      /* cimr - always 0 */
    BMAC_COMR_FRRCV | BMAC_COMR_FREI | BMAC_COMR_FRLST | BMAC_COMR_FRCOP | 
        BMAC_COMR_FRNCOP | BMAC_COMR_FRTRX | BMAC_COMR_TKRCVD,  /* comr */
    ~BMAC_EMR_CWI & ~BMAC_EMR_CCE & ~BMAC_EMR_CPE & ~BMAC_EMR_PPE
                    & ~BMAC_EMR_RES,        /* emr */
    BMAC_IMR_RNG | BMAC_IMR_TTE | BMAC_IMR_COE | BMAC_IMR_IERR  /* imr */
};

/*
 *------------------------------------------------------------------------
 *          BSIs
 *------------------------------------------------------------------------
 */


BSI_INIT_TYPE bsi_master_default[BSI_MAX] =
{
#ifdef __FEBRIDGE		/* FDDI-Eth bridge */
    {   /* BSI 0 */
        (BSI_REG_TYPE*)BSI_B_BASEADDR_BR,
        0x14,                       /* idud shadow register offset */
        0x15,                       /* odud shadow register offset */
        SMT_PSP_NUM_BR,            /* for application */
        LLC_PSP_NUM_BR,
        MON_PSP_NUM_BR,
        SMT_PSP_NUM_BR,            /* for booter */
        LLC_PSP_NUM_BR,
        MON_PSP_NUM_BR,
	0x92,							/* ICR for the application */
	0x93							/* ICR for boot */
    }
#else					/* concentrator */
    {   /* BSI 0 */
        (BSI_REG_TYPE*)BSI_B_BASEADDR,
        0x14,                       /* idud shadow register offset */
        0x15,                       /* odud shadow register offset */
        BSI_SMT_PSP_NUM,            /* for application */
        BSI_LLC_PSP_NUM,
        BSI_MON_PSP_NUM,

	/**** for booter  ****/
	BSI_BOOT_SMT_PSPS,
	BSI_BOOT_MON_PSPS,    /* primary mac needs it for download file */
        0,                    
	0x93,         /* normal mode - ch 0,1 are only, ch 2 promis */
	0x48          /* boot mode, ch 0,2 not copy; ch 1 only */
    },

    {   /* BSI 1 */
        (BSI_REG_TYPE*)BSI_A_BASEADDR,
        0x14,                       /* idud shadow register offset */
        0x15,                       /* odud shadow register offset */
        BSI_SMT_PSP_NUM,
        BSI_LLC_PSP_NUM,
        BSI_MON_PSP_NUM,

	/**** for booter  ****/
	BSI_BOOT_SMT_PSPS,
	BSI_BOOT_LLC_PSPS,
	BSI_BOOT_MON_PSPS,          /* secondary mac need it to download */
	0x93,         /* normal mode - ch 0,1 are only, ch 2 promis */
	0x4b     /* boot mode: ch 0 no copy; ch 1 only; ch 2 promis */
    }
#endif
};

/******************************************************************
 *  BSI RAM Registers Offset
 *****************************************************************/
REQ_RAM_REGS bsi_req_ram[BSI_REQCH_NUM] = {
    {   /* BSI_REQCH0 */
        0x02,       /* rqlr */
        0x03,       /* cqlr */
        0x04,       /* opr */
        0x05,       /* olpr */
        0x06,       /* cqpr */
        0x07        /* rqpr */
    },
    {   /* BSI_REQCH1 */
        0x0,        /* rqlr */
        0x01,       /* cqlr */
        0x0,        /* opr */
        0x01,       /* olpr */
        0x02,       /* cqpr */
        0x03        /* rqpr */
    }
};

IND_RAM_REGS bsi_ind_ram[BSI_INDCH_NUM] = {
    {   /* BSI_INDCH0 */
        0x08,       /* iqli */
        0x09,       /* pqli */
        0x10,       /* ipi */
        0x11,       /* iqpi */
        0x12,       /* pqpi */
        0x13        /* npi */
    },
    {   /* BSI_INDCH1 */
        0x06,       /* iqli */
        0x07,       /* pqli */
        0x0c,       /* ipi */
        0x0d,       /* iqpi */
        0x0e,       /* pqpi */
        0x0f        /* npi */
    },
    {   /* BSI_INDCH2 */
        0x04,       /* iqli */
        0x05,       /* pqli */
        0x08,       /* ipi */
        0x09,       /* iqpi */
        0x0a,       /* pqpi */
        0x0b        /* npi */
    }
};


/*
 *------------------------------------------------------------------------
 *          default table for fddi master concentrator initialization
 *------------------------------------------------------------------------
 */
BSI_DEFAULT_TABLE bsicon_default_table = {
    BSI_MR0_SMLQ,    /* mr0 */
    BSI_MR1_DEFAULT,                /* mr1 */
    0,   /* mnr - polling */
    BSI_STNR_ERRN | BSI_STNR_SPSTOPN | BSI_STNR_RQSTOPN | BSI_STNR_INSTOPN,
    0,      /* snr */
    BSI_NSNR_NSI2N | BSI_NSNR_LDI2N | BSI_NSNR_LDI0N |
    BSI_NSNR_NSI1N | BSI_NSNR_LDI1N | BSI_NSNR_NSI0N | BSI_NSNR_NSR1N |
        BSI_NSNR_NSR0N,         /* nsnr */
    BSI_RNR_USRR0N | BSI_RNR_EXCR0N | BSI_RNR_USRR1N | BSI_RNR_EXCR1N,

    BSI_RxCR0_FCT | 0xc0,    /* r0cr0 */
    BSI_RxCR0_FCT | 0xc0,    /* r1cr0 */

    0,                /* r0efsr - always 0 */
    0,                /* r1efsr - always 0 */
    0,

    ITR_THRESHOLD_DEFAULT,
    BSI_IMR_BOS | BSI_IMR_BOB | BSI_IMR_BOT1 | BSI_IMR_BOT2 | BSI_IMR_FPP | BSI_IMR_SM | BSI_IMR_SKIP,
    BSI_IHLR_CON_DEFAULT,
    0x06,          /* acr - switch on req channels */
    0,          /* r0cr1 - always 0 */
    0           /* r1cr1 - always 0 */
};

/*
 *------------------------------------------------------------------------
 *          default table for fddi bridge initialization
 *------------------------------------------------------------------------
 */
BSI_DEFAULT_TABLE bsibr_default_table = {
    BSI_MR0_SMLQ,    /* mr0 */
    BSI_MR1_DEFAULT,                /* mr1 */
	0,
    BSI_STNR_ERRN | BSI_STNR_SPSTOPN | BSI_STNR_RQSTOPN | BSI_STNR_INSTOPN,
    0,      /* snr */
    BSI_NSNR_NSI2N | BSI_NSNR_LDI2N |
    BSI_NSNR_NSI1N | BSI_NSNR_LDI1N | BSI_NSNR_NSI0N | BSI_NSNR_NSR1N |
        BSI_NSNR_NSR0N,         /* nsnr */
    BSI_RNR_USRR0N | BSI_RNR_EXCR0N | BSI_RNR_USRR1N | BSI_RNR_EXCR1N,

	/* add Source Address Transparency and Void Stripping */
    BSI_RxCR0_FCT+BSI_RxCR0_SAT+BSI_RxCR0_VST+0xc0,    /* r0cr0 */
    BSI_RxCR0_FCT+BSI_RxCR0_SAT+BSI_RxCR0_VST+0xc0,    /* r1cr0 */

    0,                /* r0efsr - always 0 */
    0,                /* r1efsr - always 0 */
	0,

    ITR_THRESHOLD_DEFAULT,
    BSI_IMR_BOS | BSI_IMR_BOT1 | BSI_IMR_BOT2 | BSI_IMR_FPP | BSI_IMR_SKIP
      | BSI_IMR_SM,      /* imr */
    BSI_IHLR_CON_DEFAULT,
    0x1f,          /* acr - switch on req channels */
    0,          /* r0cr1 - always 0 */
    0           /* r1cr1 - always 0 */
};



