#ifndef __CONSTANT_H
#define __CONSTANT_H
#include "memory.h"

#ifndef TRUE
#define TRUE            1
#endif

#ifndef FALSE
#define FALSE           0
#endif

#ifndef DONT_CARE
#define DONT_CARE       FALSE
#endif

/*
*	Station Limitations
*	These values determine the system limits for various elements
*	within the station.
*/

#define	MAX_MAC_COUNT		FDDI_MAC_CT
#ifdef __FEBRIDGE
#define	MAX_PATH_COUNT		2
#else
#define	MAX_PATH_COUNT		FDDI_MAC_CT
#endif
#define	MAX_PORT_COUNT		(FDDI_MASTER_CT + FDDI_NONMASTER_CT)
#define	MAX_ATTACH_COUNT	MAX_PORT_COUNT

#define	MAX_PHY_COUNT		MAX_PORT_COUNT	/* for backward compatibility */
#define	MAX_ALIASES_COUNT	1     /* also apply for group addresses */

#endif /* __CONSTANT_H */


