/****************************************************************************
 *  File    drv_timer.h
 *
 *  Description
 *      Defines for Intel 82C54 Timer Chip
 *
 *  Copyright (c) 1992, 1993 Hughes Lan Systems
 *
 *  Author:     Jia-wei Jang
 ***************************************************************************/

#ifndef _DRV_TIMER_H_
#define _DRV_TIMER_H_

#include <fddi.h>
#include <memory.h>

/*** 82C54 Timer Registers ***/
#define DRV_TIMER_CTRL_ADDR                 TIMERIO + 0x0c
#define DRV_TIMER0_COUNTER                  TIMERIO + 0
#define DRV_TIMER1_COUNTER                  TIMERIO + 0x04
#define DRV_TIMER2_COUNTER                  TIMERIO + 0x08 

#define DRV_1uSEC_TICKS               2       /* timer 2 1 ticks is 500 ns */




/*** bit mask for control word ***/
#define TIME_CW_COUNT0          0        /* control word select counter 0 */
#define TIME_CW_COUNT1          0x40
#define TIME_CW_COUNT2          0x80
#define TIME_CW_READBACK        0xc0    /* read back */
#define TIME_CW_LATCH           0x0
#define TIME_CW_LSB             0x10
#define TIME_CW_MSB             0x20
#define TIME_CW_WORD            0x30    /* write/read 2 bytes */
#define TIME_CW_MODE0           0
#define TIME_CW_MODE1           0x02
#define TIME_CW_MODE2           0x04
#define TIME_CW_MODE3           0x06
#define TIME_CW_MODE4           0x08
#define TIME_CW_MODE5           0x0b
#define TIME_CW_BCD             0x01


typedef struct _drv_timer_ {
    byte    counter_0;
    byte    filler1;
    uint16  filler2;

    byte    counter_1;
    byte    filler3;
    uint16  filler_4;

    byte    counter_2;
    byte    filler_5;
    uint16  filler_6;

    byte    ctrl_reg;   /* control word register */
    byte    filler_7;
    uint16  filler_8;
} DRV_TIMER;
volatile extern DRV_TIMER *timer_2;


#ifdef DO_LINT
extern void  DRV_Timer3nit(void);
extern void DRV_Counter2ISR (void);
#else
extern void  DRV_Timer3Init();
extern void DRV_Counter2ISR ();
#endif
#endif  /*  _DRV_TIMER_H_ */
