/************************************************************************************
 *  File     fddimap.h
 *
 *  Description
 *    This file contains all the product dependent constants used by driver and smt
 *
 *
 *  Programmer:   Jiawei Jang
 *
 *  $Log:   /user/pvcs/fddicon/include/fddimap.h_v  
 * 
 *    Rev 1.10   12 Oct 1993 12:42:34   gregs
 * No change.
 * 
 *    Rev 1.9   15 Sep 1993 09:23:58   gregs
 * No change.
 * 
 *    Rev 1.8   28 Jun 1993 11:10:28   gregs
 * Reverse addresses of backplane A and B PHYs.
 * 
 *    Rev 1.7   19 May 1993 09:25:50   gregs
 * Reversed phy A/B addresses for fddi-eth bridge.
 * 
 *    Rev 1.6   29 Mar 1993 10:16:02   gregs
 * CAM addr change for fddi-th bridge
 * 
 *    Rev 1.5   26 Mar 1993 13:28:40   jang
 * added CAM addresses
 * 
 *    Rev 1.4   24 Mar 1993 18:44:22   jlin
 * 
 *    Rev 1.3   19 Mar 1993 11:28:42   gregs
 * GJS  -  To make common src with fddi-eth bridge
 * 
 *    Rev 1.2   09 Mar 1993 17:29:32   jang
 * added player+
 * 
 *    Rev 1.1   22 Feb 1993 17:34:04   jlin
 * 
 *    Rev 1.0   22 Feb 1993 14:17:32   jang
 * Initial revision.
 ************************************************************************************/

#ifndef _FDDIMAP_H_
#define _FDDIMAP_H_

#ifdef __FEBRIDGE		/* FDDI-Eth bridge */
#define FDDI_MAC_CT            1
#define FDDI_NONMASTER_CT      2
#define FDDI_MASTER_CT         0
#define PHY_MASTER_PORTS       0
#else			/* FDDI Con */
#define FDDI_MAC_CT            2
#define FDDI_NONMASTER_CT      2
#define FDDI_MASTER_CT         6
#define PHY_MASTER_PORTS                    FDDI_MASTER_PORTS
#endif

  
/*
 *-----------------------------------------------------------------------------------
 *   BSI control registers base address
 *-----------------------------------------------------------------------------------
 */
#define BSI_A_BASEADDR      0x90000800
#define BSI_B_BASEADDR      0x90000900

#define FDDI_INTREG_BASE            0xE0000000



/*
 *-----------------------------------------------------------------------------------
 *   BMAC control registers base address
 *-----------------------------------------------------------------------------------
 */
#define BMAC_A_BASEADDR         0XA0000A00      /* MAC A */
#define BMAC_B_BASEADDR         0XA0000B00      /* MAC B */

#define BMAC_A_CAM_ADDR         0x3000000c
#define BMAC_B_CAM_ADDR         0x4000000c


/*
 *-----------------------------------------------------------------------------------
 *   PLAYER control registers base address
 *   NOTE: It is assumed that there is always a PLAYER IN B0000000
 *-----------------------------------------------------------------------------------
 */
#define PHY_B_BASE              0xb0000000
#define PHY_A_BASE              0xb0000020
#define PHY_4_BASE              0xb0000040
#define PHY_5_BASE              0xb0000060
#define PHY_6_BASE              0xb0000080
#define PHY_7_BASE              0xb00000a0
#define PHY_AB_BASE             0xb00000e0  /* phy A backplane */
#define PHY_BB_BASE             0xb00000c0  /* phy B backplane */


/*
 *-----------------------------------------------------------------------------------
 *   PLAYER+ control registers base address
 *-----------------------------------------------------------------------------------
 */
#define PLAYER_PLUS_B_BASE              0xb0000000
#define PLAYER_PLUS_A_BASE              0xb0000040
#define PLAYER_PLUS_4_BASE              0xb0000080
#define PLAYER_PLUS_5_BASE              0xb00000c0
#define PLAYER_PLUS_6_BASE              0xb0000100
#define PLAYER_PLUS_7_BASE              0xb0000140
#define PLAYER_PLUS_AB_BASE             0xb00001c0  /* phy A backplane */
#define PLAYER_PLUS_BB_BASE             0xb0000180  /* phy B backplane */



#define PHY_BACKPLANE_PORTS                 2   /* always 2 backplane ports */


/* definitions for the FDDI-Ethernet bridge */
#define BSI_B_BASEADDR_BR   		0x60000500
#define BMAC_B_BASEADDR_BR        	0x60000400      /* MAC B */

#define PLAYP_A_BASE_BR      0x60000000
#define PLAYP_B_BASE_BR      0x60000100
#define PLAYP_BB_BASE_BR     0x60000200  /* phy B backplane */
#define PLAYP_AB_BASE_BR     0x60000300  /* phy A backplane */

#define BMAC_CAM_ADDR_BR     0xB000000c
#endif
