/*****************************************************************
 *      Copyright (c) 1992 by Hughes LAN Systems
 *
 *      Program Name:   FDDI Concentrator application
 *
 *      Filename:       fdrmontype.h
 *
 *      Description: This file contains the type definitions  
 *		     required to implement the fddi rmon agent.
 *
 *	$Log:   /user/pvcs/fddicon/include/fdrmonty.h_v  $
 * 
 *    Rev 1.45   12 Oct 1993 12:42:36   gregs
 * No change.
 * 
 *    Rev 1.44   15 Sep 1993 09:24:02   gregs
 * No change.
 * 
 *    Rev 1.43   03 Jun 1993 17:42:30   nayan
 * StationId in struct _fddiRSEntry defined as uChar Id[8].
 * 
 *    Rev 1.42   21 May 1993 16:30:52   nayan
 * 
 * modified variable TraversalCount in Host Entry.
 * 
 *    Rev 1.41   19 May 1993 14:14:08   nayan
 * added field TraversalCount to HostEntry.
 * 
 *    Rev 1.40   30 Apr 1993 19:47:18   jlin
 * Add NC_SIF_ERROR in NodeClass of host entry
 * 
 *    Rev 1.39   30 Apr 1993 16:20:32   jang
 * added msg header to FDDI_PSTATS
 * 
 *    Rev 1.39   30 Apr 1993 15:56:44   jang
 * added msg header to FDDI_PSTATS data structure
 * 
 *    Rev 1.39   30 Apr 1993 15:51:44   jang
 * added msg header to FDDI_PSTATS
 * 
 *    Rev 1.38   20 Apr 1993 10:51:02   jlin
 * Move physical map's data structure from rs_entry to host_entry
 * 
 *    Rev 1.37   20 Apr 1993 10:46:42   shekhar
 * 
 *    Rev 1.36   17 Apr 1993 10:09:44   jlin
 * 
 *    Rev 1.35   29 Mar 1993 12:01:22   jlin
 * 
 *    Rev 1.34   09 Mar 1993 17:06:06   jlin
 * 
 *    Rev 1.33   05 Mar 1993 09:57:14   jang
 * added 2 fields to HOSTENTRY
 * 
 *    Rev 1.32   15 Feb 1993 09:32:18   shekhar
 * name of HASH_TABLE_SIZE is now changed to FDHASH_TABLE_SIZE
 * 
 *    Rev 1.31   15 Feb 1993 08:59:48   shekhar
 * name of MON_P_PORT is changed to MON_P_FDPORT; This is because the
 * token ring software uses the same name.
 * 
 *    Rev 1.30   26 Jan 1993 12:42:18   jlin
 * 
 *    Rev 1.29   19 Jan 1993 14:42:46   shekhar
 * added new definitions for events; also added MASK for each function code.
 * 
 *    Rev 1.28   19 Jan 1993 10:34:42   nayan
 * replaced field FirstTimeCopy field by HasUNAChanged field in
 * host_control_tbl.
 * 
 *    Rev 1.27   18 Jan 1993 15:23:24   nayan
 * added fields CurHead and WorkHeadd in host_contol_tbl.
 * 
 *    Rev 1.26   18 Jan 1993 12:05:12   shekhar
 * 
 *    Rev 1.25   18 Jan 1993 10:12:34   nayan
 * added field FirstTimeCopy to host_control_tbl.
 * 
 *    Rev 1.24   18 Jan 1993 10:06:30   shekhar
 * changed prototype of get_hostentry.
 * 
 *    Rev 1.23   15 Jan 1993 15:38:44   jlin
 * Add TopologyWrapped in RSEntry
 * 
 *    Rev 1.22   14 Jan 1993 11:36:20   nayan
 * changed structures _hostControlTbl and _HostEntry.
 * also renamed flag IsRingClosed to IsRingMapValid.
 * 
 *    Rev 1.21   14 Jan 1993 10:52:46   nayan
 * modified host_control_tbl and host_entry structures.
 * 
 *    Rev 1.20   08 Jan 1993 17:10:28   jlin
 * 
 *    Rev 1.19   08 Jan 1993 16:17:00   jlin
 * Changed CON_PORT_COUNT.
 * 
 *    Rev 1.18   07 Jan 1993 17:45:24   shekhar
 * 
 *    Rev 1.17   07 Jan 1993 17:40:08   jlin
 * Add an attribute RingOrderChanged in the structure HOST_CONTROL_TABLE
 * 
 *    Rev 1.16   07 Jan 1993 13:30:18   jlin
 * 
 *    Rev 1.15   07 Jan 1993 11:46:52   jlin
 * change FDDI_RS_ENTRY for physical mapping
 * 
 *    Rev 1.14   07 Jan 1993 10:21:26   jlin
 * Change the constant value for MAC & PORT numbers
 * 
 *    Rev 1.13   05 Jan 1993 17:50:46   jang
 * 
 *    Rev 1.12   05 Jan 1993 11:49:44   nayan
 * added field transID in struct _hostControlTbl.
 * 
 *    Rev 1.11   29 Dec 1992 16:20:28   shekhar
 * Modified FDDI_RS_ENTRY; Deleted Order Index
 * 
 *    Rev 1.10   28 Dec 1992 16:30:04   shekhar
 * added dataSourceLen field for all the control entries.
 * 
 *    Rev 1.9   28 Dec 1992 14:52:04   jang
 * changed PstatsASyncPkts to PStatsAsyncPkts due to PStatsAsyncOctets
 * 
 *    Rev 1.8   28 Dec 1992 11:09:04   nayan
 * added field IsRingClosed in struct _hostControlTbl.
 * 
 *    Rev 1.7   22 Dec 1992 17:27:10   shekhar
 * added FDDI PORT & Interface Related Function Codes; Also defined ENTRY STATUS
 * Values
 * 
 *    Rev 1.6   21 Dec 1992 17:25:56   shekhar
 * added RSFreeQHeader for fddiHost_control_tbl
 * 
 *    Rev 1.5   21 Dec 1992 16:22:40   jang
 * added function prototype and others
 * 
 *    Rev 1.4   17 Dec 1992 17:53:18   shekhar
 * 
 *    Rev 1.3   17 Dec 1992 17:44:28   shekhar
 * 
 *    Rev 1.2   17 Dec 1992 15:43:54   jang
 * moved DRIVER_MSG to msgutil.h and redefined it.
 * 
 *    Rev 1.1   17 Dec 1992 13:55:18   shekhar
 *
 *	Revision :
 *	1-000		12-01-92		Shekhar Ambe
 *		- Original
 *
 *******************************************************************
 */

#ifndef _FDRMONTYPE_H_
#define _FDRMONTYPE_H_


#include <types.h>
#include <asn1.h>
#include <a_queue.h>
#include "fddi.h"

/* Non Promiscuous Statistics table  */

typedef struct _fddiMLStats
	{
	uint		MLIndex;
	UINT_32_T	MLStatsDataSource[32];
	uint		MLStatsDataSourceLen;
	uint		MLStatsDropEvents;
  	uint		MLStatsVoidFrameEvents;
  	uint		MLStatsVoidPkts;
  	uint		MLStatsBeaconEvents;
  	uint		MLStatsBeaconPkts;
  	uint		MLStatsClaimStateEvents;
  	uint		MLStatsClaimPkts;
  	OCTET_T 	MLStatsOwner[256];
	ushort		MLStatsStatus;
	} FDDI_MLSTATS;

/*  Promiscuous Statistics table  */
#define PSTATS_MARKER    0x50535441
typedef struct _fddiPStats
	{
	struct _fddiPStats *next;
	int             pstats_marker;
	uint		PIndex;
	UINT_32_T	PStatsDataSource[32];
	uint		PStatsDataSourceLen;
  	uint		PStatsDropEvents;
  	uint		PStatsOctets;
  	uint		PStatsPkts;
  	uint		PStatsDataBroadcastPkts;
  	uint		PStatsDataMulticastPkts;
  	uint		PStatsSmtBroadcastPkts;
  	uint		PStatsSmtMulticastPkts;
  	uint		PStatsMacOctets;
  	uint		PStatsMacPkts;
  	uint		PStatsSmtOctets;
  	uint		PStatsSmtPkts;
  	uint		PStatsAsyncOctets;
  	uint		PStatsAsyncPkts;
  	uint		PStatsSyncOctets;
  	uint		PStatsSyncPkts;
  	uint		PStatsDataPkts18to63Octets;
  	uint		PStatsDataPkts64to127Octets;
  	uint		PStatsDataPkts128to255Octets;
  	uint		PStatsDataPkts256to511Octets;
  	uint		PStatsDataPkts512to1023Octets;
  	uint		PStatsDataPkts1024to2047Octets;
  	uint		PStatsDataPkts2048to4095Octets;
  	uint		PStatsDataPkts4096orGreaterOctets;
  	OCTET_T		PStatsOwner[256];
  	ushort		PStatsStatus;
	}  FDDI_PSTATS;
	
/*  SMT Statistics table  */

typedef struct _fddiSmtStats
	{
	uint		SmtIndex;
	UINT_32_T	SmtStatsDataSource[32];
	uint		SmtStatsDataSourceLen;
  	uint		SmtStatsDropEvents;
  	uint		SmtStatsNifPkts;
  	uint		SmtStatsSifPkts;
  	uint		SmtStatsEchoPkts;  
  	uint		SmtStatsRafPkts;
  	uint		SmtStatsRdfPkts;   
  	uint		SmtStatsSrfPkts;   
  	uint		SmtStatsPmfPkts;
  	uint		SmtStatsEsfPkts;
  	uint		SmtStatsConfigurationChgEvents;
  	uint		SmtStatsUndesiredConnectionAttempts;
  	uint		SmtStatsPathTraceStatusEvents;
  	uint		SmtStatsNeighborChangeEvents;
  	uint		SmtStatsMacFrameErrorConditions;
  	uint		SmtStatsPortLerConditions;
  	uint		SmtStatsMacNotCopiedConditions;
  	uint		SmtStatsMacDuplicateAddressConditions;
  	uint		SmtStatsPortEbErrorConditions;
  	OCTET_T		SmtStatsOwner[256];
  	uint		SmtStatsStatus;
	} FDDI_SMT_STATS;

/* FDDI Ring Station Control Table  */

#define ADDR_FLD_LEN	7	/* the first byte of this field
				   indicates the length of mac address */

typedef struct _fddiRSControlTbl
	{
    uint		IfIndex;
    uint		TableSize;
    uint		ActiveStations;
    uint		RingState;
    OCTET_T		BeaconSender[ADDR_FLD_LEN];
    OCTET_T		ClaimTokenWinner[ADDR_FLD_LEN];
    uint		Ttrt;
    uint		Changes;
    OCTET_T		Owner[256];
    uint		Status;
	}  FDDI_RS_CONTROL_TBL;

	
/* FDDI Ring Station Entry */
#define PORT_BITMAP_SIZE              (128/4)

typedef struct _fddiRSEntry
	{
	queue_node		freeq;
    OCTET_T			LastUNA[ADDR_FLD_LEN];       
    OCTET_T			LastDNA[ADDR_FLD_LEN];
#define		ACTIVE_STATION   1
#define     INACTIVE_STATION 2
    uint			StationStatus;
    uint			LastEnterTime;
    uint			LastExitTime;  
    uChar			Id[8];            
    uint			VersionId;     
    uint			ConfigurationChgEvents;
    uint			UndesiredConnectionAttempts;
    uint			PathTraceStatusEvents;
    uint			NeighborChangeEvents;
    uint   			MacFrameErrorConditions;
    uint			PortLerConditions;
    uint			MacNotCopiedConditions;
    uint			MacDuplicateAddress;
    uint			PortEbErrorConditions;
	} FDDI_RS_ENTRY;

typedef struct _HostEntry
	{
	struct _HostEntry	*next;	/* used for hashing     			*/
	struct _HostEntry  	*prev;	/* used for hashing     			*/
	queue_node 	workringOrder;		/* working ring order						*/

	queue_node 	ringOrder;		/* current ring order						*/
	queue_node 	macOrder;		/* mac order						*/
	queue_node 	hostOrder;		/* Creation order   				*/
	queue_node 	ageOrder;		/* Age Order - used to  			*/
								/* delete the aged entry			*/
	Boolean	    valid_Ro;		/* this flag indicates if the RO
	   							   for this is valid or not 		*/
	Boolean		valid_MoHoAo;	/* this flag indicates if the mac 
		   			   			   order, hostorder and ageorder 
		   			   			   for this host is valid or not    */
	OCTET_T		macAddress[ADDR_FLD_LEN];
	unsigned int   TraversalCount[2]; /* the number of times the host is 
							  * encountered while travesing the
							  * work ring order queue			*/ 
	Boolean		portflag;		/* TRUE if the port no is known;    */
								/* FALSE otherwise. 				*/
	ushort		portno; 		/* port number of the concentrator
					    		   where this station is attached 	*/
	FDDI_RS_ENTRY 	*rs_entry;	/* only local ring station has this */
								/* entry; for remote stations this  */
								/* pointer is null 					*/
	FDDI_PSTATS	*port_pstats;   /* if the port for this host is not
		   						   known at the time of creation of 
		   						   HostEntry, then the PStas for the 
		   						   Port is stored in this structure 
		   						   temporarily.			    		*/
	bool            MySlotNid;          /* TRUE if this is My MAC addr */
	struct _HostEntry   *mon_ptr;   /* to monitor address list */
	/* ----- data to support RMON host table ----- */
	uint	hostInPkts;
	uint	hostOutPkts;
	uint	hostInOctets;
	uint	hostOutOctets;
	uint	hostOutErrors;
	uint	hostOutBroadcastPkts;
	uint	hostOutMulticastPkts;
	uint	creationTime;
    /************************************************
     *   Used for physical mapping
     */
    uInt16                      NodeClass;
		    #define NC_NO_STATUS          0
	            #define NC_OLD_SIF_RESPOND    0
	            #define NC_NEW_SIF_RESPOND    0x001
	            #define NC_STATION            0
	            #define NC_CONCENTRATOR       0x002
	            #define NC_SINGLE_ATTACH      0
	            #define NC_DUAL_ATTACH        0x004
	            #define NC_DUAL_HOMING        0x008
		    #define NC_THRU		  0
		    #define NC_WRAPPED		  0x010
		    #define NC_TREE		  0
		    #define NC_PEER		  0x020
		    #define NC_UNROOTED		  0
		    #define NC_ROOTED		  0x040
		    #define NC_SRF_NO		  0
		    #define NC_SRF_SUPPORTED	  0x080
		    #define NC_PORT_INC		  0
		    #define NC_PORT_DEC		  0x100
	            #define NC_SIF_ERROR          0x200
	            #define NC_DAS (NC_STATION | NC_DUAL_ATTACH)
	            #define NC_SAS (NC_STATION | NC_SINGLE_ATTACH)
	            #define NC_DAC (NC_CONCENTRATOR | NC_DUAL_ATTACH)
	            #define NC_SAC (NC_CONCENTRATOR | NC_SINGLE_ATTACH)

    Int16                       ActivePortCount;
    uChar                       TreeDepth;
    uChar                       ParentPortAttached;
    uChar                       PortBitMap[PORT_BITMAP_SIZE];
		    #define PM_PORT_NONE          0
		    #define PM_PORT_NORMAL        1
		    #define PM_PORT_UNKNOWN       2
    struct _HostEntry          *Sibling;
    struct _HostEntry          *Children;
    struct _HostEntry          *Parent;
    struct _HostEntry          *OtherMACofSameNode;
	} HOSTENTRY;


#define	FDHASH_TABLE_SIZE		1024 

typedef struct _hostControlTbl
	{
	HOSTENTRY		*HashTable[FDHASH_TABLE_SIZE];	
	queue_head		RSFreeQHead;		/* Ring Station Free Queue */
	queue_head		WorkRingOrderHead;
	queue_head		*WorkHead;
	queue_head		RingOrderHead;
	queue_head		*CurHead;
	queue_head		MacOrderHead;
	queue_head		HostOrderHead;
	queue_head		AgeOrderHead;
	uint			Index;
	UINT_32_T		DataSource[32];
	uint			DataSourceLen;
	uint			TableSize;
	uint			LastDeleteTime;
    	OCTET_T			Owner[256];
	uint			Status;	
/*------ for Ring Mapping -------*/
	uint        		transID;
	uChar        		IsRingMapValid;
	uChar		        HasUNAChanged;
	uChar                   RingOrderChanged;
	uChar                   PortChanged;
	uInt32                  ActiveStations;
	uInt32                  NIFResponsiveStations;
        uInt32 			WrapTreeNodeCount;
        uInt32 			WrapPeerNodeCount;
	} FDDIHOST_CONTROL_TABLE;	

typedef struct _PortControlTbl
	{
	/* points to the first host of the port. */
	HOSTENTRY		*host_ptr; 
	uint			Index;
	UINT_32_T		DataSource[32];
	uint			DataSourceLen;
	uint			TableSize;
	uint			LastDeleteTime;
    OCTET_T			Owner[256];
	uint			Status;	
	} FDDIPORT_CONTROL_TABLE;	

/* Various Constats used by Rmon Collector and retrieval functions  	*/

#define CON_MAC_COUNT		FDDI_MAC_CT/* Total Number of Interfaces	*/
#define CON_PORT_COUNT		(FDDI_MASTER_CT+FDDI_NONMASTER_CT)/* Total Number Of Ports 		*/

#define CON_MAC_PORT_COUNT	(CON_MAC_COUNT + CON_PORT_COUNT)

#define MAX_HOST_COUNT		1024

/* Enumeration of ENTRY STATUS */
#define	ESTATUS_VALID			1
#define ESTATUS_CREATEREQUEST	2
#define ESTATUS_UNDERCREATION	3
#define ESTATUS_INVALID			4

/* FDDI PORT and Interface Related Function Codes */
#define	MON_ML_IF				0x21
#define	MON_ML_PORT				0x22
#define	MON_P_IF				0x23
#define	MON_P_FDPORT			0x24
#define MON_SMT_IF				0x25
#define	MON_SMT_PORT			0x26
#define	MON_HOST_IF				0x27
#define	MON_HOST_PORT			0x28
#define MON_MATRIX_IF			0x29
#define	SMT_CFSTATE_EVENT		0x2A
#define PORT_CONN_STATE_EVENT   0x2B
#define CONFIG_CHG_EVENT		0x2C
#define UNDESIRED_CONN_EVENT	0x2D
#define PATH_TRACE_EVENT		0x2E
#define NEIGHBOR_CHANGE_EVENT   0x2F
#define MAC_FRAMEERR_EVENT		0x30
#define PORT_LER_EVENT			0x31
#define MAC_NOTCP_EVENT			0x32
#define MAC_DUP_ADDR_EVENT		0x33
#define PORT_EBERR_EVENT		0x34

#define MASK_MON_ML_IF            	0x8000 + (MON_ML_IF * 0x100) 
#define MASK_MON_ML_PORT            0x8000 + (MON_ML_PORT * 0x100) 
#define MASK_MON_P_IF              	0x8000 + (MON_P_IF * 0x100) 
#define MASK_MON_P_PORT            	0x8000 + (MON_P_FDPORT * 0x100) 
#define MASK_MON_SMT_IF           	0x8000 + (MON_SMT_IF * 0x100) 
#define MASK_MON_SMT_PORT         	0x8000 + (MON_SMT_PORT * 0x100) 
#define MASK_MON_HOST_IF          	0x8000 + (MON_HOST_IF * 0x100) 
#define MASK_MON_HOST_PORT         	0x8000 + (MON_HOST_PORT * 0x100) 
#define MASK_MON_MATRIX_IF         	0x8000 + (MON_MATRIX_IF * 0x100) 
#define MASK_SMT_CFSTATE_EVENT     	0x8000 + (SMT_CFSTATE_EVENT * 0x100) 
#define MASK_PORT_CONN_STATE_EVENT 	0x8000 + (PORT_CONN_STATE_EVENT * 0x100) 
#define MASK_CONFIG_CHG_EVENT      	0x8000 + (CONFIG_CHG_EVENT * 0x100) 
#define MASK_UNDESIRED_CONN_EVENT  	0x8000 + (UNDESIRED_CONN_EVENT * 0x100) 
#define MASK_PATH_TRACE_EVENT      	0x8000 + (PATH_TRACE_EVENT * 0x100) 
#define MASK_NEIGHBOR_CHANGE_EVENT 	0x8000 + (NEIGHBOR_CHANGE_EVENT * 0x100) 
#define MASK_MAC_FRAMEERR_EVENT    	0x8000 + (MAC_FRAMEERR_EVENT * 0x100) 
#define MASK_PORT_LER_EVENT        	0x8000 + (PORT_LER_EVENT * 0x100) 
#define MASK_MAC_NOTCP_EVENT       	0x8000 + (MAC_NOTCP_EVENT * 0x100) 
#define MASK_MAC_DUP_ADDR_EVENT    	0x8000 + (MAC_DUP_ADDR_EVENT * 0x100) 
#define MASK_PORT_EBERR_EVENT      	0x8000 + (PORT_EBERR_EVENT * 0x100) 
 

extern HOSTENTRY 		*get_host_entry(uint MacNo);
extern FDDI_RS_ENTRY 	*get_rs_entry(uint MacNo);
extern uint				get_hash_index();

#endif
