/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	febridge
*
*	Filename:	memory.h
*
*	$Log:   /b/gregs/bridge/include/memory.h_v  $
 * 
 *    Rev 1.6   08 Dec 1993 10:12:30   franks
 * Performance: Changed the starting address of SRAM to 2ff80000 to take advantage
 * of the additional SRAM added to the bridge.
 * 
 *    Rev 1.5   12 Oct 1993 09:12:34   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 09:35:08   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:19:30   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:02:54   franks
 * No change.
 * 
 *    Rev 1.1   03 Aug 1993 15:01:26   gregs
 * Addition of optical bypass register address.
 * 
 *    Rev 1.0   07 Jul 1993 09:05:44   franks
 * Initial revision.
 * 
 *    Rev 1.24   22 Feb 1993 14:17:34   jang
 * moved some constants to fddimap.h
 * 
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************
 * This file contains the memory map definitions for the hub bridge cards.
 ******************************************************************/
#ifndef __MEMORY_H
#define __MEMORY_H	0x100a	/* V1.00a */

/*
 * This section defines the basic memory locations.
 */
#define BEPROM64  	0xffff0000	/* 08b EPROM for the preboot code (64 K)*/
#define BEPROM128  	0xfffe0000	/* 08b EPROM for the preboot code (128 K)*/
#define BEPROM256  	0xfffc0000	/* 08b EPROM for the preboot code (256K)*/
#define BEPROM512  	0xfff80000	/* 08b EPROM for the preboot code (512K)*/
#define EEPROM  	0xc0030000	/* 16b EEPROM for nvram data */
#define FEPROM  	0xe0000000	/* 32b Flash EPROM for boot&application */
#define PERIPHIO 	0x90000000	/* 08b misc. I/O (LEDs, Wdog, etc.) */
#define	SLOWIO		0x80000000	/* 08b timers, SIO, etc. */
#define SONICIO  	0x70000000	/* 16b SONIC regs: 0x100 per chip */
#define DRAM    	0x30000000	/* 32b DRAM for code and data */
#define SRAM    	0x2ff80000	/* 512kb SRAM for code and data */
#define SHRAM   	0x50000000	/* 32b Shared SRAM for CPU & SONIC */
#define NVRAM		0xc0000000	/* 8b NVRAM */
#define ADMRAM		0xa0000000	/* 8b NVRAM */
#define	ADMRAM_SIZE	(32 * 1024)	/* 32 k 	*/
/*
 *	Data size reserved for important data in the beginning of 
 *	SRAM.
 */
#define	SYS_DATA_SIZE	0x00010000		/* 64 K 	*/

/* divisions of SONICIO */
#define SONIC_IO_SPC	0x80	/* 100 between each sonic */

/*
 * divisions of SLOWIO
 */
#define TIMERIO	(SLOWIO+0x0000)	/* Location of the TIMER regs */
#define UARTIO	(SLOWIO+0x0010)	/* Location of the UART regs */

/*
 * divisions of PERIPHIO
 */
#define TR_RI_REG	(PERIPHIO)
#define TR_SLED_REG (PERIPHIO+0x0020) /* Location of 7-seg LED's */
#define LEDIO		(PERIPHIO+0x0040) /* Location of LED's */

/*
 * for the current zebra board, io address for bi-color led
 * and mono-color led are swapped, remember to swap them back
 * in the future
 */
#define LEDMIO	(PERIPHIO+0x0060) /* Location of LED's */
#define LEDBIO	(PERIPHIO+0x0040) /* Location of LED's */
#define	HUBIDIO	(PERIPHIO+0x0040) /* hub id */
#define DIPIO	(PERIPHIO+0x0060) /* Location of DIP_SWITCHES */
#define WDOGIO	(PERIPHIO+0x0080) /* Location of Watch Dog strobe */
#define	CARRIERIO	(PERIPHIO+0x00a0)	/* location of lan carrier 
						 * sense, back plane type 
						 * and slot id */
#define SNCENA	(PERIPHIO+0x00c0)	/* reset control lines for the Sonics */
#define GPWREG  (PERIPHIO+0x00c0)   /* misc ctrl lines (Gen Purpose Wr Reg) */

#define	CONTROL_IO	(PERIPHIO+0x00e0)/* control port io	*/

#define	SLOTID_MASK	0x0f		/* slot id bits are d0 - d3	*/
#define	BACK_PLANE_TYPE_MASK	0x60	/* it is d5 and d6		*/
#define	BACK_PLANE_STANDALONE	0x60	/* d5 and d6 are set for this	*/
#define	SYSCARD_INSTALLED	0x10	/* d4 is 0 if a system card is installed */

#define	TRANSCEIVER_TYPE_MASK	0xE000	/* d13 - d15 for transceiver type */
#define	TRANSCEIVER_AUI		0x0000	/* AUI 		*/
#define	TRANSCEIVER_THIN_NET	0x2000	/* THIN NET	*/
#define	TRANSCEIVER_10BASET	0x4000	/* 10 base T	*/
#define	TRANSCEIVER_FOIRL	0x8000
#define	TRANSCEIVER_BLANK	0xE000	

/*
* used by scc routines
*/
#define	SCC_COLLISION_REG	0x80000020

#ifdef __FDDI_CON	/* GJS */
/******************************************************************
 Defintions for fddi code that needs to compile, but that we
	may or may not be using
******************************************************************/
#include <fddimap.h>

#define DEFAULT_DRAM_SIZE     0x00400000      /* 4 Megabytes */
#define DEFAULT_NVRAM_SIZE    0x00020000      /* 128K */
#define DEFAULT_EEPROM_SIZE   0x00002000      /* 8 Kb */
#define DEFAULT_FPROM_SIZE    0x00100000      /* 1 Megabytes */
#define	EEP_INPUT	0					/* i960/util/eeprom.c */
#define	EEP_CONTROL	0					/* i960/util/eeprom.c */
#define BP_RCV_LINE	(PERIPHIO)
#define SEVEN_SEGMENT	(PERIPHIO+0x0020)	/* seven segment port */
#define DIPIO1		(PERIPHIO+0x0060) /* Location of DIP_SWITCHES */
#define DIPIO2		(PERIPHIO+0x0061) /* Location of DIP_SWITCHES */
#define SLOT_ID		(PERIPHIO+0x00a0)	/* slot id */
#define NVRAM_ENABLE (PERIPHIO+0x00c0)	/* reg for NVLOCK bit */
#define FDDI_LANRST_REG	(PERIPHIO+0x00c0)	/* reset ctrl line for FDDI */
#define DRAM_SIZE_CTRL	(PERIPHIO+0x00e0)	/* reg for DRAM size select */
#define DEFAULT_SRAM_SIZE	1024		/* boot/tftpboot/main.c */
#define DEFAULT_CPU_CACHE_SIZE	1024	/* boot/tftpboot/main.c */
#define TIMER3_INT           3			/* timer 3 int priority */
#define TIMER3_INT_VECTOR    0x66		/* timer 3 cached vector no. */
#define BOOTER_MEMORY_SIZE     (((unsigned int) &end + 0x50000) - DRAM) 
                                        /*(0x00150000)*/
#define BP_RCV_LINE2    BP_RCV_LINE   /* 2nd backplane receive line wreg*/
#define	FDDI_BYPASS_SWITCH_PRESENT	0x60000017	/* optical bypass in phy reg */
/* THESE NEXT 2 ACtually point to the 7-segment LED register, because we 
	don't have these regs in the fddi-eth bridge ** TEMPORARY ** */
#define BP_AM_MUX       (PERIPHIO+0x0020)   /* Multiplex B & M into back plane */
#define BP_BM_MUX       (PERIPHIO+0x0020)   /* Multiplex B & M into back plane */
#endif

/* EEP Record & NVRAM Record sizes */
#define MAX_MAC_RESERVED     2
#define MAX_PATH_RESERVED    MAX_MAC_RESERVED
#define MAX_PORT_RESERVED    16
#define MAX_ATTACH_RESERVED  MAX_PORT_RESERVED

#define SMALLOC_SIZE  	 	0x8000		/* SRAM area tested by loader */
#ifdef notused
#define BOOT_AREA_START		0x30300000	/* start of boot area */
#endif
#define BOOT_AREA_START		0x30200000	/* start of boot area */
#define BOOT_AREA_END		0x30400000	/* start of boot area */

#endif /* __MEMORY_H */

