/*********************************************************************
 *  File          msgutil.h
 *
 *  Description
 *    Used by the fddi mailbox only. 
 *
 *  Copyright (c) 1992. 1993 Hughes Lan Systems
 *
 *  $Log:   /user/pvcs/fddicon/include/msgutil.h_v  
 * 
 *    Rev 1.21.1.2   12 Oct 1993 12:48:10   gregs
 * No change.
 * 
 *    Rev 1.21.1.1   15 Sep 1993 09:08:08   gregs
 * No change.
 * 
 *    Rev 1.21.1.0   30 Jul 1993 09:47:50   jang
 * took out dbd.h and changed PKT_RCV_BROADCAST/PKT_GROUP to
 * hex numbers
 * 
 *    Rev 1.21   26 Apr 1993 20:44:54   jlin
 * Move EClistElement data structure from fbmsrp.c to this file
 * 
 *    Rev 1.20   24 Apr 1993 12:22:34   jlin
 * 
 *    Rev 1.19   13 Apr 1993 13:38:38   jang
 * added one more field in drv_generic_msg for port locking/trigger
 * 
 *    Rev 1.18   07 Apr 1993 08:45:38   jang
 * changed frame_len & frame_flag in generic_msg from short to int
 * 
 *    Rev 1.17   02 Apr 1993 14:14:12   jlin
 * 
 *    Rev 1.16   01 Apr 1993 15:43:46   jlin
 * 
 *    Rev 1.15   09 Mar 1993 15:43:44   nayan
 * 
 *    Rev 1.14   13 Jan 1993 18:46:20   jlin
 * 
 *    Rev 1.13   13 Jan 1993 17:54:48   jlin
 * 
 *    Rev 1.12   28 Dec 1992 14:05:08   jang
 * added next and pkt[] to drv_generic_msg
 * 
 *    Rev 1.11   21 Dec 1992 14:07:48   shekhar
 * 
 *    Rev 1.10   17 Dec 1992 15:46:00   jang
 * added more fields to drv_generic_msg for collector need.
 ********************************************************************/


#ifndef __MSGUTIL_H
#  define __MSGUTIL_H

#include "ifglobal.h"
#include "drvglbl.h"
#include "fdrmonty.h"


/* The lower value, the highest priority */
#define EV_MAC_DISABLED       0x01
#define EV_BUILD_PHYSICAL_MAP 0x02
#define EV_OTHER              0x04
#define EV_SIF_REQ_TIME_OUT   0x08
#define EV_MAC_ENABLED        0x10


#define INIT_FREE_FDDI_MSGHDR_CT       200
#define INIT_FREE_SMT_MSG_BUFFERS_CT   1
#define MORE_FREE_FDDI_MSGHDR_CT       3
#define MORE_FREE_SMT_MSG_BUFFERS_CT   3
#define INTERNAL_MSGDATA_SIZE 1000    /* not including header
				         size */ 
#define SMT_MSG_BUFFER_SIZE   4500

#define GetFDDIMsgHdr()      (GenericMsgType *) RcvMessage(&FDDIMsgHdrDescr.freeMsgList)
#define AcptFDDIMsgHdr()     (GenericMsgType *) AcptMessage(&FDDIMsgHdrDescr.freeMsgList)
#define FreeFDDIMsgHdr(buf)  (GenericMsgType *) SendMessage((MSGHDR*) buf, &FDDIMsgHdrDescr.freeMsgList)

#define AcptSRFMsgBuf()      AcptMessage(&SRFIntMsgDescr.freeMsgList)
#define FreeSRFMsgBuf(buf)   SendMessage((MSGHDR*) buf, &SRFIntMsgDescr.freeMsgList)

/* Data Structure Types */
/*
 *  Used to be defined in the SMT core file fbmsrp.c
 */

#define	MAX_EC_ELEMENTS	185

struct ECListElement {
	struct ECListElement	*nextEC;
	struct ECListElement	*lastEC;
	uInt32			limitCount;
	union {
		TLVHdrType		hdr;
		EvtCfgChgType		evtCfgChg;
		CondDAType		condDA;
		CondFrErrType		condFrErr;
		CondNotCopiedType	condNotCopied;
		EvtNbrChgType		evtNbrChg;
		EvtTrStatType		evtTrStat;
		CondLerType		condLer;
		EvtConnectType		evtConnect;
		CondEBErrType		condEBError;
	} data;
};

/**************************************/
typedef struct 
{
   uInt16 entity;
   uInt16 signalType;
} DriverSignalType;

typedef void *(*MallocFuncVector) (size_t);
typedef void (*FreeFuncVector)(char*);


typedef struct memfreelist
{
   size_t MsgSize;
   uInt16 MsgCount;
   uInt16 MsgAdding;
   MallocFuncVector MallocFunc;
   FreeFuncVector FreeFunc ;
   MBOX freeMsgList;
} MemFreeListDescriptor;

#define PKT_CP_LEN       22  /* the rx pkt len copied to upper layer */
typedef struct drv_generic_msg
{
   struct GenericMsgType *msghdr;
   uInt32 mh_marker;
   struct drv_generic_msg *next;   /* for chaining */
   uInt32 msg_type;
      #define DRV_EVENT_MSG_TYPE    1
      #define DRV_RX_MSG_TYPE       2
      #define DRV_SM_MA_ST_MSG_TYPE 3
      #define MSG_FBM_TIMER_TIMEOUT 4
      #define MSG_FBM_STOP          5
      #define PORT_LOCK_MSG_TYPE    6
   uInt32 dev_num;
   byte   *ptr;
   uint32 frame_status;    /* rx frame E, C, A status */
   uint32 frame_len;       /* frame len, exclude fcs */
   uint32 frame_flag;      /* receive flag */
#define MSG_RX_BROADCAST   0x0002
#define MSG_RX_GROUP       0x0040   /* multicast */
   HOSTENTRY *DAhost_ptr;  /* DA host table */
   HOSTENTRY *SAhost_ptr;  /* SA host table */
   uint32 port_lock_type;  /* msg type of port locking/trigger */
#define  UNLOCK_PORT               0
#define  LOCK_PORT_BY_TRIG         1
#define  LOCK_PORT_BY_ADDR         2
   byte      pkt[PKT_CP_LEN];
} drv_generic_msg;

typedef drv_generic_msg GenericMsgType;


/* extern Variables */

extern MBOX RxSMTFrameMBox, TxSMTFrameMBox;
extern MemFreeListDescriptor FDDIMsgHdrDescr, SMTIntMsgDescr, SRFIntMsgDescr;
extern void *lmalloc();
extern void free();
extern void PushSignal();
extern uInt32 PopSignal();
extern void InitSignalStack();

#endif __MSGUTIL_H
