/***************************************************************************
 *  File monp.h
 *
 *  Description:
 *     Header file for monp.c
 *
 *  Copyright (c) 1992, 1993 Hughes Lan Systems
 *
 *  $Log:   /usr/shasta/pvcs/fddicon/include/monp.h_v  
 * 
 *    Rev 1.11   30 Apr 1993 16:24:06   jang
 * changed MAX_MON_FRAME to 15
 * 
 *    Rev 1.10   24 Apr 1993 12:07:38   jang
 * added one function prototype
 * 
 *    Rev 1.9   21 Apr 1993 15:33:42   jang
 * fixed the error define of FDDI_SMT_FRAME_MASK
 * 
 *    Rev 1.8   13 Apr 1993 13:38:10   jang
 * added 3 defines for port locking/trigger
 * 
 *    Rev 1.7   05 Apr 1993 16:35:10   jang
 * changed the monp msg header handling
 * 
 *    Rev 1.6   25 Mar 1993 17:06:14   jang
 * increased MAX_MON_FRAME from 30 to 60
 * 
 *    Rev 1.5   12 Feb 1993 16:09:42   jang
 * 
 *    Rev 1.4   12 Feb 1993 16:05:06   jang
 * commented out one function prototype due to multiple definition
 * 
 *    Rev 1.3   08 Feb 1993 16:31:38   nayan
 * changed PORT_INFO so that it will alignment with 
 * word boundary
 * 
 *    Rev 1.2   08 Jan 1993 11:41:36   shekhar
 * defined port action constants.
 * 
 *    Rev 1.1   07 Jan 1993 09:45:42   jang
 * 
 *    Rev 1.0   29 Dec 1992 17:53:32   jang
 * Initial revision.
 **************************************************************************/

#ifndef _MONP_H_
#define _MONP_H_


#include <types.h>
#include <fdrmonty.h>
#include <fddi.h>
#include <krnl.h>

#define PORT_NOT_LOCK                 0
#define PORT_LOCK_BY_TRIG             1
#define PORT_LOCK_BY_ADDR             2





extern MBOX MonpMsgMbox;
#define MONP_FreeMonpMsg(msg)    SendMessage((MSGHDR *)msg,&MonpMsgMbox)

#define MAX_MON_FRAME     15   /* max frames to process each time */
#define FDDI_LLC_FC_MASK  0xf0 /* mask out the LLC priority bits */
#define FDDI_LLC_ASY      0x50 /* LLC async pkt - 48 bits addr */
#define FDDI_LLC_SYN      0xd0 /* LLC sync pkt - 48 bits addr */
#define FDDI_SMT_FRAME_MASK    0x30  /* 4th bit is 0 */


#define MLSTATS_DROP_EVNT     1   /* drop event */
#define MLSTATS_VOID_FRAME    2   /* void frame event */
#define MLSTATS_VOID_PKT      3   /* void pkt */
#define MLSTATS_BCN_EVNT      4   /* beacon event */
#define MLSTATS_BCN_PKT       5
#define MLSTATS_CLM_EVNT      6   /* claim event */
#define MLSTATS_CLM_PKT       7


/*
 *---------------------------------------------------------------------
   the port is numbering as:
     physical port position -  B  M5  M4  M3  M2  A
     indexing               -  0  5   4   3   2   1

   All the fields in the structure are pointers that point to smt mibs
   or rmon mibs. All the pointers should be initialized at PHY_Init().
 *---------------------------------------------------------------------
 */
#define LOCK_ADDR_MAX      6   /* # of addresses monitored per port */
#define LOCK_ADDR_LEN      6   /* address bytes - long address */
#define LOCK_SRC_ADDR      0
#define LOCK_DEST_ADDR     1

typedef struct _port_info_ {
  uint32 src_addr_num;
  byte   src_addr[LOCK_ADDR_MAX][LOCK_ADDR_LEN]; /* address locking */
  uint32 dest_addr_num;
  byte   dest_addr[LOCK_ADDR_MAX][LOCK_ADDR_LEN];


  FDDI_PSTATS *pstats;   /* point to promiscuous statistics table */
} PORT_INFO;


/* Definitions of PORT ACTIONS */
#define PORT_ACT_VALID		2
#define PORT_ACT_INVALID	1




/*
 *----------------------------------------------------------------------
 *   Function prototypes
 *----------------------------------------------------------------------
 */



extern void MONP_Init(void);
extern HOSTENTRY *MONP_hash(byte *,uint32,bool);
extern void MONP_Process();
extern void MONP_FreePstats(FDDI_PSTATS *);

extern void MONP_StopProc(void);
extern void MONP_StartProc(void);
extern void MONP_MLstats(uint32,uint32);
extern void MONP_PstatsDataPkt(FDDI_PSTATS *,uint32,uint32);
extern FDDI_PSTATS *MONP_get_free_pstats();

#ifdef DO_LINT
extern void MONP_PstatsDataPkt(uint32,uint32,uint32);
#else
extern void MONP_PstatsDataPkt();
#endif


#endif

