
/**
 *	Filename:	dbd.h	
 *
 *	$Log:   /b/gregs/i960/include/pkt.h_v  $
 * 
 *    Rev 1.1   30 Jul 1993 13:38:24   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:28:42   gregs
 * Initial revision.
 * 
 *	Comments:	The PKT data structure.
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/


#ifndef __PKT_H
#define __PKT_H 0x100a	/* V1.00a */

#ifndef __DBD_H
#include <dbd.h>
#endif

#ifndef __KRNL_H
#include <krnl.h>
#endif

typedef struct pkt
	{
	/* PACKET INFO */
	MSGHDR		pktMsgHdr;	/* for application use */
	unsigned short	pktTotalSize;	/* byte cnt of frame */
	unsigned short	pktUseCount;	/* */
	unsigned short	pktRcvPort;	/* port # on which pkt was received */
	unsigned short	pktXmtPort; 	/* bit mask of xmt ports */
	struct pkt	*pktDriverLink; /* for linking used by driver */

	/* BUFFER INFO */
	struct pkt 	*pktBufLink;	/* for buffer chaining */
	char		*pktBufPtr;	/* pointer to this buffer */
	unsigned short	pktBufLen;	/* length of the buffer */
	unsigned short	pktDataSize;	/* byte cnt of data */
	char		*pktDataPtr;	/* pointer to data in this buffer */
	void		(*pktFree)();	/* function to free this pkt */
	void		(*pktDriverFree)();	/* to free driver buffer */
	unsigned int	pktDriverInfo;	/* index to Descriptor of the driver */

	/* BRIDGE INFO */
	int		pktBridgeArea[4];

	/* APPLICATION (ROUTER) INFO */
	int		pktApplArea[4];
	} PKT;

/* add by sammy here 11/19/92 */
/*#define PKTINXMT	0x80000000 */
#define PKTINXMT	0x8000
#define PKTBROUT	0x4000
#define PKTBROUTINXMT	PKTINXMT|PKTBROUT

#define pktDestRecord pktBridgeArea[0]
#define pktProtocol pktBridgeArea[1]
#define pktLocal pktApplArea[0]

#define PKT_MARKER 	0x88888888	/* mark that this is a PKT */

#ifndef __NID_DEF
#define	__NID_DEF

#endif

#endif
