/*********************************************************************
	Management Application Module

	MAP SMT Control Menu Module

	File:		mapmctl.c
	Created:	03/25/91

	SID:		1.1
	Last Modified:	4/22/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module provides the MAP Station Control menu 
	SMT submenu functions.

	Modification History:
*********************************************************************/

#include        "ctype.h"
#include        "smtdefs.h"
#include        "smttypes.h"
#include        "smtmsg.h"
#include        "smtmacro.h"
#include        "fbmmacro.h"
#include        "fddihdr.h"
#include        "mibdefs.h"
#include	"maphdr.h"
#include	"mapglbl.h"
#include        "krnl.h"


extern	WINDOW	*inputwin;
extern	WINDOW	*WindowGet ();
extern	int	WindowVisible ();
extern	PTVF_t	WindowUpdate ();
extern	void	WorkLoop ();
extern	void	DoSMTWindow ();
extern	void	DoMACStatWindow ();

extern	uInt32	MAPGetMIBAttr ();
extern	uInt32	MAPChangeMIBAttr ();
TIMER   FDDIActionTimer;

/*********************************************************************
	Menu Command SMT Menu
*********************************************************************/
uChar ReadSMTECMState()
{
        mibAttr[0].paramType = fddiSMTECMState;
	mibAttr[0].paramLen = 0;
	MAPGetMIBAttr (sizeof (TLVParamType), (uChar *) mibAttr, NULL);

	return mibAttr[0].SMTPARAM8;
}

void
DoConnect ()
/*********************************************************************
Function:	Give a connect command to SMT.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
uInt32		result, i;

	/* clear buffers */
	MEMZERO (&mibData, sizeof (mibData));

	mibData.paramType = fddiSMTStationAction;
	mibData.paramLen = 4;
	mibData.SMTPARAM16 = StationAction_Connect;

        MAPChangeMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);

        for (i=0; (i < 30000) && (ReadSMTECMState() != EC_IN); i++)
	{
	   ReSchedule();   /* let SMT have chances to initialize ports */
	}
	return;
}

void
DoDisconnect ()
/*********************************************************************
Function:	Give SMT a disconnect command.
Parameters:	None.
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
uInt32		result, i;

	/* clear buffers */
	MEMZERO (&mibData, sizeof (mibData));

	mibData.paramType = fddiSMTStationAction;
	mibData.paramLen = 4;
	mibData.SMTPARAM16 = StationAction_Disconnect;

        MAPChangeMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);

        for (i=0; (i < 3000) && (ReadSMTECMState() != EC_OUT); i++)
	{
	   ReSchedule();   /* let SMT have chances to close ports */
	}
	return;
}

void FDDIActionDisconnect( dummy )
int dummy;
{
   DoDisconnect();
}

void SignalDoDisconnect()
/* intend to be called in the ISR */
{
   StartTimerCall(&FDDIActionTimer, 1, FDDIActionDisconnect, (int) 0);
}

void
DisplaySMTParameters ()
/*********************************************************************
Function:	Display the SMT parameters.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
WINDOW	*win=NULL;
int	i, y;
char	c;
TLVParamType	mibData;

	/* read MIB data */
	mibData.paramType = fddiSMTOpVersionId;
	mibData.paramLen = 0;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.SMTStationIdGrp.OpVersionId = mibData.SMTPARAM16;

	mibData.paramType = fddiSMTUserData;
	mibData.paramLen = 0;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	MEMCOPY (mapInfo.SMTStationIdGrp.UserData, mibData.SMTOTHER, 32);

	mibData.paramType = fddiSMTConnectionPolicy;
	mibData.paramLen = 0;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.SMTStationConfigGrp.ConnectionPolicy = mibData.SMTPARAM16;

	mibData.paramType = fddiSMTReportLimit;
	mibData.paramLen = 0;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.SMTStationConfigGrp.ReportLimit = mibData.SMTPARAM32;

	mibData.paramType = fddiSMTT_Notify;
	mibData.paramLen = 0;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.SMTStationConfigGrp.T_Notify = mibData.SMTPARAM16;

	wmove (win, 0, 0);
	wprintw (win, "   SMT Operating Parameters\n\n");

	win = WindowGet (DISPLAY_WIN);
	wprintw (win, "1. Operating Version ID: ");
	wprintw (win, "%d\n", mapInfo.SMTStationIdGrp.OpVersionId);
        wprintw (win, "2. SMT User Data:\n");
	for (y = 0; y < 4; y++)
	{
	        printf("\t");
		for (i = 0; i < 8; i++)
		{
			c = mapInfo.SMTStationIdGrp.UserData[(y<<3)+i];
			if (isprint (c))
			   wprintw (win, "%02x", c);
			else
			  wprintw (win, ".");
		}
		printf("\n");
	}
	wprintw (win, "3. Connection Policy: ");
	wprintw (win, "0x%04x\n",
		mapInfo.SMTStationConfigGrp.ConnectionPolicy);

	wprintw (win, "4. SRF Report Limit: ");
	wprintw (win, "%d Frames\n",
		mapInfo.SMTStationConfigGrp.ReportLimit);

	wprintw (win, "5. NN T_Notify:");
	wprintw (win, "%d Seconds\n",
		mapInfo.SMTStationConfigGrp.T_Notify);

        printf("\n\n");
	return;
}

void
SMTParameters ()
/*********************************************************************
Function:	Display/change SMT parameters.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		Updates mapInfo MIB database.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
int		oldWorkWin;
int		c;
uInt32		result, value;
WINDOW		*win;
extern	char	mapinstr[];

	oldWorkWin = WindowVisible (WORK_WIN, FALSE);
	WindowUpdate (DISPLAY_WIN, DisplaySMTParameters);
	WindowVisible (DISPLAY_WIN, TRUE);
	win = WindowGet (DISPLAY_WIN);
	werase (win);

	DisplaySMTParameters ();

	werase (inputwin);
	wprintw (inputwin, "Enter parameter number to change (RETURN to exit):\n");

	c = 0;
	while (c != CHAR_RETURN)
	{
		c = WGETCH (inputwin);

		result = 0;
		switch (c)
		{
		case '1':
			/* Set version ID */
			wprintw (inputwin, "Enter new version ID: ");
			mibData.paramType = fddiSMTOpVersionId;
			mibData.paramLen = 4;
			wscanw (inputwin, "%d", &value);
			mibData.SMTPARAM16 = value;
			break;

		case '2':
			/* set user data */
			wprintw (inputwin, "Enter new User Data: ");
			mibData.paramType = fddiSMTUserData;
			mibData.paramLen = 32;
			gets (mapinstr);
			memcpy (mibData.SMTOTHER, mapinstr, mibData.paramLen);
			break;

		case '3':
			/* set connection policy */
			wprintw (inputwin, "Enter new policy bit string: ");
			mibData.paramType = fddiSMTConnectionPolicy;
			mibData.paramLen = 4;
			wscanw (inputwin, "%x", &value);
			mibData.SMTPARAM16 = value;
			break;

		case '4':
			/* set report limit */
			wprintw (inputwin, "Enter new report limit: ");
			mibData.paramType = fddiSMTReportLimit;
			mibData.paramLen = 4;
			wscanw (inputwin, "%d", &value);
			mibData.SMTPARAM32 = value;
			break;

		case '5':
			/* set T_Notify */
			wprintw (inputwin, "Enter new T_Notify interval: ");
			mibData.paramType = fddiSMTT_Notify;
			mibData.paramLen = 4;
			wscanw (inputwin, "%d", &value);
			mibData.SMTPARAM16 = value;
			break;
		}

		if (c >= '1' && c <= '5')
		{
			result = DoMIBSet (sizeof (mibData),
				(uChar *) &mibData, &setCount);
			if (result != RC_SUCCESS)
				MIBErrorMessage ("SMT parameter not set",
					result);
		}
	}

	WindowVisible (WORK_WIN, oldWorkWin);
	WindowVisible (DISPLAY_WIN, FALSE);
	werase (win);

	return;
}
