/*********************************************************************
	Management Application Module

	MAP Window Module

	File:		mapwin.c
	Created:	03/20/91

	SID:		1.1
	Last Modified:	4/22/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module is provides the window display routines for the
	management application.

	Modification History:
*********************************************************************/

#ifdef	NSC_DOS
#include	<time.h>
#endif

#include        "smtdefs.h"
#include        "smttypes.h"
#include        "smtmsg.h"
#include        "fddihdr.h"
#include        "fbmframe.h"
#include        "smtmacro.h"
#include        "fbmmacro.h"
#include        "mibdefs.h"
#include	"maphdr.h"
#include	"mapglbl.h"

#define SMT_VERSION            "6.23"
#define RELEASE_NUM            "1.0"


extern	TLVParamType	*FindGroupAttr ();
extern	uInt32		MAPGetMIBAttr ();
extern	uInt32		ntohl ();
extern	uInt32		htonl ();
extern	uInt16		ntohs ();
extern	uInt16		htons ();
extern  WINDOW*         newwin();
extern  void            ReadData ();


/*********************************************************************
	Window Structures
*********************************************************************/

WINDOW	*statwin, 		/* station status */
	*inputwin, 		/* user input */
	*displaywin,		/* temp work display */
	*workwin,		/* active working window */
	*framewin,		/* frame buffer display */
	*parsewin,		/* frame parse display */
	*eventwin,		/* event display */
	*menuwin;		/* menu display */


typedef struct DispStatStruct {
	int	visible;	/* set if visible */
	WINDOW	*win;		/* window to use */
	void	(*proc) ();	/* window drawing routine */
} DispStatType;

DispStatType	dispStat[MAX_WIN_COUNT];


/*********************************************************************
	Global Data
*********************************************************************/
uChar PortNum[MAX_PORT_COUNT] =    { 1, 8, 2, 3, 4, 5, 6, 7 };
uChar mibPortNum[MAX_PORT_COUNT] = { 1, 3, 4, 5, 6, 7, 8, 2 };

/*********************************************************************
	Window Display Routines
*********************************************************************/

void
DisplayStationInfo ()
/*********************************************************************
CONFIG _12_________ aa:aa:aa:aa:aa:aa ECM:_9_______     CFM:_8______
       7            20                    42                60
*********************************************************************/
{
WINDOW	*win;

	win = dispStat[SMT_WIN].win;

	wstandout (win);

	wprintw (win, "\nCONFIG %s ",
		TYPESTATION[(mapInfo.SMTStationConfigGrp.Master_Ct > 0) ? 1 : 0]);

	wprintw (win, " %02x:%02x:%02x:%02x:%02x:%02x  ",
		bitSwap[mapInfo.SMTStationIdGrp.StationId.IEEEAddress[0]],
		bitSwap[mapInfo.SMTStationIdGrp.StationId.IEEEAddress[1]],
		bitSwap[mapInfo.SMTStationIdGrp.StationId.IEEEAddress[2]],
		bitSwap[mapInfo.SMTStationIdGrp.StationId.IEEEAddress[3]],
		bitSwap[mapInfo.SMTStationIdGrp.StationId.IEEEAddress[4]],
		bitSwap[mapInfo.SMTStationIdGrp.StationId.IEEEAddress[5]]);

	wprintw (win, "ECM:%s  ", ECMSTATE[mapInfo.SMTStatusGrp.ECMState]);

	wprintw (win, "CFM:%s\n", CFMSTATE[mapInfo.SMTStatusGrp.CF_State]);

	wstandend (win);

        return;
}

void
DisplayMACInfo (macID)
        uInt16    macID;
/*********************************************************************
MAC  d  aaaaaaaaaaaa UNA:aaaaaaaaaaaa DNA:aaaaaaaaaaaa  RMT:_11________
     5  8                25               42                60
*********************************************************************/
{
int	line;
WINDOW	*win;

	win = dispStat[SMT_WIN].win;

	line = 1 + macID;

	wstandout (win);

	wprintw (win, "MAC %1d  ", macID);

	wprintw (win, "%02x%02x%02x%02x%02x%02x \n",
		mapInfo.MACAddressGrp[macID].SMTAddress[0],
		mapInfo.MACAddressGrp[macID].SMTAddress[1],
		mapInfo.MACAddressGrp[macID].SMTAddress[2],
		mapInfo.MACAddressGrp[macID].SMTAddress[3],
		mapInfo.MACAddressGrp[macID].SMTAddress[4],
		mapInfo.MACAddressGrp[macID].SMTAddress[5]);
/*
	wprintw (win, "UNA:%02x%02x%02x%02x%02x%02x ",
		mapInfo.MACConfigGrp[macID].UpstreamNbr[0],
		mapInfo.MACConfigGrp[macID].UpstreamNbr[1],
		mapInfo.MACConfigGrp[macID].UpstreamNbr[2],
		mapInfo.MACConfigGrp[macID].UpstreamNbr[3],
		mapInfo.MACConfigGrp[macID].UpstreamNbr[4],
		mapInfo.MACConfigGrp[macID].UpstreamNbr[5]);

	wprintw (win, "DNA:%02x%02x%02x%02x%02x%02x  ",
		mapInfo.MACConfigGrp[macID].DownstreamNbr[0],
		mapInfo.MACConfigGrp[macID].DownstreamNbr[1],
		mapInfo.MACConfigGrp[macID].DownstreamNbr[2],
		mapInfo.MACConfigGrp[macID].DownstreamNbr[3],
		mapInfo.MACConfigGrp[macID].DownstreamNbr[4],
		mapInfo.MACConfigGrp[macID].DownstreamNbr[5]);

	wprintw (win, "%RMT:%s\n",
		RMTSTATE[mapInfo.MACStatusGrp[macID].RMTState]);
*/

	wstandend (win);

        return;
}

void
DisplayPHYInfo (phyID)
        uInt16    phyID;
/*********************************************************************
PORT c  PCM:_7_____  LER:10e-dd  PC_Nbr:c  RemoteMAC:c  CEM:_8______  LCF:dd
     5      12               29         40           53     60            74
*********************************************************************/
{
int	line;
WINDOW	*win;

	win = dispStat[SMT_WIN].win;

	if (phyID >= mapInfo.SMTStationConfigGrp.NonMaster_Ct
			+ mapInfo.SMTStationConfigGrp.Master_Ct)
                return;

	line = 1 + macTotal + phyID;

	wstandout (win);

wprintw (win, "  PORT %d (%s)  ", PortNum[phyID],
		PCTYPE[mapInfo.PORTConfigGrp[phyID].PC_Type]);

	wprintw (win, "PCM: %s  ",
		PCMSTATE[mapInfo.PORTStatusGrp[phyID].PCMState]);
/*
	wprintw (win, "LER:10e-%2d  ",
		mapInfo.PORTLerGrp[phyID].Ler_Estimate);
*/
	wprintw (win, "PC_Nbr:%s  ",
		PCTYPE[mapInfo.PORTConfigGrp[phyID].PC_Neighbor]);

	wprintw (win, "RemoteMAC:%c  ",
		(mapInfo.PORTConfigGrp[phyID].RemoteMACIndicated)?'Y':'N');

	wprintw (win, "CEM:%s  ",
		CEMSTATE[mapInfo.PORTConfigGrp[phyID].CE_State]);

	wprintw (win, "LCF:%2d\n",
		mapInfo.PORTErrorCtrsGrp[phyID].LCTFail_Ct);

	wstandend (win);

        return;
}

void
DoSMTWindow ()
/*********************************************************************
CONFIG _12_________ aa:aa:aa:aa:aa:aa ECM:_9_______     CFM:_8______
MAC  d  aaaaaaaaaaaa UNA:aaaaaaaaaaaa DNA:aaaaaaaaaaaa  RMT:_11________
PORT c  PCM:_7_____  LER:10e-dd  PC_Nbr:c  RemoteMAC:c  CEM:_8______  LCF:dd
*********************************************************************/
{
int	i;
WINDOW	*win;

	win = dispStat[SMT_WIN].win;
        ReadData();

	/* Show station data */

	DisplayStationInfo ();

	/* Show MAC data */
/*
	for (i = 0; i < mapInfo.SMTStationConfigGrp.MAC_Ct; i++)
	{

		DisplayMACInfo (i);
	}
*/
	for (i = 0;
		i < mapInfo.SMTStationConfigGrp.NonMaster_Ct
			+ mapInfo.SMTStationConfigGrp.Master_Ct;
		i++)
	{
		DisplayPHYInfo (i);
	}

	return;
}

void
DoStatusWindow ()
/*********************************************************************
Function:	Draws the status window.
Parameters:	None.
Input:		Uses mapInfo.
Output:		None.
Return:		None.
Display:
XLNT Manager(tm) x.x.xv                   1:RMT STATE__  2:RMT STATE__
*********************************************************************/
{
WINDOW	*win;
extern	char	*curMenu;		/* current menu option mapmenu.c */
#ifdef	NSC_DOS
time_t	curTime;
#endif

	/* get short hand value */
	win = dispStat[STATUS_WIN].win;


	wstandout (win);
	wprintw (win, "XLNT Manager(tm) SMT %s%s",
		SMT_VERSION, RELEASE_NUM);
	wstandend (win);

#ifdef NSC_DOS
	time (&curTime);
	wprintw (win, "%s", ctime (&curTime));
#endif

	wprintw (win, "1:%-11s",
		RMTSTATE[mapInfo.MACStatusGrp[0].RMTState]);

	if (mapInfo.SMTStationConfigGrp.MAC_Ct > 1)
	{
		wprintw (win, "2:%-11s",
			RMTSTATE[mapInfo.MACStatusGrp[1].RMTState]);
	}

	wstandout (win);
	wprintw (win, "%s", curMenu);
	wstandend (win);

	return;
}

void PrintCounter (win, y, x, mibData)
	WINDOW		*win;
	int		y, x;
	TLVParamType	*mibData;
/*********************************************************************
Function:	Print a counter value for the MAC statistics.
Parameters:	win	= window to use
		y, x	= starting coordinates
		mibData	= MIB MAC counter attribute
Input:		Uses dispStat[].
Output:		None.
Return:		None.
*********************************************************************/
{
	wstandout (win);
	if (mibData)
		wprintw (win, "%11d", mibData->MACPARAM32);
	else
		wprintw (win, "%11s", "N/A");
	wstandend (win);

	return;
}

void
DoMACStatWindow ()
/*********************************************************************
Function:	Display MAC statistics.
Parameters:	None.
Input:		Uses dispStat[].
Output:		None.
Return:		None.
Primary MAC                             Secondary MAC
UNA:xxxx xxxx xxxx  DNA:xxxx xxxx xxxx  UNA:xxxx xxxx xxxx  DNA:xxxx xxxx xxxx

Counters Grp         Error Ctrs Grp     Counters Grp         Error Ctrs Grp
Frame    ##########  Error  ##########  Frame    ##########  Error  ##########  
Copied   ##########  Lost   ##########  Copied   ##########  Lost   ##########  
Transmit ##########  TVXExp ##########  Transmit ##########  TVXExp ##########  
Token    ##########  NotCop ##########  Token    ##########  NotCop ##########  
                     Late   ##########                       Late   ##########  
                     RingOp ##########                       RingOp ##########  
*********************************************************************/
{
WINDOW 	*win;
int	i, offset;
TLVParamType	*mibData;

	win = dispStat[MAC_STAT_WIN].win;
        ReadData();
	offset = 0;

	for (i = 0; i < mapInfo.SMTStationConfigGrp.MAC_Ct; i++)
	{
		wprintw (win, 
			   ((i) ? "\nSecondary MAC\n" : "\nPrimary MAC\n"));
		/* UNA and DNA already in local MIB */
		wprintw (win,"UNA:%02x%02x %02x%02x %02x%02x  ",
			mapInfo.MACConfigGrp[i].UpstreamNbr[0],
			mapInfo.MACConfigGrp[i].UpstreamNbr[1],
			mapInfo.MACConfigGrp[i].UpstreamNbr[2],
			mapInfo.MACConfigGrp[i].UpstreamNbr[3],
			mapInfo.MACConfigGrp[i].UpstreamNbr[4],
			mapInfo.MACConfigGrp[i].UpstreamNbr[5]);

		wprintw (win, "DNA:%02x%02x %02x%02x %02x%02x\n\n",
			mapInfo.MACConfigGrp[i].DownstreamNbr[0],
			mapInfo.MACConfigGrp[i].DownstreamNbr[1],
			mapInfo.MACConfigGrp[i].DownstreamNbr[2],
			mapInfo.MACConfigGrp[i].DownstreamNbr[3],
			mapInfo.MACConfigGrp[i].DownstreamNbr[4],
			mapInfo.MACConfigGrp[i].DownstreamNbr[5]);

		/* get counters group */
		MEMZERO ((uChar *) mibAttr1, sizeof (MIBBufferType));
		mibAttr1[0].paramType = fddiMACCountersGrp;
		mibAttr1[0].paramLen = 4;
		mibAttr1[0].MACINDEX = i + 1;
		MAPGetMIBAttr (sizeof (MIBBufferType), (uChar *) mibAttr1, NULL);

		/* get error counters group */
		MEMZERO ((uChar *) mibAttr, sizeof (MIBBufferType));
		mibAttr[0].paramType = fddiMACErrorCtrsGrp;
		mibAttr[0].paramLen = 4;
		mibAttr[0].MACINDEX = i + 1;
		MAPGetMIBAttr (sizeof (MIBBufferType), (uChar *) mibAttr, NULL);

		wprintw (win, "Counters Grp\t\tError Ctrs Grp\n");
		wprintw (win, "Frame    ");
		mibData = FindGroupAttr (mibAttr1, fddiMACFrame_Ct);
		PrintCounter (win, 4, 9 + offset, mibData);

		mibData = FindGroupAttr (mibAttr, fddiMACError_Ct);
		printf("\tError  ");
		PrintCounter (win, 4, 28 + offset, mibData);
		printf("\n");

		wprintw (win, "Copied   ");
		mibData = FindGroupAttr (mibAttr1, fddiMACCopied_Ct);
		PrintCounter (win, 5, 9 + offset, mibData);

		printf("\tLost   ");
		mibData = FindGroupAttr (mibAttr, fddiMACLost_Ct);
		PrintCounter (win, 5, 28 + offset, mibData);
		printf("\n");

		wprintw (win, "Transmit ");
		mibData = FindGroupAttr (mibAttr1, fddiMACTransmit_Ct);
		PrintCounter (win, 6, 9 + offset, mibData);

		printf("\tTVXExp ");
		mibData = FindGroupAttr (mibAttr, fddiMACTvxExpired_Ct);
		PrintCounter (win, 6, 28 + offset, mibData);
		printf("\n");

		wprintw (win, "Token    ");
		mibData = FindGroupAttr (mibAttr1, fddiMACToken_Ct);
		PrintCounter (win, 7, 9 + offset, mibData);

		printf("\tNotCop ");
		mibData = FindGroupAttr (mibAttr, fddiMACNotCopied_Ct);
		PrintCounter (win, 7, 28 + offset, mibData);
		printf("\n");

		wprintw (win, "\t\tLate   ");
		mibData = FindGroupAttr (mibAttr, fddiMACLate_Ct);
		PrintCounter (win, 8, 28 + offset, mibData);
		printf("\n");

		wprintw (win, "\t\tRingOp ");
		mibData = FindGroupAttr (mibAttr, fddiMACRingOp_Ct);
		PrintCounter (win, 9, 28 + offset, mibData);
		printf("\n\n");

		offset += 40;
	}

	return;
}

void
DrawScreen ()
/*********************************************************************
Function:	Update the screen display.
Parameters:	None.
Input:		Uses dispStat[].
Output:		None.
Return:		None.
*********************************************************************/
{
int 	i;
int	count = 0;

	for (i = 0; i < MAX_WIN_COUNT; i++)
	{
		if (dispStat[i].visible)
		{
			if (dispStat[i].proc)
				(*dispStat[i].proc) ();
			wnoutrefresh (dispStat[i].win);
			count++;
		}
	}

	if (count)
		doupdate ();

	return;
}

void
StartupScreen ()
/*********************************************************************
Function:	Draw the title screen.
Parameters:	None.
Input:		Uses window pointers.
Output:		None.
Return:		0 if initialization is successful, otherwise an error code
		is returned.
*********************************************************************/
{
	wclear (statwin);
	werase (displaywin);
	werase (workwin);
	werase (inputwin);
	werase (eventwin);
	werase (menuwin);
	werase (framewin);
	werase (parsewin);

	DrawScreen ();

#define	LEFT_MARGIN 15
	wstandout (workwin);
	mvwprintw (workwin, 1, LEFT_MARGIN, "XLNT Manager(tm) Control Interface");
	mvwprintw (workwin, 2, LEFT_MARGIN, "          SMT Version %s", SMT_VERSION);
	mvwprintw (workwin, 4, LEFT_MARGIN, " Copyright 1991 XLNT Designs, Inc.");
	mvwprintw (workwin, 5, LEFT_MARGIN, "         XLNT Designs, Inc.");
	mvwprintw (workwin, 6, LEFT_MARGIN, "15010 Avenue of Science, Suite 100");
	mvwprintw (workwin, 7, LEFT_MARGIN, "     San Diego, CA 92128  USA");
	mvwprintw (workwin, 8, LEFT_MARGIN, "     Telephone (619) 487-9320");
	mvwprintw (workwin, 9, LEFT_MARGIN, "     FAX       (619) 487-9768");
	wstandend (workwin);
	mvwprintw (workwin, 11, LEFT_MARGIN, "Contact XDI for the latest version.\n");
	wrefresh (workwin);

	return;
}

uInt32
InitMAPWindows ()
/*********************************************************************
Function:	Provide local initialization support. Such support can
		include hardware initialization, local data initialization,
		system communications, etc.
Parameters:	None.
Input:
Output:
Return:		0 if initialization is successful, otherwise an error code
		is returned.
*********************************************************************/
{
int	i;

	/*
	*	Curses Initialization.
	*/
	initscr ();

	/* general status window */
	statwin = newwin (3, 79, 0, 0);		/* status lines */
	displaywin = newwin (11, 79, 3, 0);	/* temp display */
	workwin = newwin (11, 79, 3, 0);	/* active display */
	inputwin = newwin (5, 79, 20, 0);	/* user input */
	eventwin = newwin (6, 79, 14, 0);	/* event display */
	menuwin = newwin (11, 32, 3, 4);	/* menus */

						/* frame parsing */
	framewin = newwin (FRAME_LINES + 1, 79, 0, 0);
	parsewin = newwin (23 - FRAME_LINES, 79, FRAME_LINES + 1, 0);

	scrollok (inputwin, TRUE);
	scrollok (eventwin, TRUE);

	for (i = 0; i < MAX_WIN_COUNT; i++)
	{
		dispStat[i].visible = FALSE;
		dispStat[i].proc = (void *) NULL;
	}

	dispStat[STATUS_WIN].visible = SET;
	dispStat[STATUS_WIN].win = statwin;
	dispStat[STATUS_WIN].proc = DoStatusWindow;

	dispStat[INPUT_WIN].visible = SET;
	dispStat[INPUT_WIN].win = inputwin;

	dispStat[EVENT_WIN].visible = SET;
	dispStat[EVENT_WIN].win = eventwin;

	dispStat[WORK_WIN].win = workwin;

	dispStat[DISPLAY_WIN].win = displaywin;

	dispStat[FRAME_BUF_WIN].win = framewin;

	dispStat[FRAME_PARSE_WIN].win = parsewin;

	cbreak ();
	noecho ();
	keypad (inputwin, TRUE);
	/* nodelay (inputwin, TRUE); */

	cursoff ();

	return (0);
}

void
ExitMAPWindows ()
/*********************************************************************
Function:	Restore display to exit application.
Parameters:	None.
Input:
Output:
Return:		None.
*********************************************************************/
{
	curson ();
	endwin ();

	return;
}

WINDOW *
WindowGet (win)
int win;
/*********************************************************************
Function:	Get current window pointer.
Parameters:	win	= window index to get.
Input:		dispStat[]
Output:		None.
Return:		Current curses WINDOW pointer.
*********************************************************************/
{
	return (dispStat[win].win);
}

int
WindowVisible (win, status)
	int	win, status;
/*********************************************************************
Function:	Change window visibility status
Parameters:	win	= window index to change.
		status	= visibility status: TRUE or FALSE;
Input:		dispStat[]
Output:		Updates dispStat[]
Return:		Previous visibility status.
*********************************************************************/
{
int	previous;

	previous = dispStat[win].visible;
	dispStat[win].visible = status;
	return (previous);
}

PTVF_t
WindowUpdate (win, update)
	int	win;
	void	(*update)();
/*********************************************************************
Function:	Change window update status.
Parameters:	win	= window index to change.
		update	= update function or NULL for no updates.
Input:		dispStat[]
Output:		Updates dispStat[]
Return:		Previous update function.
*********************************************************************/
{
PTVF_t	previous;

	previous = dispStat[win].proc;
	dispStat[win].proc = update;
	return (previous);
}

