#include "fddi.h"
#include "smttypes.h"
#include "fddihdr.h"
#include "mibdefs.h"
#include "maphdr.h"
#include "mapglbl.h"
#include "memory.h"
#include "fddiled.h"
#include "smtmacro.h"
#include "krnl.h"
#include "brip.h"
#include "nvrfddi.h"
#include "dips.h"
#ifdef	__FEBRIDGE
#include "eeprecs.h"
#endif

/* States for FDDI Back Plane Insertion Protocol State Machine */
#define FBP_ISOLATED     0
#define FBP_INSERT_BPB   1
#define FBP_INSERT_BPA   2
#define FBP_INSERT_BPAB  3
#define FBP_STOP         0xff

#if 0
/* Events for the State Machine */
#define EVENT_INSERT_A      1
#define EVENT_ISOLATE_A     2
#define EVENT_INSERT_B      3
#define EVENT_ISOLATE_B     4
#define EVENT_ISOLATE_AB    5
#endif 

#define SELECT_M          0
#define SELECT_A          2
#define SELECT_B          SELECT_A

/* Some Defines to describe the bridge's A/B port configuration states		*/
/* They correspond to variables A_Port_Config_State and B_Port_Config_State.*/ 
/* Also defined in phy.h													*/
#ifdef __FEBRIDGE
#define	FRONT		1
#define BACK		2
#define QUIET_LINE_P        0x001c
#define QUIET_LINE_S        0x1c00
#define	RCV_A_MASK			0x00ff
#define	RCV_B_MASK			0xff00
static ushort BPRegValue1;
/* This table, indexed by ring-in line number, contains the 8-bit
value to be written to the RI register to select the given rcv line.
The output of this table is used directly for port A, but must be
shifted up by 8 for port B. */
static char RiRegConfig[] = {0x18,0x38,0x58,0x78,0x98,0xb8,0xd8,0xf8,
							 0x14,0x34,0x54,0x74,0x94,0xb4,0xd4,0xf4,
							 0x0c,0x2c,0x4c,0x6c,0x8c,0xac,0xcc,0xec};
#else
#define QUIET_LINE_P        0x18
#define QUIET_LINE_S        0xc0
static uChar BPRegValue1, BPRegValue2;
#endif
	
extern Flag SMTInitialized;
extern int *PortInitState;
extern int fault_cnt;
extern int brip_inited;

static uChar FddiBripState = FBP_STOP;
static word *FddiBripStack;
static MBOX StartActionMBox;
static uChar BPMStop[2];
uChar ECM_Active;
#define   FDDI_BRIP_STACK_SIZE     (sizeof(word) * 0x3000)

TIMER  PortStartTimer[4];
#define TIMER_A      0
#define TIMER_B      1
#define TIMER_MA     2
#define TIMER_MB     3
#define WAIT_FOR_START_INTERVAL  400   /* 4 seconds */
#define WAIT_FOR_INIT_INTERVAL  1000   /* 10 seconds */

void DisableFDDIBrip()
{
   if ((brip_inited) && (FddiBripState != FBP_STOP))
   {
      ECM_Active = FALSE;
      insert_hub_ring (0, 0);
   }
}

void EnableFDDIBrip()
{
   if (!ECM_Active)
   {
      ECM_Active = TRUE;
      if ((brip_inited) && (FddiBripState != FBP_STOP))
      {
	 insert_hub_ring (0, get_ring_number());
      }
   }
}

void AB2FrontPort()
{
   nvr_fddi_rec.UI_Defaults.Port1_PC_Type 
     = nvr_fddi_rec.PORTInfo[PHY_A].PC_Type;
   nvr_fddi_rec.UI_Defaults.Port6_PC_Type
     = nvr_fddi_rec.PORTInfo[PHY_B].PC_Type;
   PutFDDIRec(&nvr_fddi_rec);
   insert_hub_ring(0, get_ring_number());
}

void AB2Backplane()
{
   nvr_fddi_rec.UI_Defaults.Port1_PC_Type
     = nvr_fddi_rec.UI_Defaults.Port6_PC_Type = PC_Type_M;
   PutFDDIRec(&nvr_fddi_rec);
   insert_hub_ring(0, get_ring_number());
}

void ChangeRingNumber()
{
   unsigned ringNum, defaultRing;

   defaultRing = get_ring_number();
   ringNum = QueryUnsigned ("Please specify the new ring number",
			    (unsigned) defaultRing, 0, 14);
   if (ringNum != defaultRing)
   {
	  #ifndef __FEBRIDGE
      nvr_boot_rec.nvr_ring_number = (short) ringNum;
      PutBootRec(&nvr_boot_rec);
	  #else
	  eep_boot_rec.eep_ring_number = (short) ringNum;
	  PutEeprom(EEP_BOOT_ADDR,&eep_boot_rec,EEP_BOOT_SIZE);
	  #endif
      insert_hub_ring(0, ringNum);
   }
   #ifndef __FEBRIDGE
   else if (nvr_boot_rec.nvr_ring_number != -1)
   #else
   else if (eep_boot_rec.eep_ring_number != -1)
   #endif
   {
      printf("*** Ring Number is set to Dip Switch value\n");
	  #ifndef __FEBRIDGE
      nvr_boot_rec.nvr_ring_number = -1;
      PutBootRec(&nvr_boot_rec);
	  #else
	  eep_boot_rec.eep_ring_number = -1;
	  PutEeprom(EEP_BOOT_ADDR,&eep_boot_rec,EEP_BOOT_SIZE);
	  #endif
      insert_hub_ring(0, get_ring_number());
   }
}

void WriteReg (IOaddr, value)
uInt32 IOaddr;
uChar value;
{
   volatile uChar *IOReg;

   IOReg = (volatile uChar *) IOaddr;
   *IOReg = value;
}

uChar ReadPortPCMState(uInt16 portID)
{
      mibAttr[0].paramType = fddiPORTPCMState;
      mibAttr[0].paramLen = 4;
      mibAttr[0].PORTINDEX = portID + 1;
      MAPGetMIBAttr (sizeof (TLVParamType), (uChar *) mibAttr, NULL);
      return mibAttr[0].PORTPARAM8;
}

void DoPortAction ( portID, portAction )
uInt16 portID, portAction;
{
   char retry;
   uChar state;

   if (!SMTInitialized || !ECM_Active)
      return;

   mibAttr[0].paramType = fddiPORTAction;
   mibAttr[0].paramLen = 4;
   mibAttr[0].PORTINDEX = portID+1;
   mibAttr[0].PORTPARAM16 = portAction;
   MAPChangeMIBAttr (sizeof (TLVParamType), (uChar *) mibAttr, NULL);
   if (portAction != PORTAction_Disable)
   {
      return;
   }
   retry = 20;

   do 
   {
      ReSchedule();
      state = ReadPortPCMState(portID);
#if 0
      mibAttr[0].paramType = fddiPORTPCMState;
      mibAttr[0].paramLen = 4;
      mibAttr[0].PORTINDEX = portID+1;
      MAPGetMIBAttr (sizeof (TLVParamType), (uChar *) mibAttr, NULL);
#endif
   } while ((state != PC_MAINT) && (--retry > 0));
}

void DoStartPortActionTask ()
{ 
   TIMER *tm;

   while (TRUE)
   {
      tm = (TIMER*) RcvMessage (&StartActionMBox);
#if 0
   fault_cnt = 1;
   MAPDPT("************ Start Port %d\n", tm->tm_arg);
   fault_cnt = 0;
#if 0
   asm("fmark");
#endif
#endif
      DoPortAction((uInt16) tm->tm_arg, PORTAction_Start);
      ReSchedule();
   }
}

void StartPortTimer(timer, entity)
uInt16 timer, entity;
{
#if 0
      fault_cnt = 1;
      MAPDPT("************ Wait for Port %d\n", entity);
      fault_cnt = 0;
#if 0
      asm("fmark");
#endif
#endif
      PortStartTimer[timer].tm_arg = entity;
      StartTimer (&PortStartTimer[timer], (int) WAIT_FOR_START_INTERVAL,
		  &StartActionMBox);
}


void DoActionBM(Action)
uInt16 Action;
{
   if (Action == PORTAction_Start)
   {
      StartPortTimer(TIMER_B, PHY_B);
#ifndef __FEBRIDGE
      if ((BPMStop[1] != PC_MAINT) && (BPMStop[1] != PC_OFF))
      {
	 DoPortAction(MAX_PORT_COUNT - 1, Action);
      }
#endif
   }
   else
   {
      DoPortAction(PHY_B, Action);
#ifndef __FEBRIDGE
      if (Action == PORTAction_Enable) 
      {
	 if (BPMStop[1] != PC_MAINT)
	 {
	    DoPortAction(MAX_PORT_COUNT - 1, Action);
	 }
       }
      else
      {
	 DoPortAction(MAX_PORT_COUNT - 1, Action);
      }
#endif
   }

}

void DoActionAM (Action)
uInt16 Action;
{
   if (Action == PORTAction_Start)
   {
      StartPortTimer (TIMER_A, PHY_A);
#ifndef __FEBRIDGE
      if ((BPMStop[0] != PC_MAINT) && (BPMStop[0] != PC_OFF))
      {
	 DoPortAction(FDDI_NONMASTER_CT, Action);
      }
#endif
   }
   else
   {
      DoPortAction(PHY_A, Action);
#ifndef __FEBRIDGE
      if (Action == PORTAction_Enable) 
      {
	 if (BPMStop[0] != PC_MAINT)
	 {
	    DoPortAction(FDDI_NONMASTER_CT, Action);
	 }
       }
      else
      {
	 DoPortAction(FDDI_NONMASTER_CT, Action);
      }
#endif
   }
}

void SetBPBQuietLine()
{
#ifdef __FEBRIDGE
   BPRegValue1 = (BPRegValue1 & ~RCV_B_MASK) | QUIET_LINE_S;
   *(ushort*)BP_RCV_LINE = BPRegValue1;
#else
   BPRegValue2 = QUIET_LINE_S;
   WriteReg (BP_RCV_LINE2, BPRegValue2);
#endif
}

void SetBPAQuietLine()
{
#ifdef __FEBRIDGE
   BPRegValue1 = (BPRegValue1 & ~RCV_A_MASK) | QUIET_LINE_P;
   *(ushort*)BP_RCV_LINE = BPRegValue1;
#else
   BPRegValue1 |= QUIET_LINE_P;
   WriteReg (BP_RCV_LINE, BPRegValue1);
#endif
}

void PutBPRxQuiet()
{

#ifdef __FEBRIDGE
   BPRegValue1 = QUIET_LINE_P | QUIET_LINE_S;
   *(ushort*)BP_RCV_LINE = BPRegValue1;
/*
   Br_Switch_B_Phys(FRONT);
   Br_Switch_A_Phys(FRONT);
*/
#else
   BPRegValue1 = QUIET_LINE_P ;
   WriteReg (BP_RCV_LINE, BPRegValue1);
   WriteReg (BP_AM_MUX, SELECT_M);
   BPRegValue2 = QUIET_LINE_S;
   WriteReg (BP_RCV_LINE2, BPRegValue2);
   WriteReg (BP_BM_MUX, SELECT_M);
#endif
}

void DoIsolateBPB()
{
   uChar tmp;

#ifdef __FEBRIDGE
   DoActionBM( PORTAction_Stop );
   /* Set the B port BP rcv line for the new config */
   BPRegValue1 = (BPRegValue1 & ~RCV_B_MASK) | QUIET_LINE_S;
   *(ushort*)BP_RCV_LINE = BPRegValue1;
   Br_Switch_B_Phys(FRONT);
#else
   BPMStop[1] = ReadPortPCMState(MAX_PORT_COUNT - 1);
   DoActionBM( PORTAction_Disable );
   SetBPBQuietLine();
   WriteReg (BP_BM_MUX, SELECT_M);
   if (tmp = Port2LedMap[MAX_PORT_COUNT-1])
   {
      Port2LedMap[MAX_PORT_COUNT-1] = 0;
      Port2LedMap[PHY_B] = tmp;
      UI2PortMap[tmp-1] = PHY_B + 1;
      UI2PortMap[MAX_PORT_COUNT-1] = MAX_PORT_COUNT;
   }

   DoPortAction(PHY_B, PORTAction_Enable);
#endif
   DoPortAction(PHY_B, PORTAction_Start);
}

void DoIsolateBPA()
{
   uChar tmp;

#ifdef __FEBRIDGE
   DoActionAM( PORTAction_Stop );
   /* Set the A port BP rcv line for the new config */
   BPRegValue1 = (BPRegValue1 & ~RCV_A_MASK) | QUIET_LINE_P;
   *(ushort*)BP_RCV_LINE = BPRegValue1;
	Br_Switch_A_Phys(FRONT);
#else
   BPMStop[0] = ReadPortPCMState(FDDI_NONMASTER_CT);
   DoActionAM( PORTAction_Disable );
   SetBPAQuietLine();
   WriteReg (BP_AM_MUX, SELECT_M);
   if (tmp = Port2LedMap[PHY_B+1])
   {
      Port2LedMap[PHY_B+1] = 0;
      Port2LedMap[PHY_A] = tmp;
      UI2PortMap[tmp-1] = PHY_A + 1;
      UI2PortMap[MAX_PORT_COUNT-2] = PHY_B + 2;
   }

   DoPortAction(PHY_A, PORTAction_Enable);
#endif
   DoPortAction(PHY_A, PORTAction_Start);
}

void DoInsertBPB( lineNum )
int  lineNum;
{
   uChar tmp;

#ifdef __FEBRIDGE
   DoActionBM( PORTAction_Stop );
   /* Set the B port BP rcv line for the new config */
   BPRegValue1 = (BPRegValue1 & ~RCV_B_MASK) |
				((ushort)RiRegConfig[lineNum]<< 8);
   *(ushort*)BP_RCV_LINE = BPRegValue1;
   Br_Switch_B_Phys(BACK);
#else
   DoActionBM( PORTAction_Disable );

   BPRegValue1 = ((lineNum & 0x07)<<5 | (BPRegValue1 & 0x1f));
   BPRegValue2 = (lineNum & 0x18)<<3;
   WriteReg (BP_RCV_LINE, BPRegValue1);
   WriteReg (BP_RCV_LINE2, BPRegValue2);
   WriteReg (BP_BM_MUX, SELECT_B);
   if (tmp = Port2LedMap[PHY_B])
   {
      Port2LedMap[PHY_B] = 0;
      Port2LedMap[MAX_PORT_COUNT-1] = tmp;
      UI2PortMap[tmp-1] = MAX_PORT_COUNT;
      UI2PortMap[MAX_PORT_COUNT-1] = PHY_B + 1;
   }

   DoActionBM( PORTAction_Enable );
#endif
   DoActionBM( PORTAction_Start );
}

void DoInsertBPA( lineNum )
int lineNum;
{
   uChar tmp;

#ifdef __FEBRIDGE
   DoActionAM( PORTAction_Stop );
   /* Set the A port BP rcv line for the new config */
   BPRegValue1 = (BPRegValue1 & ~RCV_A_MASK) | (ushort)RiRegConfig[lineNum];
   *(ushort*)BP_RCV_LINE = BPRegValue1;
	Br_Switch_A_Phys(BACK);
#else
   DoActionAM( PORTAction_Disable );
   BPRegValue1 = ((lineNum & 0x1f) | (BPRegValue1 & 0xe0));
   WriteReg (BP_RCV_LINE, BPRegValue1);
   WriteReg (BP_AM_MUX, SELECT_A);
   if (tmp = Port2LedMap[PHY_A])
   {
      Port2LedMap[PHY_A] = 0;
      Port2LedMap[PHY_B+1] = tmp;
      UI2PortMap[tmp-1] = PHY_B+2;
      UI2PortMap[MAX_PORT_COUNT-2] = PHY_A + 1;
   }

   DoActionAM( PORTAction_Enable );
#endif
   DoActionAM( PORTAction_Start );
}

void fddi_brip_stop()
{
   int i;

   for (i=0; i < 4; i++)
   {
      StopTimer(&PortStartTimer[i]);
   }

   FddiBripState = FBP_STOP;
}


void init_fddi_brip()
{
   uChar i;

   FddiBripState = FBP_ISOLATED;
   ECM_Active = TRUE;
   for (i=0; i < 4; i++)
   {
      CreatTimer (&PortStartTimer[i]);
   }
   CreatMailbox (&StartActionMBox);

   if (!(FddiBripStack = (word*) lmalloc(FDDI_BRIP_STACK_SIZE)))
   {
      if (get_debug() == DEBUG_ON)
	 printf("Can not allocate a stack for FDDI BRIP TASK.\n");
   }
   CreatTask( DoStartPortActionTask, FddiBripStack, FDDI_BRIP_STACK_SIZE, 
	     (int) NULL);
   DoIsolateBPB();
   DoIsolateBPA();
}

void notify_fddi_smt( event, lineNum )
int event, lineNum;
{
      switch (FddiBripState)
      {
      case FBP_ISOLATED:
	switch (event)
	  {
	  case EVENT_INSERT_B:
	    {
	       MAPDPT("EVENT_INSERT_B\n");
	       FddiBripState = FBP_INSERT_BPB;
	       DoInsertBPB(lineNum);
	       break;
	    }
	  case EVENT_INSERT_A:
	    {
	       MAPDPT("EVENT_INSERT_A\n");
	       FddiBripState = FBP_INSERT_BPA;
	       DoInsertBPA(lineNum);
	       break;
	    }
	  }	
	break;

      case FBP_INSERT_BPB:
	switch (event)
	  {
	  case EVENT_INSERT_B:  
	    {
	       MAPDPT("EVENT_INSERT_B\n");
	       DoInsertBPB(lineNum);
	       break;
	    }
	  case EVENT_ISOLATE_B:
	  case EVENT_ISOLATE_AB:
	    {
	       if (event == EVENT_ISOLATE_B)
		 {
		    MAPDPT("EVENT_ISOLATE_B\n");
		 }
	       else
		 {
		    MAPDPT("EVENT_ISOLATE_AB\n");
		 }
	       FddiBripState = FBP_ISOLATED;
	       DoIsolateBPB();
	       break;
	    }
	  case EVENT_INSERT_A:
	    {
	       MAPDPT("EVENT_INSERT_A\n");
	       FddiBripState = FBP_INSERT_BPAB;
	       DoInsertBPA(lineNum);
	       break;
	    }
	  }
	break;

      case FBP_INSERT_BPA:
	switch (event)
	  {
	  case EVENT_INSERT_A:
	    {
	       MAPDPT("EVENT_INSERT_A\n");
	       DoInsertBPA(lineNum);
	       break;
	    }
	  case EVENT_ISOLATE_A:
	  case EVENT_ISOLATE_AB:
	    {
	       if (event == EVENT_ISOLATE_A)
	       {
		  MAPDPT("EVENT_ISOLATE_B\n");
	       }
	       else
	       {
		  MAPDPT("EVENT_ISOLATE_AB\n");
	       }
	       FddiBripState = FBP_ISOLATED;
	       DoIsolateBPA();
	       break;
	    }
	  case EVENT_INSERT_B:
	    {
	       MAPDPT("EVENT_INSERT_B\n");
	       FddiBripState = FBP_INSERT_BPAB;
	       DoInsertBPB(lineNum);
	       break;
	    }
	  }
	break;

      case FBP_INSERT_BPAB:
	switch (event)
	  {
	  case EVENT_ISOLATE_AB:
	    {
	       MAPDPT("EVENT_ISOLATE_AB\n");
	       FddiBripState = FBP_ISOLATED;
	       DoIsolateBPB();
	       DoIsolateBPA();
	       break;
	    }
	  case EVENT_ISOLATE_B:
	    {
	       MAPDPT("EVENT_ISOLATE_B\n");
	       FddiBripState = FBP_INSERT_BPA;
	       DoIsolateBPB();
	       break;
	    }
	  case EVENT_ISOLATE_A:
	    {
	       MAPDPT("EVENT_ISOLATE_A\n");
	       FddiBripState = FBP_INSERT_BPB;
	       DoIsolateBPA();
	       break;
	    }
	  case EVENT_INSERT_B:
	    {
	       MAPDPT("EVENT_INSERT_B\n");
	       DoInsertBPB(lineNum);
	       break;
	    }
	  case EVENT_INSERT_A:
	    {
	       MAPDPT("EVENT_INSERT_A\n");
	       DoInsertBPA(lineNum);
	       break;
	    }
	  break;
	  }
      case FBP_STOP:
	break;
      }
}


