/*********************************************************************
	Management Application Module

	MAP PORT Control Module

	File:		mapmport.c
	Created:	03/25/91

	SID:		1.1
	Last Modified:	4/22/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module provides the Station Control menu PORT submenu
	functions.

	Modification History:
*********************************************************************/

#include        "smtdefs.h"
#include        "smttypes.h"
#include        "smtmsg.h"
#include        "fddihdr.h"
#include        "fbmframe.h"
#include        "fbmmacro.h"
#include        "mibdefs.h"
#include	"maphdr.h"
#include	"mapglbl.h"
#include  <nvrfddi.h>
#include  <monp.h>
#include  <msgutil.h>
#include  <dips.h>
#include  <syteksnm.h>


#define PORT_DEBUG             0

extern int *PortInitState;

/*
 * defined in fddiled.c under util subdir 
 */
extern unsigned char UI2PortMap[];
extern unsigned char  Port2LedMap[];


extern	WINDOW	*inputwin;
extern	WINDOW	*WindowGet ();
extern	int	WindowVisible ();
extern	PTVF_t	WindowUpdate ();
extern	uInt32	DoMIBSet ();
extern	void	MIBErrorMessage ();

extern	uInt32	MAPGetMIBAttr ();
extern	uInt32	MAPChangeMIBAttr ();


/*********************************************************************
	Global Variables
*********************************************************************/

extern uChar mibPortNum[], PortNum[];
static	uInt16	portEntity;

/*********************************************************************
	Menu Command PORT Menu
*********************************************************************/

uInt16
SetPORTEntity ()
/*********************************************************************
Function:	Get the PORT entity index from user.
Parameters:	None.
Input:		None.
Output:		None.
Return:		Entity value of 1 or greater or 0 if invalid value given.
*********************************************************************/
{
uInt16	entity;

	wprintw (inputwin, "Enter PORT entity number (1 - %d): ",
		mapInfo.SMTStationConfigGrp.NonMaster_Ct +
		mapInfo.SMTStationConfigGrp.Master_Ct);
	wscanw (inputwin, "%d", &entity);
	if (entity < 1 || entity > 
			mapInfo.SMTStationConfigGrp.NonMaster_Ct +
			mapInfo.SMTStationConfigGrp.Master_Ct)
		return (0);
	
	return (mibPortNum[entity-1]);
}




void
DoPORTStart ()
/*********************************************************************
Function:	Give a start command to a port.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
uInt32		result;

	/* get PORT index */
	if ((portEntity = SetPORTEntity ()) == 0)
		return;

	/* clear buffers */
	MEMZERO (&mibData, sizeof (mibData));

	mibData.paramType = fddiPORTAction;
	mibData.paramLen = 8;
	mibData.PORTINDEX = portEntity;
	mibData.PORTPARAM16 = PORTAction_Start;

	result = DoMIBSet (sizeof (mibData), (uChar *) &mibData, &setCount);
	if (result != RC_SUCCESS)
		MIBErrorMessage ("Start command failed.", result);

	return;
}

void
DoPORTStop ()
/*********************************************************************
Function:	Give a stop command to a port.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
uInt32		result;

	/* get PORT index */
	if ((portEntity = SetPORTEntity ()) == 0)
		return;

	/* clear buffers */
	MEMZERO (&mibData, sizeof (mibData));

	mibData.paramType = fddiPORTAction;
	mibData.paramLen = 8;
	mibData.PORTINDEX = portEntity;
	mibData.PORTPARAM16 = PORTAction_Stop;

	result = DoMIBSet (sizeof (mibData), (uChar *) &mibData, &setCount);
	if (result != RC_SUCCESS)
		MIBErrorMessage ("Stop command failed.", result);

	return;
}

void
DoPORTEnable ()
/*********************************************************************
Function:	Give an enable command to a port.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
uInt32		result;

	/* get PORT index */
	if ((portEntity = SetPORTEntity ()) == 0)
		return;

	/* clear buffers */
	MEMZERO (&mibData, sizeof (mibData));

	mibData.paramType = fddiPORTAction;
	mibData.paramLen = 8;
	mibData.PORTINDEX = portEntity;
	mibData.PORTPARAM16 = PORTAction_Enable;

	result = DoMIBSet (sizeof (mibData), (uChar *) &mibData, &setCount);
	if (result != RC_SUCCESS)
		MIBErrorMessage ("Enable command failed.", result);

	return;
}

void
DoPORTDisable ()
/*********************************************************************
Function:	Give a disable command to a port.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
uInt32		result;

	/* get PORT index */
	if ((portEntity = SetPORTEntity ()) == 0)
		return;

	/* clear buffers */
	MEMZERO (&mibData, sizeof (mibData));

	mibData.paramType = fddiPORTAction;
	mibData.paramLen = 8;
	mibData.PORTINDEX = portEntity;
	mibData.PORTPARAM16 = PORTAction_Disable;

	result = DoMIBSet (sizeof (mibData), (uChar *) &mibData, &setCount);
	if (result != RC_SUCCESS)
		MIBErrorMessage ("Disable command failed.", result);

	return;
}

void
DoPORTMaint ()
/*********************************************************************
Function:	Give a Maint LS command to a port.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
uInt32		result;

	/* get PORT index */
	if ((portEntity = SetPORTEntity ()) == 0)
		return;

	/* clear buffers */
	MEMZERO (&mibData, sizeof (mibData));

	mibData.paramType = fddiPORTAction;
	mibData.paramLen = 8;
	mibData.PORTINDEX = portEntity;
	mibData.PORTPARAM16 = PORTAction_Maint;

	result = DoMIBSet (sizeof (mibData), (uChar *) &mibData, &setCount);
	if (result != RC_SUCCESS)
		MIBErrorMessage ("Maintenance command failed.", result);

	return;
}

void
DisplayPORTParameters ()
/*********************************************************************
Function:	Display the PORT parameters.
Parameters:	None.
Input:		portEntity	= MIB's PORT entity index.
Output:		Updates mapInfo database.
Return:		None.
*********************************************************************/
{
WINDOW	*win = NULL;
TLVParamType	mibData;
uInt16		phyID;
uInt16		curLS;
extern uInt16	ReadLineState ();

	/**********
		READING LINE STATE DIRECTLY FROM CSP IS NOT THE EXPECTED
		END RESULT. EVENTUALLY, THE SMT MIB WILL EITHER BE CHANGED 
		BY THE COMMITTEE OR ENHANCED BY XDI TO INCLUDE THIS
		ATTRIBUTE.
	**********/
/*	ReadLineState ();*/
	curLS = ReadLineState (portEntity-1);
	switch (curLS)
	{
	case 0x02:
		curLS = 0;
		break;

	case 0x01:
	case 0x40:
		curLS = 1;
		break;

	case 0x08:
		curLS = 2;
		break;

	case 0x04:
		curLS = 3;
		break;

	case 0x100:
	default:
		curLS = 4;
		break;

	}

	/* read MIB data */
	phyID = PortNum[portEntity-1] - 1;

	mibData.paramType = fddiPORTPathsRequested;
	mibData.paramLen = 4;
	mibData.PORTINDEX = portEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTConfigGrp[phyID].PathsRequested = mibData.PORTPARAM8;

	mibData.paramType = fddiPORTAvailablePaths;
	mibData.paramLen = 4;
	mibData.PORTINDEX = portEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTConfigGrp[phyID].AvailablePaths = mibData.PORTPARAM8;

	mibData.paramType = fddiPORTMACLoop_Time;
	mibData.paramLen = 4;
	mibData.PORTINDEX = portEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTConfigGrp[phyID].MACLoop_Time = mibData.PORTPARAM32;

	mibData.paramType = fddiPORTTB_Max;
	mibData.paramLen = 4;
	mibData.PORTINDEX = portEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTOperationGrp[phyID].TB_Max = mibData.PORTPARAM32;

	mibData.paramType = fddiPORTMaintLineState;
	mibData.paramLen = 4;
	mibData.PORTINDEX = portEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTOperationGrp[phyID].MaintLineState = mibData.PORTPARAM8;

	mibData.paramType = fddiPORTConnectionPolicies;
	mibData.paramLen = 4;
	mibData.PORTINDEX = portEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTConfigGrp[phyID].ConnectionPolicies = mibData.PORTPARAM8;

	mibData.paramType = fddiPORTLer_Cutoff;
	mibData.paramLen = 4;
	mibData.PORTINDEX = portEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTLerGrp[phyID].Ler_Cutoff = mibData.PORTPARAM8;

	mibData.paramType = fddiPORTLer_Alarm;
	mibData.paramLen = 4;
	mibData.PORTINDEX = portEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTLerGrp[phyID].Ler_Alarm = mibData.PORTPARAM8;

	/* set up window */
	wmove (win, 0, 0);
	wprintw (win, "   PORT %d Operating Parameters\n\n", 
		 PortNum[portEntity-1]);
	win = WindowGet (DISPLAY_WIN);

	wprintw (win, "1. Path Requested: ");
	wprintw (win, "0x%02x", 
		mapInfo.PORTConfigGrp[phyID].PathsRequested);
	wprintw (win, "\t(Paths Available: ");
	wprintw (win, "0x%02x)\n", 
		mapInfo.PORTConfigGrp[phyID].AvailablePaths);

	wprintw (win, "2. MAC Loop Time : ");
	wprintw (win, "%9d\n",
		mapInfo.PORTConfigGrp[phyID].MACLoop_Time);

	wprintw (win, "3. TB_Max        : ");
	wprintw (win, "%9d\n",
		MFddi2Usecs (-mapInfo.PORTOperationGrp[phyID].TB_Max));

	wprintw (win, "4. Maintenance LS: ");
	wprintw (win, "%s",
		MAINTLS[mapInfo.PORTOperationGrp[phyID].MaintLineState]);
	wprintw (win, "\t(Current LS: ");
	wprintw (win, "%s)\n", MAINTLS[curLS]);

	wprintw (win, "5. Connect Policy: ");
	wprintw (win, "0x%02x\n",
		mapInfo.PORTConfigGrp[phyID].ConnectionPolicies);

	wprintw (win, "6. LER Cutoff    : ");
	wprintw (win, "10E-%02d\n",
		mapInfo.PORTLerGrp[phyID].Ler_Cutoff);

	wprintw (win, "7. LER Alarm     : ");
	wprintw (win, "10E-%02d\n", 
		mapInfo.PORTLerGrp[phyID].Ler_Alarm);

        printf("\n\n");
	return;
}

void
PORTParameters ()
/*********************************************************************
Function:	Display/change PORT parameters.
Parameters:	None.
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
int		oldWorkWin;
int		c;
uInt32		result, value;
WINDOW		*win;
extern char	mapinstr[];

	/* get PORT index */
	if ((portEntity = SetPORTEntity ()) == 0)
		return;

	oldWorkWin = WindowVisible (WORK_WIN, FALSE);
	WindowUpdate (DISPLAY_WIN, DisplayPORTParameters);
	WindowVisible (DISPLAY_WIN, TRUE);
	win = WindowGet (DISPLAY_WIN);
	werase (win);

	DisplayPORTParameters ();

	werase (inputwin);
	wprintw (inputwin, "Enter parameter number to change (RETURN to exit):\n");

	c = 0;
	while (c != CHAR_RETURN)
	{
		c = WGETCH (inputwin);

		result = 0;
		switch (c)
		{
		case '1':
			/* set path requested */
			wprintw (inputwin, "Enter new path: ");
			mibData.paramType = fddiPORTPathsRequested;
			mibData.paramLen = 8;
			wscanw (inputwin, "%x", &value);
			mibData.PORTPARAM8 = value;
			break;

		case '2':
			/* set MAC Loop Time */
			wprintw (inputwin, 
				"Enter new MAC loopback time (in usecs): ");
			mibData.paramType = fddiPORTMACLoop_Time;
			mibData.paramLen = 8;
			wscanw (inputwin, "%d", &value);
			mibData.PORTPARAM32 = value;
			mibData.PORTPARAM32 
				= mibData.PORTPARAM32;
			break;

		case '3':
			/* set TB_Max */
			wprintw (inputwin, "Enter new TB_Max (in usecs): ");
			mibData.paramType = fddiPORTTB_Max;
			mibData.paramLen = 8;
			wscanw (inputwin, "%d", &value);
			mibData.PORTPARAM32 = value;
			mibData.PORTPARAM32 
				= -MUsecs2Fddi (mibData.PORTPARAM32);
			break;

		case '4':
			/* set maintenance line state */
			wprintw (inputwin,
			"Enter new maintenance line state (Q, I, M, H, A):");
			mibData.paramType = fddiPORTMaintLineState;
			mibData.paramLen = 8;
			wscanw (inputwin, "%s", mapinstr);
			switch (*mapinstr)
			{
			case 'Q':
			case 'q':
				mibData.PORTPARAM8 = 0;
				break;

			case 'I':
			case 'i':
				mibData.PORTPARAM8 = 1;
				break;

			case 'M':
			case 'm':
				mibData.PORTPARAM8 = 2;
				break;

			case 'H':
			case 'h':
				mibData.PORTPARAM8 = 3;
				break;

			case 'A':
			case 'a':
				mibData.PORTPARAM8 = 4;
				break;

			default:
				c = 0;
				break;
			}
			break;

		case '5':
			/* set connection policies */
			wprintw (inputwin, "Enter new connection policies: ");
			mibData.paramType = fddiPORTConnectionPolicies;
			mibData.paramLen = 8;
			wscanw (inputwin, "%x", &value);
			mibData.PORTPARAM8 = value;
			break;

		case '6':
			/* set LER Cutoff */
			wprintw (inputwin, 
			"Enter abs. value of exponent for new LER Cutoff: ");
			mibData.paramType = fddiPORTLer_Cutoff;
			mibData.paramLen = 8;
			wscanw (inputwin, "%d", &value);
			mibData.PORTPARAM8 = value;
			break;

		case '7':
			/* set LER Alarm */
			wprintw (inputwin, 
			"Enter abs. value of exponent for new LER Alarm: ");
			mibData.paramType = fddiPORTLer_Alarm;
			mibData.paramLen = 8;
			wscanw (inputwin, "%d", &value);
			mibData.PORTPARAM8 = value;
			break;
		}

		if (c >= '1' && c <= '7')
		{
			mibData.PORTINDEX = portEntity;
			result = DoMIBSet (sizeof (mibData),
				(uChar *) &mibData, &setCount);
			if (result != RC_SUCCESS)
				MIBErrorMessage ("PORT parameter not set",
					result);
		}
	}

	WindowVisible (WORK_WIN, oldWorkWin);
	WindowVisible (DISPLAY_WIN, FALSE);
	werase (win);

	return;
}


void StartOnePort (port_num)
uint32 port_num;
/*********************************************************************
Function:	Give a start command to a port.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
  TLVParamType	mibData;
  uInt32		result;

  /* clear buffers */
  MEMZERO (&mibData, sizeof (mibData));
  mibData.paramType = fddiPORTAction;
  mibData.paramLen = 8;
  mibData.PORTINDEX = port_num + 1;
  mibData.PORTPARAM16 = PORTAction_Start;

  result = DoMIBSet (sizeof (mibData), (uChar *) &mibData, NULL);
  if (result != RC_SUCCESS)
    MIBErrorMessage ("StartOnePort() fail", result);

  return;
}


void EnableOnePort (port_num)
uint32 port_num;
/*********************************************************************
Function:	Give a start command to a port.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
  TLVParamType	mibData;
  uInt32		result;

  /* clear buffers */
  MEMZERO (&mibData, sizeof (mibData));
  mibData.paramType = fddiPORTAction;
  mibData.paramLen = 8;
  mibData.PORTINDEX = port_num + 1;
  mibData.PORTPARAM16 = PORTAction_Enable;
  result = DoMIBSet (sizeof (mibData), (uChar *) &mibData, NULL);
  if (result != RC_SUCCESS)
    MIBErrorMessage ("Enable command failed.", result);

  MEMZERO (&mibData, sizeof (mibData));
  mibData.paramType = fddiPORTAction;
  mibData.paramLen = 8;
  mibData.PORTINDEX = port_num + 1;
  mibData.PORTPARAM16 = PORTAction_Start;
  result = DoMIBSet (sizeof (mibData), (uChar *) &mibData, NULL);
  if (result != RC_SUCCESS)
    MIBErrorMessage ("EnableOnePort() start fail", result);

  return;
}



void DisableOnePort (port_num)
uint32 port_num;
/*********************************************************************
Function:	Give a disable command to a port.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
  TLVParamType	mibData;
  uInt32		result;

  /* clear buffers */
  MEMZERO (&mibData, sizeof (mibData));

  mibData.paramType = fddiPORTAction;
  mibData.paramLen = 8;
  mibData.PORTINDEX = port_num + 1;
  mibData.PORTPARAM16 = PORTAction_Disable;

  result = DoMIBSet (sizeof (mibData), (uChar *) &mibData, NULL);
  if (result != RC_SUCCESS)
    MIBErrorMessage ("DisableOnePort() fail", result);

  return;
}

#include <phy.h>
#include <drv.h>
/******************************************************************************
 *  Function   set_port_state
 *
 *  Description
 *    This function sets port state and send trap to snmp
 *
 *  Parameter:
 *    uint32 port_num
 *    state  [LOCK_PORT_BY_TRIG | LOCK_PORT_BY_ADDR | UNLOCK_PORT]
 *
 *  Return: void
 *****************************************************************************/
void set_port_state (port_num,state)
uint32 port_num;
uint32 state;
{
	extern PLAYER_TYPE phys[];

	/* 
	 * if it is A/B/S port, exit 
	 */
	if ((port_num == 0) || (port_num == 1)) 
	{
		if (phys[port_num].p_type != PC_TYPE_M)
		{
if (get_debug() == DEBUG_ON)
		printf("Message: Port %d is not of type M; So cannot lock/unlock\n", Port2LedMap[port_num]);
			return;
		}
	}
  
#if 0
	/*
 	 * port 1 or 6 is not M 
 	 */ 
	if (Port2LedMap[port_num] == 0)
	{
		if ( port_num == 2 )
			port_num = 0;
		else if ( port_num == 7 )
			port_num = 1;
		else
			;
		printf("Message: Port %d is not of type M; So cannot lock/unlock\n", Port2LedMap[port_num]);
   	return;
	}
#endif

if (get_debug() == DEBUG_ON)
  printf("set_port_state(), port %d, state %d\n",Port2LedMap[port_num],state);

  switch (state) {
  case LOCK_PORT_BY_TRIG:

#if 0
	/*
	 * currently we do not update the state of 
	 * port when we lock/unlock a port by
	 * trigger action or by locking on source
	 * or destination addr
	 */	
    *(PortInitState + port_num) = nvr_port_init.port_state[port_num] = PORT_LOCK_BY_TRIG;
    if(Nvram_Updt(NVR_PORT_INIT_ADDR,&nvr_port_init,NVR_PORT_INIT_SIZE) != NVRAM_AOK) {
      if (get_debug() == DEBUG_ON)
	printf("Error: fail to write port monitor record to NVRAM\n");
    }
#endif

#if 0
	printf("\nMessage: Locking port %d; LED Status of port provides confirmation\n", Port2LedMap[port_num] ) ;
#endif

    DisableOnePort(port_num);

    break;

  case LOCK_PORT_BY_ADDR:

#if 0
	printf("\nMessage: Locking port %d; LED Status of port provides confirmation\n", Port2LedMap[port_num]  ) ;
#endif

#if 0
    *(PortInitState + port_num) = nvr_port_init.port_state[port_num] = PORT_LOCK_BY_ADDR;
    if(Nvram_Updt(NVR_PORT_INIT_ADDR,&nvr_port_init,NVR_PORT_INIT_SIZE) != NVRAM_AOK) {
      if (get_debug() == DEBUG_ON)
	printf("Error: fail to write port monitor record to NVRAM\n");
    }
#endif

    DisableOnePort(port_num);
    break;

  case UNLOCK_PORT:
#if 0
	printf("\nMessage: UNLocking port %d; LED Status of port provides confirmation.\n", Port2LedMap[port_num] ) ;
#endif

#if 0
    /* update to NVRAM */
    *(PortInitState + port_num) = nvr_port_init.port_state[port_num] = PORT_NOT_LOCK;
    if(Nvram_Updt(NVR_PORT_INIT_ADDR,&nvr_port_init,NVR_PORT_INIT_SIZE) != NVRAM_AOK) {
      if (get_debug() == DEBUG_ON)
	printf("Error: fail to write port monitor record to NVRAM\n");
    }
#endif

    EnableOnePort(port_num);
    break;

  default:
    if (get_debug() == DEBUG_ON)
      printf("Error: illegal parameter in set_port_state()\n");

    break;
  }

  return;
}
