/*********************************************************************
	Management Application Module

	MAP Test Control Module

	File:		mapmtest.c
	Created:	03/25/91

	SID:		1.1
	Last Modified:	4/22/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module provides the Test menu functions.

	Modification History:
*********************************************************************/

#include        "smtdefs.h"
#include        "smttypes.h"
#include        "smtmsg.h"
#include        "fddihdr.h"
#include        "fbmframe.h"
#include        "fbmmacro.h"
#include        "mibdefs.h"
#include	"maphdr.h"
#include	"mapglbl.h"


extern	WINDOW	*inputwin;
extern	WINDOW	*WindowGet ();
extern	int	WindowVisible ();
extern	PTVF_t	WindowUpdate ();
extern	void	DoSMTWindow ();
extern	uInt32	DoMIBSet ();
extern	void	DoConnect ();
extern	void	DoDump ();
extern	void	SendSMTFrame ();
extern	int	GetAddress ();
extern	void	ClearFrameBuffer ();
extern	uInt32	BuildEchoRequest ();
extern	uInt16	ntohs ();

extern	uInt32	MAPGetMIBAttr ();
extern	uInt32	MAPChangeMIBAttr ();


/*********************************************************************
	Global Variables
*********************************************************************/

static	uInt32	activePorts;
static	void	(*smtProc)();
static	uInt16	numPorts;


/*********************************************************************
	Menu Command Test Menu
*********************************************************************/

void
UpdatePORTTest ()
/*********************************************************************
Function:	Check PORT to see if PC_Start is needed and update
		SMT display. This routine is called as the SMT display
		update routine.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
#if 0
uInt32		result;
#endif
uInt32		entity;
int		i;

	/* clear buffers */
	MEMZERO (&mibData, sizeof (mibData));

	mibData.paramType = fddiPORTAction;
	mibData.paramLen = 8;
	mibData.PORTPARAM16 = PORTAction_Start;

	for (entity = 1, i = 1; i <= numPorts; i++, entity <<= 1)
	{
		if ((entity & activePorts) 
			&& (mapInfo.PORTStatusGrp[i-1].PCMState == PC_ACTIVE))
		{
			mibData.PORTINDEX = i;
			DoMIBSet (sizeof (mibData), (uChar *) &mibData, 
				&setCount);
		}
	}

	DoSMTWindow ();

	return;
}

void
DoPORTTest ()
/*********************************************************************
Function:	Do PORT connection test by sending PC_Start to the
		PORT whenever its PCM reaches ACTIVE.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
WINDOW		*win;
int		oldVisible;
int		c, i;
uInt32		entity;

	/* initialize active ports */
	activePorts = 0;
	numPorts = mapInfo.SMTStationConfigGrp.NonMaster_Ct +
			mapInfo.SMTStationConfigGrp.Master_Ct;

	/* set SMT display */
	smtProc = WindowUpdate (SMT_WIN, UpdatePORTTest);
	oldVisible = WindowVisible (SMT_WIN, TRUE);

	win = WindowGet (SMT_WIN);
	werase (win);

	/* put instructions on screen */
	werase (inputwin);
	wmove (inputwin, 0, 0);
	wprintw (inputwin, "PORT Test Status:\n");
	wprintw (inputwin, "     (Highlighted PORTS are testing)\n");
	wprintw (inputwin, "Enter: 1 - %-2d   to toggle test on that PORT\n",
		numPorts);
	wprintw (inputwin, "       *        to test all PORTs\n");
	wprintw (inputwin, "       RETURN      to exit test");

	/* make sure connection process is going */
	DoConnect ();

	/* check for input */
	c = 0;
	while (c != CHAR_RETURN)
	{
		/* draw test status for ports*/
		wmove (inputwin, 0, 18);
		for (i = 0; i < numPorts; i++)
		{
			if (activePorts & (1 << i))
				wstandout (inputwin);
			wprintw (inputwin, "%2d ", i + 1);
			wstandend (inputwin);
		}

		c = WGETCH (inputwin);

		/* if input given, do action */
		if (c == '*')
			activePorts = -1;

		else if (isdigit (c))
		{
			c = c - '0';
			if (c >= 1 && c <= numPorts)
			{
				/* toggle port */
				c--;
				entity = 1 << c;
				if (entity & activePorts)
					activePorts &= ~entity;
				else
					activePorts |= entity;
			}
		}
	}

	/* restore window */
	werase (inputwin);
	werase (win);
	WindowVisible (SMT_WIN, oldVisible);
	WindowUpdate (SMT_WIN, smtProc);

	return;
}

void
ReadMemory ()
/*********************************************************************
Function:	Read a memory location.
Parameters:	None.
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{
uChar	*p;
uInt16	count;
int	c;

	do
	{
		wprintw (inputwin, "Enter starting address(in hex): ");
		wscanw (inputwin, "%x", &p);
		wprintw (inputwin, "Enter # of bytes to read: ");
		wscanw (inputwin, "%d", &count);
		wprintw (inputwin, "Dumping %d bytes at 0x%08x:\n",
			count, p);
		DoDump (p, count, inputwin);
		wprintw (inputwin, "Enter RETURN to exit or any key to continue");
		c = WGETCH (inputwin);
		wprintw (inputwin, "\n");
	} while (c != CHAR_RETURN);

	return;
}

void
WriteMemory ()
/*********************************************************************
Function:	Write a value to a memory location.
Parameters:	None.
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{
uChar	*p;
int	val;
int	c;

	do
	{
		wprintw (inputwin, "Enter byte address to write(in hex) : ");
		wscanw (inputwin, "%x", &p);
		wprintw (inputwin, "Enter new value (in hex): ");
		wscanw (inputwin, "%x", &val);
		*p = (uChar) val;
		wprintw (inputwin, "Enter RETURN to exit or any key to continue");
		c = WGETCH (inputwin);
		wprintw (inputwin, "\n");
	} while (c != CHAR_RETURN);

	return;
}

void
ShowMemory ()
/*********************************************************************
Function:	Show memory remaining.
Parameters:	None.
Input:		Uses global memStart from main.c.
Output:		None.
Return:		None.
*********************************************************************/
{
#ifdef	NSC_DOS
uInt32		memLeft;
extern	uInt32	memStart;

	memLeft = farcoreleft ();
	wprintw (inputwin, "%d bytes left out of %d bytes at start\n",
		memLeft, memStart);
#else
	wprintw (inputwin, "Not available on this platform.n");
#endif

	return;
}

/*********************************************************************
	ECHO Traffic Generator Routines
*********************************************************************/

static	uInt32	maxFrames,		/* # frame to generate */
		frameCount;		/* frames generated so far */
static	uInt16	indexMAC,		/* index of MAC to use */
		frameLen;		/* frame length */
static	WINDOW	*echowin;

void
UpdateTrafficTest ()
/*********************************************************************
Function:	Update display and values for traffic generator test.
Parameters:	None.
Input:		
Output:		None.
Return:		None.
*********************************************************************/
{
	/* transmit frame */
	if (maxFrames == 0 || frameCount < maxFrames)
	{
		SendSMTFrame (mapFrameBuffer, frameLen, indexMAC);
		frameCount++;
	}

	wmove (echowin, 1, 0);
	wprintw (echowin, "%9ld", frameCount);

	return;
}

void
DoECHOTraffic ()
/*********************************************************************
Function:	Generate traffic using ECHO frames.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
int		oldVisible;
uInt16		echoSize;
int		c, i;
uChar		*echoData;
SMTFrameHdrType	*frameHdr;
MACAddr48	destAddr;

	/* Get frame info */
	werase (inputwin);
	wmove (inputwin, 0, 0);
	wprintw (inputwin, "Enter # of bytes in ECHO field: ");
	wscanw (inputwin, "%li", &echoSize);
	if (echoSize > 0x1168)
	{
		wprintw (inputwin, 
			"Max ECHO field size is %d. Using this value.\n", 
			0x1168);
		echoSize = 0x1168;
	}
	wprintw (inputwin, 
		"Enter # of frames to generate (0 for continuous): ");
	wscanw (inputwin, "%d", &maxFrames);
	wprintw (inputwin, 
		"Enter index of MAC to use: ");
	wscanw (inputwin, "%d", &indexMAC);
	GetAddress (&destAddr);

	/*
	*	Clear frame buffer.
	*/
	frameHdr = (SMTFrameHdrType *) mapFrameBuffer;
	ClearFrameBuffer (mapFrameBuffer);
	echoData = mapFrameBuffer + sizeof (SMTFrameHdrType) 
		+ sizeof (ParamHdrType);

	/*
	*	Create an ECHO Request frame.
	*	Set initial trans ID if 0.
	*/
	BuildEchoRequest (mapFrameBuffer, SMT_INFO_FC, destAddr, indexMAC, 
		echoData, echoSize);

	/* fill in echo data */
	for (i = 0; i < echoSize; i++)
		*echoData++ = (uChar) i;

	/* set up transmit */
	frameCount = 0;
	frameLen = ntohs (frameHdr->smtHdr.InfoField_Length)
		    + SMT_FRAME_HDR_SIZE;

	/* set traffic display */
	smtProc = WindowUpdate (INPUT_WIN, UpdateTrafficTest);
	oldVisible = WindowVisible (INPUT_WIN, TRUE);

	echowin = WindowGet (INPUT_WIN);
	werase (echowin);
	wmove (echowin, 0, 0);
	wprintw (echowin, "Traffic Stats:\n");
	wprintw (echowin, "%9d frames generated ", frameCount);
	if (maxFrames)
		wprintw (echowin, "out of %d total frames.", maxFrames);
	else
		wprintw (echowin, "in continuous test.");
	wprintw (inputwin, "\n\nEnter RETURN to stop test");

	/* check for input */
	do
	{
		c = WGETCH (inputwin);
	} while (c != CHAR_RETURN);

	/* restore window */
	werase (echowin);
	werase (inputwin);
	WindowVisible (INPUT_WIN, oldVisible);
	WindowUpdate (INPUT_WIN, smtProc);

	return;
}

