/*********************************************************************
	Management Application Module

	MAP Command Processing Module

	File:		mapproc.c
	Created:	12/01/89

	SID:		1.1
	Last Modified:	4/22/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module contains the MAP command processing routines.

	Modification History:
*********************************************************************/
#include        "smtdefs.h"
#include        "smttypes.h"
#include        "smtmsg.h"
#include        "fddihdr.h"
#include        "fbmframe.h"
#include        "fbmmacro.h"
#include        "mibdefs.h"
#include	"maphdr.h"
#include	"mapglbl.h"
#include        "fdrextrn.h"


extern	uInt32	ntohl ();
extern	uInt32	htonl ();
extern	void	ProcessSMTNotification ();
extern	void	StoreFrame ();
extern  void    MONP_UpdateSMTStats();
extern  int	ProcessEchoResponse( SMTMessage *);
extern  int     BuildRingMap ( SMTMessage *);
extern  uChar   MacIDWaitResponse;
extern	WINDOW	*eventwin;
extern	char	*FRAMETYPE[], *FRAMECLASS[];
extern uChar    PhysicalRingInit;

/*********************************************************************
	Processing Routines
*********************************************************************/

void
ProcessMAPMessage (msg)
	SMTMessage	*msg;
{
SendFrameBuf	*sendBuf;
MACAddr48	*destAddr;
SMTFrameHdrType	*frameHdr;
uInt16 infoLen;

	switch (msg->type)
	{

	case CSP_ERROR_MSG:
	case FBM_ERROR_MSG:
	case MIB_ERROR_MSG:
		wprintw (eventwin, ">>>ERROR 0x%04x from %d<<<\n",
			msg->typeInfo, msg->source);
		break;

	case MIB_EVENT_NOTIFY_SMT:
		ProcessSMTNotification (msg);
		if (!eventLogging)
		{
		   return;
		}
		break;

	case FBM_EVENT_FRAME_TRACE:
		MONP_UpdateSMTStats(msg);	

		frameHdr = (SMTFrameHdrType *) msg->p2;
		sendBuf = msg->p1.sendFrameBuf;
		if (PhysicalRingInit &&
		    (frameHdr->smtHdr.Frame_Class == SIFCONFIG_CLASS))
		{
		   if (frameHdr->smtHdr.Frame_Type == SMTREQUEST)
		   {
		      UpdateSIFBroadcast(msg);
		   }
		   else if (frameHdr->smtHdr.Frame_Type == SMTRESPONSE)
		   {
		      BuildRingMap(msg);
		   }
		}
		break;

	case FBM_EVENT_FRAME_RECEIVED:
		frameHdr = (SMTFrameHdrType *) msg->p2;
#ifdef __MAP_DEBUG
		wprintw (eventwin, "Received %s %s from ",
			FRAMECLASS[frameHdr->smtHdr.Frame_Class],
			FRAMETYPE[frameHdr->smtHdr.Frame_Type]);
		wprintw (eventwin, "%02x.%02x.%02x.%02x.%02x.%02x ",
			frameHdr->macHdr.SA[0],
			frameHdr->macHdr.SA[1],
			frameHdr->macHdr.SA[2],
			frameHdr->macHdr.SA[3],
			frameHdr->macHdr.SA[4],
			frameHdr->macHdr.SA[5]);
		wprintw (eventwin, "ID = %x\n",
			  ntohl (frameHdr->smtHdr.Transaction_ID));
#endif
		sendBuf = msg->p1.sendFrameBuf;
		if (frameHdr->smtHdr.Frame_Type == SMTRESPONSE)
		{
			switch (frameHdr->smtHdr.Frame_Class)
			{
			case PMFGET_CLASS:
			        infoLen = ntohs(frameHdr->smtHdr.InfoField_Length);
				DisplayPMFGetResponse(frameHdr, infoLen);
			        break;
			case PMFCHANGE_CLASS:
				printf("$Rx PMF Change Response:");
				break;
			case PMFADD_CLASS:
				printf("$Rx PMF Add  Response:");
				break;
			case PMFREMOVE_CLASS:
				printf("$Rx PMF Remove Response:");
				break;
			case ECHO_CLASS:
				if (!ProcessEchoResponse(msg))
				{;
				}	
				break;
#if 0
			case SIFCONFIG_CLASS:
				BuildRingMap(msg);
				break;
#endif
			}
		 }
		 break;

	case FBM_RESPONSE_FRAME_SENT:
		frameHdr = (SMTFrameHdrType *) msg->p2;
		sendBuf = msg->p1.sendFrameBuf;
		destAddr = NULL;
		if (sendBuf->frameType == SMTREQUEST)
		{
			switch (sendBuf->frameClass)
			{
			case NIF_CLASS:
				destAddr = &sendBuf->frameData.nif.destAddr;
				break;

			case SIFCONFIG_CLASS:
				fddiHost_control_tbl[MacIDWaitResponse].transID
				  = sendBuf->sentTransID;
				destAddr = &sendBuf->frameData.sif.destAddr;
				break;

			case SIFOP_CLASS:
				destAddr = &sendBuf->frameData.sif.destAddr;
				break;

			case ECHO_CLASS:
				destAddr = &sendBuf->frameData.ecf.destAddr;
				break;

			case ESF_CLASS:
				destAddr = &sendBuf->frameData.esf.destAddr;
				break;

			case PMFGET_CLASS:
			case PMFCHANGE_CLASS:
			case PMFADD_CLASS:
			case PMFREMOVE_CLASS:
				destAddr = &sendBuf->frameData.pmf.destAddr;
				break;
			}
		}

#ifdef __MAP_DEBUG
		wprintw (eventwin,
		"Frame sent - Class: %02x, Type: %02x, Trans ID: %04x ",
			sendBuf->frameClass, sendBuf->frameType,
			sendBuf->sentTransID);
		if (destAddr != NULL)
		{
			wprintw (eventwin,
			" to %02x%02x %02x%02x %02x%02x",
				(*destAddr)[0],
				(*destAddr)[1],
				(*destAddr)[2],
				(*destAddr)[3],
				(*destAddr)[4],
				(*destAddr)[5]);
		}

		wprintw (eventwin, "\n");
#endif
		break;

	default:
#ifdef __MAP_DEBUG
		wprintw (eventwin,
	"MAP Message received from 0x%x: Type = 0x%x, TypeInfo = 0x%x\n",
		msg->source, msg->type, msg->typeInfo);
#endif
		break;
	}

#ifdef __MAP_DEBUG
        printf("***< Press Return to continue >***\n");
#endif
	return;
}

