/***********************************************************************
 *      Copyright (c) 1992 by Hughes LAN Systems
 *
 *      Program Name:   FDDI Concentrator application
 *
 *      Filename:       mapptask.c
 *      Created:        1/5/93
 *
 *      Description:    This file contains task for sending SIF Config
 *			Request at periodic intervals for building 
 *			logical ring map.  
 *
 *      $log$
 *
 *
 ***********************************************************************
 */

#include <krnl.h>
#include <types.h>
#include <sys.h>
#include <constant.h>
#include <fdrextrn.h>
#include "smtdefs.h"
#include "smttypes.h"
#include "smtmsg.h"
#include "fddihdr.h"
#include "fbmframe.h"
#include "fbmmacro.h"
#include "mibdefs.h"
#include "maphdr.h"
#include "mapglbl.h"
#include "fbmhdr.h"
#include "fbmglbl.h"
 
#define TEST_MAPPER 1
 
/*********************************************************************
        External functions
*********************************************************************/
extern  uInt32  ntohl ();
extern  uInt32  htonl ();
extern  uChar *FindFrameParam ();
extern  uInt32  GenTransID ();
extern  void  BuildRingMap (uChar *, uChar *, uInt16);
extern  void  InitRingMap (uInt, queue_head *);

extern int scr_pause();

extern uChar Pri_Addr[];
extern uChar Sec_Addr[];

/*********************************************************************
        Global Data
*********************************************************************/
#define SIF_STACK_WORD_SIZE   (sizeof(word) *0x400)
TIMER SIFSendTimer;
MBOX SIFSendMBox; 
word *SIFSendTaskStack;

#define SEND_INTERVAL (60 * 10000)

void SIFSendTasks()
{
uint running;

	running = TRUE;

	while (running)
	{
		StartTimer(&SIFSendTimer,SEND_INTERVAL,&SIFSendMBox);

		RcvMessage(&SIFSendMBox);

		SendSIF();
	}
}


uChar Addr1[6] = "\001\001\002\002\002\001";;
uChar Addr2[6] = "\001\001\002\002\002\002";
uChar Addr3[6] = "\001\001\002\002\002\003";
uChar Addr4[6] = "\001\001\002\002\002\004";
uChar Addr5[6] = "\001\001\002\002\002\005";

uChar Addr6[6] = "\001\001\002\002\002\006";
uChar Addr7[6] = "\001\001\002\002\002\007";

uInt16  done = FALSE;


void stop_dummy(void)
{
}

void SIFSendTask()
{
uInt16 Num;
uChar Src[6], UNA[6];
int RUNNING;

	Num = 0;

#ifdef TEST_MAPPER
#endif

        printf ("\n\nBuild 1nd Work Ring Map\n\n");

	scr_pause();

	MCopyAddress(UNA, Addr3);
	MCopyAddress(Src, Addr4);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr2);
	MCopyAddress(Src, Addr3);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr4);
	MCopyAddress(Src, Addr5);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr1);
	MCopyAddress(Src, Addr2);
	BuildRingMap(Src,UNA,Num);

        printf ("\n\nBuild 2nd Work Ring Map\n\n");

	scr_pause();

	MCopyAddress(UNA, Addr3);
	MCopyAddress(Src, Addr4);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr4);
	MCopyAddress(Src, Addr6);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr6);
	MCopyAddress(Src, Addr7);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr2);
	MCopyAddress(Src, Addr3);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr7);
	MCopyAddress(Src, Addr5);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr1);
	MCopyAddress(Src, Addr2);
	BuildRingMap(Src,UNA,Num);

        printf ("\n\nBuild 3rd Work Ring Map for Mac 1\n\n");

	scr_pause();

	Num = 1;

	MCopyAddress(Addr1, &Sec_Addr[1]);

	MCopyAddress(UNA, Addr3);
	MCopyAddress(Src, Addr4);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr4);
	MCopyAddress(Src, Addr6);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr6);
	MCopyAddress(Src, Addr7);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr2);
	MCopyAddress(Src, Addr3);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr7);
	MCopyAddress(Src, Addr5);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr1);
	MCopyAddress(Src, Addr2);
	BuildRingMap(Src,UNA,Num);

        printf ("\n\nBuild 4nd Work Ring Map for Mac 0\n\n");

	Num = 0;

	MCopyAddress(Addr1, &Pri_Addr[1]);

	scr_pause();

	MCopyAddress(UNA, Addr3);
	MCopyAddress(Src, Addr4);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr2);
	MCopyAddress(Src, Addr3);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr4);
	MCopyAddress(Src, Addr5);
	BuildRingMap(Src,UNA,Num);

	MCopyAddress(UNA, Addr1);
	MCopyAddress(Src, Addr2);
	BuildRingMap(Src,UNA,Num);

	RUNNING = TRUE;

	while (RUNNING)
	{
		scr_pause();
		ReSchedule();
	}
}	

void InitSIFSend()
{
uInt MacNum;

        printf("Calling InitRingMap\n");
	for (MacNum = 0; MacNum < mapInfo.SMTStationConfigGrp.MAC_Ct;
	     MacNum++)
	{
	   InitRingMap(MacNum, fddiHost_control_tbl[MacNum].WorkHead);
	}
	CreatTimer(&SIFSendTimer);
	CreatMailbox(&SIFSendMBox);
        if (!(SIFSendTaskStack = (word*) lmalloc(SIF_STACK_WORD_SIZE)))
	{
	   printf("\nSIF Task stack allocation fails.\n");
	   reset();
	}

	CreatTask( SIFSendTask, SIFSendTaskStack, SIF_STACK_WORD_SIZE, 
			(int) NULL);
#ifdef TEST_MAPPER
        printf ("\nDoing InitSIFSend\n");
#endif

}


SendSIF()
{
MACAddr48	DestAddr;
SendFrameBuf	buf;
uInt16		MacNum;

#ifdef TEST_MAPPER
        printf ("\nSend SIF Config Frame for Mapper\n");
#endif

        MCopyAddress(DestAddr,BROADCAST_ADDRESS);

	for (MacNum = 0; MacNum < mapInfo.SMTStationConfigGrp.MAC_Ct;
	     MacNum++)
	{
#if 0
#endif
	   BuildSIFSend (MacNum, SIFCONFIG_CLASS, SMTREQUEST, SMT_INFO_FC, 
			 &DestAddr );
	}


} 
