#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) cspinit.c V6.2.3:cs.910829:6:6 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/*********************************************************************
	Connection Services Process Module
	
	System Initialization Routines
	
	File:		cspinit.c
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.910829	09/04/91
	
	Copyright 1990,1991 XLNT Designs, Inc.

	This module initializes the CSP global data structures. 
	This initialization occurs after the MIB has been initialized.
	CSP will not execute until this initialization has been
	completed.

	Modification History:

	*** Updated to SMT 6.2 ***
	910122-005	LJP
		Removed unused global values resID from
		MAC info and PHY info.
	910823-003	LJP
		Set CF_MAC based on attachCount, not phyCount.
*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"fddihdr.h"
#include	"smtmacro.h"
#include	"csphdr.h"
#include	"cspglbl.h"
#include	"mibdefs.h"

/*********************************************************************
	External Functions
*********************************************************************/

extern	uInt32	CSPGetMIBAttr ();


/*********************************************************************
	Initialization Routines
*********************************************************************/

uInt32
InitCSPData ()
/*********************************************************************
Function:	Initialize CSP global data structures.
parameters:	None.
Input:		
Output:		All global values set to a SM-DAS in the disconnected state.
Return:		0 if successful, otherwise an error value is returned.
Notes:		None.
Modification History:
*********************************************************************/
{
Int16		i;
Int16		j;

	/*
	*	Initialize station data
	*/
	stationData.macCount = 1;
	stationData.attachCount = 1;
	stationData.masterCount = 0;
	stationData.pathsAvailable = PA_UNKNOWN;
	stationData.configPolicy = Config_None;
	stationData.connectionPolicy = Policy_expanded;

	stationData.Bypass = CLEAR;
	stationData.bothWrapPolicy = CLEAR;
	stationData.Trace_Max = Trace_Max_Default;
	stationData.I_Max = I_Max_Default;
	stationData.T_Rmode = T_Rmode_Default;

	stationData.WA_Flag = CLEAR;
	stationData.cfState = CF_ISOLATED;

	stationData.CF_MAC = SET;
	stationData.phyCount = stationData.attachCount 
			+ stationData.masterCount;
        stationData.WAT_Flag = CLEAR;    /* Advisory 6.2.3-017 */
	
	/*
	*	Initialize MAC data
	*/
	for (i = 0; i < MAX_MAC_COUNT; i++)
	{
		MCopyAddress (macData[i].SMTAddress, UNKNOWN_ADDRESS);
		MCopyAddress (macData[i].upstreamNbr, UNKNOWN_ADDRESS);
		macData[i].pathsRequested = PA_UNKNOWN;

		macData[i].operational = CLEAR;
		MCopyAddress (macData[i].dataAddress, UNKNOWN_ADDRESS);
		macData[i].dupPolicy1 = RMT_DUP_LEAVE;
		macData[i].dupPolicy2 = RMT_DUP_LEAVE;
		/*
		*	910122-005	LJP
		*	Removed resID.
		*/
		macData[i].MAC_Avail = CLEAR;
		macData[i].Loop_Avail = CLEAR;
	}
	
	/*
	*	Initialize all PHY data
	*/
	for (i = 0; i < MAX_PHY_COUNT; i++)
	{
		phyData[i].PC_Type = PC_Type_None;
		phyData[i].connectionPolicies = PC_MAC_None;
		phyData[i].pathsRequested = PA_UNKNOWN;
		phyData[i].MACLoop_Time = 0;
		phyData[i].TB_Max = TB_Max_Default;

		phyData[i].operational = CLEAR;
		/*
		*	910122-005	LJP
		*	Removed resID.
		*/

		phyData[i].PC_Neighbor = PC_Type_None;
		phyData[i].PC_Mode = PC_Mode_None;
		phyData[i].PC_Withhold = PC_WH_None;
		phyData[i].PC_LCT_Fail = 0;
		phyData[i].LCT_Passed = CLEAR;
	}

	/*
	*	Initialize ECM state machine
	*/
	ecmData.Path_Test = PT_Passed;
	ecmData.SB_Flag = CLEAR;
	ecmData.RE_Flag = SET;
	ecmData.Hold = CLEAR;
	ecmData.TEC = 0;
	ecmData.ecState = EC_OUT;
	
	/*
	*	Initialize PCM state machine
	*/
	for (i = 0; i < MAX_PHY_COUNT; i++)
	{
		pcmData[i].Maint_LS = (LineState) 0;
		pcmData[i].PC_LS = 0;
		pcmData[i].n = 0;
		pcmData[i].LS_Flag = CLEAR;
		pcmData[i].RC_Flag = CLEAR;
		pcmData[i].TC_Flag = CLEAR;
		pcmData[i].TD_Flag = CLEAR;
		pcmData[i].T_Val = 0;
		pcmData[i].R_Val = 0;
		pcmData[i].TR_Flag = CLEAR;
		pcmData[i].BS_Flag = CLEAR;
		pcmData[i].TPC = 0;
		pcmData[i].TNE = 0;
		pcmData[i].TScrub = 0;
		pcmData[i].LC_Test = (uTime) 0;
		pcmData[i].pcState = PC_OFF;
		pcmData[i].RE_Needed = CLEAR; /* Advisory 6.2.3-017 */
	}
	
	/*
	*	Initialize CEM state machines
	*/
	for (i = 0; i < MAX_PHY_COUNT; i++)
	{
		cemData[i].CF_Loop = CLEAR;
		cemData[i].CF_Join = CLEAR;
		cemData[i].ceState = CE_ISOLATED;
		for (j=0; j < MAX_MAC_COUNT; j++)
		{
		   cemData[i].RM_Join[j] = CLEAR;
		   cemData[i].RM_Loop[j] = CLEAR;
		}
	}
	
	/*
	*	Initialize RMT state machine
	*/
	for (i = 0; i < MAX_MAC_COUNT; i++)
	{
		rmtData[i].RM_Loop = CLEAR;
		rmtData[i].RM_Join = CLEAR;
		rmtData[i].JM_Flag = CLEAR;
		rmtData[i].DA_Flag = CLEAR;
		rmtData[i].BN_Flag = CLEAR;
		rmtData[i].NO_Flag = SET;
		rmtData[i].traceStatus = Trace_NoCurrent;
		rmtData[i].rmState = RM_ISOLATED;
		rmtData[i].TRM = 0;
		rmtData[i].ringOP = CLEAR;
		rmtData[i].inClaim = CLEAR;
		rmtData[i].claimTimed = CLEAR;
		rmtData[i].TRC = 0;
		rmtData[i].beaconTimed = CLEAR;
		rmtData[i].TRB = 0;
	}
	
	/*
	*	Initialize LEM state machine
	*/
	for (i = 0; i < MAX_PHY_COUNT; i++)
	{
		lemData[i].cutoffRate = 7;
		lemData[i].estimate = 0;
		lemData[i].leState = LE_OFF;
		lemData[i].TLE = 0;
		lemData[i].rateIndex = 0;
		lemData[i].threshhold = 0;
		lemData[i].LEM_Fail = CLEAR;
		lemData[i].LEM_Reject_Ct = 0;
		lemData[i].lemCount = 0;
	}

	/*
	*	Set initialized status.
	*/
	stationData.CSPInitialized = CLEAR;

	return (0);
}

uInt32
InitCSPMIBData ()
/*********************************************************************
Function:	Initialize CSP global data after MIB has been initialized.
parameters:	None.
Input:		None.
Output:		All global values set to current MIB settings.
Return:		0 if successful, otherwise an error value is returned.
Notes:		This function is called when the MIB initialization
		message is received.
Modification History:
*********************************************************************/
{
TLVParamType	buffer;
Int16		i;

	/*
	*	Initialize station data
	*/
	buffer.paramType = fddiSMTMAC_Ct;
	buffer.paramLen = 0;
	CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
	stationData.macCount = buffer.SMTPARAM8;

	buffer.paramType = fddiSMTNonMaster_Ct;
	buffer.paramLen = 0;
	CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
	stationData.attachCount = buffer.SMTPARAM8;

	buffer.paramType = fddiSMTMaster_Ct;
	buffer.paramLen = 0;
	CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
	stationData.masterCount = buffer.SMTPARAM8;

	buffer.paramType = fddiSMTPathsAvailable;
	buffer.paramLen = 0;
	CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
	stationData.pathsAvailable = buffer.SMTPARAM8;

	buffer.paramType = fddiSMTConfigPolicy;
	buffer.paramLen = 0;
	CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
	stationData.configPolicy = buffer.SMTPARAM16;

	buffer.paramType = fddiSMTConnectionPolicy;
	buffer.paramLen = 0;
	CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
	stationData.connectionPolicy = buffer.SMTPARAM16;

	buffer.paramType = fddiATTACHMENTOpticalBypassPresent;
	buffer.paramLen = 4;
	buffer.ATTACHINDEX = 1;
	CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
	stationData.Bypass = buffer.ATTACHPARAM8;

	buffer.paramType = xdiSMTBothWrapPolicy;
	buffer.paramLen = 0;
	CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
	stationData.bothWrapPolicy = buffer.SMTPARAM8;

	buffer.paramType = fddiPATHClassTrace_MaxExpiration;
	buffer.paramLen = 0;
	buffer.PATHINDEX = 1;
	CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
	/* convert from FddiTimerTwosComplement */
	stationData.Trace_Max = MFddi2Usecs (-buffer.PATHPARAM32);

	buffer.paramType = fddiATTACHMENTI_MaxExpiration;
	buffer.paramLen = 0;
	buffer.ATTACHINDEX = 1;
	CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
	/* convert from FddiTimerTwosComplement */
	stationData.I_Max = MFddi2Usecs (-buffer.ATTACHPARAM32);

	buffer.paramType = fddiPATHClassPATHT_Rmode;
	buffer.paramLen = 0;
	buffer.PATHINDEX = 1;
	CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
	/* convert from FddiTime */
	stationData.T_Rmode = MFddi2Usecs (buffer.PATHPARAM32);


	/*
	*	Set local values.
	*/
	stationData.phyCount = stationData.attachCount
			+ stationData.masterCount;

	/*
	*	Set implied policies.
	*	MAC-based LCT or loopback is not supported in single-
	*	MAC, dual-attachment configurations.
	*/
	/*
	*	910823-003	LJP
	*	CF_MAC should be set based upon attachCount, not phyCount.
	*/
	if ((stationData.attachCount == 2 && stationData.macCount == 1)
			|| stationData.macCount == 0)
		stationData.CF_MAC = CLEAR;
	else
		/* Otherwise a MAC may be used if indicated. */
		stationData.CF_MAC = SET;

	/*
	*	Hold policy set only for dual-MAC stations allowing
	*	the hold policy.
	*/
	ecmData.Hold = ((stationData.macCount == 2)
		&& (stationData.configPolicy & Config_Hold_Available))
		? SET : CLEAR;

	/*
	*	Initialize MAC data
	*/
	for (i = 0; i < stationData.macCount; i++)
	{
		buffer.paramType = fddiMACSMTAddress;
		buffer.paramLen = 4;
		buffer.MACINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		MCopyAddress (macData[i].SMTAddress, buffer.MACADDR);

		buffer.paramType = fddiMACPathsRequested;
		buffer.paramLen = 4;
		buffer.MACINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		macData[i].pathsRequested = buffer.MACPARAM8;

		buffer.paramType = fddiPATHClassT_MaxLowerBound;
		buffer.paramLen = 4;
		buffer.MACINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		/* convert from FddiTimerTwosComplement */
		macData[i].RM34cTime = MFddi2Usecs (-buffer.MACPARAM32);
		/*
		* The amount of time to wait before checking for Receiving
		* Valid Claim with My Address & T_Bid != T_Req is based on
		* this station's T_Max. The T_Max value is converted to
		* microseconds and then reduced a small amount. If the T_Max
		* is smaller than the wait time, then no checking will be
		* done since the time is too small.
		*/
		if (macData[i].RM34cTime > T_RM34c)
			macData[i].RM34cTime -= T_RM34c;
		else
			macData[i].RM34cTime = 0;


		buffer.paramType = xdiMACOperational;
		buffer.paramLen = 4;
		buffer.MACINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		macData[i].operational = buffer.MACPARAM8;

		buffer.paramType = xdiMACDataAddress;
		buffer.paramLen = 4;
		buffer.MACINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		MCopyAddress (macData[i].dataAddress, buffer.MACADDR);

		buffer.paramType = xdiMACRMTDupPolicy1;
		buffer.paramLen = 4;
		buffer.MACINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		macData[i].dupPolicy1 = buffer.MACPARAM8;

		buffer.paramType = xdiMACRMTDupPolicy2;
		buffer.paramLen = 4;
		buffer.MACINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		macData[i].dupPolicy2 = buffer.MACPARAM8;
	}

	/*
	*	Initialize port data
	*/
	for (i = 0; i < stationData.phyCount; i++)
	{
		/* PHY data */
		buffer.paramType = fddiPORTPC_Type;
		buffer.paramLen = 4;
		buffer.PORTINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		phyData[i].PC_Type = buffer.PORTPARAM8;

		buffer.paramType = fddiPORTConnectionPolicies;
		buffer.paramLen = 4;
		buffer.PORTINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		phyData[i].connectionPolicies = buffer.PORTPARAM8;

		buffer.paramType = fddiPORTPathsRequested;
		buffer.paramLen = 4;
		buffer.PORTINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		phyData[i].pathsRequested = buffer.PORTPARAM8;

		buffer.paramType = fddiPORTMACLoop_Time;
		buffer.paramLen = 4;
		buffer.PORTINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		/* convert from FddiTime */
		phyData[i].MACLoop_Time = MFddi2Usecs (buffer.PORTPARAM32);

		buffer.paramType = fddiPORTTB_Max;
		buffer.paramLen = 4;
		buffer.PORTINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		/* convert from FddiTimerTwosComplement */
		phyData[i].TB_Max = MFddi2Usecs (-buffer.PORTPARAM32);

		buffer.paramType = xdiPORTOperational;
		buffer.paramLen = 4;
		buffer.PORTINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		phyData[i].operational = buffer.PORTPARAM8;

		/* LEM data */
		buffer.paramType = fddiPORTLer_Cutoff;
		buffer.paramLen = 4;
		buffer.PORTINDEX = i + 1;
		CSPGetMIBAttr (sizeof (buffer), &buffer, (SetCountType *) NULL);
		lemData[i].cutoffRate = buffer.PORTPARAM8;
	}

	stationData.CSPInitialized = SET;

	return (0);
}

