#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) csplct.c V6.2.3:cs.622c:5:5 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/*********************************************************************
	Connection Services Process Module
	
	Link Confidence Test Routines
	
	File:		csplct.c
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.622c	08/02/91
	
	Copyright 1990,1991 XLNT Designs, Inc.
	
	This module implements the a link confidence test.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"smtmsg.h"
#include	"cspmacro.h"
#include	"csphdr.h"
#include	"cspglbl.h"
#include	"mibdefs.h"


/*********************************************************************
	LCT External Functions
*********************************************************************/

extern	void	SMTSendSignal ();
extern	void	SetLEMCounter ();
extern	void	SetLEMState ();
extern	void	SetupMACLCT ();
extern	void	FinishMACLCT ();
extern	void	SendCSPEvent ();


void
StopLCT (phyID)
	uInt	phyID;
/*********************************************************************
Function:	Stop link confidence test.
Parameters:	phyID	= index of PHY on link tested.
Input:		Uses phyData and stationData.
Output:		Disable LEM hardware.
Return:		None.
Modification History:
*********************************************************************/
{
	/* notify LEM to stop LCT */
	SetLEMState (phyID, DISABLE);
	SMTSendSignal (SIG_LCT_Stop, phyID, (uInt32) 0);

	/* remove MAC if used */
	if ((phyData[phyID].connectionPolicies & PC_MAC_LCT)
			&& stationData.CF_MAC)
		FinishMACLCT (phyID);

	/*
	*	At this point, if LCT has passed,
	*	then the count of consecutive failures can be cleared
	*	and the LEM_Fail flag can be cleared.
	*	Otherwise increment count.
	*/
	if (phyData[phyID].LCT_Passed)
	{
		phyData[phyID].PC_LCT_Fail = 0;
		lemData[phyID].LEM_Fail = CLEAR;
	}
	else
		phyData[phyID].PC_LCT_Fail++;

	/* notify MIB of new value */
	SendCSPEvent (fddiPORTLCTFail_Ct, phyID);

	return;
}

void
StartLCT (phyID)
	uInt	phyID;
/*********************************************************************
Function:	Start link confidence test.
Parameters:	phyID	= index of PHY on link tested.
Input:		Uses phyData and stationData.
Output:		Enables LEM hardware.
Return:		None.
Modification History:
*********************************************************************/
{
	/* notify LEM to perform LCT */
	SMTSendSignal (SIG_LCT_Start, phyID, (uInt32) 0);

	/* enable LEM hardware with a threshhold of 3 */
	SetLEMCounter (phyID, 1);
	SetLEMState (phyID, ENABLE);

	/* set MAC if used */
	if ((phyData[phyID].connectionPolicies & PC_MAC_LCT)
			&& stationData.CF_MAC)
		SetupMACLCT (phyID);

	return;
}
