#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) cspproc.c V6.2.3:cs.622c:5:5 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/*********************************************************************
	Connection Services Process Module
	
	CSP Signal Processing Module
	
	File:		cspproc.c
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.622c	08/02/91
	
	Copyright 1990,1991 XLNT Designs, Inc.
	
	This module is the interrupt entry point. The function
	ProcessCSP() begins the processing of any signals placed
	in the signal queue. This function will be called from 
	the interrupt handling routine or any other interface routine
	that causes CSP to begin executing.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"cspmacro.h"
#include	"csphdr.h"
#include	"cspglbl.h"


/*********************************************************************
	External Function Declarations
*********************************************************************/

extern	uInt32	SMTReadSignal ();
extern	void	SignalECM ();
extern	void	SignalCFM ();
extern	void	SignalPCM ();
extern	void	SignalRMT ();
extern	void	SignalLEM ();


/*********************************************************************
	Signal Queue Global Variables
*********************************************************************/

/*
*	Make operating flag global to allow for explicit initialization.
*/
static	Flag	operating = CLEAR;	/* flag SET if already running */


/*********************************************************************
	Signal Queue Processing Function
*********************************************************************/

uInt32
InitProcessCSP ()
/*********************************************************************
Function:	Initialize system for processing CSP events.
Parameters:	None.
Input:		None.
Output:		Sets operating flag to CLEAR.
Return:		0 if successful, otherwise error code.
Modification History:
*********************************************************************/
{
	operating = CLEAR;
	return (0);
}

void
ProcessCSP (onState)
	ProcState	*onState;
/*********************************************************************
Function:	Process all signals in the signal queue. For each signal
		read from the signal queue, this function activates the
		appropriate state machine or service routine.
Parameters:	onState	= the processor interrupt state value to use
			when interrupts are enabled.
Input:		Reads from signal queue.
Output:		None.
Return:		None.
Notes:		IMPORTANT! Interrupts must be disabled when this function is
		called. This function will enable interrupts to the level
		specified by onState.
*********************************************************************/
{
uInt16		sigType, sigEntity;
uInt32		sigData;
uInt32          processCount;    /* jlin */          

	/*
	*	If an interrupt occurred during CSP processing and this
	*	function is called again from the interrupt handler, the
	*	operating flag must be checked to insure that CSP is not 
	*	invoked more than once.
	*/
	if (operating)
	{
/*	        CSPDPT("\nReentry to ProcessCSP.\n");*/
		return;
	}

	/*
	*	If CSP has not been completely initialized, then
	*	ignore any signal that are in the queue.
	*/
	if (!stationData.CSPInitialized)
	{
/*	        CSPDPT("\nCSP is not initialized.\n");*/
		while (SMTReadSignal (&sigType, &sigEntity, &sigData) 
			!= ECSP_SIG_Q_MT) ;
		return;
	}

	/*
	*	Set operating flag.
	*	(Note: Interrupts are still off.)
	*/
	operating = SET;
        processCount = 0;
	
	/*
	*	Loop through all signals in the signal queue.
	*/
	while (SMTReadSignal (&sigType, &sigEntity, &sigData) != ECSP_SIG_Q_MT)
	{
#ifdef	USE_DISPLAY_ALL
DisplaySignal (sigType, sigEntity, sigData);
#endif

		/*
		*	Enable interrupts.
		*/
		MRestoreCSPInterrupts (onState);
/*                CSPDPT("\nProcessCSPSignal.\n");*/

                if (++processCount & 0x0004)    /* jlin : Avoid the watch dog kicks in */
		{
		   strobe_wdt();
		   processCount = 0;
		}
#if 0
                else if (processCount & 0x40)
		{
		   strobe_wdt();
		   processCount = 0;
		}
#endif
		/*
		*	Activate state machine.
		*	State machine is specified by high byte.
		*/
		switch (sigType & 0xFF00)
		{
		case ECM_SIGNALS:
			SignalECM (sigType, sigEntity, sigData);
#ifdef	USE_DISPLAY
DisplayECMInfo ();
#endif
			break;
			
		case PCM_SIGNALS:
			SignalPCM (sigType, sigEntity, sigData);
#ifdef	USE_DISPLAY
DisplayPCMInfo (sigEntity);
DisplayPHYInfo (sigEntity);
#endif
			break;
			
		case RMT_SIGNALS:
			SignalRMT (sigType, sigEntity, sigData);
#ifdef	USE_DISPLAY
DisplayRMTInfo (sigEntity);
DisplayMACInfo (sigEntity);
#endif
			break;
			
		case CFM_SIGNALS:
			SignalCFM (sigType, sigEntity, sigData);
#ifdef	USE_DISPLAY
DisplayCFMInfo ();
#endif
			break;
			
		case LEM_SIGNALS:
			SignalLEM (sigType, sigEntity, sigData);
			break;
			
		default:
			break;
		}
		
		/*
		*	Disable interrupts while checking signal queue to avoid
		*	race condition where a signal is put on the queue after
		*	SMTReadSignal() indicates the queue is empty.
		*/

		MDisableCSPInterrupts (onState);
	}
	
	/*
	*	Clear operating flag.
	*/
	operating = CLEAR;

	return;
}
